<?php
/**
 * Media from FTP
 * 
 * @package    Media from FTP
 * @subpackage MediafromFTPAdmin Main & Management screen
/*  Copyright (c) 2013- Katsushi Kawamori (email : dodesyoswift312@gmail.com)
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class MediaFromFtpAdmin {

	public $postcount;

	/* ==================================================
	 * Add a "Settings" link to the plugins page
	 * @since	1.0
	 */
	function settings_link( $links, $file ) {
		static $this_plugin;
		if ( empty($this_plugin) ) {
			$this_plugin = MEDIAFROMFTP_PLUGIN_BASE_FILE;
		}
		if ( $file == $this_plugin ) {
			$links[] = '<a href="'.admin_url('admin.php?page=mediafromftp').'">Media from FTP</a>';
			$links[] = '<a href="'.admin_url('admin.php?page=mediafromftp-settings').'">'.__( 'Settings').'</a>';
			$links[] = '<a href="'.admin_url('admin.php?page=mediafromftp-search-register').'">'.__('Search & Register', 'media-from-ftp').'</a>';
			$links[] = '<a href="'.admin_url('admin.php?page=mediafromftp-log').'">'.__('Log', 'media-from-ftp').'</a>';
		}
			return $links;
	}

	/* ==================================================
	 * Settings page
	 * @since	1.0
	 */
	function add_pages() {
		add_menu_page(
				'Media from FTP',
				'Media from FTP',
				'upload_files',
				'mediafromftp',
				array($this, 'manage_page'),
				'dashicons-upload'
		);
		add_submenu_page(
				'mediafromftp',
				__('Settings'),
				__('Settings'),
				'upload_files',
				'mediafromftp-settings',
				array($this, 'settings_page')
		);
		add_submenu_page(
				'mediafromftp',
				__('Search & Register', 'media-from-ftp'),
				__('Search & Register', 'media-from-ftp'),
				'upload_files',
				'mediafromftp-search-register',
				array($this, 'search_register_page')
		);
		add_submenu_page(
				'mediafromftp',
				__('Log', 'media-from-ftp'),
				__('Log', 'media-from-ftp'),
				'upload_files',
				'mediafromftp-log',
				array($this, 'log_page')
		);
	}

	/* ==================================================
	 * Add Css and Script
	 * @since	2.23
	 */
	function load_custom_wp_admin_style() {
		if ($this->is_my_plugin_screen()) {
			wp_enqueue_style( 'jquery-datetimepicker', MEDIAFROMFTP_PLUGIN_URL.'/css/jquery.datetimepicker.css' );
			wp_enqueue_style( 'jquery-responsiveTabs', MEDIAFROMFTP_PLUGIN_URL.'/css/responsive-tabs.css' );
			wp_enqueue_style( 'jquery-responsiveTabs-style', MEDIAFROMFTP_PLUGIN_URL.'/css/style.css' );
			wp_enqueue_style( 'stacktable', MEDIAFROMFTP_PLUGIN_URL.'/css/stacktable.css' );
			wp_enqueue_style( 'mediafromftp',  MEDIAFROMFTP_PLUGIN_URL.'/css/mediafromftp.css' );
			wp_enqueue_script( 'jquery' );
			wp_enqueue_script( 'jquery-datetimepicker', MEDIAFROMFTP_PLUGIN_URL.'/js/jquery.datetimepicker.js', null, '2.3.4' );
			wp_enqueue_script( 'jquery-responsiveTabs', MEDIAFROMFTP_PLUGIN_URL.'/js/jquery.responsiveTabs.min.js' );
			wp_enqueue_script( 'stacktable', MEDIAFROMFTP_PLUGIN_URL.'/js/stacktable.js' );
		}
	}

	/* ==================================================
	 * Add Script on footer
	 * @since	2.24
	 */
	function load_custom_wp_admin_style2() {
		if ($this->is_my_plugin_screen()) {
			echo $this->add_js();
		}
	}

	/* ==================================================
	 * For only admin style
	 * @since	8.82
	 */
	function is_my_plugin_screen() {
		$screen = get_current_screen();
		if (is_object($screen) && $screen->id == 'toplevel_page_mediafromftp') {
			return TRUE;
		} else if (is_object($screen) && $screen->id == 'media-from-ftp_page_mediafromftp-settings') {
			return TRUE;
		} else if (is_object($screen) && $screen->id == 'media-from-ftp_page_mediafromftp-search-register') {
			return TRUE;
		} else if (is_object($screen) && $screen->id == 'media-from-ftp_page_mediafromftp-log') {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	/* ==================================================
	 * Main
	 */
	function manage_page() {

		if ( !current_user_can( 'upload_files' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
		}

		$plugin_datas = get_file_data( MEDIAFROMFTP_PLUGIN_BASE_DIR.'/mediafromftp.php', array('version' => 'Version') );
		$plugin_version = __('Version:').' '.$plugin_datas['version'];

		?>

		<div class="wrap">

		<h2 style="float: left;">Media from FTP</h2>
		<div style="display: block; padding: 10px 10px;">
			<form method="post" style="float: left; margin-right: 1em;" action="<?php echo admin_url('admin.php?page=mediafromftp-settings'); ?>">
				<input type="submit" class="button" value="<?php _e('Settings'); ?>" />
			</form>
			<form method="post" style="float: left; margin-right: 1em;" action="<?php echo admin_url('admin.php?page=mediafromftp-search-register'); ?>" />
				<input type="submit" class="button" value="<?php _e('Search & Register', 'media-from-ftp'); ?>" />
			</form>
			<form method="post" action="<?php echo admin_url('admin.php?page=mediafromftp-log'); ?>" />
				<input type="submit" class="button" value="<?php _e('Log', 'media-from-ftp'); ?>" />
			</form>
		</div>
		<div style="clear: both;"></div>

		<h3><?php _e('Register to media library from files that have been uploaded by FTP.', 'media-from-ftp'); ?></h3>
		<h4 style="margin: 5px; padding: 5px;">
		<?php echo $plugin_version; ?> |
		<a style="text-decoration: none;" href="<?php _e('https://wordpress.org/plugins/media-from-ftp/faq', 'media-from-ftp'); ?>" target="_blank">FAQ</a> |<a style="text-decoration: none;" href="https://wordpress.org/support/plugin/media-from-ftp" target="_blank"><?php _e('Support Forums') ?></a> |
		<a style="text-decoration: none;" href="https://wordpress.org/support/view/plugin-reviews/media-from-ftp" target="_blank"><?php _e('Reviews', 'media-from-ftp') ?></a>
		</h4>

		<div style="width: 250px; height: 180px; margin: 5px; padding: 5px; border: #CCC 2px solid;">
		<h3><?php _e('Please make a donation if you like my work or would like to further the development of this plugin.', 'media-from-ftp'); ?></h3>
		<div style="text-align: right; margin: 5px; padding: 5px;"><span style="padding: 3px; color: #ffffff; background-color: #008000">Plugin Author</span> <span style="font-weight: bold;">Katsushi Kawamori</span></div>
<a style="margin: 5px; padding: 5px;" href='https://pledgie.com/campaigns/28307' target="_blank"><img alt='Click here to lend your support to: Various Plugins for WordPress and make a donation at pledgie.com !' src='https://pledgie.com/campaigns/28307.png?skin_name=chrome' border='0' ></a>
		</div>

		</div>
		<?php

	}

	/* ==================================================
	 * Sub Menu
	 */
	function settings_page() {

		if ( !current_user_can( 'upload_files' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
		}

		$submenu = 1;
		$this->options_updated($submenu);

		$def_max_execution_time = ini_get('max_execution_time');
		$scriptname = admin_url('admin.php?page=mediafromftp-settings');
		$mediafromftp_settings = get_option($this->wp_options_name());

		?>

		<div class="wrap">

		<h2>Media from FTP <?php _e('Settings'); ?>
			<form method="post" style="float: right;" action="<?php echo admin_url('admin.php?page=mediafromftp-log'); ?>" />
				<input type="submit" class="button" value="<?php _e('Log', 'media-from-ftp'); ?>" />
			</form>
			<form method="post" style="float: right; margin-right: 0.5em;" action="<?php echo admin_url('admin.php?page=mediafromftp-search-register'); ?>" />
				<input type="submit" class="button" value="<?php _e('Search & Register', 'media-from-ftp'); ?>" />
			</form>
		</h2>
		<div style="clear: both;"></div>

		<div id="mediafromftp-settings-tabs">
			<ul>
			<li><a href="#mediafromftp-settings-tabs-1"><?php _e('Settings'); ?></a></li>
			<li><a href="#mediafromftp-settings-tabs-2"><?php _e('Command-line', 'media-from-ftp'); ?></a></li>
			</ul>

			<div id="mediafromftp-settings-tabs-1">
			<div style="display: block; padding: 5px 15px">
			<form method="post" action="<?php echo $scriptname; ?>">

				<div class="item-mediafromftp-settings">
					<h3><?php _e('Execution time', 'media-from-ftp'); ?></h3>
					<div style="display:block; padding:5px 5px">
						<?php
							$max_execution_time_text = __('The number of seconds a script is allowed to run.', 'media-from-ftp').'('.__('The max_execution_time value defined in the php.ini.', 'media-from-ftp').'[<font color="red">'.$def_max_execution_time.'</font>]'.')';
							?>
							<div style="float: left;"><?php echo $max_execution_time_text; ?>:<input type="text" name="mediafromftp_max_execution_time" value="<?php echo $mediafromftp_settings['max_execution_time'] ?>" size="3" /></div>
					</div>
					<div style="clear: both;"></div>
				</div>

				<?php
				if ( function_exists('mb_check_encoding') ) {
				?>
				<div class="item-mediafromftp-settings">
					<h3><?php _e('Character Encodings for Server', 'media-from-ftp'); ?></h3>
					<p>
					<?php _e('It may fail to register if you are using a multi-byte name in the file name or folder name. In that case, please change.', 'media-from-ftp');
					$characterencodings_none_html = '<a href="'.__('https://en.wikipedia.org/wiki/Variable-width_encoding', 'media-from-ftp').'" target="_blank" style="text-decoration: none; word-break: break-all;">'.__('variable-width encoding', 'media-from-ftp').'</a>';
					echo sprintf(__('If you do not use the filename or directory name of %1$s, please choose "%2$s".','media-from-ftp'), $characterencodings_none_html, '<font color="red">none</font>');
					?>
					</p>
					<select name="mediafromftp_character_code" style="width: 210px">
					<?php
					if ( 'none' === $mediafromftp_settings['character_code'] ) {
						?>
						<option value="none" selected>none</option>
						<?php
					} else {
						?>
						<option value="none">none</option>
						<?php
					}
					foreach (mb_list_encodings() as $chrcode) {
						if ( $chrcode <> 'pass' && $chrcode <> 'auto' ) {
							if ( $chrcode === $mediafromftp_settings['character_code'] ) {
								?>
								<option value="<?php echo $chrcode; ?>" selected><?php echo $chrcode; ?></option>
								<?php
							} else {
								?>
								<option value="<?php echo $chrcode; ?>"><?php echo $chrcode; ?></option>
								<?php
							}
						}
					}
					?>
					</select>
					<div style="clear: both;"></div>
				</div>
				<?php
				}
				?>

				<div class="item-mediafromftp-settings">
					<h3><?php _e('Date'); ?></h3>
					<div style="display: block;padding:5px 5px">
					<input type="radio" name="mediafromftp_dateset" value="new" <?php if ($mediafromftp_settings['dateset'] === 'new') echo 'checked'; ?>>
					<?php _e('Update to use of the current date/time.', 'media-from-ftp'); ?>
					</div>
					<div style="display: block;padding:5px 5px">
					<input type="radio" name="mediafromftp_dateset" value="server" <?php if ($mediafromftp_settings['dateset'] === 'server') echo 'checked'; ?>>
					<?php _e('Get the date/time of the file, and updated based on it. Change it if necessary.', 'media-from-ftp'); ?>
					</div>
					<div style="display: block; padding:5px 5px">
					<input type="radio" name="mediafromftp_dateset" value="exif" <?php if ($mediafromftp_settings['dateset'] === 'exif') echo 'checked'; ?>>
					<?php
					_e('Get the date/time of the file, and updated based on it. Change it if necessary.', 'media-from-ftp');
					_e('Get by priority if there is date and time of the Exif information.', 'media-from-ftp');
					?>
					</div>
					<div style="display: block; padding:5px 5px">
					<?php
					if ( current_user_can('manage_options') ) {
						?>
						<input type="checkbox" name="move_yearmonth_folders" value="1" <?php checked('1', get_option('uploads_use_yearmonth_folders')); ?> />
						<?php
					} else {
						?>
						<input type="checkbox" disabled="disabled" value="1" <?php checked('1', get_option('uploads_use_yearmonth_folders')); ?> />
						<input type="hidden" name="move_yearmonth_folders" value="<?php echo get_option('uploads_use_yearmonth_folders'); ?>">
						<?php
					}
					_e('Organize my uploads into month- and year-based folders');
					?>
					</div>
				</div>

				<div class="item-mediafromftp-settings">
					<h3>Exif <?php _e('Caption'); ?></h3>
					<div style="display:block;padding:5px 0">
					<?php _e('Register the Exif data to the caption.', 'media-from-ftp'); ?>
					</div>
					<div style="display:block;padding:5px 0">
					<input type="checkbox" name="mediafromftp_caption_apply" value="1" <?php checked('1', $mediafromftp_settings['caption']['apply']); ?> />
					<?php _e('Apply'); ?>
					</div>
					<div style="display: block; padding:5px 20px;">
						Exif <?php _e('Tags'); ?>
						<input type="submit" style="position:relative; top:-5px;" class="button" name="mediafromftp_exif_default" value="<?php _e('Default') ?>" />
						<div style="display: block; padding:5px 20px;">
						<textarea name="mediafromftp_exif_text" style="width: 100%;"><?php echo $mediafromftp_settings['caption']['exif_text']; ?></textarea>
							<div>
							<a href="https://codex.wordpress.org/Function_Reference/wp_read_image_metadata#Return%20Values" target="_blank" style="text-decoration: none; word-break: break-all;"><?php _e('For Exif tags, please read here.', 'media-from-ftp'); ?></a>
							</div>
						</div>
					</div>
					<div>
					<?php
						if ( is_multisite() ) {
							$exifcaption_install_url = network_admin_url('plugin-install.php?tab=plugin-information&plugin=exif-caption');
						} else {
							$exifcaption_install_url = admin_url('plugin-install.php?tab=plugin-information&plugin=exif-caption');
						}
						$exifcaption_install_html = '<a href="'.$exifcaption_install_url.'" target="_blank" style="text-decoration: none; word-break: break-all;">Exif Caption</a>';
						echo sprintf(__('If you want to insert the Exif in the media that have already been registered in the media library, Please use the %1$s.','media-from-ftp'), $exifcaption_install_html);
					?>
					</div>
				</div>

				<div class="item-mediafromftp-settings">
					<h3><?php _e('Exclude file', 'media-from-ftp'); ?></h3>
					<p><?php _e('Regular expression is possible.', 'media-from-ftp'); ?></p>
					<textarea id="mediafromftp_exclude" name="mediafromftp_exclude" rows="3" style="width: 100%;"><?php echo $mediafromftp_settings['exclude']; ?></textarea>
					<div style="clear: both;"></div>
				</div>

				<div class="item-mediafromftp-settings">
					<h3><?php _e('Search method for the exclusion of the thumbnail', 'media-from-ftp'); ?></h3>
					<div style="display: block;padding:5px 5px">
					<input type="radio" name="mediafromftp_thumb_deep_search" value="0" <?php if ($mediafromftp_settings['thumb_deep_search'] == FALSE) echo 'checked'; ?>>
					<?php _e('Usual selection. It is hi speed.', 'media-from-ftp'); ?>
					</div>
					<div style="display: block;padding:5px 5px">
					<input type="radio" name="mediafromftp_thumb_deep_search" value="1" <?php if ($mediafromftp_settings['thumb_deep_search'] == TRUE) echo 'checked'; ?>>
					<?php _e('Unusual selection. if you want to search for filename that contains such -0x0. It is low speed.', 'media-from-ftp'); ?>
					</div>
					<div style="clear: both;"></div>
				</div>

				<div class="item-mediafromftp-settings">
					<h3><?php _e('Schedule', 'media-from-ftp'); ?></h3>
					<div style="display:block;padding:5px 0">
					<?php _e('Set the schedule.', 'media-from-ftp'); ?>
					<?php _e('Will take some time until the [Next Schedule] is reflected.', 'media-from-ftp'); ?>
					</div>
					<?php
					if ( wp_next_scheduled( 'MediaFromFtpCronHook' ) ) {
						$next_schedule = ' '.get_date_from_gmt(date("Y-m-d H:i:s", wp_next_scheduled( 'MediaFromFtpCronHook' )));
					} else {
						$next_schedule = ' '.__('None');
					}
					?>
					<div style="display:block;padding:5px 0">
					<?php echo __('Next Schedule:', 'media-from-ftp').$next_schedule; ?>
					</div>
					<div style="display:block;padding:5px 0">
					<input type="checkbox" name="mediafromftp_cron_apply" value="1" <?php checked('1', $mediafromftp_settings['cron']['apply']); ?> />
					<?php _e('Apply Schedule', 'media-from-ftp'); ?>
					</div>
					<div style="display:block;padding:5px 10px">
					<input type="radio" name="mediafromftp_cron_schedule" value="hourly" <?php checked('hourly', $mediafromftp_settings['cron']['schedule']); ?>>
					<?php _e('hourly', 'media-from-ftp'); ?>
					</div>
					<div style="display:block;padding:5px 10px">
					<input type="radio" name="mediafromftp_cron_schedule" value="twicedaily" <?php checked('twicedaily', $mediafromftp_settings['cron']['schedule']); ?>>
					<?php _e('twice daily', 'media-from-ftp'); ?>
					</div>
					<div style="display:block;padding:5px 10px">
					<input type="radio" name="mediafromftp_cron_schedule" value="daily" <?php checked('daily', $mediafromftp_settings['cron']['schedule']); ?>>
					<?php _e('daily', 'media-from-ftp'); ?>
					</div>
					<div style="display:block;padding:5px 10px">
					<input type="checkbox" name="mediafromftp_cron_limit_number" value="1" <?php checked('1', $mediafromftp_settings['cron']['limit_number']); ?> />
					<?php _e('Apply limit number of update files.', 'media-from-ftp'); ?>
					</div>
					<div style="display:block;padding:5px 20px">
						<?php echo __('Limit number of update files', 'media-from-ftp').': '.$mediafromftp_settings['pagemax']; ?>
						= <a href="<?php echo admin_url('admin.php?page=mediafromftp-search-register'); ?>"><?php _e('Number of items per page:'); ?></a>
					</div>
					<div style="display:block;padding:5px 10px">
					<input type="checkbox" name="mediafromftp_cron_mail_apply" value="1" <?php checked('1', $mediafromftp_settings['cron']['mail_apply']); ?> />
					<?php _e('Email me whenever'); ?>
					</div>
					<div style="display:block;padding:5px 20px">
						<?php echo __('Your Email').': '.$mediafromftp_settings['cron']['mail']; ?>
					</div>
				</div>

				<div class="item-mediafromftp-settings">
					<h3><?php _e('Log', 'media-from-ftp'); ?></h3>
					<div style="display:block;padding:5px 0">
					<?php _e('Record the registration result.', 'media-from-ftp'); ?>
					</div>
					<div style="display:block;padding:5px 0">
					<input type="checkbox" name="mediafromftp_apply_log" value="1" <?php checked('1', $mediafromftp_settings['log']); ?> />
					<?php _e('Create log', 'media-from-ftp'); ?>
					</div>
				</div>

				<div class="item-mediafromftp-settings">
					<h3><?php _e('Remove Thumbnails Cache', 'media-from-ftp'); ?></h3>
					<div style="display:block;padding:5px 0">
						<?php _e('Remove the cache of thumbnail used in the search screen. Please try out if trouble occurs in the search screen. It might become normal.', 'media-from-ftp'); ?>
					</div>
				</div>

				<div style="clear: both;"></div>
				<p>
				<div>
					<input type="submit" class="button" style="float: left; margin-right: 1em;" value="<?php _e('Save Changes'); ?>" />
				</div>
			</form>

			<form method="post" action="<?php echo $scriptname; ?>" />
				<input type="hidden" name="mediafromftp_clear_cash" value="1" />
				<div>
				<input type="submit" class="button" value="<?php _e('Remove Thumbnails Cache', 'media-from-ftp'); ?>" />
				</div>
			</form>

			</div>
			</div>

			<div id="mediafromftp-settings-tabs-2">
				<h3><?php _e('Command-line', 'media-from-ftp'); ?></h3>
				<div style="display:block; padding:5px 10px; font-weight: bold;">
				1. <?php _e('Please [mediafromftpcmd.php] rewrite the following manner.', 'media-from-ftp'); ?>
				</div>
				<div style="display:block;padding:5px 20px">
				<?php
				$commandline_host = $_SERVER['HTTP_HOST'];
				$commandline_server = $_SERVER['SERVER_NAME'];
				$commandline_uri = untrailingslashit(wp_make_link_relative(MEDIAFROMFTP_PLUGIN_SITE_URL));
				$commandline_wpload = wp_normalize_path(ABSPATH).'wp-load.php';
				$commandline_pg = wp_normalize_path(MEDIAFROMFTP_PLUGIN_BASE_DIR.'/mediafromftpcmd.php');
$commandline_set = <<<COMMANDLINESET

&#x24_SERVER = array(
"HTTP_HOST" => "$commandline_host",
"SERVER_NAME" => "$commandline_server",
"REQUEST_URI" => "$commandline_uri",
"REQUEST_METHOD" => "GET",
"HTTP_USER_AGENT" => "mediafromftp"
            );
require_once('$commandline_wpload');

COMMANDLINESET;

				$commandline_wp_options_name = $this->wp_options_name();
$commandline_set2 = <<<COMMANDLINESET2

	&#x24mediafromftpcron->CronDo('$commandline_wp_options_name');

COMMANDLINESET2;

				?>
				<?php echo sprintf(__('The line %2$d from line %1$d.', 'media-from-ftp'), 56, 63); ?>
				<textarea readonly rows="9" style="font-size: 12px; width: 100%;">
				<?php echo $commandline_set; ?>
				</textarea>
				<?php echo sprintf(__('The line %1$d.', 'media-from-ftp'), 68); ?>
				<textarea readonly rows="2" style="font-size: 12px; width: 100%;">
				<?php echo $commandline_set2; ?>
				</textarea>
				</div>
				<div style="display:block; padding:5px 10px; font-weight: bold;">
				2. <?php _e('The execution of the command line.', 'media-from-ftp'); ?>
				</div>
				<div style="display:block; padding:5px 10px;">
				<div>% <code>/usr/bin/php <?php echo $commandline_pg; ?></code></div>
				<div style="display:block; padding:5px 15px; color:red;"><code>/usr/bin/php</code> >> <?php _e('Please check with the server administrator.', 'media-from-ftp'); ?></div>
					<div style="display:block;padding:5px 20px">
					<li style="font-weight: bold;"><?php _e('command line argument list', 'media-from-ftp'); ?></li>
						<div style="display:block;padding:5px 40px">
						<div><code>-s</code> <?php _e('Search directory', 'media-from-ftp'); ?></div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-s wp-content/uploads</code></div>
							</div>
						<div style="display:block;padding:5px 40px">
						<div><code>-d</code> <?php _e('Date time settings', 'media-from-ftp'); ?> (new, server, exif)</div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-d exif</code></div>
							</div>
						<div style="display:block;padding:5px 40px">
						<div><code>-e</code> <?php _e('Exclude file', 'media-from-ftp'); ?> (<?php _e('Regular expression is possible.', 'media-from-ftp'); ?>)</div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-e "(.ktai.)|(.backwpup_log.)|(.ps_auto_sitemap.)|\.php|\.js"</code></div>
							</div>
						<div style="display:block;padding:5px 40px">
						<div><code>-t</code> <?php _e('File type:'); ?> (all, image, audio, video, document, spreadsheet, interactive, text, archive, code)</div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-t image</code></div>
							</div>
						<div style="display:block;padding:5px 40px">
						<div><code>-x</code> <?php _e('File extension' , 'media-from-ftp'); ?></div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-x jpg</code></div>
							</div>
						<div style="display:block;padding:5px 40px">
						<div><code>-p</code> <?php _e('Limit number of update files' , 'media-from-ftp'); ?></div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-p 10</code></div>
							</div>
						<div style="display:block;padding:5px 40px">
						<div><code>-c</code> <?php _e('Exif tags for registering in the caption' , 'media-from-ftp'); ?></div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-c "%title% %credit% %camera% %caption% %created_timestamp% %copyright% %aperture% %shutter_speed% %iso% %focal_length%"</code></div>
							</div>
					<div><?php _e('If the argument is empty, use the set value of the management screen.', 'media-from-ftp'); ?></div>
					</div>
					<div style="display:block;padding:5px 20px">
					<li style="font-weight: bold;"><?php _e('command line switch', 'media-from-ftp'); ?></li>
						<div style="display:block;padding:5px 40px">
						<div><code>-h</code> <?php _e('Hides the display of the log.', 'media-from-ftp'); ?></div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-h</code></div>
							</div>
						<div style="display:block;padding:5px 40px">
						<div><code>-g</code> <?php _e('Create log to database.', 'media-from-ftp'); ?></div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-g</code></div>
							</div>
						<div style="display:block;padding:5px 40px">
						<div><code>-m</code> <?php _e('If you want to search for filename that contains such -0x0. It is low speed.', 'media-from-ftp'); ?></div>
						</div>
							<div style="display:block;padding:5px 60px">
							<div><?php _e('Example:', 'media-from-ftp'); ?> <code>-m</code></div>
							</div>
					</div>
					<div style="color:red;"><?php _e('Command-line, please use by activate sure the plug-in.', 'media-from-ftp'); ?></div>
				</div>
				<div style="display:block; padding:5px 10px; font-weight: bold;">
				3. <?php _e('Register the command-line to the server cron.', 'media-from-ftp'); ?> (<?php _e('Example:', 'media-from-ftp'); ?> <?php _e('Run every 10 minutes.', 'media-from-ftp'); ?>)
				</div>
				<div style="display:block; padding:5px 10px;">
				<div><code>0,10,20,30,40,50 * * * * /usr/bin/php <?php echo $commandline_pg; ?></code></div>
				<div style="display:block; padding:5px 15px; color:red;"><code>/usr/bin/php</code> >> <?php _e('Please check with the server administrator.', 'media-from-ftp'); ?></div>
				</div>
			</div>

		</div>
		</div>
		<?php

	}

	/* ==================================================
	 * Sub Menu
	 */
	function search_register_page() {

		if ( !current_user_can( 'upload_files' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
		}

		$def_max_execution_time = ini_get('max_execution_time');

		$submenu = 2;
		$this->options_updated($submenu);

		include_once MEDIAFROMFTP_PLUGIN_BASE_DIR.'/inc/MediaFromFtp.php';
		$mediafromftp = new MediaFromFtp();
		$mediafromftp_settings = get_option($this->wp_options_name());
		$pagemax = $mediafromftp_settings['pagemax'];
		$searchdir = $mediafromftp_settings['searchdir'];
		$ext2typefilter = $mediafromftp_settings['ext2typefilter'];
		$extfilter = $mediafromftp_settings['extfilter'];
		$max_execution_time = $mediafromftp_settings['max_execution_time'];

		set_time_limit($max_execution_time);

		$adddb = FALSE;
		if (!empty($_POST['adddb'])){
			$adddb = $_POST['adddb'];
		}

		$scriptname = admin_url('admin.php?page=mediafromftp-search-register');

		$document_root = ABSPATH.$searchdir;

		$mediafromftp->mb_initialize($mediafromftp_settings['character_code']);
		$document_root = $mediafromftp->mb_encode_multibyte($document_root, $mediafromftp_settings['character_code']);

		if ( strstr($searchdir, '../') ) {
			$document_root = realpath($document_root);
		}

		$searchtext = NULL;
		$message_searchtext = NULL;
		if ( !empty($_POST['searchtext']) ) {
			$searchtext = $_POST['searchtext'];
		} else if ( !empty($_GET['searchtext']) ) {
			$searchtext = $_GET['searchtext'];
		}
		if ( !empty($searchtext) ) {
			$searchtext = $mediafromftp->mb_utf8($searchtext, $mediafromftp_settings['character_code']);
			$message_searchtext = sprintf(__('Search Results of <span style="color: red; font-weight: bold;">%1$s</span>.', 'media-from-ftp'), $searchtext);
		}

		?>

		<div class="wrap">

		<h2>Media from FTP <?php _e('Search & Register', 'media-from-ftp'); ?>
			<form method="post" style="float: right;" action="<?php echo admin_url('admin.php?page=mediafromftp-log'); ?>" />
				<input type="submit" class="button" value="<?php _e('Log', 'media-from-ftp'); ?>" />
			</form>
			<form method="post" style="float: right; margin-right: 0.5em;" action="<?php echo admin_url('admin.php?page=mediafromftp-settings'); ?>">
				<input type="submit" class="button" value="<?php _e('Settings'); ?>" />
			</form>
		</h2>
		<div style="clear: both;"></div>

		<div id="mediafromftp-loading"><img src="<?php echo MEDIAFROMFTP_PLUGIN_URL.'/css/loading.gif'; ?>"></div>
		<div id="mediafromftp-loading-container">
		<?php
		global $wpdb;
		$user = wp_get_current_user();
		if ( $adddb <> 'TRUE' ) { // Search mode
			$dirs = $mediafromftp->scan_dir(MEDIAFROMFTP_PLUGIN_UPLOAD_DIR);
			$linkselectbox = NULL;
			$wordpress_path = wp_normalize_path(ABSPATH);
			foreach ($dirs as $linkdir) {
				if ( strstr($linkdir, $wordpress_path ) ) {
					$linkdirenc = $mediafromftp->mb_utf8(str_replace($wordpress_path, '', $linkdir), $mediafromftp_settings['character_code']);
				} else {
					$linkdirenc = MEDIAFROMFTP_PLUGIN_UPLOAD_PATH.$mediafromftp->mb_utf8(str_replace(MEDIAFROMFTP_PLUGIN_UPLOAD_DIR, "", $linkdir), $mediafromftp_settings['character_code']);
				}
				if( $searchdir === $linkdirenc ){
					$linkdirs = '<option value="'.urlencode($linkdirenc).'" selected>'.$linkdirenc.'</option>';
				}else{
					$linkdirs = '<option value="'.urlencode($linkdirenc).'">'.$linkdirenc.'</option>';
				}
				$linkselectbox = $linkselectbox.$linkdirs;
			}
			if( $searchdir ===  MEDIAFROMFTP_PLUGIN_UPLOAD_PATH ){
				$linkdirs = '<option value="'.urlencode(MEDIAFROMFTP_PLUGIN_UPLOAD_PATH).'" selected>'.MEDIAFROMFTP_PLUGIN_UPLOAD_PATH.'</option>';
			}else{
				$linkdirs = '<option value="'.urlencode(MEDIAFROMFTP_PLUGIN_UPLOAD_PATH).'">'.MEDIAFROMFTP_PLUGIN_UPLOAD_PATH.'</option>';
			}
			$linkselectbox = $linkselectbox.$linkdirs;
			?>
			<form method="post" action="<?php echo $scriptname; ?>">
				<div style="float:left;"><?php _e('Number of items per page:'); ?><input type="text" name="mediafromftp_pagemax" value="<?php echo $pagemax; ?>" size="3" /></div>
				<input type="submit" name="ShowToPage" class="button" value="<?php _e('Save') ?>" />
				<div style="clear: both;"></div>
				<div style="font-size: small; font-weight: bold;"><code><?php echo $wordpress_path; ?></code></div>
				<div>
					<select name="searchdir" style="width: 250px">
					<?php echo $linkselectbox; ?>
					</select>
					<input type="hidden" name="adddb" value="FALSE">
					<input type="submit" class="button" value="<?php _e('Search'); ?>" />
					<span style="margin-right: 1em;"></span>
					<select name="ext2type" style="width: 110px;">
					<option value="all" <?php if ($ext2typefilter === 'all') echo 'selected';?>><?php echo esc_attr( __('All types', 'media-from-ftp') ); ?></option> 
					<option value="image" <?php if ($ext2typefilter === 'image') echo 'selected';?>>image</option>
					<option value="audio" <?php if ($ext2typefilter === 'audio') echo 'selected';?>>audio</option>
					<option value="video" <?php if ($ext2typefilter === 'video') echo 'selected';?>>video</option>
					<option value="document" <?php if ($ext2typefilter === 'document') echo 'selected';?>>document</option>
					<option value="spreadsheet" <?php if ($ext2typefilter === 'spreadsheet') echo 'selected';?>>spreadsheet</option>
					<option value="interactive" <?php if ($ext2typefilter === 'interactive') echo 'selected';?>>interactive</option>
					<option value="text" <?php if ($ext2typefilter === 'text') echo 'selected';?>>text</option>
					<option value="archive" <?php if ($ext2typefilter === 'archive') echo 'selected';?>>archive</option>
					<option value="code" <?php if ($ext2typefilter === 'code') echo 'selected';?>>code</option>
					</select>
					<select name="extension" style="width: 120px;">
					<option value="all" <?php if ($extfilter === 'all') echo 'selected';?>><?php echo esc_attr( __('All extensions', 'media-from-ftp') ); ?></option>
					<?php
					$extensions = $mediafromftp->scan_extensions($ext2typefilter);
					foreach ($extensions as $extselect) {
						?>
						<option value="<?php echo $extselect; ?>" <?php if ($extfilter === $extselect) echo 'selected';?>><?php echo $extselect; ?></option>
						<?php
					}
					?>
					</select>
					<?php
					if ( empty($searchtext) ) {
						?>
						<input name="searchtext" type="text" value="" placeholder="<?php echo __('Search'); ?>">
						<?php
					} else {
						?>
						<input name="searchtext" type="text" value="" placeholder="<?php echo $searchtext; ?>">
						<?php
					}
					?>
					<input type="submit" class="button" value="<?php _e('Filter'); ?>">
				</div>
			</form>
			<?php
			$attachments = $wpdb->get_results("
							SELECT ID
							FROM $wpdb->posts
							WHERE post_type = 'attachment'
							");

			$extpattern = $mediafromftp->extpattern($extfilter);
			$files = $mediafromftp->scan_file($document_root, $extpattern, $mediafromftp_settings);
			if (!empty($_GET['sort'])){
				$sortkey = $_GET['sort'];
			} else {
				$sortkey = $mediafromftp_settings['sort'];
			}
			if ( $sortkey === 'des' ) {
				rsort($files, SORT_NATURAL | SORT_FLAG_CASE | SORT_LOCALE_STRING);
			} else {
				sort($files, SORT_NATURAL | SORT_FLAG_CASE | SORT_LOCALE_STRING);
			}

			$searchfiles = array();
			$search_ext = array();
			$search_new_url = array();
			$pageallcount = 0;
			foreach ( $files as $file ){
				// Input URL
				list($new_file, $ext, $new_url) = $mediafromftp->input_url($file, $attachments, $mediafromftp_settings['character_code'], $mediafromftp_settings['thumb_deep_search']);
				if ($new_file) {
					$searchfiles[$pageallcount] = $file;
					$search_ext[$pageallcount] = $ext;
					$search_new_url[$pageallcount] = $new_url;
					++$pageallcount;
				}
			}
			unset($files);

			// pagenation
			if( !empty($_GET['ext2typefilter']) ) {
				$ext2typefilter = $_GET['ext2typefilter'];
			}
			if( !empty($_GET['extfilter']) ) {
				$extfilter = $_GET['extfilter'];
			}
			$pagelast = ceil($pageallcount / $pagemax);
			if ( !empty($_POST['mediafromftp_page']) ) {
				$page = intval($_POST['mediafromftp_page']);
				if ( $page <= 0 ) {
					$page = 1;
				} else if ( $page > $pagelast ) {
					$page = $pagelast;
				}
			} else {
				if (!empty($_GET['p'])){
					$page = $_GET['p'];
				} else {
					$page = 1;
				}
			}
			$pagebegin = (($page - 1) * $pagemax) + 1;
			$pageend = $page * $pagemax;

			?>
			<form method="post" action="<?php echo $scriptname; ?>">
			<input type="hidden" name="adddb" value="FALSE">
			<?php
			$this->pagenation($page, $pagebegin, $pageend, $pagelast, $pageallcount, $scriptname, $ext2typefilter, $extfilter, $sortkey, $searchtext, 'jump');
			?>
			</form>
			<?php
			if ( $pageallcount > 0 ) {
			?>
			<form method="post" action="<?php echo $scriptname; ?>">
			<div class="submit" style="padding-top: 5px; padding-bottom: 5px;">
				<input type="hidden" name="adddb" value="TRUE">
				<input type="hidden" name="searchdir" value="<?php echo $searchdir; ?>">
				<input type="hidden" name="ext2type" value="<?php echo $ext2typefilter; ?>">
				<input type="hidden" name="extension" value="<?php echo $extfilter; ?>">
				<input type="submit" class="button-primary button-large" value="<?php _e('Update Media'); ?>" />
			</div>
			<div style="border-bottom: 1px solid; padding-top: 5px; padding-bottom: 5px;">
			<input type="checkbox" id="group_media-from-ftp" class="mediafromftp-checkAll"><?php _e('Select all'); ?>
			<?php
			if ( $sortkey === 'des' ) {
				$newsortkey = 'asc';
				$newsort_text = __('Ascending');
				$dashiconname = 'dashicons-arrow-up';
			} else {
				$newsortkey = 'des';
				$newsort_text = __('Descending');
				$dashiconname = 'dashicons-arrow-down';
			}
			$scriptname_plusarg = add_query_arg( array('p' => $page, 'ext2typefilter' => $ext2typefilter, 'extfilter' => $extfilter, 'sort' => $newsortkey, 'searchtext' => $searchtext ),  $scriptname);
			?>
			<a title="<?php echo $newsort_text; ?>" href="<?php echo $scriptname_plusarg; ?>" style="text-decoration: none; display:inline-block; vertical-align:middle;"> <span class="dashicons <?php echo $dashiconname; ?>"></span><?php echo $newsort_text; ?></a>
			</div>
			<div style="border-bottom: 1px solid; padding-top: 5px; padding-bottom: 5px;">
			<?php _e('Select'); ?> & <?php _e('Thumbnail'); ?> & <?php _e('Metadata'); ?>
			</div>
			<div style="clear: both;"></div>
			<?php
			}

			$this->postcount = 0;
			for ( $i = 0; $i < $pageallcount; $i++ ) {
				$file = $searchfiles[$i];
				$ext = $search_ext[$i];
				$new_url = $search_new_url[$i];
				if ( $pagebegin <= $i+1 && $i+1 <= $pageend ) {
					if ( $adddb <> 'TRUE' ) {
							$input_html = NULL;
							$input_html .= '<div style="border-bottom: 1px solid; padding-top: 5px; padding-bottom: 5px;">';
							$input_html .= '<input name="new_url_attaches['.$this->postcount.'][url]" type="checkbox" value="'.$new_url.'" class="group_media-from-ftp" style="float: left; margin: 5px;">';
							$file_size = size_format(filesize($file));
							$mimetype = $ext.'('.$mediafromftp->mime_type($ext).')';
							if ( wp_ext2type($ext) === 'image' ){
								$view_thumb_url = $mediafromftp->create_cash($ext, $file, $new_url);
							} else if ( wp_ext2type($ext) === 'audio' ) {
								$view_thumb_url = MEDIAFROMFTP_PLUGIN_SITE_URL. WPINC . '/images/media/audio.png';
								$metadata_audio = wp_read_audio_metadata( $file );
								$file_size = size_format($metadata_audio['filesize']);
								$mimetype = $metadata_audio['fileformat'].'('.$metadata_audio['mime_type'].')';
								$length = $metadata_audio['length_formatted'];
							} else if ( wp_ext2type($ext) === 'video' ) {
								$view_thumb_url = MEDIAFROMFTP_PLUGIN_SITE_URL. WPINC . '/images/media/video.png';
								$metadata_video = wp_read_video_metadata( $file );
								$file_size = size_format($metadata_video['filesize']);
								$mimetype = $metadata_video['fileformat'].'('.$metadata_video['mime_type'].')';
								$length = $metadata_video['length_formatted'];
							} else {
								$filetype2 = wp_ext2type($ext);
								if ( empty($filetype2) ) { $filetype2 = 'default'; }
								$view_thumb_url = MEDIAFROMFTP_PLUGIN_SITE_URL. WPINC . '/images/media/'.$filetype2.'.png';
							}
							$input_html .= '<img width="40" height="40" src="'.$view_thumb_url.'" style="float: left; margin: 5px;">';
							$input_html .= '<div style="overflow: hidden;">';
							$input_html .= '<div>URL:<a href="'.$new_url.'" target="_blank" style="text-decoration: none; word-break: break-all;">'.$new_url.'</a></div>';
							$input_html .= '<div>'.__('File type:').' '.$mimetype.'</div>';
							$input_html .= '<div>'.__('File size:').' '.$file_size.'</div>';
							if ( wp_ext2type($ext) === 'audio' || wp_ext2type($ext) === 'video' ) {
								$input_html .= '<div>'.__('Length:').' '.$length.'</div>';
							}
							$date = $mediafromftp->get_date_check($file, $mediafromftp_settings['dateset']);
							if ( $mediafromftp_settings['dateset'] === 'new' ) {
								$input_html .= '<input type="hidden" id="datetimepicker-mediafromftp'.$this->postcount.'" name="new_url_attaches['.$this->postcount.'][datetime]" value="'.$date.'">';
							} else {
								$input_html .= '<div style="float: left; margin: 5px 5px 0px 0px;">'.__('Edit date and time').'</div>';
								$input_html .= '<input type="text" id="datetimepicker-mediafromftp'.$this->postcount.'" name="new_url_attaches['.$this->postcount.'][datetime]" value="'.$date.'" style="width: 160px;">';
							}
							$input_html .= '</div></div>';

							echo $input_html;

						++$this->postcount;
					}
				}
			}
			unset($searchfiles, $search_ext, $search_new_url, $attachments);

			if ( $this->postcount == 0 ) {
				echo '<div class="updated"><ul><li>'.$message_searchtext.__('There is no file that is not registered in the media library.', 'media-from-ftp').'</li></ul></div>';
			} else {
				?>
				<div style="border-bottom: 1px solid; padding-top: 5px; padding-bottom: 5px;">
				<?php _e('Select'); ?> & <?php _e('Thumbnail'); ?> & <?php _e('Metadata'); ?>
				</div>
				<div style="padding-top: 5px; padding-bottom: 5px;">
				<input type="checkbox" id="group_media-from-ftp" class="mediafromftp-checkAll"><?php _e('Select all'); ?>
				</div>
				<div class="submit" style="padding-top: 5px; padding-bottom: 5px;">
					<input type="hidden" name="adddb" value="TRUE">
					<input type="hidden" name="searchdir" value="<?php echo $searchdir; ?>">
					<input type="hidden" name="ext2type" value="<?php echo $ext2typefilter; ?>">
					<input type="hidden" name="extension" value="<?php echo $extfilter; ?>">
					<input type="submit" class="button-primary button-large" value="<?php _e('Update Media'); ?>" />
				</div>
				</form>
				<?php
				$this->pagenation($page, $pagebegin, $pageend, $pagelast, $pageallcount, $scriptname, $ext2typefilter, $extfilter, $sortkey, $searchtext, NULL);
				if ( $this->postcount > 0 ) {
					echo '<div class="updated"><ul><li>'.$message_searchtext.__('These files is a file that is not registered in the media library. And can be registered.', 'media-from-ftp').'</li></ul></div>';
				}
			}
		} else { // Register mode ($adddb === 'TRUE')
			$new_url_attaches = $_POST["new_url_attaches"];
			if (!empty($new_url_attaches)) {
				?>
				<div class="submit">
				<form method="post" style="float: left; margin-right: 1em;" action="<?php echo $scriptname; ?>">
					<input type="hidden" name="searchdir" value="<?php echo $searchdir; ?>">
					<input type="hidden" name="ext2type" value="<?php echo $ext2typefilter; ?>">
					<input type="hidden" name="extension" value="<?php echo $extfilter; ?>">
					<input type="submit" class="button" value="<?php _e('Search'); ?>" />
				</form>
				<form method="post" action="<?php echo admin_url( 'upload.php'); ?>">
					<input type="submit" class="button" value="<?php _e('Media Library'); ?>" />
				</form>
				</div>
				<div style="clear: both;"></div>
				<?php
				$dateset = $mediafromftp_settings['dateset'];
				$yearmonth_folders = get_option('uploads_use_yearmonth_folders');
				$exif_text_tag = NULL;
				if ( $mediafromftp_settings['caption']['apply'] ) {
					$exif_text_tag = $mediafromftp_settings['caption']['exif_text'];
				}
				$regist_count = 0;
				foreach ( $new_url_attaches as $postkey1 => $postval1 ){
					foreach ( $postval1 as $postkey2 => $postval2 ){
						if ( $postkey2 === 'url' ) {
							$new_url_attach = $postval1[$postkey2];
							$new_url_datetime = $postval1['datetime'];
							$exts = explode('.', wp_basename($new_url_attach));
							$ext = end($exts);

							// Delete Cash
							$mediafromftp->delete_cash($ext, $new_url_attach);

							// Regist
							list($attach_id, $new_attach_title, $new_url_attach, $metadata) = $mediafromftp->regist($ext, $new_url_attach, $new_url_datetime, $dateset, $yearmonth_folders, $mediafromftp_settings['character_code'], $mediafromftp_settings['cron']['user']);
							if ( $attach_id == -1 ) { // error
								$error_title = $mediafromftp->mb_utf8($new_attach_title, $mediafromftp_settings['character_code']);
								$error_url = $mediafromftp->mb_utf8($new_url_attach, $mediafromftp_settings['character_code']);
								echo '<div class="error"><ul><li>'.'<div>'.__('File name:').$error_title.'</div>'.'<div>'.__('Directory name:', 'media-from-ftp').$error_url.'</div>'.sprintf(__('<div>You need to make this directory writable before you can register this file. See <a href="%1$s" target="_blank">the Codex</a> for more information.</div><div>Or, filename or directoryname must be changed of illegal. Please change Character Encodings for Server of <a href="%2$s">Settings</a>.</div>', 'media-from-ftp'), 'http://codex.wordpress.org/Changing_File_Permissions', admin_url('admin.php?page=mediafromftp-settings')).'</li></div>';
							} else {
								// Outputdata
								list($imagethumburls, $mimetype, $length, $stamptime, $file_size) = $mediafromftp->output_metadata($ext, $attach_id, $metadata, $mediafromftp_settings['character_code']);

								$image_attr_thumbnail = wp_get_attachment_image_src($attach_id, 'thumbnail', true);
								$exif_text = NULL;
								$thumbnail = array();
								$thumbnail[1] = NULL;
								$thumbnail[2] = NULL;
								$thumbnail[3] = NULL;
								$thumbnail[4] = NULL;
								$thumbnail[5] = NULL;
								$thumbnail[6] = NULL;

								$output_html = NULL;
								$output_html .= '<div style="border-bottom: 1px solid; padding-top: 5px; padding-bottom: 5px;">';
								$output_html .= '<img width="40" height="40" src="'.$image_attr_thumbnail[0].'" style="float: left; margin: 5px;">';
								$output_html .= '<div style="overflow: hidden;">';
								$output_html .= '<div>ID: '.$attach_id.'</div>';
								$output_html .= '<div>'.__('Title').': '.$new_attach_title.'</div>';
								$output_html .= '<div>'.__('Permalink:').' <a href="'.get_attachment_link($attach_id).'" target="_blank" style="text-decoration: none; word-break: break-all;">'.get_attachment_link($attach_id).'</a></div>';
								$output_html .= '<div>URL: <a href="'.$new_url_attach.'" target="_blank" style="text-decoration: none; word-break: break-all;">'.$new_url_attach.'</a></div>';
								$new_url_attachs = explode('/', $new_url_attach);
								$output_html .= '<div>'.__('File name:').' '.end($new_url_attachs).'</div>';

								$output_html .= '<div>'.__('Date/Time').': '.$stamptime.'</div>';
								if ( !$file_size ) {
									$file_size = '<font color="red">'.__('Could not retrieve.', 'media-from-ftp').'</font>';
								} else {
									$file_size = size_format($file_size);
								}
								$output_html .= '<div>'.__('File type:').' '.$mimetype.'</div>';
								$output_html .= '<div>'.__('File size:').' '.$file_size.'</div>';
								if ( wp_ext2type($ext) === 'image' ) {
									$output_html .= '<div>'.__('Images').': ';
									$thumb_count = 0;
									foreach ( $imagethumburls as $thumbsize => $imagethumburl ) {
										$output_html .= '[<a href="'.$imagethumburl.'" target="_blank" style="text-decoration: none; word-break: break-all;">'.$thumbsize.'</a>]';
										++$thumb_count;
										$thumbnail[$thumb_count] = $imagethumburl;
									}
									$output_html .= '</div>';
									if ( !empty($exif_text_tag) ) {
										$mime_type = $mediafromftp->mime_type($ext);
										if ( $mime_type === 'image/jpeg' || $mime_type === 'image/tiff' ) {
											$exif_text = $mediafromftp->exifcaption($attach_id, $metadata, $exif_text_tag);
											if ( !empty($exif_text) ) {
												$output_html .= '<div>'.__('Caption').'[Exif]: '.$exif_text.'</div>';
											}
										}
									}
								} else {
									if ( wp_ext2type($ext) === 'video' || wp_ext2type($ext) === 'audio' ) {
										$output_html .= '<div>'.__('Length:').' '.$length.'</div>';
									}
								}
								$output_html .= '</div></div>';
								echo $output_html;

								if ( $mediafromftp_settings['log'] ) {
									// Log
									$log_arr = array(
										'id' => $attach_id,
										'user' => $user->display_name,
										'title' => $new_attach_title,
										'permalink' => get_attachment_link($attach_id),
										'url' => $new_url_attach,
										'filename' => end($new_url_attachs),
										'time' => $stamptime,
										'filetype' => $mimetype,
										'filesize' => $file_size,
										'exif' => $exif_text,
										'length' => $length,
										'thumbnail1' => $thumbnail[1],
										'thumbnail2' => $thumbnail[2],
										'thumbnail3' => $thumbnail[3],
										'thumbnail4' => $thumbnail[4],
										'thumbnail5' => $thumbnail[5],
										'thumbnail6' => $thumbnail[6]
										);
									$table_name = $wpdb->prefix.'mediafromftp_log';
									$wpdb->insert( $table_name, $log_arr);
									$wpdb->show_errors();
								}

								++$regist_count;
							}
						}
					}
				}
				if ( $regist_count > 0 ) {
					echo '<div class="updated"><ul><li>'.__('These files was registered to the media library.', 'media-from-ftp').'</li></ul></div>';
				}
			}
			unset($new_url_attaches);

			if ( $regist_count > 0 ) {
				?>
				<div class="submit">
				<form method="post" style="float: left; margin-right: 1em;" action="<?php echo $scriptname; ?>">
					<input type="hidden" name="searchdir" value="<?php echo $searchdir; ?>">
					<input type="hidden" name="ext2type" value="<?php echo $ext2typefilter; ?>">
					<input type="hidden" name="extension" value="<?php echo $extfilter; ?>">
					<input type="submit" class="button" value="<?php _e('Search'); ?>" />
				</form>
				<form method="post" action="<?php echo admin_url( 'upload.php'); ?>">
					<input type="submit" class="button" value="<?php _e('Media Library'); ?>" />
				</form>
				</div>
				<div style="clear: both;"></div>
				<?php
			}
		}
		?>
		</div>
		</div>
		<?php
	}

	/* ==================================================
	 * Sub Menu
	 */
	function log_page() {

		if ( !current_user_can( 'upload_files' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
		}

		$mediafromftp_settings = get_option($this->wp_options_name());
		if ( !$mediafromftp_settings['log'] ) {
			echo '<div class="error"><ul><li>'.__('Current, log is not created. If you want to create a log, please put a check in the [Create log] in the settings.', 'media-from-ftp').'</li></ul></div>';
		}
		$max_execution_time = $mediafromftp_settings['max_execution_time'];
		set_time_limit($max_execution_time);

		?>
		<div class="wrap">

		<h2>Media from FTP <?php _e('Log', 'media-from-ftp'); ?>
			<form method="post" style="float: right;" action="<?php echo admin_url('admin.php?page=mediafromftp-search-register'); ?>" />
				<input type="submit" class="button" value="<?php _e('Search & Register', 'media-from-ftp'); ?>" />
			</form>
			<form method="post" style="float: right; margin-right: 0.5em;" action="<?php echo admin_url('admin.php?page=mediafromftp-settings'); ?>">
				<input type="submit" class="button" value="<?php _e('Settings'); ?>" />
			</form>
		</h2>
		<div style="clear: both;"></div>

		<div id="mediafromftp-loading"><img src="<?php echo MEDIAFROMFTP_PLUGIN_URL.'/css/loading.gif'; ?>"></div>
		<div id="mediafromftp-loading-container">
		<?php
		global $wpdb;

		$user = wp_get_current_user();

		$table_name = $wpdb->prefix.'mediafromftp_log';

		if ( !empty($_POST['mediafromftp_clear_log']) && $_POST['mediafromftp_clear_log'] == 1 ) {
			if ( current_user_can('administrator') ) {
				$wpdb->query("DELETE FROM $table_name");
				echo '<div class="updated"><ul><li>'.__('Removed all of the log.', 'media-from-ftp').'</li></ul></div>';
			} else {
				$delete_count = $wpdb->delete($table_name, array( 'user' => $user->display_name ));
				if ( $delete_count > 0 ) {
					echo '<div class="updated"><ul><li>'.sprintf(__('%1$s of the log has been deleted %2$d.', 'media-from-ftp'), $user->display_name, $delete_count ).'</li></ul></div>';
				} else {
					echo '<div class="error"><ul><li>'.sprintf(__('%1$s do not have a possible deletion log.', 'media-from-ftp'), $user->display_name ).'</li></ul></div>';
				}
			}
		}

		$records = $wpdb->get_results("SELECT * FROM $table_name");

		$html = '<table id="mediafromftp-table"><tr><th>ID</th><th>'.__('Author').':</th><th>'.__('Title').':</th><th>'.__('Permalink:').'</th><th>URL:</th><th>'.__('File name:').'</th><th>'.__('Date/Time').':</th><th>'.__('File type:').'</th><th>'.__('File size:').'</th><th>'.__('Caption').'[Exif]:</th><th>'.__('Length:').'</th><th>'.__('Featured Image').'1:</th><th>'.__('Featured Image').'2:</th><th>'.__('Featured Image').'3:</th><th>'.__('Featured Image').'4:</th><th>'.__('Featured Image').'5:</th><th>'.__('Featured Image').'6:</th></tr>'."\n";

		$csv = '"ID","'.__('Author').'","'.__('Title').':","'.__('Permalink:').'","URL:","'.__('File name:').'","'.__('Date/Time').':","'.__('File type:').'","'.__('File size:').'","'.__('Caption').'[Exif]:","'.__('Length:').'","'.__('Featured Image').'1:","'.__('Featured Image').'2:","'.__('Featured Image').'3:","'.__('Featured Image').'4:","'.__('Featured Image').'5:","'.__('Featured Image').'6:"'."\n";
		foreach ( $records as $record ) {
			$csvs = '"'.$record->id.'","'.$record->user.'","'.$record->title.'","'.$record->permalink.'","'.$record->url.'","'.$record->filename.'","'.$record->time.'","'.$record->filetype.'","'.$record->filesize.'","'.$record->exif.'","'.$record->length.'","'.$record->thumbnail1.'","'.$record->thumbnail2.'","'.$record->thumbnail3.'","'.$record->thumbnail4.'","'.$record->thumbnail5.'","'.$record->thumbnail6.'"'."\n";

			$csv .= $csvs;
			$html .= '<tr>';
			$html .= '<td>'.$record->id.'</td>';
			$html .= '<td>'.$record->user.'</td>';
			$html .= '<td>'.$record->title.'</td>';
			$html .= '<td>'.$record->permalink.'</td>';
			$html .= '<td>'.$record->url.'</td>';
			$html .= '<td>'.$record->filename.'</td>';
			$html .= '<td>'.$record->time.'</td>';
			$html .= '<td>'.$record->filetype.'</td>';
			$html .= '<td>'.$record->filesize.'</td>';
			$html .= '<td>'.$record->exif.'</td>';
			$html .= '<td>'.$record->length.'</td>';
			$html .= '<td>'.$record->thumbnail1.'</td>';
			$html .= '<td>'.$record->thumbnail2.'</td>';
			$html .= '<td>'.$record->thumbnail3.'</td>';
			$html .= '<td>'.$record->thumbnail4.'</td>';
			$html .= '<td>'.$record->thumbnail5.'</td>';
			$html .= '<td>'.$record->thumbnail6.'</td>';
			$html .= '</tr>'."\n";
		}
		$html .= '</table>'."\n";

		$csvFileName = MEDIAFROMFTP_PLUGIN_TMP_DIR.'/'.$table_name.'.csv';
		if ( !empty($_POST['mediafromftp_put_log']) && $_POST['mediafromftp_put_log'] == 1 ) {
			file_put_contents($csvFileName, pack('C*',0xEF,0xBB,0xBF)); //UTF-8 BOM
			file_put_contents($csvFileName, $csv, FILE_APPEND | LOCK_EX);
		} else {
			if ( file_exists($csvFileName) ) {
				unlink($csvFileName);
			}
		}

		if ( !empty($records) ) {
			?>
			<div style="display: block; padding: 10px 10px">
			<form style="float: left;" method="post" action="<?php echo admin_url('admin.php?page=mediafromftp-log'); ?>" />
				<input type="hidden" name="mediafromftp_clear_log" value="1" />
				<div>
				<input type="submit" class="button" value="<?php _e('Delete log', 'media-from-ftp'); ?>" />
				</div>
			</form>
			<form style="float: left; margin-left: 0.5em; margin-right: 0.5em;" method="post" action="<?php echo admin_url('admin.php?page=mediafromftp-log'); ?>" />
				<input type="hidden" name="mediafromftp_put_log" value="1" />
				<div>
				<input type="submit" class="button" value="<?php _e('Export to CSV', 'media-from-ftp'); ?>" />
				</div>
			</form>
			<?php
			if ( file_exists($csvFileName) ) {
				?>
				<form method="post" action="<?php echo MEDIAFROMFTP_PLUGIN_TMP_URL.'/'.$table_name.'.csv'; ?>" />
					<div>
					<input type="hidden" name="mediafromftp_download" value="1" />
					<input type="submit" class="button" value="<?php _e('Download CSV', 'media-from-ftp'); ?>" />
					</div>
				</form>
				<?php
			}
			?>
			</div>
			<div style="clear: both;"></div>
			<div style="display: block; padding: 10px 10px">
			<?php echo $html;
			?>
			</div>
			<?php
		} else {
			if ( $mediafromftp_settings['log'] ) {
				echo '<div class="updated"><ul><li>'.__('There is no log.', 'media-from-ftp').'</li></ul></div>';
			}
		}
		?>
		</div>

		</div>

		<?php

	}

	/* ==================================================
	 * Pagenation
	 * @since	5.1
	 * string	$page
	 * string	$pagebegin
	 * string	$pageend
	 * string	$pagelast
	 * string	$pageallcount
	 * string	$scriptname
	 * string	$ext2typefilter
	 * string	$extfilter
	 * string	$sortkey
	 * string	$searchtext
	 * string	$flag
	 * return	$html
	 */
	function pagenation($page, $pagebegin, $pageend, $pagelast, $pageallcount, $scriptname, $ext2typefilter, $extfilter, $sortkey, $searchtext, $flag){

		$pageprev = $page - 1;
		$pagenext = $page + 1;
		$scriptnamefirst = add_query_arg( array('p' => '1', 'ext2typefilter' => $ext2typefilter, 'extfilter' => $extfilter, 'sort' => $sortkey, 'searchtext' => $searchtext ),  $scriptname);
		$scriptnameprev = add_query_arg( array('p' => $pageprev, 'ext2typefilter' => $ext2typefilter, 'extfilter' => $extfilter, 'sort' => $sortkey, 'searchtext' => $searchtext ),  $scriptname);
		$scriptnamenext = add_query_arg( array('p' => $pagenext, 'ext2typefilter' => $ext2typefilter, 'extfilter' => $extfilter, 'sort' => $sortkey, 'searchtext' => $searchtext ),  $scriptname);
		$scriptnamelast = add_query_arg( array('p' => $pagelast, 'ext2typefilter' => $ext2typefilter, 'extfilter' => $extfilter, 'sort' => $sortkey, 'searchtext' => $searchtext ),  $scriptname);

		if ( $pagelast > 0 ) {
			if ( $flag === 'jump' ) {
				?>
				<div style="width: 100%; text-align: center; margin: 20px 0px 0px;">
				<?php echo sprintf(__('%s item'), $pageallcount);
				?>
				</div>
				<?php
			} else {
				?>
				<div style="width: 100%; text-align: center; margin: 10px 0px 0px;">
				<?php echo sprintf(__('%s item'), $pageallcount);
				?>
				</div>
				<?php
			}
		}
		if ( $pagelast > 1 ) {
			if ( $flag === 'jump' ) {
				?>
				<div style="width: 100%; text-align: center; margin: 0px 0px 10px;">
				<?php
			} else {
				?>
				<div style="width: 100%; text-align: center; margin: 15px 0px 20px;">
				<?php
			}
			$a_style = 'style="padding: 13px; font-size: 13px; text-decoration: none; background: #d3d3d3;" onmouseover="this.style.backgroundColor=&#39;#ffffff&#39;" onmouseout="this.style.backgroundColor=&#39;#d3d3d3&#39;"';
			if ( $page <> 1 ){
				?><a <?php echo $a_style; ?> title='<?php _e('Go to the first page', 'media-from-ftp'); ?>' href='<?php echo $scriptnamefirst; ?>'>&laquo;</a>
				<a <?php echo $a_style; ?> title='<?php _e('Go to the previous page', 'media-from-ftp'); ?>' href='<?php echo $scriptnameprev; ?>'>&lsaquo;</a>
			<?php
			}
			echo $page;
			?>/
			<?php echo $pagelast;
			if ( $page <> $pagelast ){
				?>&nbsp;<a <?php echo $a_style; ?> title='<?php _e('Go to the next page', 'media-from-ftp'); ?>' href='<?php echo $scriptnamenext; ?>'>&rsaquo;</a>
				<a <?php echo $a_style; ?> title='<?php _e('Go to the last page', 'media-from-ftp'); ?>' href='<?php echo $scriptnamelast; ?>'>&raquo;</span></a>
			<?php
			}
			if ( $flag === 'jump' ) {
				?>
				<input type="hidden" name="searchtext" value="<?php echo $searchtext; ?>">
				<input type="text" name="mediafromftp_page" value="<?php echo $page; ?>" size="3" style="padding: 13px; font-size: 13px;" /><button type="submit" style="padding: 10px; font-size: 13px; vertical-align: 2px; color: #00abd2; background: #d3d3d3;" onmouseover="this.style.backgroundColor='#ffffff'" onmouseout="this.style.backgroundColor='#d3d3d3'" title="<?php _e('jump', 'media-from-ftp'); ?>"><span class="dashicons dashicons-leftright"></span></button>
				<?php
			}
			?>
			</div>
			<div style="clear:both"></div>
			<?php
		}
	}

	/* ==================================================
	 * Update wp_options table.
	 * @param	string	$submenu
	 * @since	2.36
	 */
	function options_updated($submenu){

		include_once MEDIAFROMFTP_PLUGIN_BASE_DIR.'/req/MediaFromFtpCron.php';
		$mediafromftpcron = new MediaFromFtpCron();

		include_once MEDIAFROMFTP_PLUGIN_BASE_DIR.'/inc/MediaFromFtp.php';
		$mediafromftp = new MediaFromFtp();

		$mediafromftp_settings = get_option($this->wp_options_name());

		switch ($submenu) {
			case 1:
				if ( !empty($_POST['mediafromftp_dateset']) ) {
					if ( !empty($_POST['mediafromftp_cron_apply']) ) {
						$mediafromftp_cron_apply = $_POST['mediafromftp_cron_apply'];
					} else {
						$mediafromftp_cron_apply = FALSE;
					}
					if ( !empty($_POST['mediafromftp_cron_limit_number']) ) {
						$mediafromftp_cron_limit_number = $_POST['mediafromftp_cron_limit_number'];
					} else {
						$mediafromftp_cron_limit_number = FALSE;
					}
					if ( !empty($_POST['mediafromftp_cron_mail_apply']) ) {
						$mediafromftp_cron_mail_apply = $_POST['mediafromftp_cron_mail_apply'];
					} else {
						$mediafromftp_cron_mail_apply = FALSE;
					}
					if ( !empty($_POST['mediafromftp_caption_apply']) ) {
						$mediafromftp_caption_apply = $_POST['mediafromftp_caption_apply'];
					} else {
						$mediafromftp_caption_apply = FALSE;
					}
					if ( !empty($_POST['mediafromftp_exif_text']) ) {
						$exif_text = $_POST['mediafromftp_exif_text'];
					} else {
						$exif_text = $mediafromftp_settings['caption']['exif_text'];
					}
					if ( !empty($_POST['mediafromftp_exif_default']) ) {
						$exif_text = '%title% %credit% %camera% %caption% %created_timestamp% %copyright% %aperture% %shutter_speed% %iso% %focal_length%';
					}
					if ( !empty($_POST['mediafromftp_apply_log']) ) {
						$mediafromftp_apply_log = $_POST['mediafromftp_apply_log'];
					} else {
						$mediafromftp_apply_log = FALSE;
					}

					$mediafromftp_tbl = array(
										'pagemax' => $mediafromftp_settings['pagemax'],
										'basedir' => $mediafromftp_settings['basedir'],
										'searchdir' => $mediafromftp_settings['searchdir'],
										'sort' => $mediafromftp_settings['sort'],
										'ext2typefilter' => $mediafromftp_settings['ext2typefilter'],
										'extfilter' => $mediafromftp_settings['extfilter'],
										'dateset' => $_POST['mediafromftp_dateset'],
										'max_execution_time' => intval($_POST['mediafromftp_max_execution_time']),
										'character_code' => $_POST['mediafromftp_character_code'],
										'exclude' => stripslashes($_POST['mediafromftp_exclude']),
										'thumb_deep_search' => $_POST['mediafromftp_thumb_deep_search'],
										'cron' => array(
													'apply' => $mediafromftp_cron_apply,
													'schedule' => $_POST['mediafromftp_cron_schedule'],
													'limit_number' => $mediafromftp_cron_limit_number,
													'mail_apply' => $mediafromftp_cron_mail_apply,
													'mail' => $mediafromftp_settings['cron']['mail'],
													'user' => $mediafromftp_settings['cron']['user']
													),
										'caption' => array(
													'apply' => $mediafromftp_caption_apply,
													'exif_text' => $exif_text
													),
										'log' => $mediafromftp_apply_log
										);
					update_option( $this->wp_options_name(), $mediafromftp_tbl );
					if ( !empty($_POST['move_yearmonth_folders']) ) {
						update_option( 'uploads_use_yearmonth_folders', $_POST['move_yearmonth_folders'] );
					} else {
						update_option( 'uploads_use_yearmonth_folders', '0' );
					}
					if ( !$mediafromftp_cron_apply ) {
						$mediafromftpcron->CronStop($this->wp_options_name());
					} else {
						$mediafromftpcron->CronStart($this->wp_options_name());
					}
					echo '<div class="updated"><ul><li>'.__('Settings').' --> '.__('Changes saved.').'</li></ul></div>';
				}
				if ( !empty($_POST['mediafromftp_clear_cash']) ) {
					$del_cash_count = $mediafromftp->delete_all_cash();
					if ( $del_cash_count > 0 ) {
						echo '<div class="updated"><ul><li>'.__('Thumbnails Cache', 'media-from-ftp').' --> '.__('Delete').'</li></ul></div>';
					} else {
						echo '<div class="error"><ul><li>'.__('No Thumbnails Cache', 'media-from-ftp').'</li></ul></div>';
					}
				}
				break;
			case 2:
				if (!empty($_POST['ShowToPage'])){
					$pagemax = intval($_POST['mediafromftp_pagemax']);
					if ( $pagemax <= 0 ) {
						echo '<div class="error"><ul><li>'.__('Number of items per page:').' --> '.__('Incorrect value.', 'media-from-ftp').' '.__('Save failed.').'</li></ul></div>';
						$pagemax = $mediafromftp_settings['pagemax'];
					} else {
						echo '<div class="updated"><ul><li>'.__('Number of items per page:').' --> '.__('Settings saved.').'</li></ul></div>';
					}
				} else {
					$pagemax = $mediafromftp_settings['pagemax'];
				}
				$basedir = $mediafromftp_settings['basedir'];
				if (!empty($_POST['searchdir'])){
					$searchdir = urldecode($_POST['searchdir']);
				} else {
					$searchdir = $mediafromftp_settings['searchdir'];
					if ( MEDIAFROMFTP_PLUGIN_UPLOAD_PATH <> $basedir ) {
						$searchdir = MEDIAFROMFTP_PLUGIN_UPLOAD_PATH;
						$basedir = MEDIAFROMFTP_PLUGIN_UPLOAD_PATH;
					}
				}
				if (!empty($_GET['sort'])){
					$sort = $_GET['sort'];
					if ( $sort <> 'des' && $sort <> 'asc') {
						$sort = 'asc';
					}
				} else {
					$sort = $mediafromftp_settings['sort'];
				}
				if (!empty($_POST['ext2type'])){
					$ext2typefilter = $_POST['ext2type'];
				} else {
					$ext2typefilter = $mediafromftp_settings['ext2typefilter'];
				}
				if (!empty($_POST['extension'])){
					if ( $_POST['extension'] === 'all') {
						$extfilter = 'all';
					} else {
						if ( $ext2typefilter === 'all' || $ext2typefilter === wp_ext2type($_POST['extension']) ) {
							$extfilter = $_POST['extension'];
						} else {
							$extfilter = 'all';
						}
					}
				} else {
					$extfilter = $mediafromftp_settings['extfilter'];
				}
				$mediafromftp_tbl = array(
									'pagemax' => $pagemax,
									'basedir' => $basedir,
									'searchdir' => $searchdir,
									'sort' => $sort,
									'ext2typefilter' => $ext2typefilter,
									'extfilter' => $extfilter,
									'dateset' => $mediafromftp_settings['dateset'],
									'max_execution_time' => $mediafromftp_settings['max_execution_time'],
									'character_code' => $mediafromftp_settings['character_code'],
									'exclude' => $mediafromftp_settings['exclude'],
									'thumb_deep_search' => $mediafromftp_settings['thumb_deep_search'],
									'cron' => array(
												'apply' => $mediafromftp_settings['cron']['apply'],
												'schedule' => $mediafromftp_settings['cron']['schedule'],
												'limit_number' => $mediafromftp_settings['cron']['limit_number'],
												'mail_apply' => $mediafromftp_settings['cron']['mail_apply'],
												'mail' => $mediafromftp_settings['cron']['mail'],
												'user' => $mediafromftp_settings['cron']['user']
												),
									'caption' => array(
													'apply' => $mediafromftp_settings['caption']['apply'],
													'exif_text' => $mediafromftp_settings['caption']['exif_text']
												),
									'log' => $mediafromftp_settings['log']
									);
				update_option( $this->wp_options_name(), $mediafromftp_tbl );
				break;
		}

	}

	/* ==================================================
	 * @param	none
	 * @return	string	$wp_options_name
	 * @since	9.18
	 */
	function wp_options_name(){

		$user = wp_get_current_user();
		$cron_user = $user->ID;

		$wp_options_name = 'mediafromftp_settings'.'_'.$cron_user;

		return $wp_options_name;

	}

	/* ==================================================
	 * Add js
	 * @since	2.24
	 */
	function add_js(){

// JS
$mediafromftp_add_js = <<<MEDIAFROMFTP1

<!-- BEGIN: Media from FTP -->
<script type="text/javascript">
jQuery(function(){
  jQuery('.mediafromftp-checkAll').on('change', function() {
    jQuery('.' + this.id).prop('checked', this.checked);
  });
});
</script>
<script type="text/javascript">
jQuery('#mediafromftp-settings-tabs').responsiveTabs({
  startCollapsed: 'accordion'
});
</script>
<script type="text/javascript">
jQuery('#mediafromftp-table').stacktable();
</script>
<script type="text/javascript">
jQuery(function(){
MEDIAFROMFTP1;

		for ($i = 0; $i < $this->postcount; $i++) {

$mediafromftp_add_js .= <<<MEDIAFROMFTP2

jQuery('#datetimepicker-mediafromftp
MEDIAFROMFTP2;
			$mediafromftp_add_js .= $i;
$mediafromftp_add_js .= <<<MEDIAFROMFTP3
').datetimepicker({format:'Y-m-d H:i'});
MEDIAFROMFTP3;

		}

$mediafromftp_add_js .= <<<MEDIAFROMFTP4

});
</script>
<script type="text/javascript">
window.addEventListener( "load", function(){
  jQuery("#mediafromftp-loading").delay(2000).fadeOut();
  jQuery("#mediafromftp-loading-container").delay(2000).fadeIn();
}, false );
</script>
<script type="text/javascript">
jQuery('input[type!="submit"][type!="button"]').keypress(function(e){
  if ((e.which && e.which == 13) || (e.keyCode && e.keyCode == 13)) {
    return false;
  }else{
    return true;
  }
});
</script>
<!-- END: Media from FTP -->

MEDIAFROMFTP4;

		return $mediafromftp_add_js;

	}

}

?>