/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2016-07-01 04:52:03 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_ewwwio_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `results` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `updates` int(5) unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `trace` blob,
  UNIQUE KEY `id` (`id`),
  KEY `path_image_size` (`path`(191),`image_size`)
) ENGINE=MyISAM AUTO_INCREMENT=140 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mediafromftp_log` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id` bigint(20) DEFAULT NULL,
  `user` text,
  `title` text,
  `permalink` text,
  `url` text,
  `filename` text,
  `time` datetime DEFAULT NULL,
  `filetype` text,
  `filesize` text,
  `exif` text,
  `length` text,
  `thumbnail1` text,
  `thumbnail2` text,
  `thumbnail3` text,
  `thumbnail4` text,
  `thumbnail5` text,
  `thumbnail6` text,
  UNIQUE KEY `meta_id` (`meta_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=282 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_siteguard_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `login_name` varchar(40) NOT NULL DEFAULT '',
  `ip_address` varchar(40) NOT NULL DEFAULT '',
  `operation` int(11) NOT NULL DEFAULT '0',
  `time` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_siteguard_login` (
  `ip_address` varchar(40) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `last_login_time` datetime DEFAULT NULL,
  UNIQUE KEY `ip_address` (`ip_address`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "1", "akismet_history", "a:3:{s:4:\"time\";d:1467107102.595181941986083984375;s:5:\"event\";s:12:\"status-trash\";s:4:\"user\";s:7:\"tokumon\";}");
INSERT INTO `wp_commentmeta` VALUES("2", "1", "_wp_trash_meta_status", "1");
INSERT INTO `wp_commentmeta` VALUES("3", "1", "_wp_trash_meta_time", "1467107102");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Mr WordPress", "", "https://wordpress.org/", "", "2016-06-28 01:54:23", "2016-06-28 01:54:23", "Hi, this is a comment.\nTo delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.", "0", "trash", "", "", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20160701_e38387e383a2e382b5e382a4e38388", "5775f6e8581168294160701045152", "20", "2016-07-01 04:52:03", "tokumon", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-01 04:51:52\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.2\";s:9:\"VersionDB\";s:6:\"5.5.48\";s:10:\"VersionPHP\";s:6:\"5.5.36\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:39:\"20160701_e38387e383a2e382b5e382a4e38388\";s:4:\"Hash\";s:29:\"5775f6e8581168294160701045152\";s:8:\"NameHash\";s:69:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:69:\"/home/sample100/public_html/demo.sample100.jetboy.jp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"http://demo.sample100.jetboy.jp/wp-snapshots/\";s:8:\"ScanFile\";s:79:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:7:\"tokumon\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:81:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/sample100/public_html/demo.sample100.jetboy.jp\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-01 04:51:52\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.2\";s:9:\"VersionDB\";s:6:\"5.5.48\";s:10:\"VersionPHP\";s:6:\"5.5.36\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20160701_e38387e383a2e382b5e382a4e38388\";s:4:\"Hash\";s:29:\"5775f6e8581168294160701045152\";s:8:\"NameHash\";s:69:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:69:\"/home/sample100/public_html/demo.sample100.jetboy.jp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"http://demo.sample100.jetboy.jp/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:83:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:82:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_ewwwio_images */
INSERT INTO `wp_ewwwio_images` VALUES("1", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V.jpg", "Reduced by 1.8% (4.1&nbsp;kB)", "234736", "238926", "1", "2016-06-28 06:03:20", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("2", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-150x150.jpg", "Reduced by 6.3% (408.0&nbsp;B)", "6070", "6478", "1", "2016-06-28 06:03:20", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("3", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-300x200.jpg", "Reduced by 3.7% (444.0&nbsp;B)", "11702", "12146", "1", "2016-06-28 06:03:20", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("4", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-768x512.jpg", "Reduced by 2.0% (1,004.0&nbsp;B)", "49185", "50189", "1", "2016-06-28 06:03:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("5", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-1024x682.jpg", "Reduced by 1.8% (1.4&nbsp;kB)", "77688", "79091", "1", "2016-06-28 06:03:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("6", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-1200x800.jpg", "Reduced by 1.8% (1.8&nbsp;kB)", "99535", "101390", "1", "2016-06-28 06:03:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("7", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V.jpg", "Reduced by 3.4% (14.1&nbsp;kB)", "406555", "421036", "1", "2016-06-28 06:06:49", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("8", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-150x150.jpg", "Reduced by 6.8% (407.0&nbsp;B)", "5607", "6014", "1", "2016-06-28 06:06:49", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("9", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-300x184.jpg", "Reduced by 4.4% (611.0&nbsp;B)", "13343", "13954", "1", "2016-06-28 06:06:49", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("10", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-768x470.jpg", "Reduced by 4.4% (3.3&nbsp;kB)", "73606", "77016", "1", "2016-06-28 06:06:49", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("11", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-1024x627.jpg", "Reduced by 4.4% (5.5&nbsp;kB)", "123421", "129085", "1", "2016-06-28 06:06:49", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("12", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-1200x735.jpg", "Reduced by 4.3% (7.2&nbsp;kB)", "163837", "171214", "1", "2016-06-28 06:06:49", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("13", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V.jpg", "Reduced by 4.9% (21.1&nbsp;kB)", "415515", "437129", "1", "2016-06-28 06:09:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("14", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V-150x150.jpg", "Reduced by 7.0% (577.0&nbsp;B)", "7644", "8221", "1", "2016-06-28 06:09:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("15", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V-300x200.jpg", "Reduced by 6.4% (1.2&nbsp;kB)", "17355", "18548", "1", "2016-06-28 06:09:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("16", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V-768x512.jpg", "Reduced by 5.5% (4.8&nbsp;kB)", "83650", "88521", "1", "2016-06-28 06:09:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("17", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V-1024x682.jpg", "Reduced by 5.1% (7.1&nbsp;kB)", "135565", "142820", "1", "2016-06-28 06:09:39", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("18", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V-1200x800.jpg", "Reduced by 4.9% (8.7&nbsp;kB)", "174776", "183717", "1", "2016-06-28 06:09:39", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("19", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V.jpg", "Reduced by 10.1% (57.8&nbsp;kB)", "524330", "583539", "1", "2016-06-28 06:10:26", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("20", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V-150x150.jpg", "Reduced by 7.3% (385.0&nbsp;B)", "4880", "5265", "1", "2016-06-28 06:10:26", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("21", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V-300x200.jpg", "Reduced by 4.8% (581.0&nbsp;B)", "11455", "12036", "1", "2016-06-28 06:10:26", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("22", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V-768x512.jpg", "Reduced by 4.2% (2.8&nbsp;kB)", "63915", "66734", "1", "2016-06-28 06:10:26", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("23", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V-1024x682.jpg", "Reduced by 4.9% (5.5&nbsp;kB)", "108970", "114574", "1", "2016-06-28 06:10:26", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("24", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V-1200x800.jpg", "Reduced by 5.1% (7.6&nbsp;kB)", "143850", "151648", "1", "2016-06-28 06:10:26", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("25", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V.jpg", "Reduced by 5.9% (21.4&nbsp;kB)", "348699", "370653", "1", "2016-06-28 06:11:39", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("26", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V-150x150.jpg", "Reduced by 6.6% (421.0&nbsp;B)", "5917", "6338", "1", "2016-06-28 06:11:39", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("27", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V-300x200.jpg", "Reduced by 6.2% (851.0&nbsp;B)", "12950", "13801", "1", "2016-06-28 06:11:39", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("28", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V-768x512.jpg", "Reduced by 6.2% (4.0&nbsp;kB)", "62597", "66717", "1", "2016-06-28 06:11:39", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("29", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V-1024x682.jpg", "Reduced by 5.7% (6.1&nbsp;kB)", "103201", "109455", "1", "2016-06-28 06:11:39", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("30", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V-1200x800.jpg", "Reduced by 5.8% (8.0&nbsp;kB)", "134502", "142742", "1", "2016-06-28 06:11:39", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("31", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V.jpg", "Reduced by 5.0% (24.6&nbsp;kB)", "476625", "501826", "1", "2016-06-28 06:12:01", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("32", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V-150x150.jpg", "Reduced by 6.3% (548.0&nbsp;B)", "8187", "8735", "1", "2016-06-28 06:12:01", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("33", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V-300x176.jpg", "Reduced by 5.7% (987.0&nbsp;B)", "16386", "17373", "1", "2016-06-28 06:12:01", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("34", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V-768x451.jpg", "Reduced by 4.9% (4.3&nbsp;kB)", "86007", "90425", "1", "2016-06-28 06:12:01", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("35", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V-1024x601.jpg", "Reduced by 4.7% (6.9&nbsp;kB)", "142695", "149802", "1", "2016-06-28 06:12:01", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("36", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V-1200x704.jpg", "Reduced by 4.7% (9.1&nbsp;kB)", "188018", "197322", "1", "2016-06-28 06:12:01", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("37", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V.jpg", "Reduced by 3.0% (5.3&nbsp;kB)", "174965", "180390", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("38", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-150x150.jpg", "Reduced by 8.7% (379.0&nbsp;B)", "3956", "4335", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("39", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-300x200.jpg", "Reduced by 5.9% (447.0&nbsp;B)", "7091", "7538", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("40", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-768x512.jpg", "Reduced by 4.8% (1.6&nbsp;kB)", "32146", "33753", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("41", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-1024x682.jpg", "Reduced by 5.3% (2.8&nbsp;kB)", "52268", "55177", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("42", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-380x250.jpg", "Reduced by 4.6% (491.0&nbsp;B)", "10280", "10771", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("43", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-75x75.jpg", "Reduced by 18.7% (373.0&nbsp;B)", "1617", "1990", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("44", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-444x444.jpg", "Reduced by 4.1% (921.0&nbsp;B)", "21713", "22634", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("45", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-800x521.jpg", "Reduced by 4.8% (1.7&nbsp;kB)", "35282", "37056", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("46", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-250x180.jpg", "Reduced by 6.4% (406.0&nbsp;B)", "5943", "6349", "1", "2016-06-28 06:27:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("47", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V.jpg", "Reduced by 5.0% (15.0&nbsp;kB)", "293082", "308456", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("48", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-150x150.jpg", "Reduced by 6.8% (388.0&nbsp;B)", "5326", "5714", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("49", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-300x200.jpg", "Reduced by 3.8% (401.0&nbsp;B)", "10286", "10687", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("50", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-768x512.jpg", "Reduced by 3.3% (1.5&nbsp;kB)", "43994", "45505", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("51", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-1024x682.jpg", "Reduced by 4.2% (3.1&nbsp;kB)", "72837", "76046", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("52", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-380x250.jpg", "Reduced by 3.0% (448.0&nbsp;B)", "14673", "15121", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("53", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-75x75.jpg", "Reduced by 15.6% (382.0&nbsp;B)", "2072", "2454", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("54", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-444x444.jpg", "Reduced by 3.5% (983.0&nbsp;B)", "27494", "28477", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("55", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-800x521.jpg", "Reduced by 3.8% (1.9&nbsp;kB)", "48214", "50124", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("56", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-250x180.jpg", "Reduced by 4.4% (389.0&nbsp;B)", "8382", "8771", "1", "2016-06-28 06:27:44", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("57", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V.jpg", "Reduced by 3.8% (8.7&nbsp;kB)", "226547", "235496", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("58", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-150x150.jpg", "Reduced by 6.4% (410.0&nbsp;B)", "5998", "6408", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("59", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-300x200.jpg", "Reduced by 4.4% (575.0&nbsp;B)", "12370", "12945", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("60", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-768x512.jpg", "Reduced by 3.6% (1.8&nbsp;kB)", "48349", "50148", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("61", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-1024x682.jpg", "Reduced by 3.4% (2.6&nbsp;kB)", "75409", "78081", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("62", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-380x250.jpg", "Reduced by 4.1% (727.0&nbsp;B)", "17133", "17860", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("63", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-75x75.jpg", "Reduced by 14.0% (384.0&nbsp;B)", "2363", "2747", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("64", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-444x444.jpg", "Reduced by 3.9% (1.1&nbsp;kB)", "28083", "29210", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("65", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-800x521.jpg", "Reduced by 4.0% (2.1&nbsp;kB)", "51917", "54082", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("66", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-250x180.jpg", "Reduced by 4.6% (492.0&nbsp;B)", "10235", "10727", "1", "2016-06-28 06:28:41", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("67", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196.jpg", "Reduced by 6.7% (512.1&nbsp;kB)", "7291907", "7816293", "1", "2016-06-28 09:49:25", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("68", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196-150x150.jpg", "Reduced by 6.4% (420.0&nbsp;B)", "6127", "6547", "1", "2016-06-28 09:49:25", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("69", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196-300x192.jpg", "Reduced by 4.1% (588.0&nbsp;B)", "13622", "14210", "1", "2016-06-28 09:49:25", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("70", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196-768x492.jpg", "Reduced by 2.5% (1.6&nbsp;kB)", "64648", "66308", "1", "2016-06-28 09:49:25", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("71", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196-1024x657.jpg", "Reduced by 2.6% (2.7&nbsp;kB)", "105103", "107887", "1", "2016-06-28 09:49:26", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("72", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196-1200x769.jpg", "Reduced by 2.7% (3.7&nbsp;kB)", "136178", "139965", "1", "2016-06-28 09:49:26", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("73", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MIDSC_8613_TP_V.jpg", "Reduced by 2.2% (4.1&nbsp;kB)", "188106", "192266", "1", "2016-06-28 09:54:30", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("74", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MIDSC_8613_TP_V-150x150.jpg", "Reduced by 13.7% (448.0&nbsp;B)", "2819", "3267", "1", "2016-06-28 09:54:30", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("75", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MIDSC_8613_TP_V-300x200.jpg", "Reduced by 9.7% (589.0&nbsp;B)", "5498", "6087", "1", "2016-06-28 09:54:30", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("76", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MIDSC_8613_TP_V-768x513.jpg", "Reduced by 9.4% (2.5&nbsp;kB)", "24841", "27406", "1", "2016-06-28 09:54:31", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("77", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MIDSC_8613_TP_V-1024x684.jpg", "Reduced by 10.2% (4.7&nbsp;kB)", "42323", "47147", "1", "2016-06-28 09:54:31", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("78", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MIDSC_8613_TP_V-1200x801.jpg", "Reduced by 10.7% (6.8&nbsp;kB)", "58245", "65241", "1", "2016-06-28 09:54:31", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("79", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k.jpg", "Reduced by 4.2% (13.6&nbsp;kB)", "318738", "332663", "1", "2016-06-28 10:04:00", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("80", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k-150x150.jpg", "Reduced by 6.7% (377.0&nbsp;B)", "5224", "5601", "1", "2016-06-28 10:04:00", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("81", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k-300x200.jpg", "Reduced by 4.2% (526.0&nbsp;B)", "12147", "12673", "1", "2016-06-28 10:04:00", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("82", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k-768x513.jpg", "Reduced by 3.7% (2.2&nbsp;kB)", "57828", "60078", "1", "2016-06-28 10:04:00", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("83", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k-1024x684.jpg", "Reduced by 3.5% (3.3&nbsp;kB)", "94518", "97921", "1", "2016-06-28 10:04:00", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("84", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k-1200x801.jpg", "Reduced by 3.7% (4.7&nbsp;kB)", "125136", "129910", "1", "2016-06-28 10:04:00", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("85", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k.jpg", "Reduced by 6.7% (29.5&nbsp;kB)", "417497", "447681", "1", "2016-06-28 10:04:54", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("86", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k-150x150.jpg", "Reduced by 6.3% (363.0&nbsp;B)", "5361", "5724", "1", "2016-06-28 10:04:54", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("87", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k-300x200.jpg", "Reduced by 4.6% (587.0&nbsp;B)", "12045", "12632", "1", "2016-06-28 10:04:54", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("88", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k-768x512.jpg", "Reduced by 5.6% (3.9&nbsp;kB)", "66788", "70787", "1", "2016-06-28 10:04:54", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("89", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k-1024x682.jpg", "Reduced by 5.8% (6.9&nbsp;kB)", "115218", "122327", "1", "2016-06-28 10:04:54", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("90", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k-1200x800.jpg", "Reduced by 6.0% (9.5&nbsp;kB)", "153427", "163200", "1", "2016-06-28 10:04:54", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("91", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k.jpg", "Reduced by 3.8% (19.4&nbsp;kB)", "498316", "518143", "1", "2016-06-28 10:05:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("92", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k-150x150.jpg", "Reduced by 6.6% (521.0&nbsp;B)", "7408", "7929", "1", "2016-06-28 10:05:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("93", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k-300x225.jpg", "Reduced by 5.7% (1.2&nbsp;kB)", "19804", "21008", "1", "2016-06-28 10:05:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("94", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k-768x576.jpg", "Reduced by 4.9% (5.7&nbsp;kB)", "113568", "119397", "1", "2016-06-28 10:05:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("95", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k-1024x768.jpg", "Reduced by 4.3% (8.0&nbsp;kB)", "183989", "192190", "1", "2016-06-28 10:05:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("96", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k-1200x900.jpg", "Reduced by 4.5% (11.0&nbsp;kB)", "241988", "253296", "1", "2016-06-28 10:05:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("97", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg", "Reduced by 9.9% (77.9&nbsp;kB)", "722216", "801970", "1", "2016-06-28 10:05:55", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("98", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k-150x150.jpg", "Reduced by 6.7% (472.0&nbsp;B)", "6607", "7079", "1", "2016-06-28 10:05:55", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("99", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k-300x200.jpg", "Reduced by 6.3% (1.0&nbsp;kB)", "15766", "16829", "1", "2016-06-28 10:05:55", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("100", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k-768x513.jpg", "Reduced by 5.9% (5.8&nbsp;kB)", "93604", "99499", "1", "2016-06-28 10:05:55", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("101", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k-1024x684.jpg", "Reduced by 5.9% (9.7&nbsp;kB)", "158775", "168727", "1", "2016-06-28 10:05:55", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("102", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k-1200x801.jpg", "Reduced by 5.8% (12.9&nbsp;kB)", "214021", "227250", "1", "2016-06-28 10:05:55", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("103", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg", "Reduced by 5.4% (28.4&nbsp;kB)", "512749", "541843", "1", "2016-06-28 10:06:23", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("104", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k-150x150.jpg", "Reduced by 5.6% (417.0&nbsp;B)", "7081", "7498", "1", "2016-06-28 10:06:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("105", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k-300x200.jpg", "Reduced by 4.7% (810.0&nbsp;B)", "16320", "17130", "1", "2016-06-28 10:06:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("106", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k-768x512.jpg", "Reduced by 4.4% (4.0&nbsp;kB)", "88232", "92279", "1", "2016-06-28 10:06:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("107", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k-1024x682.jpg", "Reduced by 4.2% (6.3&nbsp;kB)", "149462", "155941", "1", "2016-06-28 10:06:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("108", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k-1200x800.jpg", "Reduced by 4.1% (8.3&nbsp;kB)", "198049", "206598", "1", "2016-06-28 10:06:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("109", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/media-from-ftp-tmp/48bbf2553c1eccd09bd39b93d0fb7c5e.jpg", "Reduced by 37.4% (375.0&nbsp;B)", "628", "1003", "1", "2016-06-28 10:30:03", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("110", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg", "No savings", "8575547", "8575547", "1", "2016-06-28 10:30:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("111", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k-150x150.jpg", "Reduced by 13.9% (456.0&nbsp;B)", "2814", "3270", "1", "2016-06-28 10:30:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("112", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k-300x200.jpg", "Reduced by 9.6% (583.0&nbsp;B)", "5500", "6083", "1", "2016-06-28 10:30:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("113", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k-768x513.jpg", "Reduced by 9.5% (2.6&nbsp;kB)", "25053", "27685", "1", "2016-06-28 10:30:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("114", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k-1024x684.jpg", "Reduced by 10.7% (5.1&nbsp;kB)", "43304", "48502", "1", "2016-06-28 10:30:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("115", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k-1200x801.jpg", "Reduced by 11.1% (7.2&nbsp;kB)", "59678", "67101", "1", "2016-06-28 10:30:24", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("116", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg", "Reduced by 6.5% (16.6&nbsp;kB)", "245101", "262136", "1", "2016-06-28 10:41:40", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("117", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262-150x150.jpg", "Reduced by 9.4% (378.0&nbsp;B)", "3635", "4013", "1", "2016-06-28 10:41:40", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("118", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262-300x166.jpg", "Reduced by 5.5% (421.0&nbsp;B)", "7177", "7598", "1", "2016-06-28 10:41:40", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("119", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262-768x426.jpg", "Reduced by 5.5% (2.0&nbsp;kB)", "35854", "37925", "1", "2016-06-28 10:41:40", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("120", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262-1024x568.jpg", "Reduced by 6.0% (3.7&nbsp;kB)", "59382", "63155", "1", "2016-06-28 10:41:40", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("121", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262-1200x665.jpg", "Reduced by 6.4% (5.4&nbsp;kB)", "81062", "86582", "1", "2016-06-28 10:41:40", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("122", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623.jpg", "Reduced by 6.6% (40.0&nbsp;kB)", "578298", "619211", "1", "2016-06-28 10:45:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("123", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623-150x150.jpg", "Reduced by 6.2% (431.0&nbsp;B)", "6543", "6974", "1", "2016-06-28 10:45:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("124", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623-300x200.jpg", "Reduced by 6.1% (1,005.0&nbsp;B)", "15541", "16546", "1", "2016-06-28 10:45:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("125", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623-768x512.jpg", "Reduced by 6.4% (6.2&nbsp;kB)", "93181", "99542", "1", "2016-06-28 10:45:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("126", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623-1024x682.jpg", "Reduced by 6.2% (10.6&nbsp;kB)", "163178", "174017", "1", "2016-06-28 10:45:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("127", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623-1200x800.jpg", "Reduced by 6.4% (14.5&nbsp;kB)", "218473", "233326", "1", "2016-06-28 10:45:21", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("128", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573.jpg", "Reduced by 5.2% (28.8&nbsp;kB)", "541001", "570536", "1", "2016-06-28 10:48:16", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("129", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573-150x150.jpg", "Reduced by 6.2% (372.0&nbsp;B)", "5592", "5964", "1", "2016-06-28 10:48:16", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("130", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573-300x200.jpg", "Reduced by 4.4% (642.0&nbsp;B)", "14016", "14658", "1", "2016-06-28 10:48:16", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("131", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573-768x512.jpg", "Reduced by 4.1% (3.4&nbsp;kB)", "81658", "85188", "1", "2016-06-28 10:48:16", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("132", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573-1024x682.jpg", "Reduced by 4.4% (6.4&nbsp;kB)", "142742", "149256", "1", "2016-06-28 10:48:16", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("133", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573-1200x800.jpg", "Reduced by 4.6% (9.1&nbsp;kB)", "193544", "202860", "1", "2016-06-28 10:48:17", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("134", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524.jpg", "Reduced by 4.9% (24.9&nbsp;kB)", "498174", "523701", "1", "2016-06-28 10:52:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("135", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524-150x150.jpg", "Reduced by 7.1% (595.0&nbsp;B)", "7777", "8372", "1", "2016-06-28 10:52:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("136", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524-300x200.jpg", "Reduced by 6.9% (1.3&nbsp;kB)", "17882", "19197", "1", "2016-06-28 10:52:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("137", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524-768x512.jpg", "Reduced by 5.6% (5.7&nbsp;kB)", "97229", "103032", "1", "2016-06-28 10:52:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("138", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524-1024x682.jpg", "Reduced by 5.1% (8.5&nbsp;kB)", "162740", "171413", "1", "2016-06-28 10:52:38", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("139", "/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524-1200x800.jpg", "Reduced by 4.8% (10.6&nbsp;kB)", "213017", "223864", "1", "2016-06-28 10:52:38", NULL);

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://demo.sample100.jetboy.jp", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://demo.sample100.jetboy.jp", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "デモサイト", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "このサイトはJETBOYレンタルサーバーのWordPress用デモサイトです。", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "ooizumieikoubu@yahoo.co.jp", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:86:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("279", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.1.12\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("253", "theme_mods_twentysixteen", "a:1:{s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("254", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:14:{i:0;s:19:\"akismet/akismet.php\";i:1;s:27:\"autoptimize/autoptimize.php\";i:2;s:26:\"cpaddons-site-software.php\";i:3;s:43:\"db-cache-reloaded-fix/db-cache-reloaded.php\";i:4;s:53:\"disable-xml-rpc-pingback/disable-xml-rpc-pingback.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";i:7;s:50:\"far-future-expiry-header/far-future-expiration.php\";i:8;s:29:\"image-widget/image-widget.php\";i:9;s:31:\"media-from-ftp/mediafromftp.php\";i:10;s:67:\"remove-query-strings-from-static-resources/remove-query-strings.php\";i:11;s:28:\"wp-file-cache/file-cache.php\";i:12;s:23:\"wp-smushit/wp-smush.php\";i:13;s:27:\"wp-super-cache/wp-cache.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:2:{i:0;s:125:\"/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/plugins/disable-xml-rpc-pingback/disable-xml-rpc-pingback.php\";i:1;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "twentysixteen", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "twentysixteen", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "36686", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:2:{s:27:\"autoptimize/autoptimize.php\";s:21:\"autoptimize_uninstall\";s:27:\"wp-super-cache/wp-cache.php\";s:22:\"wpsupercache_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "2", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "36686", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "sidebars_widgets", "a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:10:\"nav_menu-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_nav_menu", "a:2:{i:2;a:1:{s:8:\"nav_menu\";i:2;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "cron", "a:6:{i:1467349196;a:1:{s:11:\"wp_cache_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1467351097;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1467360025;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1467424480;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1467424634;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("163", "ewww_image_optimizer_disable_pngout", "1", "yes");
INSERT INTO `wp_options` VALUES("114", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1467122084", "no");
INSERT INTO `wp_options` VALUES("113", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_options` VALUES("175", "widget_widget_sp_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("178", "_image_widget_version", "4.2.2", "yes");
INSERT INTO `wp_options` VALUES("190", "wp-smush-install-type", "new", "yes");
INSERT INTO `wp_options` VALUES("191", "wp-smush-hide_upgrade_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("231", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1467085110;s:7:\"checked\";a:12:{s:19:\"akismet/akismet.php\";s:6:\"3.1.11\";s:27:\"autoptimize/autoptimize.php\";s:5:\"2.0.2\";s:26:\"cpaddons-site-software.php\";s:3:\"1.0\";s:43:\"db-cache-reloaded-fix/db-cache-reloaded.php\";s:3:\"2.3\";s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:5:\"2.8.5\";s:50:\"far-future-expiry-header/far-future-expiration.php\";s:3:\"1.3\";s:29:\"image-widget/image-widget.php\";s:5:\"4.2.2\";s:67:\"remove-query-strings-from-static-resources/remove-query-strings.php\";s:3:\"1.3\";s:23:\"siteguard/siteguard.php\";s:5:\"1.2.5\";s:28:\"wp-file-cache/file-cache.php\";s:7:\"1.2.9.1\";s:23:\"wp-smushit/wp-smush.php\";s:5:\"2.3.1\";s:27:\"wp-super-cache/wp-cache.php\";s:5:\"1.4.8\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:11:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:6:\"3.1.11\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/akismet.3.1.11.zip\";}s:27:\"autoptimize/autoptimize.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"8986\";s:4:\"slug\";s:11:\"autoptimize\";s:6:\"plugin\";s:27:\"autoptimize/autoptimize.php\";s:11:\"new_version\";s:5:\"2.0.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/autoptimize/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/autoptimize.2.0.2.zip\";}s:43:\"db-cache-reloaded-fix/db-cache-reloaded.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"21157\";s:4:\"slug\";s:21:\"db-cache-reloaded-fix\";s:6:\"plugin\";s:43:\"db-cache-reloaded-fix/db-cache-reloaded.php\";s:11:\"new_version\";s:3:\"2.3\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/db-cache-reloaded-fix/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/db-cache-reloaded-fix.zip\";}s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"32121\";s:4:\"slug\";s:20:\"ewww-image-optimizer\";s:6:\"plugin\";s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:11:\"new_version\";s:5:\"2.8.5\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/ewww-image-optimizer/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/ewww-image-optimizer.2.8.5.zip\";}s:50:\"far-future-expiry-header/far-future-expiration.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"48368\";s:4:\"slug\";s:24:\"far-future-expiry-header\";s:6:\"plugin\";s:50:\"far-future-expiry-header/far-future-expiration.php\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/far-future-expiry-header/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/far-future-expiry-header.zip\";}s:29:\"image-widget/image-widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"4078\";s:4:\"slug\";s:12:\"image-widget\";s:6:\"plugin\";s:29:\"image-widget/image-widget.php\";s:11:\"new_version\";s:5:\"4.2.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/image-widget/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/image-widget.4.2.2.zip\";}s:67:\"remove-query-strings-from-static-resources/remove-query-strings.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"46630\";s:4:\"slug\";s:42:\"remove-query-strings-from-static-resources\";s:6:\"plugin\";s:67:\"remove-query-strings-from-static-resources/remove-query-strings.php\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:73:\"https://wordpress.org/plugins/remove-query-strings-from-static-resources/\";s:7:\"package\";s:85:\"https://downloads.wordpress.org/plugin/remove-query-strings-from-static-resources.zip\";}s:23:\"siteguard/siteguard.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"54509\";s:4:\"slug\";s:9:\"siteguard\";s:6:\"plugin\";s:23:\"siteguard/siteguard.php\";s:11:\"new_version\";s:5:\"1.2.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/siteguard/\";s:7:\"package\";s:52:\"https://downloads.wordpress.org/plugin/siteguard.zip\";}s:28:\"wp-file-cache/file-cache.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5570\";s:4:\"slug\";s:13:\"wp-file-cache\";s:6:\"plugin\";s:28:\"wp-file-cache/file-cache.php\";s:11:\"new_version\";s:7:\"1.2.9.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wp-file-cache/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/wp-file-cache.1.2.9.1.zip\";}s:23:\"wp-smushit/wp-smush.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5534\";s:4:\"slug\";s:10:\"wp-smushit\";s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:11:\"new_version\";s:5:\"2.3.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/wp-smushit/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wp-smushit.2.3.1.zip\";}s:27:\"wp-super-cache/wp-cache.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"1221\";s:4:\"slug\";s:14:\"wp-super-cache\";s:6:\"plugin\";s:27:\"wp-super-cache/wp-cache.php\";s:11:\"new_version\";s:5:\"1.4.8\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-super-cache/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-super-cache.1.4.8.zip\";s:14:\"upgrade_notice\";s:38:\"Removed malware URL in a code comment.\";}}}", "yes");
INSERT INTO `wp_options` VALUES("228", "_site_transient_timeout_theme_roots", "1467086905", "yes");
INSERT INTO `wp_options` VALUES("229", "_site_transient_theme_roots", "a:3:{s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "yes");
INSERT INTO `wp_options` VALUES("164", "ewww_image_optimizer_optipng_level", "2", "yes");
INSERT INTO `wp_options` VALUES("165", "ewww_image_optimizer_pngout_level", "2", "yes");
INSERT INTO `wp_options` VALUES("166", "ewww_image_optimizer_jpegtran_copy", "1", "yes");
INSERT INTO `wp_options` VALUES("167", "ewww_image_optimizer_jpg_level", "10", "yes");
INSERT INTO `wp_options` VALUES("111", "_site_transient_timeout_browser_fbda03a1a8e1404897916c5ae0506440", "1467683682", "yes");
INSERT INTO `wp_options` VALUES("112", "_site_transient_browser_fbda03a1a8e1404897916c5ae0506440", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"51.0.2704.84\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("115", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2016 16:40:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.6-alpha-37876\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.5.3 Maintenance and Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2016/06/wordpress-4-5-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Jun 2016 09:38:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4311\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:460:\"WordPress 4.5.3 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.5.2 and earlier are affected by several security issues: redirect bypass in the customizer, reported by Yassine Aboukir; two different XSS problems via attachment names, reported by Jouko Pynnönen and Divyesh Prajapati; revision history information disclosure, reported [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Adam Silverstein\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3571:\"<p>WordPress 4.5.3 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.5.2 and earlier are affected by several security issues: redirect bypass in the customizer, reported by <a href=\"http://yassineaboukir.com\">Yassine Aboukir</a>; two different XSS problems via attachment names, reported by <a href=\"https://klikki.fi/\">Jouko Pynnönen</a> and <a href=\"https://twitter.com/divy_er\">Divyesh Prajapati</a>; revision history information disclosure, reported independently by <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a> from the WordPress security team and by Dan Moen from the Wordfence Research Team; oEmbed denial of service reported by Jennifer Dodd from Automattic; unauthorized category removal from a post, reported by David Herrera from <a href=\"https://www.alleyinteractive.com/\">Alley Interactive</a>; password change via stolen cookie, reported by <a href=\"https://blogwaffe.com/\">Michael Adams</a> from the WordPress security team; and some less secure <code>sanitize_file_name</code> edge cases reported by <a href=\"http://peter.westwood.name/\">Peter Westwood</a> of  the WordPress security team.</p>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.5.3 fixes 17 bugs from 4.5, 4.5.1 and 4.5.2. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.5.3\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.5.3\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.5.3</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.5.3.</p>\n<p>Thanks to everyone who contributed to 4.5.3:</p>\n<p><a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/neverything\">Silvan Hagen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>,  <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> and <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.5.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2016/05/wordpress-4-5-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 19:17:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4290\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordPress 4.5.2 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.5.1 and earlier are affected by a SOME vulnerability through Plupload, the third-party library WordPress uses for uploading files. WordPress versions 4.2 through 4.5.1 are vulnerable to reflected XSS [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1669:\"<p>WordPress 4.5.2 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.5.1 and earlier are affected by a <abbr title=\"Same-Origin Method Execution\">SOME</abbr> vulnerability through Plupload, the third-party library WordPress uses for uploading files. WordPress versions 4.2 through 4.5.1 are vulnerable to reflected XSS using specially crafted URIs through MediaElement.js, the third-party library used for media players. MediaElement.js and Plupload have also released updates fixing these issues.</p>\n<p>Both issues were analyzed and reported by Mario Heiderich, Masato Kinugawa, and Filedescriptor from <a href=\"https://cure53.de/\">Cure53</a>. Thanks to the team for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>, and to the Plupload and MediaElement.js teams for working closely with us to coördinate and fix these issues.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.5.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.5.2.</p>\n<p>Additionally, there are multiple widely publicized vulnerabilities in the ImageMagick image processing library, which is used by a number of hosts and is supported in WordPress. For our current response to these issues, see <a href=\"https://make.wordpress.org/core/2016/05/06/imagemagick-vulnerability-information/\">this post on the core development blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.5.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2016/04/wordpress-4-5-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Apr 2016 18:58:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4269\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"After about six million downloads of WordPress 4.5, we are pleased to announce the immediate availability of WordPress 4.5.1, a maintenance release. This release fixes 12 bugs, chief among them a singular class issue that broke sites based on the Twenty Eleven theme, an incompatibility between certain Chrome versions and the visual editor, and an [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Adam Silverstein\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2134:\"<p>After about six million downloads of WordPress 4.5, we are pleased to announce the immediate availability of WordPress 4.5.1, a maintenance release.</p>\n<p>This release fixes 12 bugs, chief among them a singular class issue that broke sites based on the Twenty Eleven theme, an incompatibility between certain Chrome versions and the visual editor, and an Imagick bug that could break media uploads. This maintenance release fixes a total of 12 bugs in Version 4.5. <span style=\"line-height: 1.5\">For more information, see the </span><a style=\"line-height: 1.5\" href=\"https://codex.wordpress.org/Version_4.5.1\">release notes</a><span style=\"line-height: 1.5\"> or consult the </span><a style=\"line-height: 1.5\" href=\"https://core.trac.wordpress.org/log/branches/4.5?rev=37295&amp;stop_rev=37182\">list of changes</a><span style=\"line-height: 1.5\">.</span></p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.5.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.5.1.</p>\n<p>Thanks to everyone who contributed to 4.5.1:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandi</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, and <a href=\"https://profiles.wordpress.org/WiZZarD_\">Pieter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 4.5 “Coleman”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2016/04/coleman/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Apr 2016 19:15:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4203\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"Version 4.5 of WordPress, named “Coleman” in honor of jazz saxophonist Coleman Hawkins, is available for download or update in your WordPress dashboard. New features in 4.5 help streamline your workflow, whether you’re writing or building your site. Editing Improvements Inline Linking Stay focused on your writing with a less distracting interface that keeps you in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:27081:\"<p>Version 4.5 of WordPress, named “Coleman” in honor of jazz saxophonist Coleman Hawkins, is available for download or update in your WordPress dashboard. New features in 4.5 help streamline your workflow, whether you’re writing or building your site.</p>\n<p><iframe width=\'692\' height=\'388\' src=\'https://videopress.com/embed/scFdjVo6?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>\n<hr />\n<h2 style=\"text-align: center\">Editing Improvements</h2>\n<p><img class=\"aligncenter size-full wp-image-4220\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/04/illustration-short-inlinelinks.png?resize=692%2C277&#038;ssl=1\" alt=\"illustration-short-inlinelinks\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/04/illustration-short-inlinelinks.png?w=1000&amp;ssl=1 1000w, https://i2.wp.com/wordpress.org/news/files/2016/04/illustration-short-inlinelinks.png?resize=300%2C120&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/04/illustration-short-inlinelinks.png?resize=768%2C307&amp;ssl=1 768w\" sizes=\"(max-width: 692px) 100vw, 692px\" data-recalc-dims=\"1\" /></p>\n<h3>Inline Linking</h3>\n<p>Stay focused on your writing with a less distracting interface that keeps you in place and allows you to easily link to your content.</p>\n<p><img class=\"aligncenter size-full wp-image-4265\" src=\"https://i0.wp.com/wordpress.org/news/files/2016/04/editing-shortcuts-big.gif?resize=692%2C415&#038;ssl=1\" alt=\"editing-shortcuts-big\" data-recalc-dims=\"1\" /></p>\n<h3>Formatting Shortcuts</h3>\n<p>Do you enjoy using formatting shortcuts for lists and headings? Now they’re even more useful, with horizontal lines and <code>&lt;code&gt;</code>.</p>\n<hr />\n<h2 style=\"text-align: center\">Customization Improvements</h2>\n<p><img class=\"aligncenter size-full wp-image-4221\" src=\"https://i0.wp.com/wordpress.org/news/files/2016/04/illustration-short-responsive-preview.png?resize=692%2C277&#038;ssl=1\" alt=\"illustration-short-responsive-preview\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2016/04/illustration-short-responsive-preview.png?w=1000&amp;ssl=1 1000w, https://i0.wp.com/wordpress.org/news/files/2016/04/illustration-short-responsive-preview.png?resize=300%2C120&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2016/04/illustration-short-responsive-preview.png?resize=768%2C307&amp;ssl=1 768w\" sizes=\"(max-width: 692px) 100vw, 692px\" data-recalc-dims=\"1\" /></p>\n<h3>Live Responsive Previews</h3>\n<p>Make sure your site looks great on all screens! Preview mobile, tablet, and desktop views directly in the customizer.</p>\n<p><img class=\"aligncenter wp-image-4239 size-full\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/04/illustration-short-customlogo-whitespace.png?resize=692%2C304&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/04/illustration-short-customlogo-whitespace.png?w=1000&amp;ssl=1 1000w, https://i2.wp.com/wordpress.org/news/files/2016/04/illustration-short-customlogo-whitespace.png?resize=300%2C132&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/04/illustration-short-customlogo-whitespace.png?resize=768%2C338&amp;ssl=1 768w\" sizes=\"(max-width: 692px) 100vw, 692px\" data-recalc-dims=\"1\" /></p>\n<h3>Custom Logos</h3>\n<p>Themes can now support logos for your business or brand. Try it out with Twenty Sixteen and Twenty Fifteen in the Site Identity section of the customizer.</p>\n<hr />\n<h2 style=\"text-align: center\">Under the Hood</h2>\n<div class=\"under-the-hood three-col\">\n<div class=\"col\">\n<h3>Smart Image Resizing</h3>\n<p>Generated images now load up to 50% faster with no noticeable quality loss. <a href=\"https://make.wordpress.org/core/2016/03/12/performance-improvements-for-images-in-wordpress-4-5/\">It’s really cool</a>.</p>\n</div>\n<div class=\"col\">\n<h3>Selective Refresh</h3>\n<p>The customizer now supports a <a href=\"https://make.wordpress.org/core/2016/02/16/selective-refresh-in-the-customizer/\">comprehensive framework</a> for rendering parts of the preview without rewriting your PHP code in JavaScript.</p>\n</div>\n<div class=\"col\">\n<h3>Script Loader Improvements</h3>\n<p>Better support has been added for script header/footer dependencies. New <code><a href=\"https://make.wordpress.org/core/2016/03/08/enhanced-script-loader-in-wordpress-4-5/\">wp_add_inline_script()</a></code> enables adding extra code to registered scripts.</p>\n<h3>Better Embed Templates</h3>\n<p>Embed templates have been split into parts and can be <a href=\"https://make.wordpress.org/core/2016/03/11/embeds-changes-in-wordpress-4-5/\">directly overridden by themes</a> via the template hierarchy.</p>\n<h3>JavaScript Library Updates</h3>\n<p>jQuery 1.12.3, jQuery Migrate 1.4.0, Backbone 1.2.3, and Underscore 1.8.3 are bundled.</p>\n</div>\n</div>\n<div class=\"under-the-hood two-col\"></div>\n<hr />\n<h2 style=\"text-align: center\">The Crew</h2>\n<p><a class=\"alignleft\" href=\"https://profiles.wordpress.org/mikeschroder\"><img src=\"https://www.gravatar.com/avatar/76424a001dc6b3ebb4faca0c567800c4?d=mm&amp;s=180&amp;r=G\" alt=\"Mike Schroder\" width=\"80\" height=\"80\" /></a>This release was led by <a href=\"https://getsource.net\">Mike Schroder</a>, backed up by <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a> as Release Deputy, <a href=\"https://choycedesign.com/\">Mel Choyce</a> as Release Design Lead, and the help of these fine individuals. There are <span style=\"font-weight: 400\">298</span> contributors with props in this release. Pull up some Coleman Hawkins on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/mercime\">@mercime</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/uglyrobot\">Aaron Edwards</a>, <a href=\"https://profiles.wordpress.org/ahockley\">Aaron Hockley</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abiralneupane\">Abiral Neupane</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/aidanlane\">aidanlane</a>, <a href=\"https://profiles.wordpress.org/ambrosey\">Alice Brosey</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andg\">Andrea Gandino</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rockwell15\">Andrew Rockwell</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/apaliku\">apaliku</a>, <a href=\"https://profiles.wordpress.org/aramzs\">Aram Zucker-Scharff</a>, <a href=\"https://profiles.wordpress.org/ashmatadeen\">ash.matadeen</a>, <a href=\"https://profiles.wordpress.org/bappidgreat\">Ashok Kumar Nath</a>, <a href=\"https://profiles.wordpress.org/bandonrandon\">BandonRandon</a>, <a href=\"https://profiles.wordpress.org/barryceelen\">Barry Ceelen</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/berengerzyla\">berengerzyla</a>, <a href=\"https://profiles.wordpress.org/neoxx\">Bernhard Riedl</a>, <a href=\"https://profiles.wordpress.org/thisisit\">Bhushan S. Jawle</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/williamsba1\">Brad Williams</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/thebrandonallen\">Brandon Allen</a>, <a href=\"https://profiles.wordpress.org/bhubbard\">Brandon Hubbard</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/borgesbruno\">Bruno Borges</a>, <a href=\"https://profiles.wordpress.org/chmac\">Callum Macdonald</a>, <a href=\"https://profiles.wordpress.org/camikaos\">Cami Kaos</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/mackensen\">Charles Fulton</a>, <a href=\"https://profiles.wordpress.org/chetanchauhan\">Chetan Chauhan</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrico\">ChriCo</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/chris_dev\">Chris Mok</a>, <a href=\"https://profiles.wordpress.org/christophherr\">christophherr</a>, <a href=\"https://profiles.wordpress.org/ckoerner\">ckoerner</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/compute\">Compute</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">d4z_c0nf</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/scarinessreported\">Daniel Bailey</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/diddledan\">Daniel Llewellyn</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/danielpataki\">danielpataki</a>, <a href=\"https://profiles.wordpress.org/dvankooten\">Danny van Kooten</a>, <a href=\"https://profiles.wordpress.org/thewanderingbrit\">Dave Clements</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dbrumbaugh10up\">David Brumbaugh</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dnewton\">David Newton</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dossy\">Dossy Shiobara</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/drebbitsweb\">Dreb Bits</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duaneblake\">duaneblake</a>, <a href=\"https://profiles.wordpress.org/kucrut\">Dzikri Aziz</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/codex-m\">Emerson Maningo</a>, <a href=\"https://profiles.wordpress.org/enej\">Enej Bajgoric</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericdaams\">Eric Daams</a>, <a href=\"https://profiles.wordpress.org/ethitter\">Erick Hitter</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/faishal\">faishal</a>, <a href=\"https://profiles.wordpress.org/fantasyworld\">fantasyworld</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/finnj\">finnj</a>, <a href=\"https://profiles.wordpress.org/firebird75\">firebird75</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fusillicode\">fusillicode</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/garusky\">Giuseppe Mamone</a>, <a href=\"https://profiles.wordpress.org/jubstuff\">Giustino Borzacchiello</a>, <a href=\"https://profiles.wordpress.org/grantpalin\">Grant Palin</a>, <a href=\"https://profiles.wordpress.org/groovecoder\">groovecoder</a>, <a href=\"https://profiles.wordpress.org/wido\">Guido Scialfa</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/hakre\">hakre</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/iamntz\">Ionut Staicu</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/jamesdigioia\">James DiGioia</a>, <a href=\"https://profiles.wordpress.org/jason_the_adams\">Jason</a>, <a href=\"https://profiles.wordpress.org/jaspermdegroot\">Jasper de Groot</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeffpyebrookcom\">Jeffrey Schutzman</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/ardathksheyna\">Jess G.</a>, <a href=\"https://profiles.wordpress.org/boluda\">Joan Boluda</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelerr\">joelerr</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnnypea\">JohnnyPea</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/keraweb\">Jory Hogeveen</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/joshlevinson\">Josh Levinson</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/jrchamp\">jrchamp</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/katieburch\">katieburch</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kiranpotphode\">Kiran Potphode</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/krissiev\">KrissieV</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/leemon\">leemon</a>, <a href=\"https://profiles.wordpress.org/layotte\">Lew Ayotte</a>, <a href=\"https://profiles.wordpress.org/liamdempsey\">Liam Dempsey</a>, <a href=\"https://profiles.wordpress.org/luan-ramos\">Luan Ramos</a>, <a href=\"https://profiles.wordpress.org/luciole135\">luciole135</a>, <a href=\"https://profiles.wordpress.org/lpawlik\">Lukas Pawlik</a>, <a href=\"https://profiles.wordpress.org/latz\">Lutz Schr&#246;er</a>, <a href=\"https://profiles.wordpress.org/madvic\">madvic</a>, <a href=\"https://profiles.wordpress.org/marcochiesi\">Marco Chiesi</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/mark8barnes\">Mark Barnes</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/gitlost\">Martin Burke</a>, <a href=\"https://profiles.wordpress.org/mattfelten\">Matt Felten</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattgeri\">MattGeri</a>, <a href=\"https://profiles.wordpress.org/maweder\">maweder</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mcapybara\">mcapybara</a>, <a href=\"https://profiles.wordpress.org/mehulkaklotar\">Mehul Kaklotar</a>, <a href=\"https://profiles.wordpress.org/meitar\">Meitar</a>, <a href=\"https://profiles.wordpress.org/mensmaximus\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/micropat\">micropat</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Mika Epstein</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/usermrpapa\">Mr Papa</a>, <a href=\"https://profiles.wordpress.org/mwidmann\">mwidmann</a>, <a href=\"https://profiles.wordpress.org/nexurium\">nexurium</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/nicdford\">Nic Ford</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/ninos-ego\">Ninos</a>, <a href=\"https://profiles.wordpress.org/oaron\">oaron</a>, <a href=\"https://profiles.wordpress.org/overclokk\">overclokk</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/obrienlabs\">Pat O\'Brien</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pauldewouters\">Paul de Wouters</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/perezlabs\">Perez Labs</a>, <a href=\"https://profiles.wordpress.org/gungeekatx\">Pete Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/cadeyrn\">petermolnar</a>, <a href=\"https://profiles.wordpress.org/walbo\">Petter Walb&#248; Johnsg&#229;rd</a>, <a href=\"https://profiles.wordpress.org/wizzard_\">Pieter</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/ptahdunbar\">Pirate Dunbar</a>, <a href=\"https://profiles.wordpress.org/prettyboymp\">prettyboymp</a>, <a href=\"https://profiles.wordpress.org/profforg\">Profforg</a>, <a href=\"https://profiles.wordpress.org/programmin\">programmin</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahalaboulfeth\">rahal.aboulfeth</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/lamosty\">Rastislav Lamos</a>, <a href=\"https://profiles.wordpress.org/rickalee\">Ricky Lee Whittemore</a>, <a href=\"https://profiles.wordpress.org/ritteshpatel\">Ritesh Patel</a>, <a href=\"https://profiles.wordpress.org/rob\">rob</a>, <a href=\"https://profiles.wordpress.org/rogerhub\">Roger Chen</a>, <a href=\"https://profiles.wordpress.org/romsocial\">RomSocial</a>, <a href=\"https://profiles.wordpress.org/ruudjoyo\">Ruud Laan</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sagarjadhav\">Sagar Jadhav</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/salvoaranzulla\">salvoaranzulla</a>, <a href=\"https://profiles.wordpress.org/samhotchkiss\">Sam Hotchkiss</a>, <a href=\"https://profiles.wordpress.org/rosso99\">Sara Rosso</a>, <a href=\"https://profiles.wordpress.org/sarciszewski\">Scott Arciszewski</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scottbrownconsulting\">scottbrownconsulting</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergejmueller\">Sergej M&#252;ller</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shamess\">Shane</a>, <a href=\"https://profiles.wordpress.org/shinichin\">Shinichi Nishikawa</a>, <a href=\"https://profiles.wordpress.org/sidati\">Sidati</a>, <a href=\"https://profiles.wordpress.org/siobhan\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/aargh-a-knot\">sky</a>, <a href=\"https://profiles.wordpress.org/slushman\">slushman</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/stephanethomas\">stephanethomas</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/charlestonsw\">Store Locator Plus</a>, <a href=\"https://profiles.wordpress.org/subharanjan\">Subharanjan</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/tacoverdo\">Taco Verdonschot</a>, <a href=\"https://profiles.wordpress.org/tahteche\">tahteche</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/takayukister\">Takayuki Miyoshi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/themiked\">theMikeD</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timplunkett\">timplunkett</a>, <a href=\"https://profiles.wordpress.org/tmuikku\">tmuikku</a>, <a href=\"https://profiles.wordpress.org/skithund\">Toni Viemer&#246;</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/rilwis\">Tran Ngoc Tuan Anh</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/vhomenko\">vhomenko</a>, <a href=\"https://profiles.wordpress.org/virgodesign\">virgodesign</a>, <a href=\"https://profiles.wordpress.org/vladolaru\">vlad.olaru</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vtieu\">vtieu</a>, <a href=\"https://profiles.wordpress.org/webaware\">webaware</a>, <a href=\"https://profiles.wordpress.org/wesleye\">Wesley Elfring</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wisdmlabs\">WisdmLabs</a>, <a href=\"https://profiles.wordpress.org/wpdelighter\">WP Delighter</a>, <a href=\"https://profiles.wordpress.org/wp-architect\">wp-architect</a>, <a href=\"https://profiles.wordpress.org/xavortm\">xavortm</a>, <a href=\"https://profiles.wordpress.org/yetanotherdaniel\">yetAnotherDaniel</a>, and <a href=\"https://profiles.wordpress.org/zinigor\">zinigor</a>.\n<p>&nbsp;</p>\n<p>Special thanks go to <a href=\"http://siobhanmckeown.com/\">Siobhan McKeown</a> for producing the release video and <a href=\"https://jacklenox.com\">Jack Lenox</a> for the voice-over.</p>\n<p>Finally, thanks to all of the contributors who provided translations for the release. WordPress 4.5 comes fully translated into 44 languages and the release video has been translated into 32 languages!</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.6!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress 4.5 RC2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2016/04/wordpress-4-5-rc2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Apr 2016 05:14:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4186\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:350:\"The second release candidate for WordPress 4.5 is now available. We&#8217;ve made 91 changes since the first release candidate. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.5 on Tuesday, April 12, but we need your help [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3044:\"<p>The second release candidate for WordPress 4.5 is now available.</p>\n<p>We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37171&amp;stop_rev=37078&amp;limit=120&amp;verbose=on\">91 changes</a> since the first release candidate. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.5 on <strong>Tuesday, April 12</strong>, but we need your help to get there.</p>\n<p>If you haven’t tested 4.5 yet, now is the time!</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.5, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.5-RC2.zip\">download the release candidate here</a> (zip).</p>\n<p>For more information about what’s new in version 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.5 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.5. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p><strong>Polyglots</strong>, strings are now hard frozen, including the About Page, so you are clear to translate!</p>\n<p>A few changes of note since the first release candidate:</p>\n<ul>\n<li>Normalized non-slashing of data in the REST API infrastructure. If you use the REST API infrastructure, <a href=\"https://make.wordpress.org/core/2016/04/06/rest-api-slashed-data-in-wordpress-4-4-and-4-5/\">check out the post on this change</a>.</li>\n<li>Customizer settings for widget instances get registered a bit later to give a chance for the widget instances themselves to be registered first. See <a href=\"https://core.trac.wordpress.org/ticket/36431\">#36431</a> for details.</li>\n<li>Fixed various cropping issues in the Custom Logo feature and Twenty Fifteen / Twenty Sixteen themes.</li>\n</ul>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where you can find the <a href=\"https://make.wordpress.org/core/2016/03/30/wordpress-4-5-field-guide/\">Field Guide for 4.5</a>.</p>\n<p><em>It&#8217;s great fun to test</em><br />\n<em>Enjoyment in another</em><br />\n<em>Release Candidate</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Contributor Weekend: Global WordPress Translation Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wordpress.org/news/2016/04/contributor-weekend-global-wordpress-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 07 Apr 2016 21:04:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4191\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"Global WordPress Translation Day is a one-day contributor initiative organised by the WordPress project’s Polyglots team that is dedicated to helping new contributors who would like to translate WordPress in one of the 160 languages WordPress is available in. Global WordPress Translation Day will be on Sunday, April 24th, starting at 0:00 UTC and will go on for [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3069:\"<p class=\"p1\"><span class=\"s1\">Global WordPress Translation Day is a one-day contributor initiative organised </span><span class=\"s1\">by the WordPress project’s </span><span class=\"s1\"> <a href=\"https://make.wordpress.org/polyglots\"><span class=\"s2\">Polyglots team</span></a> that is dedicated to helping new contributors who would like to translate WordPress in one of the 160 languages WordPress is available in.</span></p>\n<p class=\"p1\"><span class=\"s1\">Global WordPress Translation Day will be on Sunday, April 24th, starting at 0:00 UTC and will go on for 24 hours covering all time zones.</span></p>\n<p class=\"p3\"><span class=\"s1\"><b>What are we doing?</b></span></p>\n<ul class=\"ul1\">\n<li class=\"li1\"><span class=\"s1\"><span class=\"s1\">Live training: A 24h live streaming of tutorials about translating WordPress in different languages and making your code translatable (30min/1h sessions in different languages including a general instruction and specifics for that particular language). The </span></span><span class=\"s1\">internationalization </span>sessions will be in English. The sessions will be presented by some of the most experienced WordPress translators and internationalization experts. The Schedule can be found on the website.</li>\n<li class=\"li1\"><span class=\"s1\">Local translation contributor days: Groups of contributors gather at different locations and work face to face.</span></li>\n<li class=\"li1\"><span class=\"s1\">Local remote translation contributor days: Current translation teams dedicate time and get involved remotely to do orientation for their potential contributors or work with their current translation teams on translating as many strings as they can.</span></li>\n</ul>\n<p class=\"p1\"><span class=\"s1\">If you organise a local meetup, why not organise a contributor day for translating in your language?</span></p>\n<p class=\"p3\"><span class=\"s1\"><b>Join us! Read about the initiative and </b><a href=\"https://make.wordpress.org/polyglots/2016/03/02/wordpress-global-translation-day-april-24th-2016/\"><span class=\"s3\"><b>sign up as an organiser</b></span></a><b>.</b></span></p>\n<p class=\"p3\"><span class=\"s1\"><b>Can I get involved if I only speak English?</b></span></p>\n<p class=\"p1\"><span class=\"s1\">Yes! Even if you only speak English, it would be great to get involved and check out some of the English locale variants &#8211; English as spoken in the United Kingdom, Canada, New Zealand, Australia, South Africa. English has many variants across the globe and you can learn about the differences and why it&#8217;s important that users have the option to choose a variant during some of our sessions. And if you&#8217;re in a funky mood, you can give translating the interface into Emoji a try! Yes, we have a WordPress in Emoji locale!</span></p>\n<p class=\"p3\"><span class=\"s1\"><b>Questions?</b></span></p>\n<p class=\"p1\"><span class=\"s1\">The polyglots team and the event organisers hang out in <a href=\"http://wordpress.slack.com/messages/polyglots/\">#Polyglots in Slack</a>. They will gladly help you out.</span></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.5 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2016/03/wordpress-4-5-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Mar 2016 03:50:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:344:\"The release candidate for WordPress 4.5 is now available. We&#8217;ve made 49 changes since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.5 on Tuesday, April 12, but we need your help [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2251:\"<p>The release candidate for WordPress 4.5 is now available.</p>\n<p>We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37077&amp;stop_rev=37026&amp;limit=120&amp;verbose=on\">49 changes</a> since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.5 on <strong>Tuesday, April 12</strong>, but we need your help to get there.</p>\n<p>If you haven’t tested 4.5 yet, now is the time!</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.5, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.5-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>For more information about what’s new in version 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.5 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.5 before next week. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where we&#8217;ll continue to post <a href=\"https://make.wordpress.org/core/tag/dev-notes+4-5/\">notes for developers</a> for 4.5.</p>\n<p><em>Free as in Freedom</em><br />\n<em>It is WordPress 4.5</em><br />\n<em>Also free as in beer</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 04:30:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4155\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3392:\"<p>WordPress 4.5 Beta 4 is now available!</p>\n<p>This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta4.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">in-depth field guides on make/core</a>. This is the final <a href=\"https://make.wordpress.org/core/version-4-5-project-schedule/\">planned beta</a> of WordPress 4.5, with a release candidate scheduled for next week.</p>\n<p>Some of the changes in Beta 4 include:</p>\n<ul>\n<li>Add support for oEmbed <strong>moments and timelines from Twitter</strong> (<a href=\"https://core.trac.wordpress.org/ticket/36197\">#36197</a>).</li>\n<li>More changes to better support <strong>HHVM with Imagick</strong>.<strong> </strong>Please test with HHVM setups and resizing/rotating images (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>).</li>\n<li>Tightened up the <strong>Inline Link</strong> feature (<a href=\"https://core.trac.wordpress.org/ticket/33301\">#33301</a>, <a href=\"https://core.trac.wordpress.org/ticket/30468\">#30468</a>).</li>\n<li>Support <code>&lt;hr&gt;</code> <strong>editor shortcut</strong> with 3 or more dashes (<code>---</code>); no spaces. To give more time to study the best shortcuts for users, text patterns for bold and italic have been removed and won&#8217;t ship with for 4.5 (<a href=\"https://core.trac.wordpress.org/ticket/33300\">#33300</a>).</li>\n<li>Fixes for <strong>SSL with Responsive Images</strong>. Please test with SSL, especially on sites with mixed http/https setups (<a href=\"https://core.trac.wordpress.org/ticket/34945\">#34945</a>).</li>\n<li>Allow rewrite rules to work in nested <strong>WordPress installations on IIS</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35558\">#35558</a>).</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37025&amp;stop_rev=36932&amp;limit=200&amp;verbose=on\">almost 100 changes</a> during the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p class=\"p1\"><em>Llegamos al fin</em><br />\n<em>del tiempo pa&#8217; beta</em><br />\n<em>¡Pruébalo Ahora!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 06:59:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4128\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3631:\"<p>WordPress 4.5 Beta 3 is now available!</p>\n<p>This software is still in development<strong>,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta3.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">in-depth field guides on make/core</a>. Some of the fixes in Beta 3 include:</p>\n<ul>\n<li>Many <strong>Theme Logo Support</strong> (<a href=\"https://core.trac.wordpress.org/ticket/33755\">#33755</a>) fixes, including support for bundled Twenty Fifteen (<a href=\"https://core.trac.wordpress.org/ticket/35944\">#35944</a>).</li>\n<li>Add <strong>Responsive Preview</strong> to theme install previewer (<a href=\"https://core.trac.wordpress.org/ticket/36017\">#36017</a>).</li>\n<li>Support <strong>Imagick in HHVM</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>).</li>\n<li><strong>Whitelist IPTC, XMP, and EXIF profiles</strong> from <code>strip_meta()</code> to maintain authorship, copyright, license, and image orientation (<a href=\"https://core.trac.wordpress.org/ticket/28634\">#28634</a>).</li>\n<li>Support <strong>Windows shares/DFS roots</strong> in <code>wp_normalize_path()</code> (<a href=\"https://core.trac.wordpress.org/ticket/35996\">#35996</a>).</li>\n<li><span class=\"s1\">New installs default to <strong>generating secret keys and salts locally</strong> instead of relying on the <span class=\"s2\">WordPress.org</span> API. Please test installing WP in situations where it can’t connect to the internet <span class=\"s1\">(like on a 🛳, ✈️, or 🛰) </span></span><span class=\"s1\">(<a href=\"https://core.trac.wordpress.org/ticket/35290\">#35290</a>).</span></li>\n<li>OPTIONS requests to REST API should <strong>return Allow header</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35975\">#35975</a>).</li>\n<li>Upgrade twemoji.js to version 2 (<a href=\"https://core.trac.wordpress.org/ticket/36059\">#36059</a>) and add extra IE11 compatibility (<a href=\"https://core.trac.wordpress.org/ticket/35977\">#35977</a>) for <strong>Emoji</strong>.</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36931&amp;stop_rev=36814&amp;limit=200&amp;verbose=on\">more than 100 changes</a> during the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p class=\"p1\"><em><span class=\"s1\">Beta one, two, three<br />\n</span><span class=\"s1\">so many bugs have been fixed<br />\n</span><span class=\"s2\">Closer now; four, five.</span></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Mar 2016 04:55:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4116\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2370:\"<p>WordPress 4.5 Beta 2 is now available!</p>\n<p>This software is still in development<strong>,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta2.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1 blog post</a>. Some of the fixes in Beta 2 include:</p>\n<ul>\n<li>Added <a href=\"https://core.trac.wordpress.org/ticket/33300\">Horizontal Rule (HR) editing shortcut</a> and <a href=\"https://core.trac.wordpress.org/ticket/28612\">dismissible &#8220;Paste as Text&#8221; notice</a> in <strong>TinyMCE</strong>.</li>\n<li><strong>Selective Refresh</strong> support is <a href=\"https://core.trac.wordpress.org/changeset/36797\">enabled for core themes titles and taglines</a>, which allows shift-click to focus on controls and PHP filters to apply in the preview.</li>\n<li>Resolved a fatal error on <strong>image upload</strong> when ImageMagick could not complete stripping meta during resize (<a href=\"https://core.trac.wordpress.org/ticket/33642\">#33642</a>).</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36813&amp;stop_rev=36701&amp;limit=200&amp;verbose=on\">just over 100 changes</a> in the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p><em>It&#8217;s peer pressure time</em><br />\n<em>Testing: all cool kids do it</em><br />\n<em>Help find ALL the bugs!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 28 Jun 2016 01:54:44 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 22 Jun 2016 16:40:08 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20160506200020\";}", "no");
INSERT INTO `wp_options` VALUES("116", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1467122084", "no");
INSERT INTO `wp_options` VALUES("117", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1467078884", "no");
INSERT INTO `wp_options` VALUES("118", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1467122085", "no");
INSERT INTO `wp_options` VALUES("119", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress.tv Blog: Spotlight: WordCamp Miami 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.wordpress.tv/?p=464\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://blog.wordpress.tv/2016/06/22/spotlight-wordcamp-miami-2016/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2223:\"<p>WordCamp Miami helped kick off the 2016 WordCamp season with sunny skies and great presentations on how to take your WordPress site to the next level. You can see all the <a href=\"https://wordpress.tv/event/wordcamp-miami-2016/\">WordCamp Miami sessions here</a>, but below are a few that stood out for us.</p>\n<h2>\nRachel Carden: Tools and Techniques for Evaluating Accessibility</h2>\n<div id=\"v-o320Yj17-1\" class=\"video-player\">\n</div>\n<p>When your website is accessible, all users can access your content no matter their abilities. Visually-impaired users can visit your website using a screen reader. Those who can’t use the mouse can navigate your site using a keyboard or other input device. Some accessibility features might also improve your SEO. When your site is inaccessible, research shows you could be excluding up to 20 percent of your users. This talk for all skill levels will review tools and techniques you can use to test and improve your site’s accessibility.</p>\n<p><a href=\"http://www.slideshare.net/rachelcarden/tools-and-techniques-for-evaluating-accessibility\">Presentation Slides</a></p>\n<p>&nbsp;</p>\n<h2>Kids WordPress Panel Discussion</h2>\n<div id=\"v-CypUoG9y-1\" class=\"video-player\">\n</div>\n<p>Kids talking about WordPress and blogging at WordCamp Miami 2016.</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptvblog.wordpress.com/464/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptvblog.wordpress.com/464/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.wordpress.tv&blog=5310177&post=464&subd=wptvblog&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://blog.wordpress.tv/2016/06/22/spotlight-wordcamp-miami-2016/\"><img alt=\"Rachel Carden: Tools and Techniques for Evaluating Accessibility\" src=\"http://videos.videopress.com/o320Yj17/toolsandtechniquesforevaluatingaccessibility_std.original.jpg\" width=\"160\" height=\"120\" /></a></div><div><a href=\"http://blog.wordpress.tv/2016/06/22/spotlight-wordcamp-miami-2016/\"><img alt=\"Kids WordPress Panel Discussion\" src=\"http://videos.videopress.com/CypUoG9y/kidspanel_scruberthumbnail_1.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2016 16:41:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jerry Bates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WordPress.tv Blog: Developing for WordPress with Pippin Williamson and Danilo Ercoli\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.wordpress.tv/?p=439\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://blog.wordpress.tv/2016/06/15/developing-for-wordpress-with-pippin-williamson-and-danilo-ercoli/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1891:\"<h2 class=\"video-title\">Pippin Williamson: Ask Me Anything About Plugins</h2>\n<p>Pippin is a prolific plugin developer and founder of several successful commercial WordPress plugin projects. This session is a Q&amp;A style format where the audience asked question related to plugin development, the WordPress.org plugins directory, selling plugins, building a development team, and anything else related to plugins.</p>\n<p></p>\n<p>More from <a href=\"http://wordpress.tv/event/wordcamp-san-diego-2016/\">WordCamp San Diego 2016</a></p>\n<p>&nbsp;</p>\n<h2 class=\"video-title\">Danilo Ercoli: Migliorare le performance di WordPress con il caching e l’esecuzione differita di codice</h2>\n<p>Questo talk è rivolto sia a chi ha appena iniziato a sviluppare con WordPress, sia agli sviluppatori più esperti che lo conoscono già da parecchio tempo, ed è un’introduzione ad alcuni argomenti come il caching e l’esecuzione differita di codice PHP, che sono utili per migliorare notevolmente le performance del tuo sito. Alcuni degli argomenti trattati sono il corretto utilizzo della cache e dei plugin di caching. Un’introduzione al WordPress Jobs System, e come eseguire codice differito senza dover quindi rallentare il rendering della pagina.</p>\n<p></p>\n<p><a href=\"https://wptv.files.wordpress.com/2016/04/danilo-ercoli-migliorare-performance-wp-caching-esecuzione-differita-codice-wctrn-2016.pdf\">Presentation Slides</a></p>\n<p>More from <a href=\"http://wordpress.tv/event/wordcamp-torino-2016/\">WordCamp Torino 2016</a></p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptvblog.wordpress.com/439/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptvblog.wordpress.com/439/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.wordpress.tv&blog=5310177&post=439&subd=wptvblog&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jun 2016 16:37:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jerry Bates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Post Status: How WordPress news happens — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=25018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://poststatus.com/wordpress-news-happens-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1636:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. This episode of Post Status Draft is hosted by Sarah Gooding &#8212; another WordPress journalist &#8212; and Brian Krogsgard.</p>\n<p><span>In this episode, Sarah and Brian discuss how they do WordPress news, manage working remotely, and handle family life.</span></p>\n<!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/39891.mp3\">https://audio.simplecast.com/39891.mp3</a>\n<p><a href=\"http://audio.simplecast.com/39891.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://wptavern.com/category/opinion\">WP Tavern opinion</a></li>\n</ul>\n<h3>Sponsor</h3>\n<p><span>This episode is sponsored by <a href=\"https://www.valet.io/\">Valet</a>. Valet helps keep your clients happy &amp; coming back. They offer expert services and keep the websites they manage functioning flawlessly. They offer preventative care that provides peace of mind around the clock. For more information, check out <a href=\"https://www.valet.io/\">their website</a> and thank you to Valet for being a Post Status partner. </span><b> </b></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jun 2016 13:35:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WordPress.tv Blog: How to create child themes and multi-lingual blogs – Featured on WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.wordpress.tv/?p=414\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://blog.wordpress.tv/2016/06/08/how-to-create-child-themes-and-multi-lingual-blogs-featured-on-wordpress-tv/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2153:\"<h2 class=\"video-title\">Corinne Welsh: My First Child Theme</h2>\n<p>Corrine Welsh explains how to get started with themes in WordPress, starting with a case study: why, why then, and why not sooner. From there she looks at the structure of a theme and walks through the steps of building a child theme. You may leave inspired to roll up your sleeves and get your hands dirty in theming after this great talk.</p>\n<div id=\"v-6oXMxwGi-1\" class=\"video-player\">\n</div>\n<p>From <a href=\"http://wordpress.tv/event/wordcamp-london-2016/\">WordCamp London 2016</a></p>\n<h2 class=\"video-title\">Maciej Pilarski: How To Make Your WordPress Website Multilingual</h2>\n<p>In this presentation Maciej Pilarski goes into detail on how  to easily and quickly create a traditional multilingual website or eCommerce store.  He also compares most popular multilingual plugins and also shows how this can be done without using any plugins, as well as discusses the benefits to your business of going global and how this can be done in minutes.</p>\n<div id=\"v-K21BXW6Y-1\" class=\"video-player\">\n</div>\n<p>From <a href=\"http://wordpress.tv/event/wordcamp-london-2016/\">WordCamp London 2016</a></p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptvblog.wordpress.com/414/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptvblog.wordpress.com/414/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.wordpress.tv&blog=5310177&post=414&subd=wptvblog&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://blog.wordpress.tv/2016/06/08/how-to-create-child-themes-and-multi-lingual-blogs-featured-on-wordpress-tv/\"><img alt=\"Corinne Welsh: My First Child Theme\" src=\"http://videos.videopress.com/6oXMxwGi/video-b0595a6e44_std.original.jpg\" width=\"160\" height=\"120\" /></a></div><div><a href=\"http://blog.wordpress.tv/2016/06/08/how-to-create-child-themes-and-multi-lingual-blogs-featured-on-wordpress-tv/\"><img alt=\"Maciej Pilarski: How to Make your WordPress Website Multilingual\" src=\"http://videos.videopress.com/K21BXW6Y/video-c5c8665f72_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jun 2016 01:46:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jerry Bates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WP Mobile Apps: WordPress for Android: Version 5.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://apps.wordpress.com/?p=3403\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://apps.wordpress.com/2016/06/01/wordpress-for-android-version-5-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3183:\"<p>Hello WordPress users! <a href=\"https://play.google.com/store/apps/details?id=org.wordpress.android\" target=\"_blank\">Version 5.4 of the WordPress for Android app</a> is now available in the Google Play Store.</p>\n<h1>Gravatar update</h1>\n<p>Did you just take a great selfie? You can update your Gravatar from the app on the <em>Me</em> screen. Tap your profile picture, and follow the prompts to take a new photo or pick an image from your device&#8217;s photo library.</p>\n<div id=\"v-a5lLmHSc-1\" class=\"video-player\">\n</div>\n<h1>Smart Lock for Passwords integration</h1>\n<p>Signing in with a WordPress.com account is easier than ever with Smart Lock for Passwords, the Google password manager. If you signed in to your account on your computer using Google&#8217;s Chrome browser, the username and password fields will be automatically pre-filled when you open the app &#8212; you can even manage several identities.</p>\n<p><img class=\"alignnone wp-image-3404 size-large\" src=\"https://apps.files.wordpress.com/2016/05/screenshot-2016-05-04_12-08-06-614.png?w=614&h=1024\" alt=\"screenshot-2016-05-04_12.08.06.614\" width=\"614\" height=\"1024\" /></p>\n<h1>Other Changes</h1>\n<p>Version 5.4 also comes with a few other fixes:</p>\n<ul>\n<li>Fixed comment previews with images in the Comment List screen.</li>\n<li>Fixed an issue with tag display in the Reader.</li>\n<li>Fixed a problem sometimes removed the <em>Themes</em> option after sign-in.</li>\n</ul>\n<p>You can track our development progress for the next release by visiting <a href=\"https://github.com/wordpress-mobile/WordPress-Android/milestones/5.5\">our 5.5 milestone on GitHub</a>.</p>\n<h1>Beta</h1>\n<p>Do you like keeping up with what’s new in the app? Do you enjoy testing new stuff before anyone else? Our testers have access to beta versions with updates shipped directly through Google Play. The beta versions may have new features, new fixes — and possibly new bugs! Testers make it possible for us to improve the overall app experience, and offer us invaluable development feedback.</p>\n<p>Want to become a tester? <a href=\"https://play.google.com/apps/testing/org.wordpress.android\">Opt-in</a>!</p>\n<h1>Thank you</h1>\n<p>Thanks to our GitHub contributors: <a href=\"https://github.com/aerych\">@aerych</a>, <a href=\"https://github.com/aforcier\">@aforcier</a>, <a href=\"https://github.com/daniloercoli\">@daniloercoli</a>, <a href=\"https://github.com/hypest\">@hypest</a>, <a href=\"https://github.com/kwonye\">@kwonye</a>, <a href=\"https://github.com/maxme\">@maxme</a>, <a href=\"https://github.com/mzorz\">@mzorz</a>, <a href=\"https://github.com/nbradbury\">@nbradbury</a>, <a href=\"https://github.com/oguzkocer\">@oguzkocer</a>, <a href=\"https://github.com/roundhill\">@roundhill</a>, and <a href=\"https://github.com/tonyr59h\">@tonyr59h</a>.</p><img alt=\"\" border=\"0\" src=\"https://pixel.wp.com/b.gif?host=apps.wordpress.com&blog=108068616&post=3403&subd=apps&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"https://apps.wordpress.com/2016/06/01/wordpress-for-android-version-5-4/\"><img alt=\"gravatar\" src=\"https://videos.files.wordpress.com/a5lLmHSc/gravatar_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Jun 2016 11:53:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Maxime\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: WordCamp Incubator Program to Launch in Indonesia, Zimbabwe, and Colombia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=55034\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/wordcamp-incubator-program-to-launch-in-indonesia-zimbabwe-and-columbia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2932:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/02/flags.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/02/flags.jpg?resize=1020%2C500\" alt=\"flags\" class=\"aligncenter size-full wp-image-16697\" /></a></p>\n<p>After receiving <a href=\"http://wptavern.com/wordcamp-incubator-program-receives-182-applications-narrows-candidates-to-16-communities\" target=\"_blank\">182 applications from cities all over the world</a>, the WordPress Community Team has selected three locations for the WordCamp Incubator program:</p>\n<ul>\n<li>Denpasar, Indonesia</li>\n<li>Harare, Zimbabwe</li>\n<li>Medellín, Colombia</li>\n</ul>\n<p>Representatives from the thirteen other short-listed locations are encouraged to organize a local WordPress meetup and will have the help of Community Team mentors as needed.</p>\n<p>Thanks to the addition of a new volunteer deputy from the Community Team, the program will move forward with three locations, instead of having to scale back to two, as previously anticipated. Each event has been assigned a deputy who will meet bi-weekly with the local team to mentor the new WordCamp organizers.</p>\n<p>Andrea Middleton outlined in the <a href=\"https://make.wordpress.org/community/2016/05/25/wordcamp-incubator-locations-announcement/\" target=\"_blank\">announcement</a> how the team plans to proceed with getting these events off the ground.</p>\n<p>&#8220;Denpasar, Harare, and Medellín will work with their respective deputies to start a monthly WordPress meetup group or add their existing meetup group to the chapter account program,&#8221; Middleton said. &#8220;Once the local WordPress user group is meeting regularly, each team will work on finding a venue, setting a date, recruiting speakers, and spreading the word about the upcoming WordCamp.&#8221;</p>\n<p>In order to take the pressure off the new organizers, the Community team will assist them in scheduling and finding speakers. The events will be 100% funded by the global sponsorship grant so organizers can focus on community building without the pressure of fundraising. Middleton said they are aiming for no more than three non-local speakers at each event, which she anticipates will happen in the last quarter of 2016.</p>\n<p>The challenge with the Incubator program is to ensure these events are a launching point and not just a flash in the pan. Middleton and the community team deputies are working to establish these emerging communities so that they continue to grow organically after the events conclude.</p>\n<p>&#8220;The goal for these events is to organize an easily reproducible, one-day, one-track event with about 50-75 attendees,&#8221; Middleton said. &#8220;Hopefully by the end of the organizing/incubating experience, members of the local community will feel confident that they can organize an annual WordCamp independently in the years to come.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 31 May 2016 05:12:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Donncha: WordPress is thirteen!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"http://z9.io/?p=89499890\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"http://z9.io/2016/05/27/wordpress-is-thirteen/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1231:\"<p>You could have knocked me over with a feather today when I read <a href=\"https://ma.tt/2016/05/wordpress-is-a-teenager/\">Matt&#8217;s post</a> announcing that WordPress was celebrating a birthday!</p>\n<p>It didn&#8217;t seem so long ago that we were working on b2++, hacking the multiuser bits in and doing all sorts of crazy things with it.</p>\n<p>Now I&#8217;m &#8220;typing&#8221; this on a mobile phone by swiping my finger across a virtual keyboard. Back then the closest to this that I could imagine would be some sort of SMS integration!</p>\n<p>WordPress today is unrecognisable from what it was back then, especially if you use the slick Calypso interface.</p>\n<p>I&#8217;m looking forward to seeing what the next few years bring.</p>\n\n<p><strong>Related Posts</strong><ul><li> <a href=\"http://z9.io/2013/08/02/like-a-dog-and-his-ball/\" rel=\"bookmark\" title=\"Permanent Link: Like a dog and his ball\">Like a dog and his ball</a></li><li> <a href=\"http://z9.io/2009/01/28/wordpress-mu-27/\" rel=\"bookmark\" title=\"Permanent Link: WordPress MU 2.7\">WordPress MU 2.7</a></li><li> <a href=\"http://z9.io/2008/09/02/wordpress-mu-261/\" rel=\"bookmark\" title=\"Permanent Link: WordPress MU 2.6.1\">WordPress MU 2.6.1</a></li></ul></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2016 22:57:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Donncha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"Post Status: WordPress.org — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=24730\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://poststatus.com/wordpress-org-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3513:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>In this episode, Joe and Brian discuss the structure and function of the WordPress.org website, which is the hub of the WordPress project. From the actual software distribution, to discussions about the project, to support, and buying swag: it all happens from WordPress.org. We break down what’s what and what we think you should know.</span></p>\n<p><a href=\"https://audio.simplecast.com/38479.mp3\">https://audio.simplecast.com/38479.mp3</a><br />\n<a href=\"http://audio.simplecast.com/38479.mp3\">Direct Download</a></p>\n<h3>Notes</h3>\n<p>Who owns WordPress.org?<br />\nWho works on WordPress.org<br />\nHow WordPress.org distributes software updates</p>\n<h3>Different Sections of WordPress.org Navigation</h3>\n<ul>\n<li>Showcase</li>\n<li>WordPress theme directory &#8212; and reviews &#8212; and commercial themes</li>\n<li>WordPress plugin directory &#8212; and reviews</li>\n<li>Mobile &#8212; Redirects to .com</li>\n<li>Support Forums / Codex &#8220;documentation&#8221;</li>\n<li>Make WordPress (Get Involved)</li>\n<li>About (many sub pages and also project structure)</li>\n<li>Blog</li>\n<li>Hosting</li>\n<li>Download (button &#8212; in future to be <a href=\"https://make.wordpress.org/meta/2016/02/29/get-wordpress-improving-the-path-to-wordpress/\">Get WordPress</a>)</li>\n</ul>\n<h3>Other Sections</h3>\n<ul>\n<li><a href=\"https://core.trac.wordpress.org/\">core.trac.wordpress.org</a></li>\n<li><a href=\"https://developer.wordpress.org/\">developer.wordpress.org</a></li>\n<li><a href=\"https://mercantile.wordpress.org/\">mercantile.wordpress.org</a></li>\n<li><a href=\"http://jobs.wordpress.net/\">jobs.wordpress.net</a></li>\n<li><a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a></li>\n<li><a href=\"https://wordpress.org/ideas/\">Ideas</a></li>\n</ul>\n<h3>Other Linked Sites</h3>\n<ul>\n<li><a href=\"https://central.wordcamp.org/\">WordCamp</a></li>\n<li><a href=\"http://wordpress.tv/\">WordPress.tv</a></li>\n<li><a href=\"https://buddypress.org/\">BuddyPress</a></li>\n<li><a href=\"https://bbpress.org/\">bbPress</a></li>\n<li><a href=\"https://wordpress.com/\">WordPress.com</a></li>\n<li><a href=\"https://ma.tt/\">ma.tt</a></li>\n</ul>\n<h3>Active Projects for Improving</h3>\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/tag/helphub/\">Helphub</a></li>\n<li>Handbooks (theme), plugin published</li>\n<li>Plugin directory</li>\n</ul>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/\">Blog for WordPress.org projects</a></li>\n</ul>\n<h3>Sponsor</h3>\n<p><span>This episode is sponsored by Gravity Forms. <a href=\"http://www.gravityforms.com/\">Gravity Forms</a>  makes the best web forms on the planet. Over a million WordPress sites are already using Gravity Forms. Is yours? For more information, check out their <a href=\"http://www.gravityforms.com/\">website</a> and thank you to Gravity Forms for being a Post Status partner. </span><b> </b></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2016 19:18:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: Jetpack 4.0.3 Patches a Critical XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=55036\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/jetpack-4-0-3-patches-a-critical-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2266:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif?resize=700%2C276\" alt=\"jetpack-logo\" class=\"aligncenter size-full wp-image-27470\" /></a></p>\n<p><a href=\"https://jetpack.com/2016/05/27/jetpack-4-0-3-critical-security-update/\" target=\"_blank\">Jetpack 4.0.3 is a security release</a> that contains an important fix for a critical vulnerability that has been present in the plugin since version 2.0, released in 2012. According to Jetpack team member Sam Hotchkiss, a stored XSS vulnerability was found in the way that some Jetpack shortcodes are processed, which allows an attacker to insert JavaScript into comments to hijack a visitor&#8217;s browser.</p>\n<p>This particular bug is similar to one <a href=\"https://blog.sucuri.net/2016/05/security-advisory-stored-xss-bbpress-2.html\" target=\"_blank\">recently found and patched in bbPress</a>.</p>\n<p>&#8220;Similar issues may exist in other plugins, and it’s a good reminder about the power of regular expressions to create issues when parsing data,&#8221; Hotchkiss said.</p>\n<p>The Jetpack team has been working with the WordPress security team to push out point releases for all vulnerable branches of the plugin&#8217;s codebase, which includes all versions following 2.0. They are using WordPress&#8217; core automatic update system, so all sites that have not explicitly opted out will receive the security update.</p>\n<p>&#8220;Fortunately, we have no evidence of this being used in the wild,&#8221; Hotchkiss said. &#8220;However, now that this update is public, it’s just a matter of time before someone attempts to exploit it.&#8221; The Jetpack team is advising users to update as soon as possible, as the update also fixes any potential exploits that may have already been put in place.</p>\n<p>The team credits Marc-Alexandre Montpas from <a href=\"https://sucuri.net/\" target=\"_blank\">Sucuri</a> for finding the bug and disclosing it responsibly. Users will be notified about the security release via email, but those who have Akismet and/or VaultPress installed have already been protected since the first reporting of the vulnerability.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2016 01:05:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Post Status: Growing a lifestyle business without losing the lifestyle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=24644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://poststatus.com/growing-lifestyle-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8760:\"<p><em><strong>Editor&#8217;s Note</strong>: This is a guest post by Nate Wright. Nate is a WordPress developer and solopreneur. He runs <a href=\"http://themeofthecrop.com\">Theme of The Crop</a>, a niche WordPress theme company geared toward restaurant websites. You can learn more about Nate on his <a href=\"https://poststatus.com/profiles/nate-wright/\">Post Status profile</a> and follow him on <a href=\"https://twitter.com/natewr\">Twitter</a>.</em></p>\n<hr />\n<p>Here&#8217;s a scenario you&#8217;re probably familiar with: a friend or family member, not terribly tech-savvy, approaches you with an idea. Why don&#8217;t you build Facebook for clowns? What about Uber for sandwiches?</p>\n<p>Their ideas are often a little better than these. Sometimes they&#8217;re worse. But in my case the conversation always gets to the same point in the end.</p>\n<p>You can build stuff on the internet. Why aren&#8217;t you shooting for the stars? Don&#8217;t you want to be rich like Zuckerberg?</p>\n<p>Right now some of you may be thinking: yes I do! This post isn&#8217;t for you.</p>\n<p>This is for those of you who cringe at the thought of your days filling up with hiring and training staff, conducting meetings, or filling out paperwork. Those of you who don&#8217;t want to live the big siloed life of a CEO. Who dove into the WordPress market because you wanted to build things yourself. For yourself.</p>\n<h3>The rockstars and the rest of us</h3>\n<p>It’s hard to find someone more widely admired among WordPress developers &#8212; and more deserving of that admiration &#8212; than <a href=\"https://pippinsplugins.com/about/\">Pippin Williamson</a>. So when he <a href=\"https://pippinsplugins.com/control-give-grow/\">described his evolution</a> from staunch go-it-aloner to team leader, many of us sat up and listened.</p>\n<p>The <a href=\"https://pippinsplugins.com/control-give-grow/#comments\">comments</a> in response to that post exhibit a common mix of anxiety, frustration and hope for us go-it-aloners, who have carved out small (and not so small) niches in the WordPress world.</p>\n<p>We’re overstretched and under resourced. We lack good marketing strategies. And we can see that growth will come from transforming our businesses into larger enterprises.</p>\n<p>But then we start thinking about what that means. The hiring. The firing. The training. The meetings. The paperwork. <i>The liability</i>.</p>\n<p>&#8216;I don’t want to be the next Zuckerberg,&#8217; you may think. Then, hopefully, you’ll laugh at the absurdity. But really, you may think, &#8216;I don’t even want to be the next <a href=\"http://carlhancock.com/\">Carl Hancock</a> or <a href=\"https://yoast.com/author/joost/\">Joost de Valk</a>.&#8217;</p>\n<p>Let me be honest with you. I’ll stop putting words in your mouth and put them in mine.</p>\n<p>I have a lifestyle business. No, I don’t sell lifestyle products. I have a business <em>tailored to my lifestyle</em>.</p>\n<p>I have a business that allows to me to take lunch when I want, finish the day when I want, go on holiday when I want, write the code that I want. That’s my job perk. That’s my killer bonus. No, that’s my Shangri-La.</p>\n<p>When people tell you to hire early or scale quickly, they’re right that giving up control can be liberating. But it can also be encumbering. It brings new responsibilities at the same time that it releases you from old ones.</p>\n<p>Whether or not growing your team is right for you will depend on your temperament, your appetite and the kind of lifestyle you want.</p>\n<h3>Being a little fish in a big pond</h3>\n<p>But let’s be honest. You took a chance on the WordPress market because you saw a window of opportunity. That window may be closing.</p>\n<p>In the last few years we’ve seen a lot of consolidation. The theme market exploded, <a href=\"http://inside.envato.com/envato-stories-muhammad-haris-themefusion-2/\">made millions for a few</a>, and then caused a gold rush which <a href=\"http://scottbolinger.com/wordpress-theme-business/\">saturated the market and pushed out small operators</a>.</p>\n<p>At the same time, two big traditional distribution channels dried up: the official <a href=\"https://wordpress.org/themes/\">WordPress.org theme repository</a>, which has a huge backlog of themes awaiting approval, and <a href=\"https://theme.wordpress.com/\">Automattic’s marketplace</a>, which is closed to new entrants.</p>\n<p>We’re also seeing more traditional investment in WordPress properties. The big one is the <a href=\"http://recode.net/2014/05/05/wordpress-parent-automattic-has-raised-160-million-now-valued-at-1-16-billion-post-money/\">$160 million raised by Automattic</a> and Automattic&#8217;s subsequent <a href=\"https://poststatus.com/automattic-acquired-woocommerce-woothemes/\">acquisition of WooThemes</a>. Many actors are moving more aggressively to leverage or retain their market position. Syed Balkhi is on a buying and building spree (<a href=\"http://enviragallery.com/about-us/\">1</a>, <a href=\"http://optinmonster.com/about/\">2</a>, <a href=\"https://wpforms.com/say-hello-to-wpforms/\">3</a>, <a href=\"http://wptavern.com/syed-balkhi-acquires-google-analytics-by-yoast-renames-to-monsterinsights\">4</a>). Ninja Forms did a <a href=\"https://ninjaforms.com/releasing-three/\">ground-up rebuild</a>. Pippin’s shedding non-essential products (<a href=\"https://pippinsplugins.com/easy-content-types-acquired/\">1</a>, <a href=\"https://pippinsplugins.com/nikhil-vimal-adopts-front-end-registration-and-login-forms-plugin/\">2</a>) and <a href=\"https://pippinsplugins.com/selfish/\">purging some third-party addons</a>.</p>\n<p>The ecosystem looks increasingly unfriendly to us go-it-aloners. Automattic was the first to go big. Given exclusive commercial access to the WordPress trademark, it carved out its own space and split WordPress down the middle. Now the other half &#8212; the WordPress for the rest of us &#8212; is going big too.</p>\n<p>The nice thing about being a small operator is that you only need a tiny sliver of the pie. But as the size of the market has grown, it’s become more difficult to attract attention. Showing up with a good product isn’t enough.</p>\n<h3>Going it alone, together</h3>\n<p>My lifestyle business is working well for me. Revenue keeps inching up. Slowly.</p>\n<p>But it might not make it in a different kind of WordPress space. I’ve been thinking a lot about that lately. And I bet you have too.</p>\n<p>Where’s the market going? What am I willing to trade to survive? Which headaches are <a href=\"http://www.codeinwp.com/blog/transparency-report-14/\">worth changing direction for</a> and which headaches aren’t?</p>\n<p>Here are some of the ideas I’ve been tossing around:</p>\n<h3>Contractors</h3>\n<p>Hiring out. I could scale up or down easily, depending on how well it goes. But it’s tough to manage quality when juggling vendors.</p>\n<p>And what would I contract? I’d like to shed my bumbling efforts in marketing and traffic generation. But that seems like precisely the kind of job full of jackals who don’t know what they’re doing.</p>\n<p>Ok, that’s harsh. I’ll just say: I worry it’d be a headache to manage it well.</p>\n<p>Theme development seems the most plausible, since there’s a large body of talented, hungry themers washing up from the stormy seas of ThemeForest. But it may be the least valuable since the market is being swallowed up by a few big themes.</p>\n<h3>Commissions</h3>\n<p>Affiliate marketing is already working for me. A little. I could go further and recruit theme or plugin developers to sell from my site on commission.</p>\n<p>Then I’m saddled with support for products I didn’t build. Can I maintain quality? Can I drive enough traffic to be an attractive outlet for them? Will I end up with all of the headaches I wanted to avoid?</p>\n<h3>Partnerships</h3>\n<p>Maybe I’ll trade in my king-of-the-hill cap and bring on partners. Not employees. Genuine partners with overlapping skill sets. Instead of being a go-it-aloner we can be two or three go-it-aloners going it alone together!</p>\n<p>Or maybe that’s just a terrible way to run a business.</p>\n<h3>Alliances</h3>\n<p>There are a lot of us out there. Independent themers looking to expand beyond ThemeForest or give up on the old freemium approach of the official repository. Plugin developers looking for a new home or seeking out themes that will integrate with their plugins.</p>\n<p>We could probably do something special if we made stronger alliances. Combined to build to stronger platforms for our products.</p>\n<p>But that sounds like a lot of project management. Isn’t that what we were hoping to avoid?</p>\n<p>I don’t know. I’m going to go write some code.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 May 2016 18:10:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Nate Wright\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WP Mobile Apps: WordPress for iOS: Version 6.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://apps.wordpress.com/?p=3416\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://apps.wordpress.com/2016/05/25/wordpress-for-ios-version-6-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3021:\"<p>Hi there, WordPress users! <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">Version 6.2 of the WordPress for iOS app</a> is now available in the App Store.</p>\n<h1>What&#8217;s New:</h1>\n<p><strong>Sharing just got easier!</strong> Post content from apps to your WordPress.com site with a new Share extension. Also, share a post right from your editor’s preview screen.</p>\n\n<a href=\"https://apps.wordpress.com/img_2229_2/\"><img width=\"169\" height=\"300\" src=\"https://apps.files.wordpress.com/2016/05/img_2229_2.png?w=169&h=300\" class=\"attachment-medium size-medium\" alt=\"IMG_2229_2\" /></a>\n<a href=\"https://apps.wordpress.com/img_2230/\"><img width=\"169\" height=\"300\" src=\"https://apps.files.wordpress.com/2016/05/img_2230.png?w=169&h=300\" class=\"attachment-medium size-medium\" alt=\"IMG_2230\" /></a>\n\n<p><strong>Improved clipboard support: </strong>Working with images? You can now copy and paste single images in your editor.</p>\n<p><strong>Login with ease:</strong> We improved error messages for self-hosted users.</p>\n<p><strong>Enhancements:</strong> Because &#8220;good&#8221; is not enough! Here&#8217;s the full <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?q=is%3Aclosed+is%3Aissue+milestone%3A6.2+label%3A%22%5BType%5D+Enhancement%22\">list of enhancements</a>.</p>\n<p><strong>Bugs, be gone!</strong> We zapped bugs that prevented images from rendering properly and caused backspaces to misbehave.  You can see the full list of bug fixes <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?q=is%3Aclosed+is%3Aissue+milestone%3A6.1+label%3A%22%5BType%5D+Bug%22\">here</a>!</p>\n<h1>Thank You</h1>\n<p>Thanks to all of the contributors who worked on this release:<br />\n<a href=\"https://github.com/aerych\">@aerych</a>, <a href=\"https://github.com/akirk\">@akirk</a>, <a href=\"https://github.com/alexcurylo\">@alexcurylo</a>, <a href=\"https://github.com/astralbodies\">@astralbodies</a>, <a href=\"https://github.com/diegoreymendez\">@diegoreymendez</a>, <a href=\"https://github.com/frosty\">@frosty</a>, <a href=\"https://github.com/jleandroperez\">@jleandroperez</a>, <a href=\"https://github.com/koke\">@koke</a>, <a href=\"https://github.com/kurzee\">@kurzee</a>, <a href=\"https://github.com/kwonye\">@kwonye</a>, <a href=\"https://github.com/maxme\">@maxme</a>, <a href=\"https://github.com/nheagy\">@nheagy</a>, <a href=\"https://github.com/rachelmcr\">@rachelmcr</a>, <a href=\"https://github.com/sendhil\">@sendhil</a>, <a href=\"https://github.com/mattmiklic\">@mattmiklic</a> and <a href=\"https://github.com/SergioEstevao\">@SergioEstevao</a>.</p>\n<p>You can track the development progress for the next update by visiting <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?utf8=✓&q=is%3Aissue+milestone%3A6.3+\" target=\"_blank\">our 6.3 milestone on GitHub</a>. Until next time!</p><img alt=\"\" border=\"0\" src=\"https://pixel.wp.com/b.gif?host=apps.wordpress.com&blog=108068616&post=3416&subd=apps&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 May 2016 06:05:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"diegoreymendez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: In Case You Missed It – Issue 9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=55015&preview_id=55015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wptavern.com/in-case-you-missed-it-issue-9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8011:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png\" rel=\"attachment wp-att-50955\"><img class=\"size-full wp-image-50955\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?resize=676%2C292\" alt=\"In Case You Missed It Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>There’s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn’t make it into a full post.</p>\n<h2>Chris Lema Launches Beyond Good</h2>\n<p>Chris Lema has launched a new site called <a href=\"http://beyondgood.com/\">Beyond Good </a>that provides insight, tips, and methodologies for leading employees to become better than good. If it&#8217;s anything like his other sites, it&#8217;s sure to be a hit in the WordPress community.</p>\n<h2>Remote Jobs, a Remote Worker Specific Jobs Board</h2>\n<p>Chris Wallace and the team at Lift have launched <a href=\"https://remotejobs.com/\">Remote Jobs</a>, a jobs board specifically catered to remote workers. According to Wallace, &#8220;The site exists to help others find remote jobs that connect them with their passions in life.&#8221; Check out the site as there&#8217;s already a decent listing of opportunities available for remote workers.</p>\n<h2>Why .Blog is Worth $19M</h2>\n<p>Matt Mullenweg participated in a <a href=\"http://venturebeat.com/2016/05/12/the-creator-of-wordpress-on-why-blog-was-worth-19-million/\">phone interview with VentureBeat</a>. The first question in the interview asks why the .blog domain is worth $19M.</p>\n<blockquote><p>Well, the domain business is actually a really good business because you can sell a domain and people use it and keep it forever. So, if you look at like a Verisign, or people who have TLDs, it’s actually an incredible business.</p>\n<p>We really wanted .blog to be open, and some of the other applications for .blog were closed, including Google — so, let’s say for example, only Blogger could have a .blog domain. And we thought that .blog should be open to everyone, even if they’re not using WordPress.</p>\n<p>I gotta be honest though, it was a stressful auction.</p></blockquote>\n<p>There are other tidbits of information included in the interview that I highly encourage you to read. If I were Google, I&#8217;d be upset as .blog is the perfect complimentary domain for Blogger.</p>\n<h2>Drupal Association Gives Community Member a Lifetime Ban</h2>\n<p>DrupalCon New Orleans took place last week and during the event, several speakers <a href=\"https://www.drupal.org/node/2729687\">experienced online harassment</a> in the form of derogatory racist, homophobic, and misogynistic comments and images from an anonymous Twitter account. Upon further investigation by community members and the Drupal Association technical and event staff, the harassment was tracked to an attendee at the event.</p>\n<blockquote><p>This person was then confronted by members of the Drupal Association staff and the Community Working Group. They were asked to leave the event and informed that they have been banned from attending any future DrupalCons as well as any events produced by the Drupal Association, in accordance with the <a href=\"https://events.drupal.org/neworleans2016/code-conduct\" rel=\"nofollow\">DrupalCon Code of Conduct</a>, which states, &#8216;We do not tolerate harassment of conference participants in any form.&#8217; Shortly after the person left the conference, the account from which the harassing tweets were made was deleted.</p></blockquote>\n<p>This is an excellent example of why Codes of Conduct exist for events. By the way, check out the <a href=\"https://plan.wordcamp.org/code-of-conduct/\">Code of Conduct</a> that&#8217;s in place for every WordCamp. If you experience harassment of any kind at a WordCamp, please tell event staff.</p>\n<h2>Plans Published to Upgrade WordPress Support Forums</h2>\n<p>Jennifer Dodd published a <a href=\"https://make.wordpress.org/meta/2016/05/19/wordpress-org-forums-upgrade/\">detailed plan</a> for migrating the WordPress.org support forums from bbPress 1.x to 2.x. The project is a huge undertaking and involves moving massive amounts of data. If all goes according to plan, the support forums will be on bbPress 2.x by the end of the year. I&#8217;m sure a lot of support forum volunteers are stoked to hear this news.</p>\n<h2>What NOT to Name a WordPress Theme</h2>\n<p>This tweet by Ryan Sullivan gave me a good laugh.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I\'d strongly consider rebranding. <a href=\"https://t.co/9MeevJTlPq\">pic.twitter.com/9MeevJTlPq</a></p>\n<p>&mdash; Ryan D. Sullivan (@ryandonsullivan) <a href=\"https://twitter.com/ryandonsullivan/status/733120690816065536\">May 19, 2016</a></p></blockquote>\n<p></p>\n<h2>Tom McFarlin on Improving the WordPress Plugin UX</h2>\n<p>Tom McFarlin published a <a href=\"https://tommcfarlin.com/wordpress-plugin-user-experience-2/\">great article</a> that offers ideas on how plugin developers can improve the WordPress plugin user experience. His first suggestion is a key reason I think GravityForms became successful.</p>\n<blockquote><p>Try to make sure that your project tightly integrates with the core WordPress user interface.</p></blockquote>\n<p>When I witnessed GravityForms for the first time in 2009, I loved how it integrated into the WordPress backend as if it were a part of the core software. Fast forward to 2016 and plugins that tie into a service are experimenting with overlay interfaces that replace WordPress&#8217;. The most recent example I recall is WP Forms <a href=\"http://wptavern.com/wpforms-aims-to-be-the-most-beginner-friendly-forms-plugin-for-wordpress\">that I reviewed</a> earlier this year.</p>\n<p>In my review, I specifically noted that the interface the developers used allowed me to focus on creating forms. It doesn&#8217;t seem like it&#8217;s a WordPress core feature and it didn&#8217;t have too. While the advice McFarlin gives is likely accurate for most cases, there are plugins that benefit from having a unique user interface different from WordPress&#8217;.</p>\n<h2>Don&#8217;t Edit Core</h2>\n<p>This comic <a href=\"http://www.commitstrip.com/en/2016/05/17/coder-dilemma-9-the-upgrade/\">created by CommitStrip</a> made me smile.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Coder Dilemma #9 &#8211; The Upgrade<br /> <a href=\"https://t.co/2Tu2l1tgYX\">https://t.co/2Tu2l1tgYX</a> <a href=\"https://t.co/xnMr2VdYWv\">pic.twitter.com/xnMr2VdYWv</a></p>\n<p>&mdash; CommitStrip (@CommitStrip) <a href=\"https://twitter.com/CommitStrip/status/732505464768843776\">May 17, 2016</a></p></blockquote>\n<p></p>\n<h2>Wapuu Tattoo!</h2>\n<p>In what is a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project. WordCamp St. Louis 2016, took place last weekend and one of the attendees had a Wapuu tattoo! Wapuu looks good everywhere, including human skin!</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Wapuu has been sighted at <a href=\"https://twitter.com/hashtag/wcstl?src=hash\">#wcstl</a> <a href=\"https://twitter.com/hashtag/wordpress?src=hash\">#wordpress</a> <a href=\"https://twitter.com/hashtag/wapuu?src=hash\">#wapuu</a> <a href=\"https://t.co/4HYlp6GI0S\">pic.twitter.com/4HYlp6GI0S</a></p>\n<p>&mdash; Nile Flores (@blondishnet) <a href=\"https://twitter.com/blondishnet/status/731504592668758017\">May 14, 2016</a></p></blockquote>\n<p></p>\n<p>That&#8217;s it for issue nine. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 May 2016 22:30:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: WordPress Meta Team Publishes Prototypes of The Plugin Directory Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=55006\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/wordpress-meta-team-publishes-prototypes-of-the-plugin-directory-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3713:\"<p>In early 2015, the WordPress.org Meta team <a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">redesigned</a> the <a href=\"https://wordpress.org/plugins/\">WordPress plugin directory</a> and added a number of new features. In an effort to iterate on the page&#8217;s layout, the Meta Team has <a href=\"https://make.wordpress.org/meta/2016/05/19/plugin-directory-prototypes/\">published prototypes</a> of a new design for the <a href=\"http://codepen.io/mapk/full/jqxqbo/\">plugin directory&#8217;s home</a> and <a href=\"http://codepen.io/mapk/full/KzGQKv/\">search results pages</a>.</p>\n<p>The prototypes are inspired by <a href=\"https://get.wp.com/\">Get WordPress</a>, a landing page that provides key information about the WordPress project at a glance.</p>\n<p>There are a few things to keep in mind while looking at these prototypes. The first is that plugin information displayed on the page is inaccurate. Second, the Pro and Light classifications are for design purposes only. Third, links at the bottom will point to their corresponding pages.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/PluginDirectoryMockup1.png\"><img class=\"size-full wp-image-55007\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/PluginDirectoryMockup1.png?resize=1025%2C2753\" alt=\"WordPress Plugin Directory Homepage Protoype\" /></a>WordPress Plugin Directory Homepage Protoype\n<p>Unlike the current design, the prototype displays far less information. Authors, Last Updated, Compatibility, and Active Installs are absent from the homepage view. Initial feedback <a href=\"https://make.wordpress.org/meta/2016/05/19/plugin-directory-prototypes/#comment-8151\">highlights the concern</a> that too much information has been stripped away.</p>\n<p>In response to a comment on the announcement post, Samuel Sidler, <span class=\"st\">Apollo Team Lead at Automattic and contributor to the Meta team</span>, <a href=\"https://make.wordpress.org/meta/2016/05/19/plugin-directory-prototypes/#comment-8154\">explains</a> why he doesn&#8217;t think the information is useful to users.</p>\n<blockquote><p>Author, as you said, is only really useful for insiders. The latter two, meanwhile, are already taken into account in the search results. If a plugin doesn’t have a recent compatible version, it will move down the list. If it’s too old, it won’t get shown at all (which is the case today).</p>\n<p>Active installs is more interesting, but we account for it weighting search results as-is. I actually find it refreshing to <em>not</em> show the active installs as it allows for less-popular plugins to get more downloads. Users will be less likely to click the popular plugins (outside of familiar names) and more likely to find the plugin they actually need.</p></blockquote>\n<p>Another commenter suggests <a href=\"https://profiles.wordpress.org/awakensolutions/\">creating a simple/advanced view. </a>By default, the page could display a simplistic design while giving power users an option for more details.</p>\n<p>&#8220;Just like <a href=\"https://wordpress.org/about/philosophy/\" rel=\"nofollow\">WordPress core</a>, we strive to design for the majority and build features for the 80%,&#8221; Sidler said in response to the comment. &#8220;An &#8216;advanced&#8217; view doesn’t meet that requirement, in my eyes.&#8221;</p>\n<p>The Meta team is iterating quickly and will soon publish a prototype of the plugin details page. If you have feedback on the plugin homepage and search result prototypes, please leave a comment on <a href=\"https://make.wordpress.org/meta/2016/05/19/plugin-directory-prototypes/\">the announcement post</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 May 2016 20:19:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: WPWeekly Episode 235 – Interview with James Giroux Envato’s WordPress Evangelist\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=55000&preview_id=55000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://wptavern.com/wpweekly-episode-235-interview-with-james-giroux-envatos-wordpress-evangelist\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1298:\"<p>In this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"https://jamesgiroux.ca/\">James Giroux</a>, Envato&#8217;s WordPress evangelist. We discuss a number of topics including what he&#8217;s accomplished since taking over the position in January, the item support policy change, and author driven pricing.</p>\n<p>We also find out what his favorite part of the job is and what he enjoys most about his role at Envato. Last but not least, we discover what the company is doing to shorten the length of time it takes to get through the review queue.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, June 1st 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #235:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 May 2016 19:18:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: BuddyPress Launches Style Modules Trial Initiative\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54954\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/buddypress-launches-style-modules-trial-initiative\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3960:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/customize-posts.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/customize-posts.jpg?resize=1024%2C583\" alt=\"photo credit: Paintbrush - (license)\" class=\"size-full wp-image-54351\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/93249705@N03/13067171403\">Paintbrush</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p>BuddyPress core developer <a href=\"https://twitter.com/hnla\" target=\"_blank\">Hugo Ashmore</a> announced a new trial initiative this week that aims to create a library of CSS and JavaScript snippets to help users customize their communities. The <a href=\"https://bpdevel.wordpress.com/2016/05/11/buddypress-style-modules/\" target=\"_blank\">Style Modules</a> project will aggregate community-submitted code that enhances BuddyPress components in a plug-and-play manner.</p>\n<p>Developers who want to contribute to the project can submit their modules by creating a ticket on <a href=\"https://buddypress.trac.wordpress.org/newticket\" target=\"_blank\">BP trac</a> and attaching a zip file that includes the CSS/JS files, a readme.md, and a screenshot.</p>\n<p>Users who want to add a module will need to create a /style-modules/ directory and then unzip the module inside it. The next step requires the user to copy functions from the module&#8217;s readme file to their theme&#8217;s functions.php file, a step which provides a significant hurdle for a non-technical BuddyPress community manager.</p>\n<p>&#8220;Initially this is a trial to see whether we get sufficient interest in the concept to continue and develop further, perhaps enhancing the loading process with enqueueing of files based on directory scanning and loading of files as an array but run from the core theme compat class, removing the need for users to copy the loading functions to their functions file,&#8221; Ashmore said.</p>\n<p>The project&#8217;s GitHub repository includes <a href=\"https://github.com/buddypress/style-modules/wiki/Style-Modules-Listings\">an example module</a> that re-styles the members list into a grid layout. Other example ideas Ashmore suggested include a new look for profile entries, a different presentation for the activity posting form, or something as simple as changing the font size for the activity stream.</p>\n<p>The experimental initiative will test the waters to see if the BuddyPress community will chip in to provide enough modules to make this a real library. The support policy stated in the proposal doesn&#8217;t offer much incentive for module authors to submit their work:</p>\n<blockquote><p>Provision of modules and use of them is entirely the discretion of the authors and users, while BP will run some basic checks on the module BP does not guarantee that the modules will work in all given situations or installs, or accept any liability in their use. Support for a module remains the responsibility of the author to ensure the continued effectiveness of the module with updates to themes, WP or BP.</p></blockquote>\n<p>Historically, BuddyPress has struggled to present itself as an easily customizable solution for communities. <a href=\"http://codex.buddypress.org/themes/theme-compatibility-1-7/a-quick-look-at-1-7-theme-compatibility/\" target=\"_blank\">Theme compatibility</a>, introduced in April 2013, made it easier to use BP with any theme, but unless you purchase a theme specifically designed for the plugin, its default output is rather generic and in need of heavy styling.</p>\n<p>The <a href=\"https://bpdevel.wordpress.com/2016/05/11/buddypress-style-modules/\" target=\"_blank\">BuddyPress Style Modules</a> concept is an attempt to make it easier for community managers to enhance BP components with different looks, but the project will need to provide a compelling reason for developers to contribute modules and continue to maintain them.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 May 2016 02:34:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: The .blog Domain Extension Is Now Open to Registrars\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54971\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://wptavern.com/the-blog-domain-extension-is-now-open-to-registrars\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2083:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?resize=960%2C521\" alt=\"photo credit: Luis Llerena\" class=\"size-full wp-image-54799\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3ZHG0XOIT6\">Luis Llerena</a>\n<p>Today marks a moment in internet history, as the very first .blog domain is now operational on WordPress.com. Knock Knock, WHOIS There, a subsidiary of Automattic, launched <a href=\"https://nic.blog/\" target=\"_blank\">Nic.blog</a> today to begin getting registrars to sign up to sell the new TLD.</p>\n<p>Automattic <a href=\"http://wptavern.com/automattic-to-oversee-the-sale-and-registration-of-top-level-blog-domains\" target=\"_blank\">won the rights to oversee the sale and registration of the .blog domain</a> in 2015 via a bidding process that is estimated to have closed around $20 million. The domain extension is so new that Twitter doesn&#8217;t yet support it as a valid link, but Automattic expects to activate 250,000 new names in 2016.</p>\n<p>According to the new nic.blog information site, registrars that sign up to sell .blog domains will be able to participate in an incentive partnership model that rewards a higher volume of sales:</p>\n<blockquote><p>Pricing will be in the standard range for new gTLDs, with premium names available in several tiers. High margins for registrars will be guaranteed by an incentive model, rewarding sales above a certain baseline. Final terms will be published in the coming weeks.</p></blockquote>\n<p>Automattic is opening up the .blog TLD to registrars around the world and companies can sign up on nic.blog to learn more about the requirements. Individuals who are interested in purchasing a .blog domain should review the tentative <a href=\"https://nic.blog/launch-plan/\" target=\"_blank\">launch plan</a> published today. Registration will be open to trademark owners during the Sunrise period starting in August 2016, followed by a Landrush period in October.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 May 2016 23:26:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: After Eight Years, Thematic Theme’s Lead Developers Discontinue the Project\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54967\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/after-eight-years-thematic-themes-lead-developers-discontinue-the-project\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3812:\"<p>Gene Robinson, lead developer of the Thematic WordPress theme, has <a href=\"http://thematictheme.com/2016/05/15/thematic-retrospective/\">announced</a> that the project will no longer be developed. Thematic <a href=\"https://wordpress.org/themes/thematic/\">was last updated</a> in 2013 and is actively installed on more than 4K sites. Users are advised to migrate to a different theme as updates will no longer be released. As WordPress core evolves, sites using Thematic may develop incompatibilities.</p>\n<h2>Continuing The Legacy with a Different Name</h2>\n<p>Although development on Thematic is discontinuing, Robinson has forked the project and renamed it to <a href=\"http://d.eciduo.us\">Deciduous. </a>The project picks up where Thematic leaves off. Those interested in continuing development can <a href=\"https://github.com/emhr/Deciduous\">follow it on GitHub</a> where pull requests are welcomed. Robinson is also seeking links to other projects that are derivative of Thematic.</p>\n<h2>Where to Get Support for Thematic</h2>\n<p>Users who need support are advised to post on the <a href=\"https://wordpress.org/support/theme/thematic\">WordPress.org support forums</a> for the Thematic theme, &#8220;The support forums on the Thematic website are shutting down due to the lack of community involvement, moderation, and developer feedback,&#8221; Robinson said. &#8220;Hopefully the greater WordPress support community will be able to help you find a resolution.&#8221;</p>\n<h2>A Look Back</h2>\n<p>The years 2008-2009 is an interesting time frame in WordPress&#8217; history. A number of commercial theme and plugin companies, WordPress-centric sites, and projects were launched. Among these was the <a href=\"https://web.archive.org/web/20080611165821/http://themeshaper.com/thematic-for-wordpress/\">Thematic theme</a> by Ian Stewart, theme Wrangler for Automattic. Thematic was more than just a theme, it was an opportunity for Stewart to learn how WordPress&#8217; theme system works.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/ThematicThemePreview.png\"><img class=\"size-full wp-image-54981\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/ThematicThemePreview.png?resize=951%2C740\" alt=\"Thematic Theme Preview from WordPress.org\" /></a>Preview of Thematic from WordPress.org\n<p>He regularly shared his knowledge with the community through <a href=\"https://themeshaper.com/\">ThemeShaper.com</a>, a site now owned by Automattic that features contributions from other members of the theme team. It was the wild west of theme development in 2008 and any person who regularly shared theme development techniques became an influential member of the community.</p>\n<p>Two years after launching Thematic, Stewart <a href=\"https://themeshaper.com/2010/03/04/ian-stewart-joined-automattic/\">joined Automattic</a> as a theme wrangler.</p>\n<blockquote><p>What can I say besides awesome, awesome, awesome? The enormous opportunity for learning and improvement; all the super-talented, friendly people; the chance to work on so many really, really cool projects—it’s almost unbelievable. This is a dream job for me.</p></blockquote>\n<p>The hiring allowed him to make available all of his commercial child themes built on the Thematic framework available free of charge to the community.</p>\n<h2>Did You Learn From Thematic?</h2>\n<p>It&#8217;s bittersweet and slightly nostalgic to see the theme come to an end. When I launched the Tavern in 2009, I regularly linked to tutorials and articles published by Stewart. I&#8217;m almost certain Thematic and its creator helped out a number of budding theme developers between 2008-2011. Let us know in the comments if you used Thematic for any projects or what you learned from its code.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 May 2016 20:45:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Post Status: WordPress as a Headless CMS — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=24518\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://poststatus.com/wordpress-headless-cms-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2870:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>Joe and Brian discuss WordPress as a Headless CMS. They talk about what a Headless CMS is, WordPress’s strengths and weaknesses as a Headless CMS, popular frameworks to utilize, and offer up example websites to check out.</span></p>\n<p><a href=\"https://audio.simplecast.com/37861.mp3\">https://audio.simplecast.com/37861.mp3</a><br />\n<a href=\"http://audio.simplecast.com/37861.mp3\">Direct Download</a></p>\n<h3>Examples</h3>\n<ul>\n<li><a href=\"https://www.guggenheim.org/\">The Guggenheim</a></li>\n<li><a href=\"https://adayofrest.hm/boston-2016/\">A Day of Rest Boston</a></li>\n<li><a href=\"https://ustwo.com/\">ustwo</a></li>\n<li><a href=\"http://skaled.com/\">Skaled</a></li>\n<li><a href=\"http://tri.be/\">Modern Tribe</a></li>\n</ul>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://angularjs.org/\">Angular</a></li>\n<li><a href=\"https://facebook.github.io/react/\">React</a></li>\n<li><a href=\"http://blog.scalac.io/2016/02/16/react-vs-angular-2.html\">React vs Angular 2</a></li>\n<li><a href=\"https://getmoxied.net/lean/\">Lean, an Agular for WordPress framework</a></li>\n<li><a href=\"https://pantheon.io/decoupled-cms\">Decoupled CMS</a></li>\n<li><a href=\"https://css-tricks.com/what-is-a-headless-cms/\">What is a Headless CMS?</a></li>\n<li><a href=\"http://petya.in/we-need-to-talk-about-the-rest-api-the-non-developer-guide-to-the-future-of-wordpress/\">We Need to Talk about the REST API</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/05/16/rest-api-authentication-broker/\">Introducing the REST API Authentication Broker</a></li>\n<li><a href=\"https://hmn.md/2016/01/14/introducing-our-wordpress-rest-api-white-paper/\">Human Made&#8217;s REST API White Paper</a></li>\n</ul>\n<h3>Sponsor</h3>\n<p><span>Today’s show is sponsored by </span><a href=\"http://optinmonster.com\"><span>OptinMonster</span></a><span>. OptinMonster allows you to convert visitors into subscribers. You can easily create &amp; A/B test beautiful lead capture forms without a developer. They recently released </span><a href=\"http://optinmonster.com/introducing-optinmonster-3-0-taking-your-conversion-optimization-to-the-next-level/\"><span>OptinMonster 3.0</span></a><span>, with an all new builder interface and other great features.</span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 May 2016 17:47:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: Take Granular Control of WordPress’ Update System with Easy Updates Manager\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54952\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wptavern.com/take-granular-control-of-wordpress-update-system-with-easy-updates-manager\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3933:\"<p>When <a href=\"https://wordpress.org/news/2013/10/basie/\">WordPress 3.7 &#8220;Basie&#8221;</a> was released in 2013, it brought automatic updates to the masses. By default, WordPress automatically updates to point releases. Using <a href=\"https://codex.wordpress.org/Configuring_Automatic_Background_Updates\">additional constants</a> within wp-config.php, you can configure WordPress to automatically update themes, plugins, and major releases.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-54958\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerFeaturedImage.png?resize=650%2C207\" alt=\"Easy Update Manager Featured Image\" /></a></p>\n<p>If you want granular control over the WordPress update system without touching code, check out <a href=\"https://wordpress.org/plugins/stops-core-theme-and-plugin-updates/\">Easy Updates Manager</a>. Easy Updates Manager is a free plugin that&#8217;s active on more than 70k sites. It&#8217;s maintained by <a href=\"https://profiles.wordpress.org/kidsguide/\">Matthew</a>, <a href=\"https://profiles.wordpress.org/ronalfy/\">Ronald Huereca</a>, <a href=\"https://profiles.wordpress.org/roary86/\">Roary Tubbs</a>, and <a href=\"https://profiles.wordpress.org/bigwing/\">BigWing Interactive</a>.</p>\n<h2>Countless Number of Configurations Available</h2>\n<p>Once activated, you&#8217;ll find the options page by browsing to Dashboard &gt; Update Options. There are two different interfaces for configuring updates. The first includes a number of toggle switches that disable/enable updates. The second is a traditional screen with radial buttons.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerDashboard.png\"><img class=\"size-full wp-image-54959\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerDashboard.png?resize=1025%2C432\" alt=\"Easy Update Manager Dashboard\" /></a>Easy Updates Manager Dashboard\n<p>Traditional settings page for Easy Updates Manager.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerGeneralSettings.png\"><img class=\"size-full wp-image-54960\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerGeneralSettings.png?resize=566%2C480\" alt=\"Easy Update Manager General Settings\" /></a>Easy Updates Manager General Settings\n<p>One of the highlights of Easy Updates Manager is the ability to enable automatic updates for individual themes and plugins. It&#8217;s a convenient way to update themes and plugins that rarely cause issues. There&#8217;s also a built-in logging feature that when enabled creates a new table in the database. It logs the username, update type, version, action, status, and date.</p>\n<p>Logging is listed as a beta feature and should be used at your own risk. It also may not work with all commercial themes and plugins. Here&#8217;s what the log looks like after I updated three plugins.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerLogs.png\"><img class=\"size-full wp-image-54961\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/EasyUpdateManagerLogs.png?resize=1025%2C350\" alt=\"Easy Update Management Log\" /></a>Easy Updates Management Log\n<p>Easy Updates Manager also includes the ability to exclude users from manipulating the plugin&#8217;s settings. The plugin contains additional features that I encourage you to explore by using it on a test site.</p>\n<p>Thanks to the number of options available, users have a countless number of update configurations to choose from. I tested the plugin on WordPress 4.6 alpha and it works as expected. You can <a href=\"https://wordpress.org/plugins/stops-core-theme-and-plugin-updates/\">download it for free</a> from the WordPress plugin directory.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 May 2016 07:17:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: WordPress 4.6 Improves the Accessibility of the Tag and Category Management Pages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54910\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://wptavern.com/wordpress-4-6-improves-the-accessibility-of-the-tag-and-category-management-pages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2775:\"<p>Among the improvements coming in WordPress 4.6 are <a href=\"https://make.wordpress.org/core/2016/05/16/categories-and-tags-screens-changes/\">accessibility enhancements</a> to the Category and Tag management pages. The flow of each page has been changed so that the visual order of elements match the tab order. This allows those who navigate with keyboards to access the Add New Tag or Add New Category area first.</p>\n<p>Andrea Fercia, WordPress core committer and a member of the accessibility team, explains why the changes matter, &#8220;For accessibility, the visual order should always match the tab order. The main functionality in a page should just be the first thing in the source markup and other parts of the user interface should never be &#8216;skipped&#8217;.&#8221;</p>\n<p>The following image shows the tab order of elements on the Tag management screen in WordPress 4.5. In order to reach the Add New Tag section, you need to tab through a number of checkboxes, each tag in the tag cloud, and various quick edit links. This is a time-consuming and frustrating process.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/WordPress45TagManagementPage.png\"><img class=\"size-full wp-image-54944\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/WordPress45TagManagementPage.png?resize=1025%2C806\" alt=\"WordPress 4.5 Tag Management Element Order\" /></a>WordPress 4.5 Tag Management Element Order\n<p>In WordPress 4.6, the Add New Tag section is the first visual element as well as the first section accessed when pressing the tab key.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WordPress46TagManagementScreen.png\"><img class=\"size-full wp-image-54945\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WordPress46TagManagementScreen.png?resize=1025%2C792\" alt=\"WordPress 4.6 Tag Management Screen\" /></a>WordPress 4.6 Tag Management Screen\n<p>The new flow is more logical and provides consistency between the tag and category management screens, &#8220;From an accessibility point of view, the content structure and organization will be easier to understand and navigate,&#8221; Fercia said.</p>\n<p>WordPress theme and plugin authors who have added custom functionality to these screens are advised to double-check their code against the bleeding edge version of WordPress 4.6. There&#8217;s also an <a href=\"https://core.trac.wordpress.org/ticket/35664\">in-depth ticket</a> where developers and users can see how the team reached a consensus to implement the changes. If you have any questions or concerns please leave a comment on the <a href=\"https://make.wordpress.org/core/2016/05/16/categories-and-tags-screens-changes/\">announcement post</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 May 2016 19:30:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: New Plugin Uses BuddyPress Email API to Send bbPress Forum Emails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/new-plugin-uses-buddypress-email-api-to-send-bbpress-forum-emails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3011:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/09/buddypress-bbpress.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/09/buddypress-bbpress.jpg?resize=1025%2C493\" alt=\"buddypress-bbpress\" class=\"aligncenter size-full wp-image-30982\" /></a></p>\n<p><a href=\"http://wptavern.com/buddypress-2-5-0-released-features-customizable-emails-and-support-for-emoji\" target=\"_blank\">BuddyPress 2.5</a>, released in March, introduced customizable emails via a new <a href=\"http://wptavern.com/buddypress-2-5-will-add-customizable-emails-via-a-new-bp-email-api\" target=\"_blank\">BP Email API</a>. This new feature allows community managers to easily edit BuddyPress-generated emails in the admin and make design changes in the customizer.</p>\n<p>It didn&#8217;t take long for developers to think of bringing this same customizability to bbPress emails. <a href=\"https://profiles.wordpress.org/thebrandonallen/\" target=\"_blank\">Brandon Allen</a> has just released <a href=\"https://wordpress.org/plugins/bp-emails-for-bbp/\" target=\"_blank\">BP Emails for BBP</a>, a plugin that sends forum and topic subscription emails using the new BP Email API.</p>\n<p>Once installed, administrators will find templates for new forum topics and topic replies under the same Emails menu item with the 16 customizable BuddyPress core emails.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/buddypress-bbpress-emails.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/buddypress-bbpress-emails.png?resize=1025%2C305\" alt=\"buddypress-bbpress-emails\" class=\"aligncenter size-full wp-image-54878\" /></a></p>\n<p>Allen noted that the plugin sends emails differently than bbPress, which puts every subscriber email in the BCC field and sends one email. Instead, it sends a separate email to each subscriber, which Allen said may improve deliverability given that some email providers look unfavorably on emails with large BCC fields.</p>\n<p>I tested the plugin and found that it works as advertised for customizing and sending bbPress emails. There are no settings to configure. It simply adds the same functionality that users now expect from BuddyPress core emails with all the same customization options.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/bbpress-subscription-email.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/bbpress-subscription-email.png?resize=1025%2C500\" alt=\"bbpress-subscription-email\" class=\"aligncenter size-full wp-image-54929\" /></a></p>\n<p><a href=\"https://wordpress.org/plugins/bp-emails-for-bbp/\" target=\"_blank\">BP Emails for BBP</a> is available on WordPress.org. It does not work with bbPress alone but requires both bbPress 2.5+ and BuddyPress 2.5+ to be active. With the help of this plugin, a community manager can brand all the email communications generated by the site so that the design and wording is consistent across both plugins.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 May 2016 05:32:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: BuddyPress 2.6 to Introduce New API for Navigation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54803\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/buddypress-2-6-to-introduce-new-api-for-navigation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2401:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/09/buddypress-logo-blue.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/09/buddypress-logo-blue.png?resize=839%2C398\" alt=\"buddypress-logo-blue\" class=\"aligncenter size-full wp-image-30655\" /></a></p>\n<p>In an exceptionally well-documented <a href=\"https://buddypress.trac.wordpress.org/changeset/10745/\" target=\"_blank\">commit message</a>, BuddyPress lead developer Boone Gorges introduced a new API to manage single item navigation, thanks to contributions from core developers Mathieu Viet and Raymond Hoh. Gorges summarized the changes to how BuddyPress will handle navigation in the upcoming 2.6 release:</p>\n<blockquote><p>The new BP_Core_Nav overhauls the way that BuddyPress registers, stores, and renders navigation items. Navigations are now component-specific, eliminating the potential for confusion and conflict between navigation items with similar names in different components, and opening the possibility of generating navs for separate objects of the same type on a single pageload.</p></blockquote>\n<p>The previous navigation system used bp_nav and bp_options_nav, global properties that managed nav and subnav across all of BuddyPress&#8217; components. Developers had a difficult time extending navigation and sometimes ended up stepping on each other&#8217;s toes when adding similar navigation items.</p>\n<p>&#8220;The new system eliminates most of these problems, by removing direct access to the underlying navigation data, while providing a full-fledged API for accessing and modifying that data,&#8221; Gorges said.</p>\n<p>Although the new API ensures backward compatibility with the legacy bp_nav and bp_options_nav, plugin developers whose extensions depend on these methods will want to update their code. With the exception of certain configurations running PHP 5.2.x, most plugins should work the same as before.</p>\n<p>However, Gorges&#8217; <a href=\"https://buddypress.trac.wordpress.org/changeset/10745/\" target=\"_blank\">commit message</a> details a handful of small ways that the new API may break backward compatibility in a few rare instances. BuddyPress plugin developers will want to review these ahead of the upcoming 2.6 release. Beta 1 is just one week away from release on May 25 and the official release is targeted for June 15.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 May 2016 05:06:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Wes Bos Launches Free React.js + Redux Online Course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/wes-bos-launches-free-react-js-redux-online-course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3193:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/react-redux-course.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/react-redux-course.png?resize=1025%2C465\" alt=\"react-redux-course\" class=\"aligncenter size-full wp-image-54916\" /></a></p>\n<p><a href=\"http://wesbos.com/\" target=\"_blank\">Wes Bos</a>, a developer and educator known for his high quality video tutorials, has just launched a free online course for building JavaScript apps with <a href=\"https://facebook.github.io/react/\" target=\"_blank\">React.js</a> and <a href=\"http://redux.js.org/\" target=\"_blank\">Redux</a>. The 2.5 hour <a href=\"https://learnredux.com/\" target=\"_blank\">Learn Redux</a> course includes 20 videos that guide developers through building an example &#8216;Reduxstagram&#8217; app to present the core ideas behind Redux.</p>\n<p>To get the most out of Learn Redux, students should have a decent foundation of React and ES6. Bos recommends those who are not comfortable with React to start with his <a href=\"https://reactforbeginners.com/\" target=\"_blank\">React for Beginners</a> course.</p>\n<p>After you sign up, you&#8217;ll receive an email with a link to the starter files and access to the videos. The example app uses Webpack to bundle ES6 modules into a single JavaScript file, so the course begins with a video on using NPM and Webpack to set up a local development environment. Learn Redux includes:</p>\n<ul>\n<li>Access to all 20 videos</li>\n<li>All starter files</li>\n<li>Webpack Build Templates</li>\n<li>Stepped and finished solutions</li>\n</ul>\n<p>Bos spent more than 100 hours producing this series in partnership with <a href=\"https://getsentry.com/welcome/\" target=\"_blank\">Sentry</a> as a sponsor. Anyone who signs up receives a $50 Sentry credit.</p>\n<p>After Calypso was announced, Bos, who describes himself as &#8220;a huge WordPress fan,&#8221; wrote a <a href=\"http://wesbos.com/wordpress-calypso-react/\" target=\"_blank\">post</a> dispelling rumors that WordPress was ditching PHP and being rewritten in Node.js. He also urged WordPress developers to learn JavaScript.</p>\n<p>&#8220;This is thunder in the distance as to what is to come in WordPress,&#8221; Bos said. &#8220;Much of the theme writing I do is already in JavaScript – I often use WordPress as just an API to get data out of, and then use frameworks like Angular, React, Google Maps or jQuery to display that data. I’m not building an entire website in a JavaScript framework, but much of the interactive view layer of these sites is moving into JavaScript frameworks.&#8221;</p>\n<p>If you want to be ready to dive into the next generation of WordPress site and application development with knowledge of one of the most popular JS frameworks, the free <a href=\"https://learnredux.com/\" target=\"_blank\">Learn Redux</a> course offers all the tools necessary for getting started with React.js, Redux, and React Router.</p>\n<p>&#8220;Our trusty PHP template files aren’t going anywhere anytime soon, but I’ll bet you dollars to donuts you’ll be writing a lot more JavaScript in your WordPress sites in the years to come,&#8221; Bos said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2016 21:50:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"WPTavern: Daniel Bachhuber Discusses WP-CLI, the WP REST API, and the Challenges of Contributing to Open Source on Roots Radio Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"http://wptavern.com/daniel-bachhuber-discusses-wp-cli-the-wp-rest-api-and-the-challenges-of-contributing-to-open-source-on-roots-radio-podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7828:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/daniel-bachhuber.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/daniel-bachhuber.jpg?resize=300%2C300\" alt=\"daniel-bachhuber\" class=\"alignright size-medium wp-image-54898\" /></a><a href=\"https://danielbachhuber.com/\" target=\"_blank\">Daniel Bachhuber</a>, maintainer of the <a href=\"http://wp-cli.org/\" target=\"_blank\">WP-CLI</a> project and a contributing developer to the <a href=\"http://v2.wp-api.org/\" target=\"_blank\">WP REST API</a>, joined Chris Carr and Austin Pray on a recent episode of the <a href=\"https://roots.io/podcast/ep13/\" target=\"_blank\">Roots Radio podcast</a>. Bachhuber discussed his recent experience crowdfunding his work on &#8220;<a href=\"https://wp-cli.org/restful/\" target=\"_blank\">A More RESTful WP-CLI</a>&#8221; as well as the challenges he&#8217;s encountered as a contributor to various open source projects over the years.</p>\n<p>In the first part of the episode, Bachhuber shared how he spent the 283 hours of time that the WordPress community funded to advance the WP-CLI and WP REST API projects. The funding gave him the opportunity to dedicate time split between the two projects. Bachhuber put in approximately 95 hours towards the REST API in January and February but the bulk of the hours went towards making WP-CLI more friendly for developers who work with the REST API.</p>\n<p>&#8220;WordPress developers are going to be putting a lot of time now towards writing REST endpoints that expose their functionality to the world, and it would be really nice if WP-CLI interoperated nicely with that and allowed you to use that functionality at the command line without having to separately write your own WP-CLI commands,&#8221; Bachhuber said.</p>\n<p>He discussed the challenge of scoping out this broad goal and what he learned about crowdfunding during the process.</p>\n<p>&#8220;The RESTful WP-CLI kickstarter project was intentionally ambitious, because I&#8217;m a guy who has big ideas and likes to do big things,&#8221; Bachhuber said. &#8220;There are some things I feel really happy that I&#8217;ve been able to ship and produce so far, and there are other features that, for one reason or another, I haven&#8217;t quite been able to execute  yet and that&#8217;s a bit frustrating.</p>\n<p>&#8220;It&#8217;s a whole different ball game trying to manage the expectations of your Kickstarter backers than it is a single client. I&#8217;ve got 107 clients that I have to make happy,&#8221; he said.</p>\n<p>Nevertheless, Bachhuber said he was able to get the issue backlog for WP-CLI down to less than 60 issues and the dedicated time has allowed him to resolve old issues that have &#8220;languished since the dawn of time.&#8221;</p>\n<p>As part of the rewards offered for contributors to the crowdfunding campaign, Bachhuber offered his time consulting with individuals and organizations, which he found to be easier than traditional physical swag rewards.</p>\n<p>&#8220;I&#8217;m really glad that I chose [consulting] over having to give out physical swag, because it&#8217;s very difficult to procure and ship to everyone, particularly when you have international backers,&#8221; he said. &#8220;Even though I&#8217;ve spent a lot of my time fulfilling the rewards and talking with people and having calls with them and meeting up with them in person, it&#8217;s a much easier effort to manage than sending 100 coffee mugs across the world.&#8221;</p>\n<p>When asked if he&#8217;d do it again, Bachhuber said yes but emphasized that spending this much time on an open source project only works if you keep a healthy balance with other aspects of life.</p>\n<p>&#8220;I think it&#8217;s really important that if you&#8217;re contributing to open source projects on a regular basis or even maintaining them, that you balance your time between that and other things,&#8221; he said. &#8220;It&#8217;s really easy to get burned out on said open source project if you spend 100% of your time on it for a whole month or six months.</p>\n<p>&#8220;I was pretty intentional to say that the money I was raising was going to cover my involvement with the project for six months, a certain number of hours, and that it was going to be a part-time thing. That was a really healthy way to approach it. I think I would have gotten burned out if I had just tried to dive into it, crank it out, and move on to the next thing,&#8221; Bachhuber said.</p>\n<h3>The Emotional Challenges of Working on Open Source Projects</h3>\n<p>During the course of the interview Bachhuber was asked to share his feelings on what he referred to as &#8220;the kerfuffle with the REST API&#8221; that happened in February. The REST API team had written a merge proposal in September 2015 that recommended merging the API in two parts &#8211; the infrastructure in 4.4 and the posts, comments, terms, and users endpoints in 4.5 or 4.6. After partially executing on that proposal, the team held a status chat to discuss the plan moving forward.</p>\n<p>Bachhuber said that the discussion became &#8220;a very emotionally fraught event&#8221; after Matt Mullenweg said the project needed feature parity with the WordPress admin before any of the endpoints could be considered for merge. After putting hundreds of hours into the project alongside a handful of dedicated contributors who were already spread thin, he found this new requirement was a difficult pill to swallow.</p>\n<p>&#8220;For better or for worse, as a maintainer or even a participant of an open source project, you have to have a thick skin and realize that all the time the decisions that are made are not about you &#8211; they are about the project,&#8221; Bachhuber said. &#8220;Even if you are personally offended by the decision, it doesn&#8217;t matter because it isn&#8217;t about you. It&#8217;s really difficult to deal with emotionally.&#8221;</p>\n<p>Bachhuber&#8217;s years of contributing to and maintaing open source projects has taught him a few things about managing stress and conflict that <a href=\"https://2016.europe.wordcamp.org/session/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/\" target=\"_blank\">he plans to share at WordCamp Europe</a> in a talk titled, &#8220;My condolences, You&#8217;re now the maintainer of a popular OS project.&#8221;</p>\n<p>&#8220;I find a lot of joy in maintaining open source projects,&#8221; Bachhuber said. &#8220;I also have to actively work to address the emotional side of the equation to make sure I&#8217;m in a healthy space to continue maintaining the project and the project is not affecting me personally. It&#8217;s taken me years to come to a point where I&#8217;m comfortable with that.&#8221;</p>\n<p>In the case of the WP REST API, Bachhuber has come to a place where he can compartmentalize his emotional reactions and responses to the differing opinions.</p>\n<p>&#8220;I&#8217;ve come to a point now where I care but I don&#8217;t care,&#8221; he said. &#8220;I care in the sense that I&#8217;d still love to see those endpoints go into core and see the fruits of our labors realized. I don&#8217;t care because I&#8217;m not emotionally attached to that happening on any particular time frame. I honestly would rather it happen when it&#8217;s ready to happen over prematurely, and I realize I might not be the best qualified person to make that decision.&#8221;</p>\n<p>In the remainder of the episode, Bachhuber and Carr discuss React, Redux, Karma, Enzyme, and other tools for testing and developing with the REST API. Check out the recording of the episode on <a href=\"https://roots.io/podcast/ep13/\" target=\"_blank\">Roots Radio</a> for more details about Bachhuber&#8217;s work on WP-CLI and his crowdfunding experience.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2016 06:03:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"WPTavern: The WordPress.org Recommended Hosting Page is Revamped, Features Flywheel for the First Time\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54822\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://wptavern.com/the-wordpress-org-recommended-hosting-page-is-revamped-features-flywheel-for-the-first-time\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8235:\"<p>DreamHost, Flywheel, and SiteGround have joined Bluehost on WordPress.org&#8217;s new <a href=\"https://wordpress.org/hosting/\">recommended hosting</a> page. In mid 2015, Matt Mullenweg, co-founder of the open source WordPress project, <a href=\"http://wptavern.com/the-recommended-hosting-page-on-wordpress-org-starts-over-from-scratch\">announced</a> the page would be revamped. To have a chance at being listed webhosting companies needed to fill out a 40-question survey.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/RecommendedHostsPage.png\"><img class=\"size-full wp-image-54844\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/RecommendedHostsPage.png?resize=790%2C642\" alt=\"2016 Recommended Hosts Page\" /></a>2016 Recommended Hosts Page\n<p>This is Flywheel&#8217;s first time on the page. <a href=\"https://getflywheel.com/\">Flywheel</a>, launched in 2013, is a managed WordPress hosting company with an emphasis towards designers and agencies. I asked Dusty Davidson, c<span class=\"team__role\">o-Founder and CEO of Flywheel</span>, what it means to be included on the page. &#8220;We&#8217;re obviously excited to be included, and think it really reflects on the work we&#8217;ve done to create a great experience for WordPress users,&#8221; he<span class=\"team__role\"> said. </span></p>\n<p>The recommended webhosting page on WordPress.org is incredibly lucrative. Based on conversations I&#8217;ve had with employees of hosts listed, it can generate millions of dollars in revenue. I asked Davidson what impact this will have on his company, &#8220;<span class=\"team__role\">I&#8217;m sure it will undoubtedly send a good deal of traffic, but honestly we&#8217;re just humbled and excited to be recognized,&#8221; he said. </span></p>\n<h2>A New Round of Controversy</h2>\n<p>Over the years, companies have come and gone from the recommended hosting page. However, Bluehost in particular has consistently appeared on the list, including the most recent iteration. Bluehost is owned by <a href=\"http://www.endurance.com/\">Endurance International Group</a> who <a href=\"http://www.prweb.com/releases/2014/05/prweb11874425.htm\">invested in Automattic</a> in 2014. Because Mullenweg is the CEO of Automattic and controls who is listed on the page, it&#8217;s easy to see why it regularly generates controversy.</p>\n<p>Kevin Ohashi of ReviewSignal.com, <a href=\"http://reviewsignal.com/blog/2016/05/12/wordpress-org-updates-hosting-recommendations-nobody-knows-selection-criteria/\">criticized the lack of transparency</a> regarding the process for how hosts.</p>\n<blockquote><p>Who is responsible for this revamp? What were the selection criteria? How often will it be updated? Will existing companies be continuously re-evaluated?</p></blockquote>\n<p>These are important questions to ask and there are no publicly documented answers. In a follow up post, <a href=\"http://reviewsignal.com/blog/2016/05/13/wordpress-org-hosting-recommendations-listing-criteria/\">Ohashi investigated</a> what criteria needs to be met for being listed on the page. The post contains a number of screenshots of his private conversation with <a href=\"https://profiles.wordpress.org/macmanx\">James Huff</a>, who has volunteered for the WordPress project for 12 years and has worked at Automattic for five years.</p>\n<p>Huff was directly related to the project and influenced who was chosen thanks to his involvement on the WordPress Support Team. Within the conversation, he shares details of the process and mentions that no money exchanged hands. Early in the conversation, Ohashi tells Huff that he wants to learn and publish how the process works. However, Huff had no idea that everything he said would be made public.</p>\n<p>&#8220;I was invited to what sounded like a friendly chat over direct message from a concerned community member, after he was referred to me by a friend,&#8221; Huff said. &#8220;At no point was it clarified or even implied that anything discussed would be made public.&#8221;</p>\n<p><del>Conversations held in a private matter should remain private unless given permission to publish them, something I discovered the hard way.</del> Unfortunately, the post comes across as a public interrogation of Huff. I asked Huff, who was shaken by the experience, how it has affected him moving forward as it relates to the WordPress project.</p>\n<p>&#8220;I&#8217;d be lying if I said my feelings weren&#8217;t at least shaken by the experience, especially considering how polite he was to my friend and how hostile he was towards me apparently just because I work for Automattic, but this isn&#8217;t the first time that has happened to me and I don&#8217;t expect it to be the last,&#8221; he said.</p>\n<p>&#8220;There&#8217;s an usually prevalent negative bias against Automatticians who contribute to WordPress.&#8221;</p>\n<h2>Mullenweg Provides Clarification</h2>\n<p>Mullenweg <a href=\"http://reviewsignal.com/blog/2016/05/13/wordpress-org-hosting-recommendations-listing-criteria/#comment-1011\">commented on the post</a> where he not only sticks up for Huff, but answers some of the controversial questions raised by Ohashi. Mullenweg explains how the applicants were chosen, how the criteria is weighted, who makes the final decisions, and how much money is involved. Here is his comment in full.</p>\n<blockquote><p>&#8216;I would like to see some transparency in the process&#8217;</p>\n<p>As stated on the page, the listing is completely arbitrary. The process was: There was a survey, four applicants were chosen, and the page was updated. That might repeat later in the year, or the process might change.</p>\n<p>&#8216;how criteria are weighted&#8217;</p>\n<p>There is no criteria or weighting. It ultimately is one person’s opinion. Information that is important is reflected in the questions asked in the survey, but that is not everything that is taken into account. (I have looked at this site in the past, for example.)</p>\n<p>&#8216;who is making the decisions&#8217;</p>\n<p>I am. James helped in sorting through the many submissions that came in, doing additional research, and digging on finalists, but ultimately the decision was mine. You can and should blame me fully for any issues you have with it. I appreciate James’ help in this go-round, but he will not be involved at all with any future updates. (So, please leave him alone.)</p>\n<p>&#8216;how much money is involved&#8217;</p>\n<p>There was no money involved. Obviously being listed on the page is hugely valuable and impacts the listed (or unlisted) businesses a great deal. This is why I take full responsibility for the listing, now and in the future — I have been fortunate to be extraordinarily successful and no financial or business consideration any of the applicants could offer matters to me. A host could offer $100,000,000 to be listed on the page for 1 day, and I would say no.</p></blockquote>\n<p>It&#8217;s unfortunate that the information in Mullenweg&#8217;s comment is not published in an official post announcing the changes to the recommended hosting page. If an official post was published that included the same information in his comment, it&#8217;s possible it would have eliminated most of the confusion, uncertainty, and doubt surrounding it.</p>\n<h2>Should WordPress.org Have a Recommended Hosting Page?</h2>\n<p>Due to the investments EIG has made in Automattic, Mullenweg&#8217;s role at the company, and him making the final decisions, there will always be a potential conflict of interest despite taking full responsibility of the page and the processes associated with it.</p>\n<p>Should WordPress.org have a recommended hosting page? What if the page was replaced with information people could use to make informed decisions on choosing a host? It would eliminate potential conflicts of interest and if there was a host Mullenweg felt strongly about, he could label it as a partner of the project. This would make it clear that any financial connection with the company is a business relationship.</p>\n<p>Are you hosting with any of the companies listed on the recommended hosting page? If so, tell us about your experience in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 May 2016 16:39:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: WordPress Accessibility Team Seeks Testers Using Speech Recognition Technology\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54829\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"http://wptavern.com/wordpress-accessibility-team-seeks-testers-using-speech-recognition-technology\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2791:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/glasses.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/glasses.jpg?resize=1024%2C562\" alt=\"photo credit: Let\'s Read - (license)\" class=\"size-full wp-image-54851\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/42788859@N00/320216939\">Let&#8217;s Read</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/\">(license)</a>\n<p>The World Health Organization estimates that <a href=\"http://www.who.int/mediacentre/factsheets/fs282/en/\" target=\"_blank\">285 million people</a> worldwide are living with some form of visual impairment and 39 million of those are estimated to be blind. Many people with low vision depend on speech recognition technology to navigate the web and communicate their thoughts. This type of software also assists people who have carpal tunnel, RSI (Repetitive Stress Injuries) and/or limited mobility in their hands and arms.</p>\n<p>Rian Rietveld and the Accessibility team are working to improve the experience of using WordPress with speech recognition software, such as <a href=\"http://www.nuance.com/dragon/index.htm\" target=\"_blank\">Dragon Naturally Speaking</a> (widely considered as one of the best for desktop use.) In particular, <a href=\"https://core.trac.wordpress.org/ticket/23562\" target=\"_blank\">the task of adding media to a post has a number of obstacles</a> that make it nearly impossible for those using speech recognition software.</p>\n<p>Rietveld <a href=\"https://make.wordpress.org/accessibility/2016/05/13/20th-wordpress-accessibility-test-add-media-with-speech-recognition-software/\" target=\"_blank\">posted three tests</a> to the Accessibility team&#8217;s blog today, inviting those who use <a href=\"http://www.nuance.com/dragon/index.htm\" target=\"_blank\">Dragon Naturally Speaking</a> or other assistive technology to help the contributors determine the roadblocks that need to be removed for adding media. These tests include actions like adding media, editing attachment details, and creating a gallery.</p>\n<p>If you use WordPress with assistive technology for speech recognition, completing these tests and offering your feedback is one way to get involved as a contributor. You don&#8217;t necessarily have to use Dragon Naturally Speaking, as there are many newer alternatives such as Windows Speech Recognition (Cortana) and Chrome&#8217;s speech recognition powered by Google Speech to Text. Testers can report their experiences, along with the assistive technology/browser/OS, in the comments on Rietveld&#8217;s <a href=\"https://make.wordpress.org/accessibility/2016/05/13/20th-wordpress-accessibility-test-add-media-with-speech-recognition-software/\" target=\"_blank\">post</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 22:40:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Happytables Pivots to Provide Restaurant Analytics and Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=41046\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/happytables-pivots-to-provide-restaurant-analytics-and-insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5302:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/happy-tables.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/happy-tables.jpg?resize=1000%2C608\" alt=\"happy-tables\" class=\"aligncenter size-full wp-image-54835\" /></a></p>\n<p><a href=\"http://www.happytables.com/\" target=\"_blank\">Happytables</a> is changing from being a platform that hosts restaurant websites to one that provides analytics and insights by tapping into apps that restaurants are already using to promote their businesses. The company uses WordPress as a command center for the application that communicates with various restaurant-tech APIs to deliver information to the dashboard in realtime.</p>\n<p>&#8220;We started with the website builder a while back,&#8221; Founder and CEO Noel Tock said. &#8220;It’s been a great ride, but we realized two things: 1) Website builders have become a race to the bottom with regards to revenue as well as extremely competitive, and 2) From our many conversations with restaurants, their challenges have become much larger; consolidating data and insights from all the products they now use.&#8221;</p>\n<p>One of the Happytables beta restaurants in London uses 14 different applications to manage its sales, operations, and marketing, and Tock says this trend is only growing.</p>\n<p>&#8220;The centre of gravity is shifting from the Point of Sale to a very fragmented collection of siloed products (reservations, online ordering, staff scheduling/wages, loyalty, waitlist, social, etc.),&#8221; Tock said. &#8220;Becoming that 30,000 foot view whilst generating actionable insights across the portfolio of applications is the challenge we’ve taken on with the new Happytables.&#8221;</p>\n<p>The first installation of the new Happytables was set up for <a href=\"http://whyteandbrown.com/\" target=\"_blank\">Whyte &amp; Brown</a> in London where the team is focusing their beta testing. The application currently aggregates data from POS (Point of Sale) and Social, but Tock says this will rapidly evolve to providing various insights from POS and Labor, such as revenue forecasting, employee performance, and breakfast/lunch/dinner performance.</p>\n<p>&#8220;It’s been very exciting working towards actionable insights, whereby we can tell a waiter that he/she was underselling a certain product or category compared to their colleagues, or that a particular employee performs a lot better on lunch then on dinner,&#8221; Tock said.</p>\n<p>Below you can see an example of Happytables&#8217; latest kitchen dashboard, using the team view as opposed to the individual employee recommendations/suggestions view.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/Happytables_kitchen_dashboard.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/Happytables_kitchen_dashboard.png?resize=1025%2C731\" alt=\"Happytables_kitchen_dashboard\" class=\"aligncenter size-full wp-image-54833\" /></a></p>\n<p>The new Happytables uses WordPress as a backend and the WP REST API and ReactJS on the frontend.  Although the development team still uses WordPress as one of its core technologies, the infrastructure is a bit more complicated.</p>\n<p>&#8220;It’s not pure WordPress for the data storage,&#8221; CTO Aaron Jorbin said. &#8220;In fact, very little of it is actually stored inside WordPress. It is used to store some information about the restaurant and manage requests to third parties where we fetch the data and then store it in DynamoDB.&#8221;</p>\n<p>The screenshots in this post show the WordPress theme in full screen mode, but Jorbin said the restaurant staff never interact with wp-admin. Restaurant operators use the app to view all the realtime information coming in so that they can make better decisions about how they run their businesses.</p>\n<p>Happytables is still hosting its customers from its first iteration as a website builder, but Tock said most are not good candidates for the beta.</p>\n<p>&#8220;The infrastructure is quite different now as we’re capturing different types of data (previously web content, now largely transactional data),&#8221; he said. &#8220;Our customers on the website builder platform came from all walks of life, so there’s not many who fit the ideal beta candidate (using Micros/Aloha as POS, based in London, run a multiunit restaurant, etc.).</p>\n<p>&#8220;We&#8217;re just looking to see how we can fit this into the larger Happytables model downstream,&#8221; Tock said. &#8220;If we’re going to implement so many API’s, there’s also value in tying those back to the website.&#8221;</p>\n<p>Not many aspects of the new infrastructure have been open sourced yet, as the team has been moving fast. Tock said they hope to make some of their code public further down the road after it&#8217;s been tested.</p>\n<p>&#8220;Once we’re past testing/beta, I’m sure a number of features will become more mature tools and move into their own public repo if they are of that sort of benefit,&#8221; he said. The new infrastructure is one of the many exciting ways that the WP REST API is being used to bring a host of information into WordPress from various third party applications and tie it all together in a useful way.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 19:45:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Mom on Tinder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2016/05/mom-on-tinder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:227:\"<p>If you&#8217;re looking for a fun Friday read, <a href=\"http://www.gq.com/story/my-mom-ran-my-tinder\">check out this story of a young GQ writer who gave control of his Tinder account to his Mom</a>. It&#8217;s adorkable.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 16:35:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: GitLab Courts Disgruntled GitHub Customers with Response to Recent Pricing Hike\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/gitlab-courts-disgruntled-github-customers-with-response-to-recent-pricing-hike\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5016:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/gitlab.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/gitlab.png?resize=1025%2C371\" alt=\"gitlab\" class=\"aligncenter size-full wp-image-50741\" /></a></p>\n<p>Yesterday GitHub <a href=\"http://wptavern.com/github-introduces-unlimited-private-repositories-hikes-prices-for-organizations\" target=\"_blank\">announced</a> pricing changes that give all paid plans unlimited repositories and change plans to a pricing-per-user model. Individual developers are the most likely customers to benefit from the changes, but many organizations will see an exponential increase in pricing.</p>\n<p>GitLab, a competitor in the Git repository hosting space, immediately addressed disgruntled GitHub customers with a <a href=\"https://about.gitlab.com/2016/05/11/git-repository-pricing/\" target=\"_blank\">pricing comparison</a> on the company&#8217;s blog. Co-founder and CEO <a href=\"https://twitter.com/sytses\" target=\"_blank\">Sid Sijbrandij</a> noted that the three main players in this space, GitHub, Bitbucket, and GitLab, all offer unlimited private repositories but that it doesn&#8217;t cost companies more to host additional repositories for a given user.</p>\n<p>Sijbrandij attributes the change to the increase in the <a href=\"https://www.sequoiacap.com/article/build-us-microservices/\" target=\"_blank\">microservices model</a>, a development approach that breaks software down into smaller, related pieces that communicate with one another via APIs.</p>\n<p>&#8220;As more and more developers, teams, and organizations seek out the advantages of microservices, they’ll need more repositories to support this new code structure,&#8221; Sijbrandij said. &#8220;Basically, the more microservices you have the more repositories you’ll need. That is why it is not surprising that GitHub has announced free private repositories.&#8221;</p>\n<p>Sijbrandij referenced several examples where GitHub&#8217;s pricing changes hit open source organizations hard, including <a href=\"https://github.com/edx/\" target=\"_blank\">Open edX</a>, a non-profit with a large number of contributors, which <a href=\"https://news.ycombinator.com/item?id=11674530\" target=\"_blank\">posted</a> the following on Hacker News:</p>\n<blockquote><p>I work for a non-profit open source organization that <a href=\"https://github.com/edx/\" target=\"_blank\">collaborates on github</a>. We have lots of people who aren&#8217;t employees, but have signed a contributor agreement with our organization and contribute changes to our software. Our bill will go up from $200/month to over $2000/month with this new pricing. We can afford it (it&#8217;s still a small fraction of our AWS bill) but it will force us to look at other alternatives. Github&#8217;s code review tools are already pretty mediocre compared to other tools like gerrit, and we&#8217;ve long since moved off of GitHub issue tracking due to lack of features compared to JIRA.</p></blockquote>\n<p>Sijbrandij emphasized that the team at GitLab believes “everyone can contribute,” a mission which drives GitLab.com&#8217;s pricing structure to offer unlimited private repositories, unlimited contributors, and unlimited CI runners for free. The on-premises solution, which includes enterprise features and support, is what keeps the lights on at the company. GitLab.com, the free, hosted version, runs the same enterprise edition software but is, by Sijbrandij&#8217;s own admission, still <a href=\"https://gitlab.com/gitlab-com/operations/issues/42\" target=\"_blank\">struggling with sluggish performance</a>.</p>\n<p>Earlier this year when open source project maintainers <a href=\"http://wptavern.com/open-source-project-maintainers-confront-github-with-open-letter-on-issue-management\" target=\"_blank\">confronted GitHub with an open letter on issue management</a>, GitLab differentiated itself by <a href=\"http://wptavern.com/gitlab-courts-open-source-project-maintainers-with-response-to-dear-github-letter\" target=\"_blank\">responding</a> to the situation with a new initiative focused on “making GitLab the best place for big open source projects.”</p>\n<p>Nearly a month later, <a href=\"http://wptavern.com/github-responds-to-letter-from-open-source-project-maintainers\" target=\"_blank\">GitHub finally responded</a> with an apology to open source project maintainers and a promise to address their concerns with a steady string of changes.</p>\n<p>GitHub has not given any indication of reversing its recent decision to change its pricing structure. However, with competitors like GitLab putting on the heat, GitHub may be forced to make some changes to its paid plans. At the very least, it could inspire the company to address concerns about organizations having to pay for inactive users and perhaps spur GitHub to offer customers the ability to distinguish between collaborators on open source projects and users who simply need access to private repositories.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 02:33:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"WPTavern: How Authors With Plugins in the Official Directory Can Use Tags to Get a Moderator’s Attention\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54441\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"http://wptavern.com/how-authors-with-plugins-in-the-official-directory-can-use-tags-to-get-a-moderators-attention\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2627:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/05/WordPressAdviceForNewUsers.png\"><img class=\"size-full wp-image-44085\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/05/WordPressAdviceForNewUsers.png?resize=612%2C237\" alt=\"WordPress Advice For New Users\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/99329675@N02/11064947983\">What You Need To Know About Food Poisoning</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>It&#8217;s almost inevitable that as a WordPress plugin gains popularity, it will receive a bad review. How plugin authors handle and respond to bad reviews is crucial, especially in a public forum. Mika Epstein, who helps review plugins before they&#8217;re added to the directory and is a dedicated support forum volunteer, <a href=\"https://make.wordpress.org/plugins/2016/05/03/handling-bad-reviews/\">gives advice </a>on how to handle and respond to bad reviews.</p>\n<p>Bad reviews are classified as those written as spam, trolling, emotional blackmail for support, and those that should have been a support post. Since the plugin review system is powered by bbPress, plugin authors can add tags to reviews in order to draw a moderator&#8217;s attention. The tags include:</p>\n<ul>\n<li><strong>Modlook</strong> &#8211; This tag notifies moderators that a particular thread needs their attention. If you think a review is spam, don&#8217;t respond to it. Instead, add the Modlook and Spam tags and let a moderator decide if the review should be deleted.</li>\n<li><strong>Sockpuppet</strong> &#8211; If you suspect a review is part of a spamming campaign where a group of people are marking a plugin as one or five stars, apply the sockpuppet and modlook tags to the review.</li>\n<li><strong>Wrongplugin</strong> &#8211; Add the wrongplugin tag to the review if you believe it&#8217;s for a different plugin. The team can move the review to the appropriate place.</li>\n<li><strong>Pluginmod</strong> &#8211; Add this tag to a review if you need an administrator&#8217;s attention. This usually results in the team performing a full review of your plugin. If it&#8217;s determined that it breaks any of <a href=\"https://wordpress.org/plugins/about/guidelines/\">the guidelines</a>, it will be removed until they&#8217;re fixed.</li>\n</ul>\n<p>Developers who host plugins in the official directory should make note of these tags and use them when necessary. The tag system is generally unknown to the public but it&#8217;s a great way for moderators to keep on top of the forums and reviews.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 May 2016 01:06:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: WPWeekly Episode 234 – All Things WordCamp with Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=54807&preview_id=54807\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/wpweekly-episode-234-all-things-wordcamp-with-andrea-middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2896:\"<p>In this episode of WordPress Weekly, Marcus Couch and I are joined by <a href=\"https://thethingwiththestuff.wordpress.com/\">Andrea Middleton</a>, who works at Automattic as a Community Organizer for the WordPress open source project. We discuss a number of topics including, updates to the WordCamp Central website, the <a href=\"https://make.wordpress.org/community/2016/03/02/transitioning-to-wordpress-community-support/\">for-profit subsidiary</a>, and the experimental <a href=\"http://wptavern.com/wordpress-to-launch-experimental-wordcamp-incubator-program\">WordCamp incubator program</a>.</p>\n<p>At the conclusion of our interview with Middleton, Mendel Kurland, GoDaddy&#8217;s Evangelist, joined us to describe his experiences attending DrupalCons. DrupalCons are events similar to WordCamps but on a larger scale. He tells us what the similarities and differences are and the unique things they do that he&#8217;d like to see WordCamps adopt. We close out the show with Marcus&#8217; plugin picks of the week.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-5-2-patches-two-security-vulnerabilities\">WordPress 4.5.2 Patches Two Security Vulnerabilities</a><br />\n<a href=\"http://wptavern.com/automattic-is-protecting-its-woo-woothemes-and-woocommerce-trademarks\">Automattic is Protecting its Woo, WooThemes, and WooCommerce Trademarks</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/disable-core-update-email/\">Disable WordPress Core Update Email</a> allows used to disable the default notification email sent by WordPress after an automatic core update is applied.</p>\n<p><a href=\"https://wordpress.org/plugins/downgrade/\">Downgrade </a>enables users to easily downgrade WordPress to an earlier version. It&#8217;s a handy diagnostics tool that helps determine if a new WordPress release is the cause of errors.</p>\n<p><a href=\"https://wordpress.org/plugins/woo-customer-insight\">Woo Customer Insight </a>provides greater insight into what visitors are doing on your sites. It allows you to see the pages your customers are visiting, where they&#8217;re clicking, the time spent on the different pages, and more.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, May 18th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #234:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 May 2016 23:23:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matt: .Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46554\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://ma.tt/2016/05/blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:858:\"<p>It&#8217;s now public that Automattic is the company behind Knock Knock Whois There LLC, the registry for the new .blog TLD. (And a great pun.) We wanted to stay stealth while in the bidding process and afterward in order not to draw too much attention, but nonetheless the cost of the .blog auction got up there (people are <a href=\"http://www.theregister.co.uk/2015/02/13/who_just_bought_dotblog_for_30m/\">estimating around $20M</a>). I&#8217;m excited we won and think that it will be both an amazing business going forward and give lots of folks an opportunity to have a fantastic domain name in a new namespace and with an easy-to-say TLD. <a href=\"https://dotblog.wordpress.com/\">You can sign up to be first in line to reserve a domain here</a>. If you have a trademark you can get in August, and then October for the &#8220;land rush.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 May 2016 19:23:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Automattic to Oversee the Sale and Registration of Top-Level .Blog Domains\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54788\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/automattic-to-oversee-the-sale-and-registration-of-top-level-blog-domains\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2974:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?resize=960%2C521\" alt=\"photo credit: Luis Llerena\" class=\"size-full wp-image-54799\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3ZHG0XOIT6\">Luis Llerena</a>\n<p>Automattic <a href=\"https://en.blog.wordpress.com/2016/05/12/coming-soon-new-blog-domains-for-websites/\" target=\"_blank\">announced</a> today that it will begin offering top-level .blog domain registration starting in August 2016. The .blog domain extension will be available to both WordPress and non-WordPress sites.</p>\n<p>According to <a href=\"https://twitter.com/markarms\" target=\"_blank\">Mark Armstrong</a>, an Automattic subsidiary is exclusively managing the registration of .blog domains and will be offering it for purchase through WordPress.com and other domain registrars.</p>\n<p>&#8220;Automattic subsidiary Knock Knock Whois There LLC, in partnership with the domain company Primer Nivel, won the rights to the .blog domain in 2015 through an auction process overseen by the Internet Corporation for Assigned Names and Numbers (ICANN), the non profit organization that oversees namespaces of the internet,&#8221; Armstrong said.</p>\n<p>In an <a href=\"https://ma.tt/2016/05/blog/\" target=\"_blank\">announcement</a> on his blog, Automattic CEO Matt Mullenweg said they used the Knock Knock Whois There LLC company name to &#8220;stay stealth while in the bidding process,&#8221; which closed around $19 million.</p>\n<p>Although WordPress.com is currently providing the registration information site at <a href=\"https://dotblog.wordpress.com/\" target=\"_blank\">dotblog.wordpress.com</a>, Armstrong said that the company is using <a href=\"http://www.nominet.uk/\" target=\"_blank\">Nominet</a> (the backend registry provider for .UK) to provide the technical infrastructure for managing the domain extension.</p>\n<p>Registration for .blog domains will be offered in a phased approach during the second half of 2016, according to the following estimated timeframe:</p>\n<ul>\n<li><strong>Sunrise (August):</strong> Trademark owners will be able to register .blog domains associated with their brands</li>\n<li><strong>Landrush (October):</strong> Before .blog becomes available to the public, domains may be registered during the landrush period on an application basis.</li>\n<li><strong>General Availability (November):</strong> Automattic plans to begin offering .blog domains to the general public before the end of the year.</li>\n</ul>\n<p>With the exclusive rights to manage the sale of millions of .blog domains, Automattic has the opportunity to promote WordPress.com as a potential host for new registrants. The company hasn&#8217;t finalized the price but Armstrong said it will be &#8220;in the standard range for new top-level domains with some premium pricing for higher-value names.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 May 2016 18:19:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Critical Vulnerabilities Found in PhpStorm, Immediate Update Advised\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54770\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/critical-vulnerabilities-found-in-phpstorm-immediate-update-advised\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2128:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/phpstorm-wp-feature.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/phpstorm-wp-feature.jpg?resize=1025%2C471\" alt=\"phpstorm-wp-feature\" class=\"aligncenter size-full wp-image-30739\" /></a></p>\n<p>JetBrains <a href=\"http://blog.jetbrains.com/blog/2016/05/11/security-update-for-intellij-based-ides-v2016-1-and-older-versions/\" target=\"_blank\">announced</a> today that it has released a security update for PhpStorm and all of its other IntelliJ-based IDEs due to a set of critical vulnerabilities:</p>\n<blockquote><p>The cross-site request forgery (CSRF) flaw in the IDE’s built-in webserver allowed an attacker to access local file system from a malicious web page without user consent.</p>\n<p>Over-permissive CORS settings allowed attackers to use a malicious website in order to access various internal API endpoints, gain access to data saved by the IDE, and gather various meta-information like IDE version or open a project.</p></blockquote>\n<p>PhpStorm is by far <a href=\"http://www.sitepoint.com/best-php-ide-2014-survey-results/\" target=\"_blank\">the most favored IDE for PHP developers</a>. It&#8217;s also widely used among WordPress developers, especially since <a href=\"http://wptavern.com/phpstorm-8-released-with-full-wordpress-support\" target=\"_blank\">version 8 added official support for WordPress</a>.</p>\n<p>The update issued today patches the critical vulnerabilities inside the underlying IntelliJ platform that powers nearly a dozen popular IDEs. Installing the update is as easy as selecting &#8216;Check for Updates&#8217; inside the IDE. Alternatively, customers can download the most recent version from JetBrains.com and the <a href=\"http://blog.jetbrains.com/blog/2016/05/11/security-update-for-intellij-based-ides-v2016-1-and-older-versions/\" target=\"_blank\">security announcement</a> includes links to download older versions.</p>\n<p>Although the JetBrains security team is not aware of these vulnerabilities having been exploited, immediate update is recommended.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 22:26:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: GitHub Introduces Unlimited Private Repositories, Hikes Prices for Organizations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54746\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/github-introduces-unlimited-private-repositories-hikes-prices-for-organizations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7590:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/github-octocat.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/github-octocat.jpg?resize=857%2C400\" alt=\"github-octocat\" class=\"aligncenter size-full wp-image-42456\" /></a></p>\n<p>GitHub has been inundated with negative feedback after <a href=\"https://github.com/blog/2164-introducing-unlimited-private-repositories\" target=\"_blank\">announcing a major change to its pricing</a> today. All paid plans now include unlimited private repositories, but there&#8217;s a catch. The new pricing structure requires GitHub.com organizations to purchase a seat for each user. At $9 per user/month, collaborating on private repositories is now far more costly than the legacy plans which started at $25/month for 10 repositories and unlimited members.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/github-pricing.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/github-pricing.png?resize=1025%2C392\" alt=\"github-pricing\" class=\"aligncenter size-full wp-image-54756\" /></a></p>\n<p>The change is good news for individual developers with paid accounts, as they are no longer charged on a per-repository basis. However, many owners of organizations are finding the new pricing to be untenable and are actively considering alternatives. For comparison, Bitbucket offers unlimited private repositories and <a href=\"https://bitbucket.org/product/pricing\" target=\"_blank\">charges $1/user/month</a>. Unlimited users caps out at $200/month.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/Krogsgard\">@Krogsgard</a> EDD org alone will go from $25 per month to $592 per month <a href=\"https://twitter.com/github\">@github</a></p>\n<p>&mdash; Pippinsplugins (@pippinsplugins) <a href=\"https://twitter.com/pippinsplugins/status/730396802638176257\">May 11, 2016</a></p></blockquote>\n<p></p>\n<p>While unlimited private repositories is an exciting benefit that enables developers to make their code more modular, it isn&#8217;t a benefit that every organization needs.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/github\">@github</a> Terrible news. I work on an open-source organization &gt;100 devs. We have 2 private repos for internal projects. $900+ vs $25 really!?</p>\n<p>&mdash; João Ventura (@jcnventura) <a href=\"https://twitter.com/jcnventura/status/730319187667759104\">May 11, 2016</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/williamsba\">@williamsba</a> ours jumped to $1,204 :-( <a href=\"https://twitter.com/github\">@github</a></p>\n<p>&mdash; Tom Willmot (@tomwillmot) <a href=\"https://twitter.com/tomwillmot/status/730391291691995136\">May 11, 2016</a></p></blockquote>\n<p></p>\n<p><a href=\"https://easydigitaldownloads.com/\" target=\"_blank\">Easy Digital Downloads</a> creator Pippin Williamson <a href=\"http://www.twitlonger.com/show/n_1solvjd\" target=\"_blank\">explained</a> why he is frustrated with what amounts to a 2,276% increase in costs for his organization:</p>\n<blockquote><p>I actually have no problems with the pricing for new organizations. It&#8217;s their space and they provide a huge number of valuable tools. It is absolutely worth it.</p>\n<p>The problem I have is the drastic increase for existing customers. It&#8217;s largely the principal of increasing a customer&#8217;s cost by 2,276% without giving them any additional value.</p>\n<p>The value that Github provides me and my team does not change at all with the new pricing, only what I pay per month.</p></blockquote>\n<p>Samuel &#8220;Otto&#8221; Wood <a href=\"http://www.twitlonger.com/show/n_1solviv\" target=\"_blank\">contends</a> that GitHub&#8217;s $9/user/month is a reasonable price to pay for having all the functionality of GitHub hosted for an organization but that the alternative of building your own is far more economical.</p>\n<blockquote><p>A &#8220;private&#8221; repo is, you know, private. On your own server. Git is, after all, decentralized. You could plop a normal git repo on any private VPS you like in a matter of under an hour. If you&#8217;re collaborating with a small group of like 5 people, then coordination is not really a big deal that I&#8217;d pay $45 a month to use GitHub for it. You can use any tooling you like, make any website you like. You could probably reproduce the important parts of GitHub that you need for your private setup using WordPress in like a day or two. </p>\n<p>It just seems to me that any advantages of using GitHub at all seem largely nullified by using private repos. Yes, collaboration and using the same toolset you are used to, I get that. But here you&#8217;re falling prey to vendor lock-in once again. You&#8217;re used to it, you like it, you&#8217;re afraid of change, pay up. Simple. </p>\n<p>The advantage of open source software is the freedom to say &#8220;up yours&#8221; and build your own version instead. Git is open source. Think about it. A $15 a month VPS could easily fit your needs for both privacy and collaboration.</p></blockquote>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/github\">@github</a> found a way to be more expensive than the datacenter that runs my app. Seriously, what\'s happening at <a href=\"https://twitter.com/github\">@github</a> ???</p>\n<p>&mdash; Adilson Carvalho (@lcadilson) <a href=\"https://twitter.com/lcadilson/status/730405070819471361\">May 11, 2016</a></p></blockquote>\n<p></p>\n<p>GitHub has established itself as the de facto code collaboration site by offering free hosting for public, open source repositories. However, the emphasis on &#8220;social coding&#8221; no longer extends to private repositories as organization owners will have little incentive to add more collaborators under the new pricing structure. It discourages organizations from adding users to be bug reporters or third-party collaborators. Teams and agencies hit hardest by the changes are now examining competitors like Bitbucket and self-hosted GitLab.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Today is for <a href=\"https://twitter.com/gitlab\">@gitlab</a> what 2007 was for <a href=\"https://twitter.com/WordPress\">@WordPress</a>. If code is poetry, Gitlab is your library. Own your code like you own your content. ❤️</p>\n<p>&mdash; John James Jacoby (@JJJ) <a href=\"https://twitter.com/JJJ/status/730417868047790080\">May 11, 2016</a></p></blockquote>\n<p></p>\n<p>Organization owners will not be forced onto the new pricing plans immediately and GitHub promises to give a year&#8217;s notice before mandating a switch to the new plans:</p>\n<blockquote><p>We want everyone to have a plan with unlimited private repositories, but don’t worry—you are welcome to stay on your current plan while you evaluate the new cost structure and understand how to best manage your organization members and their private repository access. And while we&#8217;re currently not enforcing a timeline to move, rest assured that you&#8217;ll have at least 12 months notice before any mandated change to your plan.</p></blockquote>\n<p>While many individual developers will see lower monthly prices and even prorated credits on their accounts, the exponential cost increase for GitHub&#8217;s largest customers may cause a mass exodus to the company&#8217;s more affordable competitors. Are you moving your organization off of GitHub? Let us know in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 19:27:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Affinity: A Free WordPress Wedding Theme from Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54688\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/affinity-a-free-wordpress-wedding-theme-from-automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3832:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity.png?resize=800%2C471\" alt=\"affinity\" class=\"aligncenter size-full wp-image-54691\" /></a></p>\n<p>Affinity is the latest addition to WordPress.com&#8217;s small collection of <a href=\"https://wordpress.com/themes/search/wedding/\" target=\"_blank\">themes created specifically for weddings</a>. This highly customizable, elegant theme was designed by <a href=\"http://carolinemoore.net/\" target=\"_blank\">Caroline Moore</a> with weddings and family announcements in mind.</p>\n<p>Affinity is a one-page theme with support for five different panels. Each panel&#8217;s content can be assigned in the customizer under Theme Options by selecting a page from a drop-down.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/panel.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/panel.png?resize=660%2C231\" alt=\"panel\" class=\"aligncenter size-full wp-image-54717\" /></a></p>\n<p>With the customizable panel approach users are not locked into providing content for sections they don&#8217;t need. Single posts and pages support full screen featured images that, if used as a panel, become the background of that section. Affinity offers the option to set the header image opacity to create better contrast with header text. Users can also enable or disable scrolling on the header and front-page featured images.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity-home-page.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity-home-page.png?resize=200%2C474\" alt=\"affinity-home-page\" class=\"alignright size-full wp-image-54693\" /></a></p>\n<p>Affinity includes support for a sidebar widget area and three optional widget areas in the footer. If widgets are added to the sidebar, the one-column layout becomes a two-column layout. It also has a fullwidth page template for removing the sidebar on select pages.</p>\n<p>The different panels give users ample space for adding photos, links to registries, personal stories, info about the bridal party, and anything else related to the event. Affinity includes a Guestbook page template with a special format for displaying visitors&#8217; comments. Turning the Guestbook on is as easy as setting the page template and making sure that comments are enabled.</p>\n<p>Another unique feature of the theme is its post intro area that displays beneath the headline before the first paragraph. It pulls content from the excerpt field and post authors can use it to capture readers&#8217; attention with a quick summary or highlight.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity-post-intro.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/affinity-post-intro.png?resize=660%2C328\" alt=\"affinity-post-intro\" class=\"aligncenter size-full wp-image-54729\" /></a></p>\n<p>Check out the <a href=\"https://affinitydemo.wordpress.com/\" target=\"_blank\">live demo</a> to see the theme in action. It shows an example of panels that display quotes, an RSVP form, event details, and an engagement story.</p>\n<p>Since no wedding or family announcement is the same, Affinity&#8217;s multi-panel approach offers flexibility for many different types of uses. If you&#8217;re creating a wedding website and are not finding enough customization options with a hosted service, this theme makes it quick and easy to set it up with WordPress. It&#8217;s not yet available on WordPress.org, but you can download a copy for your self-hosted site for free from the sidebar of its <a href=\"https://wordpress.com/themes/affinity\" target=\"_blank\">homepage on WordPress.com</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 06:52:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: Help WPCampus Gather Data on How Schools and Campuses Use WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/help-wpcampus-gather-data-on-how-schools-and-campuses-use-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1247:\"<p>The organizers of <a href=\"https://2016.wpcampus.org/\">WPCampus</a> are <a href=\"https://www.surveymonkey.com/r/wpcampus05-2016\">seeking feedback</a> via a survey on how schools and campuses utilize WordPress in their environments. The survey consists of five sections:</p>\n<ul>\n<li>How Do You Use WordPress on Campus</li>\n<li>Site Demographics, Traffic, and Data</li>\n<li>Plugins, Themes, and Features</li>\n<li>Security, Performance, and Hosting</li>\n<li>Your Team Structure &amp; Workflows</li>\n</ul>\n<p>There are a couple of perks for those who fill out the survey. Respondents will receive an anonymized version of the complete data set. Those who complete four or more sections will be entered into a drawing to win a free ticket to the conference and will receive a $5 Starbucks or Amazon Gift card.</p>\n<p>Answer the questions that you know and skip the ones you don&#8217;t. The team needs as much data as possible to provide a clearer picture of WordPress&#8217; use in higher education. If you know someone or an organization that uses WordPress in higher education, please <a href=\"https://www.surveymonkey.com/r/wpcampus05-2016\">share the survey</a> with them. The survey closes on May 27th.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 03:21:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: What Do You Think of the Recommended Plugins Page in WordPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54437\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/what-do-you-think-of-the-recommended-plugins-page-in-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3913:\"<p>In late 2014, <a href=\"http://wptavern.com/wordpress-4-1-to-introduce-plugin-recommendations\">WordPress 4.1 added</a> a Recommended Plugins tab that takes into account the plugins you have installed and suggests plugins based on which ones are commonly used together. After nearly a year and a half since it was added, I asked the <a href=\"https://twitter.com/wptavern/status/727578470415532032\">Tavern&#8217;s Twitter followers</a> if they have ever installed plugins recommended by WordPress.</p>\n<p>I was surprised to discover that some people don&#8217;t know the tab exists.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> There\'s a \"Recommended\" tab?!?</p>\n<p>&mdash; Joe Taiabjee (@joetek) <a href=\"https://twitter.com/joetek/status/727581218414407681\">May 3, 2016</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> I\'ve just noticed the Recommended tab. It seems to show those plugins with most Active Installs. Interesting, but a bit \'hidden\'</p>\n<p>&mdash; Alejandro Vargas S. (@Alejandro_V_S) <a href=\"https://twitter.com/Alejandro_V_S/status/727836820159930369\">May 4, 2016</a></p></blockquote>\n<p></p>\n<p>Steve Brown says the recommendations are useful.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> yep :) very useful feature indeed</p>\n<p>&mdash; Steve Brown (@stevna) <a href=\"https://twitter.com/stevna/status/727681984504287232\">May 4, 2016</a></p></blockquote>\n<p></p>\n<p>Some people view the page as an opportunity for Automattic to advertise its plugins while others don&#8217;t trust the recommendations.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> I have no needs for the Automattic plugins that are almost only being recommended there</p>\n<p>&mdash; Marko Heijnen (@markoheijnen) <a href=\"https://twitter.com/markoheijnen/status/727624592399998976\">May 3, 2016</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/wptavern\">@wptavern</a> Once. However 10 of the plugins recommended on page 1 are untested with my version of WP. So wouldnt rely on the recommendations</p>\n<p>&mdash; WPin.me (@wp_in) <a href=\"https://twitter.com/wp_in/status/727725233843671040\">May 4, 2016</a></p></blockquote>\n<p></p>\n<p>When I viewed the recommended plugins page in 2014, the results displayed plugins that weren&#8217;t updated in years.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/RecommendedPluginsTab.png\"><img class=\"size-full wp-image-35318\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/RecommendedPluginsTab.png?resize=1025%2C527\" alt=\"Plugins Recommended To Me Based on Data of Sites with Similar Plugins Installed\" /></a>Plugins Recommended To Me Based on Data of Sites with Similar Plugins Installed\n<p>Today, the page displays more relevant results with recently updated plugins. On the first page of results for WP Tavern, only one plugin from Automattic is recommended. The second page of results doesn&#8217;t list any plugins authored by Automattic.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/2016RecommendedPlugins.png\"><img class=\"size-full wp-image-54616\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/2016RecommendedPlugins.png?resize=1025%2C514\" alt=\"Recommended Plugins in 2016\" /></a>Recommended Plugin Results in 2016\n<p>To help determine how useful the recommended plugins page is, I&#8217;d like you to take this short survey. Results will be displayed on Tuesday, May 17th. In addition to the survey, you can leave your feedback in the comments.</p>\n<div class=\"pd-embed\" type=\"type\"></div>\n<p></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 May 2016 03:19:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Automattic is Protecting its Woo, WooThemes, and WooCommerce Trademarks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wptavern.com/automattic-is-protecting-its-woo-woothemes-and-woocommerce-trademarks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6735:\"<p>When <a href=\"http://wptavern.com/automattic-acquires-woocommerce\">Automattic acquired WooThemes in 2015</a>, it gained employees, plugins, themes, and the company&#8217;s trademarks. These trademarks include, standard character marks, logos, and specific graphics such as the Verified WooExpert badges. One of the responsibilities of a trademark owner is to protect it from infringement.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/VerifiedWooExpertServicemark.png\"><img class=\"size-full wp-image-54702\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/VerifiedWooExpertServicemark.png?resize=1025%2C621\" alt=\"Verified WooExpert Service Mark\" /></a>Verified WooExpert Service Mark\n<p>WooGPL is a service that provides customers with commercial themes, plugins, and extensions for WooCommerce at a discounted rate. In March, Automattic <a href=\"https://woogpl.com/woogpl-is-closing/\">sent Billy Ablett</a>, owner of <a href=\"https://woogpl.com\">WooGPL</a>, the following notice that informs him that his domain infringes the Woo and WooCommerce trademarks.</p>\n<blockquote><p>I’m writing to you on behalf of Automattic Inc. regarding your use of the Woo and WooCommerce trademarks.</p>\n<p>As you may know, Automattic owns the Woo, WooCommerce, and WooThemes brands, as well as the associated trademarks. We recently learned of https://woogpl.com, which actively makes use of our registered trademarks in both its name and promotion. We are very concerned that your use of Woo and WooCommerce will create confusion by communicating that your WooCommerce products are endorsed by or associated with Automattic, when in fact it is not.</p>\n<p>While Automattic appreciates that you are providing products that build on WooCommerce open source software, that fact does not authorize you to use Woo, WooThemes or WooCommerce trademarks.</p>\n<p>To minimize user confusion and to protect our own intellectual property, we unfortunately must insist that you take prompt steps to change your domain name to something that doesn’t include &#8216;Woo&#8217; in the prefix, and change your product descriptions to avoid confusion and potentially misleading consumers to believe they are purchasing our products. An example of this would be: WooCommerce Email Customiser Pro would need to be changed to Email Customiser Pro for WooCommerce.</p>\n<p>For more information, please see our <a href=\"https://www.woothemes.com/style-guide/#sg-trademarks\">Trademark Guidelines</a>.</p>\n<p>While we are appreciative that you have included a disclaimer on your site, unfortunately this would not be sufficient and we would still insist that the domain name and product names be changed.</p></blockquote>\n<p>While it&#8217;s not the sole reason <a href=\"https://woogpl.com/woogpl-is-closing/\">WooGPL is shutting down</a>, the notice provides a convenient opportunity to rebrand to <a href=\"https://www.gplkit.com/\">GPL Kit</a>, something the company was already planning to do.</p>\n<p>&#8220;We would have eventually closed down WooGPL due to GPL Kit however, it would have been great to close it down on our terms when the time was right,&#8221; Daniel, who is part of the GPL Kit team told the Tavern.</p>\n<p>Daniel says that when he started WooGPL there wasn&#8217;t a trademark registered with the Woo character mark until October of 2015.</p>\n<p>A search of the United States Patent and Trademark Office for Woo contains over 1K results. However, this is the only character mark for Woo that I found. The filing date is October 22nd, 2015 and is in the approval process.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WooCharacterMark.png\"><img class=\"size-full wp-image-54703\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WooCharacterMark.png?resize=1003%2C557\" alt=\"Woo Character Mark\" /></a>Woo Character Mark\n<h2>When You Should Ask For Permission</h2>\n<p>WooThemes has a <a href=\"https://www.woothemes.com/style-guide/#sg-trademarks\">style guide</a> on its site that explains how the brand is used and has details on when Woo™, WooCommerce®, and WooThemes® names, logos, and related icons collectively known as Woo Marks can be used without permission. The following chart provides some examples.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/PermissionChartForWooTrademarks.png\"><img class=\"size-full wp-image-54704\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/PermissionChartForWooTrademarks.png?resize=1010%2C814\" alt=\"Examples of When You Do and Don\'t Need Permission\" /></a>Examples of When You Do and Don&#8217;t Need Permission\n<p>If you&#8217;re in doubt, you can email Automattic&#8217;s trademark team  <a href=\"mailto:trademarks@automattic.com\">trademarks @ automattic.com</a> to receive clarification.</p>\n<h2>Woo&#8217;s at Risk?</h2>\n<p>There are quite a few businesses in the WordPress ecosystem that use Woo in their name and domain. <a href=\"http://www.woorockets.com/\">WooRockets</a> is a WooCommerce theme shop while <a href=\"http://wooassist.com/\">WooAssist</a> provides support and maintenance for store owners.</p>\n<p>I reached out to both companies to determine if Automattic sent them the same notice it sent to WooGPL. While I didn&#8217;t receive a response from WooRockets, John Gamour of WooAssist provided the Tavern with the following statement:</p>\n<blockquote><p>No, we haven&#8217;t been contacted by Automattic about that. It would be dissapointing if we were asked to change our name as our founder Nicholas Jones reached out to WooThemes before starting Wooassist and they gave the OK. We have also worked with Matt Cohen and James Koster on a project and nothing was ever mentioned about our name.</p></blockquote>\n<p>I tried to get in touch with Paul Sieminski, legal counsel for Automattic, to learn what the criteria is for violating the trademarks, who&#8217;s at risk, and how long they have enforced the marks but he could not be reached for comment.</p>\n<h2>Better to be Safe Than Sorry</h2>\n<p>As WooGPL discovered, adding a disclaimer to the bottom of your sites may not be enough. Considering the cost and potential impacts of re branding a company or product, it&#8217;s important to know as soon as possible if you&#8217;re infringing a company&#8217;s trademarks.</p>\n<p>Business owners in the WooCommerce and WooThemes ecosystem should double-check the <a href=\"https://www.woothemes.com/style-guide/#sg-trademarks\">style guide</a> to make sure you&#8217;re not violating any guidelines. Owners can also take a proactive step and contact Automattic&#8217;s trademark team to determine if your business meets the requirements.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 May 2016 20:21:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WooCommerce Releases Storefront 2.0 with Major Improvements to Mobile Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/woocommerce-releases-storefront-2-0-with-major-improvements-to-mobile-design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3509:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/storefront-update.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/storefront-update.png?resize=1025%2C451\" alt=\"storefront-update\" class=\"aligncenter size-full wp-image-54669\" /></a></p>\n<p><a href=\"https://wordpress.org/themes/storefront/\" target=\"_blank\">Storefront</a>, the official WooCommerce theme built to work seamlessly with the plugin, has just passed the <a href=\"https://www.woothemes.com/2016/05/storefront-2-0-release/\" target=\"_blank\">2.0 milestone</a>. This release introduces a new &#8220;best sellers&#8221; section to the homepage and adds compatibility with the upcoming WooCommerce 2.6’s tabbed “My Account” section and the average rating widget.</p>\n<p>The most important update in Storefront 2.0 is the redesigned mobile experience. According to <a href=\"http://resources.mobify.com/50-mobile-commerce-stats.html\" target=\"_blank\">Mobify</a>, 30% of mobile shoppers will abandon a transaction if the experience is not optimized for mobile. <a href=\"http://www.themobileplaybook.com/\" target=\"_blank\">Google&#8217;s Mobile Playbook</a> says that not having a mobile optimized website is like closing your store one day each week. To keep pace with the expectations of mobile buyers, WooCommerce has drastically reduced Storefront&#8217;s mobile header height by 60% and has added the search, shopping cart, and account links to a sticky bottom menu for easy access.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/storefront-mobile-home.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/storefront-mobile-home.png?resize=799%2C697\" alt=\"storefront-mobile-home\" class=\"aligncenter size-full wp-image-54671\" /></a></p>\n<p>Storefront 2.0 includes many design improvements that make the theme cleaner and more flexible. This update removes Helvetica in favor of Source Sans, which WooCommerce says gives them access to a wider variety of weights they can use to &#8220;provide greater depth and cohesion.&#8221; Other notable design changes include:</p>\n<ul>\n<li>Borders have been largely removed so that pages don’t feel quite so broken up.</li>\n<li>The breadcrumb and the main navigation are now wrapped in their own content regions, cementing them as unique components.</li>\n<li>Product reviews and comments tweaked to make them cleaner and more scannable.</li>\n<li>Blog post meta has been redesigned to include the author Gravatar.</li>\n<li>Softer design treatment for tables with colors based on the main background color.</li>\n<li>oEmbeds have been styled to match the rest of Storefront (including typography, padding, colors).</li>\n<li>Integrated WordPress 4.5’s custom logo feature so users can add a logo without using a plugin.</li>\n</ul>\n<p><a href=\"https://wordpress.org/themes/storefront/\" target=\"_blank\">Storefront</a> is active on more than 50,000 websites. There are nearly a dozen free themes on WordPress.org that use it as a parent theme and another dozen commercial themes on WooThemes.com. If you use a heavily customized Storefront child theme, you may want to test its compatibility with the 2.0 update on a development site to ensure that there are no visual surprises. If you have any ideas or recommendations for updates to Storefront, you can leave feedback on the theme&#8217;s <a href=\"http://ideas.woothemes.com/forums/275029-storefront\" target=\"_blank\">idea board</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 May 2016 22:23:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: Timber 1.0 Is Now Available on WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54396\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wptavern.com/timber-1-0-is-now-available-on-wordpress-org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5932:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/timber.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/timber.png?resize=1025%2C405\" alt=\"timber\" class=\"aligncenter size-full wp-image-54630\" /></a></p>\n<p>Last week the creators of <a href=\"https://wordpress.org/plugins/timber-library/\" target=\"_blank\">Timber</a>, the plugin that enables WordPress theme developers to write HTML using the <a href=\"http://twig.sensiolabs.org/\" target=\"_blank\">Twig Template Engine</a>, released version 1.0 on WordPress.org. The plugin is active on more than 10,000 websites where theme authors have elected to keep PHP files separate from HTML. Timber is built on DRY and MVC principles to solve the problem stated in its unofficial tagline: <em>&#8220;Because WordPress is awesome, but the_loop isn&#8217;t.&#8221;</em></p>\n<p>Over the past four years, the open source project has evolved from being a starter theme to a plugin that can be added to existing themes. It is now used on <a href=\"http://upstatement.com/timber/#showcase\" target=\"_blank\">thousands of websites</a> and has 83 <a href=\"https://github.com/timber/timber/graphs/contributors\" target=\"_blank\">contributors</a> listed on GitHub.</p>\n<p>&#8220;In 2012 I was getting more into WordPress after doing lots of JS development with <a href=\"http://handlebarsjs.com/\" target=\"_blank\">Handlebars</a> (a JS templating language),&#8221; Timber creator Jared Novack said. &#8220;I went to WordCamp Providence to learn more about state-of-the-art WordPress ways. I remember thinking: &#8216;This is great, but I really miss the cleanliness of Handlebars &#8212; I wish someone would make something like that for WordPress.&#8217; That&#8217;s when I realized, I was that someone.&#8221;</p>\n<p>Novack was playing around with <a href=\"http://www.smarty.net/\" target=\"_blank\">Smarty</a> and <a href=\"https://mustache.github.io/\" target=\"_blank\">Mustache</a> before he finally discovered Fabien Potencier&#8217;s <a href=\"http://twig.sensiolabs.org/\" target=\"_blank\">Twig project</a>.</p>\n<p>&#8220;The syntax felt so natural I almost didn&#8217;t need to read the docs (don&#8217;t worry, I did),&#8221; he said. &#8220;I realized what I needed was a way to marry Twig and WordPress, and thus: Timber was born.&#8221;</p>\n<p>At that time Novack&#8217;s company, <a href=\"https://upstatement.com/\" target=\"_blank\">Upstatement</a>, was beginning development on a big new project for Random House to enable their marketers to generate unique sites from a library of templates. This client project became Timber&#8217;s first test case.</p>\n<p>&#8220;Originally, Timber was a parent theme, like _s. But after we completed the Random House project, I realized I wanted to apply Timber functionality to existing sites,&#8221; Novack said. &#8220;I converted it into a plugin that could be employed on existing themes which is the form it takes today.&#8221;</p>\n<p>The plugin allows designers skilled with HTML and CSS to create themes without having extensive knowledge of PHP and WordPress functions. Timber successfully powers sites like Michael Bloomberg&#8217;s <a href=\"https://www.thetrace.org/\" target=\"_blank\">The Trace</a>, <a href=\"http://everytown.org/\" target=\"_blank\">Everytown for Gun Safety</a>, <a href=\"https://www.hoteltonight.com/\" target=\"_blank\">Hotel Tonight</a>, and the <a href=\"http://harvardlawreview.org/\" target=\"_blank\">Harvard Law Review</a>.</p>\n<h3>Timber 1.0 Puts the Project on the Path of Stability</h3>\n<p>As of Timber 1.0, developers can now include the project as a plugin or require it as a <a href=\"https://packagist.org/packages/timber/timber\" target=\"_blank\">Composer dependency</a>.</p>\n<p>&#8220;The big news is that 1.0 represents a maturing of the platform — developers can use Timber and Twig with confidence that they’re building on top of a stable and universal platform,&#8221; Novack said.</p>\n<p>This release sheds years of deprecated functions and methods dating back to the project&#8217;s early days in 2013. Novack said that technical and documentation debt were the biggest hurdles in getting to 1.0.</p>\n<p>&#8220;In hindsight it’s so easy to build stuff, but so hard to build a complete system,&#8221; he said. &#8220;When Timber started it was just for me and the documentation could just live in my head. I’d add and improve stuff and then live with some of the quirks.&#8221;</p>\n<p>As the project and its contributors grew, Novack found it difficult to keep up with the growing codebase while running his company. Bringing it to a place of maturity with up-to-date automated testing and documentation took nearly a year.</p>\n<p>&#8220;Backwards compatibility was also a major challenge,&#8221; Novack said. &#8220;As ideas and new code got submitted, development slowed as every decision might have implications for existing users. We would deprecate features, but I was hesitant to remove things that I knew were mistakes, but that people were using.&#8221;</p>\n<p>Developers are encouraged to read the <a href=\"https://github.com/timber/timber/wiki/1.0-Upgrade-Guide\" target=\"_blank\">1.0 Upgrade Guide</a>, as there may be additional steps required depending on how Timber is being used. This release adds a few new features but the most important change is the bulk removal of older sections of the codebase. The upgrade guide outlines all of the object properties and static methods that will need to be updated so that nothing breaks. In the future, Timber-powered themes will be easier to maintain, with fewer quirks and better-documented features.</p>\n<p>&#8220;The key learning for me is that the ultimate &#8216;killer feature&#8217; is stability and predictability,&#8221; Novack said. &#8220;When everything is organized cleanly and developers can use the things that they would intuitively expect — that’s success.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 May 2016 17:52:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Post Status: WordPress Security — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=24378\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://poststatus.com/wordpress-security-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2296:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>Security &#8212; in WordPress core, distributed plugins and themes, and in our custom code &#8212; is a constant battle. It’s important to be vigilant with our security practices, from the perspective of managing our websites and when writing code. In this episode, Joe and Brian discuss the nature of WordPress security, best practices for writing secure code, and dig into various situations WordPress developers and site owners may run into.</span></p>\n<a href=\"https://audio.simplecast.com/37301.mp3\">https://audio.simplecast.com/37301.mp3</a>\n<p><a href=\"http://audio.simplecast.com/37301.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"http://codex.wordpress.org/Hardening_WordPress\">Hardening WordPress</a></li>\n<li><a href=\"https://wordpress.org/about/security/\">About WordPress Security</a></li>\n<li><a href=\"https://make.wordpress.org/themes/2015/05/19/a-guide-to-writing-secure-themes-part-1-introduction/\">A Guide to Writing Secure Themes</a></li>\n<li><a href=\"http://ben.lobaugh.net/uploads/writing-secure-plugins-and-themes/#/\">Writing Secure Plugins &amp; Themes</a> by Ben Lobaugh</li>\n<li><a href=\"https://codex.wordpress.org/Class_Reference/wpdb\">$wpdb</a></li>\n<li><a href=\"https://wpvulndb.com/\">WP Scan</a></li>\n<li><a href=\"https://blog.sucuri.net/2015/03/understanding-wordpress-plugin-vulnerabilities.html\">Understanding Vulnerabilities</a></li>\n</ul>\n<h3>Sponsor: Pagely</h3>\n<p><a href=\"https://pagely.com\"><span>Pagely</span></a><span> offers best in class managed WordPress hosting, powered by the Amazon Cloud, the Internet’s most reliable infrastructure. Post Status is proudly hosted by Pagely. Thank you to </span><a href=\"https://pagely.com\"><span>Pagely</span></a><span> for being a Post Status partner.</span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 May 2016 01:01:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Apple and Podcasting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46548\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2016/05/apple-and-podcasting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:557:\"<p><a href=\"https://marco.org/2016/05/07/apple-role-in-podcasting\">Marco Arment has a great take on how the decentralized nature of podcasting is a feature</a>, not a bug, and Apple being more proactive there would be harmful to the ecosystem. As an aside, since I&#8217;ve been in Houston more recently, which means driving a lot, I&#8217;ve been really loving his app <a href=\"https://overcast.fm/\">Overcast</a> and I opted in to the optional paid subscription for it. I just need to get in more of a habit of listening to podcasts outside of Houston.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 08 May 2016 14:17:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: VersionPress 3.0 Adds New Search Feature, Bulk Undo, and Commit Tracking per Environment\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54530\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://wptavern.com/versionpress-3-0-adds-new-search-feature-bulk-undo-and-commit-tracking-per-environment\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3843:\"<p><a href=\"https://blog.versionpress.net/2016/04/versionpress-3-0-released/\" target=\"_blank\">VersionPress 3.0</a>, released this week, is the first version since the plugin <a href=\"http://wptavern.com/versionpress-transitions-into-a-free-open-source-project\" target=\"_blank\">became a free, open source project</a>. Creators Borek Bernard and Jan Voráček, who originally attempted to crowdfund the project and then <a href=\"http://wptavern.com/versionpress-raises-400k-in-seed-funding\" target=\"_blank\">raised $400,000 in seed funding</a>, <a href=\"http://wptavern.com/versionpress-transitions-into-a-free-open-source-project\" target=\"_blank\">announced</a> last month that they are transitioning to a public development model.</p>\n<p>The team&#8217;s goal with this release was to polish up the experience of using VersionPress in the default WordPress installation while adding more useful features. However, it is not yet ready for use in production, according to Bernard.</p>\n<p>&#8220;We’re still keeping VersionPress in the <a href=\"http://docs.versionpress.net/en/getting-started/about-eap\" target=\"_blank\">“early access” period</a>, because of the third party plugins integration story but on simpler sites, VersionPress already shines,&#8221; he said.</p>\n<p>One of the most notable new features in VersionPress 3.0 is the plugin&#8217;s ability to track commits with the environment where they were created. Users can view changes in the admin and easily see if they were pushed to the staging or production environment.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/commit-tracking-in-environment.gif\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/commit-tracking-in-environment.gif?resize=725%2C347\" alt=\"commit-tracking-in-environment\" class=\"aligncenter size-full wp-image-54599\" /></a></p>\n<p>Version 3.0 also adds searching capabilities for filtering commits by author, date, commit message, and WordPress action. This release also includes a new bulk undo feature for commits and many improvements to the core versioning engine.</p>\n<h3>VersionPress 4.0 to Focus on Support for 3rd Party Plugins</h3>\n<p>One of the reasons the VersionPress team decided to go with a public development model was to mitigate the plugin&#8217;s conflicts with third-party themes and plugins. This was only possible if the opened up the codebase for contribution from other developers.</p>\n<p>&#8220;While we had most of the WordPress core covered pretty well, there was still this huge ecosystem of WordPress plugins and themes that could cause trouble to VersionPress in million different ways,&#8221; Borek said. &#8220;In the long run, the project had to turn into OSS should it be successful, and, fortunately, we met investors who understood this and supported our vision.&#8221;</p>\n<p>Borek and the team plan to focus on adding support for complex third party plugins in version 4.0, tentatively scheduled for mid-2016. One commenter on the post mentioned that a lack of WooCommerce support is a major thing holding him back from using VersionPress on projects. Borek confirmed that WooCommerce is high on their list of plugins they want to support.</p>\n<p>&#8220;Our goal remains the same: to take all the incredibly powerful functionality of Git and package it so that every WordPress user can use it,&#8221; Borek said.</p>\n<p>Since most site owners interested in this plugin are not running vanilla installations of WordPress, support for third party plugins will be a major leap forward for the project with the potential to greatly expand its user base. Check out VersionPress&#8217; <a href=\"http://docs.versionpress.net/en/release-notes/roadmap\" target=\"_blank\">roadmap</a> to follow along with its progress and see what&#8217;s next.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 22:04:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WordPress 4.5.2 Patches Two Security Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54594\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/wordpress-4-5-2-patches-two-security-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1441:\"<p>The WordPress core team has <a href=\"https://wordpress.org/news/2016/05/wordpress-4-5-2/\">released WordPress 4.5.2</a> which patches two security vulnerabilities in WordPress versions 4.5.1 and below. The first is a <a href=\"http://www.benhayak.com/2015/06/same-origin-method-execution-some.html\">SOME vulnerability</a> (Same-Origin Method Execution) in Plupload, the third-party library WordPress uses for uploading files. The second is a reflected cross-site-scripting vulnerability in MediaElement.js, the third-party library used for media players.</p>\n<p>Auto updates are rolling out to sites but if you don&#8217;t want to wait, browse to Dashboard &gt; Updates and click the Update Now button. Mario Heiderich, Masato Kinugawa, and Filedescriptor of <a href=\"https://cure53.de/\">Cure53</a> are credited with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerabilities.</p>\n<p>In addition to the release, the core team has <a href=\"https://make.wordpress.org/core/2016/05/06/imagemagick-vulnerability-information/\">published a post</a> concerning the <a href=\"https://imagetragick.com/\">multiple vulnerabilities</a> discovered in ImageMagick, a popular image processing script used on thousands of webhosting servers. The post describes how WordPress is affected and what the team is doing to mitigate issues.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 20:01:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: Laravel Releases Valet, a Minimalist Development Environment with Support for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://wptavern.com/laravel-releases-valet-a-minimalist-development-environment-with-support-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3404:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/valet-parking.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/valet-parking.jpg?resize=900%2C520\" alt=\"photo credit: Valet Parking, Las Vegas, NV - (license)\" class=\"size-full wp-image-54589\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/55151301@N00/175606346\">Valet Parking, Las Vegas, NV</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p><a href=\"https://laravel.com/\" target=\"_blank\">Laravel</a>, the open source MVC PHP framework created for application development, has just released <a href=\"https://laravel.com/docs/5.2/valet\" target=\"_blank\">Valet</a>, a minimalist development environment for Mac. It uses just 7mb of RAM, because it doesn&#8217;t include Vagrant, Apache, Nginx, or a /etc/hosts file. Here&#8217;s how it works:</p>\n<blockquote><p>Laravel Valet configures your Mac to always run PHP&#8217;s built-in web server in the background when your machine starts. Then, using DnsMasq, Valet proxies all requests on the *.dev domain to point to sites installed on your local machine.\n</p></blockquote>\n<p>Valet supports Laravel, Lumen, Statamic, Craft, Jigsaw, and even has a driver for WordPress. It&#8217;s handy if you just need a simple, fast development environment without virtualization. Developers can also share sites publicly via local tunnels. It&#8217;s as easy as navigating to the site&#8217;s directory in the terminal and running the <code>valet share</code> command, which generates a publicly accessible URL.</p>\n<p><a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> founder Peter Suhm, who is active in both the Laravel and WordPress communities, wrote a <a href=\"http://blog.wppusher.com/a-minimalist-development-environment-for-wordpress-with-laravel-valet/\" target=\"_blank\">tutorial</a> for setting up Valet for WordPress development.</p>\n<p>&#8220;For larger apps, I generally prefer my development environment to be very similar to production,&#8221; Suhm said. &#8220;Vagrant and Docker are great for that. Valet is great for all those quick and dirty WordPress installations you need, just to test something or quickly work on an idea. If you don’t need anything else besides PHP 7 and a database, Valet is a great setup.&#8221;</p>\n<p>Since it doesn&#8217;t require a ton of dependencies, Valet is quick to set up and doesn&#8217;t require any configuration. Developers don&#8217;t even need to make Valet aware that their app is WordPress &#8211; you can simply drop WordPress core files into a folder on your machine and then access the site in your browser.</p>\n<p>If you&#8217;re looking for a new lightweight development environment or just a quick way to do some PHP 7 testing for WordPress plugins, Valet may fit nicely into your workflow. You can install it using <a href=\"http://brew.sh/\" target=\"_blank\">Homebrew</a>. View the <a href=\"https://laravel.com/docs/5.2/valet#installation\" target=\"_blank\">docs</a> for installation and site setup or follow along with Suhm&#8217;s <a href=\"http://blog.wppusher.com/a-minimalist-development-environment-for-wordpress-with-laravel-valet/\" target=\"_blank\">tutorial</a>.</p>\n<p>To see a quick demo of Valet in action, check out the two-minute introduction video created by Adam Wathan:</p>\n<div class=\"embed-wrap\"></div>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 18:44:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: WordPress 4.6 to Drop Open Sans in the Admin in Favor of System Fonts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54507\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wptavern.com/wordpress-4-6-to-drop-open-sans-in-the-admin-in-favor-of-system-fonts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2130:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/system-fonts-firefox-osx.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/05/system-fonts-firefox-osx.png?resize=1025%2C450\" alt=\"system-fonts-firefox-osx\" class=\"aligncenter size-full wp-image-54575\" /></a></p>\n<p>WordPress 4.6 will bid farewell to Open Sans in the admin in favor of using system fonts. Open Sans, which loads from Google Fonts as an external resource, has been in use in the admin since 2013.</p>\n<p>&#8220;At the time of introduction in 3.8, there were not good system fonts common to all platforms at the time,&#8221; WordPress lead developer <a href=\"http://helenhousandi.com/\" target=\"_blank\">Helen Hou-Sandí</a> said in her <a href=\"https://core.trac.wordpress.org/changeset/37361\" target=\"_blank\">commit</a> message. &#8220;In the years since, Windows, Android, OS X, iOS, Firefox OS, and various flavors of Linux have all gotten their own (good) system UI fonts.&#8221;</p>\n<p>Now that the admin doesn&#8217;t have to load fonts from Google, it should feel faster and will provide a better experience for developers who are working offline.</p>\n<p>Dropping Open Sans originated as part of the <a href=\"https://make.wordpress.org/core/features/font-natively/\" target=\"_blank\">Font Natively</a> feature project led by WordPress designer <a href=\"https://mattmiklic.com/\" target=\"_blank\">Matt Miklic</a>, Mark Uraine, and Helen Hou-Sandí. The project page provides screenshots for the WP admin with Open Sans in Firefox on OSX vs the admin with system fonts, but the team noted that they are in need of more screenshots from different environments.</p>\n<p>Anytime that WordPress can shed a third-party dependency while improving the experience in the admin is a win for everyone. The commit comes early in the release cycle in order to get more people testing for misalignments and any other issues. Feel free to report any bugs you experience with the change, as work is still ongoing on the <a href=\"https://core.trac.wordpress.org/ticket/36753\" target=\"_blank\">ticket</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 20:50:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Ninja Forms Update Patches Critical Security Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54556\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://wptavern.com/ninja-forms-update-patches-critical-security-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4325:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/03/NinjaFormsFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-40019\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/03/NinjaFormsFeaturedImage.png?resize=840%2C273\" alt=\"Ninja Forms Featured Image\" /></a><a href=\"https://wordpress.org/plugins/ninja-forms/\">Ninja Forms</a>, a popular plugin active on more than 500K websites, released an update 48 hours ago that addresses a critical security vulnerability. Wordfence <a href=\"https://www.wordfence.com/blog/2016/05/ninja-forms-shell-upload-vulnerability-high-risk/\">is reporting</a> that Ninja Forms versions 2.9.36 to 2.9.42 contain multiple security vulnerabilities.</p>\n<p>One of the vulnerabilities allows an attacker to upload and execute code remotely on WordPress sites. The only information needed to exploit the vulnerability is the URL of the target site that&#8217;s using a form powered by an affected version of Ninja Forms.</p>\n<p>Kevin Stover, CTO of Ninja Forms, explains to the Tavern how they discovered the vulnerabilities:</p>\n<blockquote><p>About two weeks ago, we were contacted by a security researcher, James Golovich, regarding a file upload issue within Ninja Forms. He demonstrated that it was possible to upload an arbitrary file using some test code that hadn’t been removed during our build process.</p>\n<p>We realised that the test code had accidentally been utilised in other areas of the plugin, and we immediately began working on a fix. While the issue was being patched, we reached out to the devs at the <a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a> repo and began the processes of preparing for auto updating users of the affected versions.</p>\n<p>Once the patch had been tested, we pushed version 2.9.43 and .1 versions of 2.9.36 &#8211; 2.9.42. Shortly after, <a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a> began pushing out automatic updates.</p></blockquote>\n<p>As to why there wasn&#8217;t a post published immediately on the official <a href=\"https://ninjaforms.com/blog/\">Ninja Forms blog</a> announcing the update, &#8220;We didn’t want to go public with the vulnerability until our users had time to update, both to the newest version and the .1 versions,&#8221; Stover said.</p>\n<p>&#8220;James Golovich&#8217;s responsible disclosure gave us time to fix the issue and for our users to update to safe versions before disclosing the vulnerability on his site,&#8221; he said. The company has since <a href=\"https://ninjaforms.com/important-security-update-always-hurt-ones-love/\">published a blog post </a>concerning the update.</p>\n<p>Working with the WordPress security team, automatic updates started rolling out on Tuesday, May 3rd. If automatic plugin updates are disabled, you&#8217;re highly encouraged to update manually to 2.9.45 as soon as possible. The Ninja Forms team is also working with a number of large webhosts to ensure as many sites as possible are updated.</p>\n<p>Wordfence is not detecting wide-spread exploitation but this could change in the next few days as details of the exploit emerge.</p>\n<p>When it comes to security vulnerabilities, the ability to upload and execute code remotely is about as severe as it gets. Golovich is credited with <a href=\"http://www.pritect.net/blog/ninja-forms-2-9-42-critical-security-vulnerabilities\">responsibly disclosing</a> the vulnerability to the Ninja Forms team. He also provides technical details of each vulnerability, most of which are in the Ninja Forms 3.0 code base.</p>\n<p>According to Golovich, the most vulnerable code is a proof of concept:</p>\n<blockquote><p>The following vulnerable code was, according to Kyle Johnson of the WP Ninjas team &#8216;not a live feature of Ninja Forms, but was more of a proof of concept for a future free feature.&#8217; Unfortunately, even proof of concept code that is accessible is still vulnerable to attack. This is the most critical vulnerability here because it potentially allows an attacker to execute arbitrary php code on a site.</p></blockquote>\n<p>Users should update as soon as possible as it&#8217;s only a matter of time before tools are created that can easily take advantage of the exploit.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 20:46:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WordPress.org Support Forums Adds Accessibility Section\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54472\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/wordpress-org-support-forums-adds-accessibility-section\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3619:\"<p>Earlier this year, the WordPress project made a huge move by <a href=\"http://wptavern.com/wordpress-adopts-accessibility-coding-standards-for-all-new-and-updated-code\">adopting accessibility coding standards</a> for new and updated code. If you&#8217;re struggling to meet <a href=\"https://www.w3.org/WAI/intro/wcag\">WCAG 2.0 guidelines</a> in your WordPress projects and need help, check out the new <a href=\"https://wordpress.org/support/forum/accessibility\">Accessibility section</a> in the WordPress.org support forums.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WPAccessibilitySupport.png\"><img class=\"size-full wp-image-54551\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/WPAccessibilitySupport.png?resize=1025%2C487\" alt=\"WordPress Accessibility Support\" /></a>WordPress Accessibility Support\n<p>Amanda Rush, who helps WordPress developers make their themes and plugins accessible, says the forum is the result of a conversation with a support team member at WordCamp Atlanta.</p>\n<p>&#8220;I <span class=\"message_body\">mentioned that part of what makes the job difficult when it comes to making WordPress accessible is stopping during our work to answer occasional questions.<br />\n</span></p>\n<p>&#8220;Most of the time the answer is not a quick one, because in the case of screen reader users, you have to first find out how well they can use their tech, how familiar they are with WordPress itself, and if neither of those chances are high, you spend time giving them a crash course in either one or both, and then answer their question,&#8221; <span class=\"message_body\">Rush said. </span></p>\n<p>Most of the people on the <a href=\"https://make.wordpress.org/accessibility/\">WordPress Accessibility team</a> are volunteers with full-time jobs which limits their ability to provide one-on-one support. Many of the support queries come through email or direct messages to individuals on the team. The forum enables everyone to participate in the support process.</p>\n<p>&#8220;If people ask their questions publicly, I or others not necessarily on the Accessibility Team can answer, and the answers are then public,&#8221; Rush said.</p>\n<p>&#8220;We have a pattern library on GitHub, which we all contribute to when we have time. But there are all kinds of solutions being passed around on Twitter and spread across other people&#8217;s GitHub accounts. So if someone asks a question like that, we can either point to something in specific cases, which is most of them, there&#8217;s probably already a specific solution that someone&#8217;s built, and we can link to that,&#8221; Rush told the Tavern.</p>\n<p>The accessibility support forum also comes with a side benefit, &#8220;W<span class=\"message_body\">e don&#8217;t have to say no all the time when people ask for support, or what looks like all the time to some people. Everyone can help each other </span><span class=\"message_body\">out and Google has a public resource,&#8221; Rush said.<br />\n</span></p>\n<p>The support forum comes at a time where accessibility is an increasingly important part of web development. For example, the European Union <a href=\"http://europa.eu/rapid/press-release_IP-16-1654_en.htm\">recently agreed to new rules</a> that will make public sector websites and apps more accessible.</p>\n<p>If you have any questions related to accessibility, you can post them on the forum. If you have experience and knowledge in the accessibility field, consider answering questions as it&#8217;s a great way to contribute to the WordPress project.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 20:13:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"WPTavern: Font Awesome CDN Now in Beta, Loads Icons Asynchronously with Automatic Accessibility Best Practices\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=54509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"http://wptavern.com/font-awesome-cdn-now-in-beta-loads-icons-asynchronously-with-automatic-accessibility-best-practices\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2903:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/font-awesome.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/font-awesome.png?resize=1025%2C326\" alt=\"font-awesome\" class=\"aligncenter size-full wp-image-54532\" /></a></p>\n<p><a href=\"https://fortawesome.github.io/Font-Awesome/\" target=\"_blank\">Font Awesome</a>, the open source vector icon collection used by more than 300 plugins on WordPress.org and many free and commercial themes, <a href=\"https://articles.fortawesome.com/announcing-font-awesome-cdn-81773e0b301f#.egol888o7\" target=\"_blank\">announced the beta release of its new CDN</a>. Developers can now add a single line of code to bring the icons and CSS toolkit into their projects.</p>\n<p>The icon files and CSS are hosted by <a href=\"https://www.maxcdn.com/\" target=\"_blank\">MaxCDN</a>, which serves a cached version that loads quickly on websites that use Font Awesome. The CDN uses <a href=\"https://github.com/typekit/webfontloader\" target=\"_blank\">Web Font Loader</a>, which was co-developed by Google and Typekit, to load the icons asynchronously. This also gives developers <a href=\"https://github.com/typekit/webfontloader#events\" target=\"_blank\">CSS and JavaScript events</a> to hook into on loading.</p>\n<p><a href=\"http://wptavern.com/font-awesome-4-6-0-adds-new-accessibility-icons-category\" target=\"_blank\">FontAwesome 4.6 added a new accessibility icon category</a> and the new CDN helps to automate outputting the correct markup. If the icon you&#8217;re using has semantic meaning, including an accurate title attribute with the inline icon will trigger Font Awesome&#8217;s JS to do the rest.</p>\n<p>Font Awesome requires an email address from those want to use the CDN so it can issue a unique embed code for each. Developers also have the option to register a Font Awesome CDN account to keep track of sites and apps where they are using the icons, and manage multiple embed codes. Once logged in, you can enable or disable auto-accessibility, asynchronous icon loading, easy updates to newer Font Awesome versions, and CSS or JS embed.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/font-awesome-account.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/font-awesome-account.png?resize=1025%2C865\" alt=\"font-awesome-account\" class=\"aligncenter size-full wp-image-54543\" /></a></p>\n<p>One of the most convenient reasons to use the CDN is to simplify updates. WordPress plugin and theme developers do not have to bump versions or push any code to use the latest version. Font Awesome version changes can be triggered on an individual basis for each embed code in a developer&#8217;s account dashboard. Check out the instructions at <a href=\"https://cdn.fontawesome.com/\" target=\"_blank\">cdn.fontawesome.com</a> to get your project hooked up.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2016 18:09:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 28 Jun 2016 01:54:44 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"217777\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Tue, 28 Jun 2016 01:45:13 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20160506200020\";}", "no");
INSERT INTO `wp_options` VALUES("120", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1467122085", "no");
INSERT INTO `wp_options` VALUES("121", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1467078885", "no");
INSERT INTO `wp_options` VALUES("122", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1467122086", "no");
INSERT INTO `wp_options` VALUES("123", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:25:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"The most downloaded plugin for WordPress (almost 30 million downloads). Use All in One SEO Pack to automatically optimize your site for Search Engines\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 15 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Google Analytics by MonsterInsights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Connect Google Analytics with WordPress by adding your Google Analytics tracking code. Get the stats that matter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Syed Balkhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"47509@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical login experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Easy to use WordPress Slider plugin. Create responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 28 Jun 2016 01:54:46 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Tue, 28 Jun 2016 02:00:49 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Tue, 28 Jun 2016 01:25:49 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20160506200020\";}", "no");
INSERT INTO `wp_options` VALUES("124", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1467122086", "no");
INSERT INTO `wp_options` VALUES("125", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1467078886", "no");
INSERT INTO `wp_options` VALUES("126", "_transient_timeout_plugin_slugs", "1467171511", "no");
INSERT INTO `wp_options` VALUES("127", "_transient_plugin_slugs", "a:12:{i:0;s:19:\"akismet/akismet.php\";i:1;s:27:\"autoptimize/autoptimize.php\";i:2;s:26:\"cpaddons-site-software.php\";i:3;s:43:\"db-cache-reloaded-fix/db-cache-reloaded.php\";i:4;s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";i:5;s:50:\"far-future-expiry-header/far-future-expiration.php\";i:6;s:29:\"image-widget/image-widget.php\";i:7;s:67:\"remove-query-strings-from-static-resources/remove-query-strings.php\";i:8;s:23:\"siteguard/siteguard.php\";i:9;s:28:\"wp-file-cache/file-cache.php\";i:10;s:23:\"wp-smushit/wp-smush.php\";i:11;s:27:\"wp-super-cache/wp-cache.php\";}", "no");
INSERT INTO `wp_options` VALUES("128", "_transient_timeout_dash_88ae138922fe95674369b1cb3d215a2b", "1467122086", "no");
INSERT INTO `wp_options` VALUES("129", "_transient_dash_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2016/06/wordpress-4-5-3/\'>WordPress 4.5.3 Maintenance and Security Release</a> <span class=\"rss-date\">June 18, 2016</span><div class=\"rssSummary\">WordPress 4.5.3 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.5.2 and earlier are affected by several security issues: redirect bypass in the customizer, reported by Yassine Aboukir; two different XSS problems via attachment names, reported by Jouko Pynnönen and Divyesh Prajapati; revision history information disclosure, reported [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://blog.wordpress.tv/2016/06/22/spotlight-wordcamp-miami-2016/\'>WordPress.tv Blog: Spotlight: WordCamp Miami 2016</a></li><li><a class=\'rsswidget\' href=\'http://blog.wordpress.tv/2016/06/15/developing-for-wordpress-with-pippin-williamson-and-danilo-ercoli/\'>WordPress.tv Blog: Developing for WordPress with Pippin Williamson and Danilo Ercoli</a></li><li><a class=\'rsswidget\' href=\'https://poststatus.com/wordpress-news-happens-draft-podcast/\'>Post Status: How WordPress news happens — Draft podcast</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\"dashboard-news-plugin\"><span>Popular Plugin:</span> UpdraftPlus WordPress Backup Plugin&nbsp;<a href=\"plugin-install.php?tab=plugin-information&amp;plugin=updraftplus&amp;_wpnonce=f178bbc678&amp;TB_iframe=true&amp;width=600&amp;height=800\" class=\"thickbox open-plugin-details-modal\" aria-label=\"Install UpdraftPlus WordPress Backup Plugin\">(Install)</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("130", "_site_transient_timeout_available_translations", "1467089687", "yes");
INSERT INTO `wp_options` VALUES("131", "_site_transient_available_translations", "a:81:{s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-13 14:44:00\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.5.2/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-10 15:55:55\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-18 20:18:13\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-11 22:42:10\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-16 14:49:09\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-01 06:39:12\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-19 23:16:37\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-17 11:01:42\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.4.3\";s:7:\"updated\";s:19:\"2016-02-16 15:34:57\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.3/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-11 18:32:36\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:12:\"Čeština‎\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-11 14:21:06\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-12 17:20:10\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-12 19:26:41\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-12 20:03:25\";s:12:\"english_name\";s:23:\"(Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/4.5.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-16 05:39:37\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-02 08:22:25\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.5.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-14 00:07:52\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-13 12:51:07\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-28 11:29:02\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-26 02:00:05\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-10 05:23:57\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-13 06:26:11\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-11 10:58:49\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-28 13:08:25\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-12 21:06:55\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-13 06:41:57\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-04 06:10:33\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.3-RC/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-19 16:39:25\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-19 21:32:12\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-13 12:43:00\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/es_GT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-16 17:35:43\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-12 11:11:25\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-23 22:05:23\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-20 14:58:27\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-09 10:11:54\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-11 07:33:47\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-15 18:57:20\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-15 09:40:08\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.3.4\";s:7:\"updated\";s:19:\"2015-09-24 15:25:30\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.4/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-22 23:06:30\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-16 13:14:11\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-13 11:24:52\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-07 12:13:44\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-11 06:46:15\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-04 07:13:54\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-06 22:14:55\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-02 15:13:48\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-16 12:36:18\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-27 00:36:15\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-11 09:29:35\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-08 02:07:38\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-10 06:34:16\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-12 13:55:28\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-16 06:42:31\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-06 05:52:25\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.11\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.11/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-13 12:35:50\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-13 08:12:50\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.4.3\";s:7:\"updated\";s:19:\"2016-01-20 13:35:50\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.4.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-11 07:36:04\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-25 06:38:00\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.5.2/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-13 17:52:25\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.11\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.11/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-16 13:40:41\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-27 18:35:51\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-06-20 07:40:08\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-13 18:04:14\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-29 09:53:12\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-11-26 00:00:18\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-09 09:01:28\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-10 08:00:57\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-14 14:47:49\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-22 14:05:41\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-11-27 15:51:36\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-21 01:31:12\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-31 09:50:18\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-05-23 09:33:59\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.5.2/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-09 01:01:25\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-17 03:29:01\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.5.2\";s:7:\"updated\";s:19:\"2016-04-12 09:08:07\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "yes");
INSERT INTO `wp_options` VALUES("132", "WPLANG", "ja", "yes");
INSERT INTO `wp_options` VALUES("135", "_site_transient_timeout_wporg_theme_feature_list", "1467089703", "yes");
INSERT INTO `wp_options` VALUES("136", "_site_transient_wporg_theme_feature_list", "a:4:{s:6:\"Colors\";a:15:{i:0;s:5:\"black\";i:1;s:4:\"blue\";i:2;s:5:\"brown\";i:3;s:4:\"gray\";i:4;s:5:\"green\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:3:\"red\";i:9;s:6:\"silver\";i:10;s:3:\"tan\";i:11;s:5:\"white\";i:12;s:6:\"yellow\";i:13;s:4:\"dark\";i:14;s:5:\"light\";}s:6:\"Layout\";a:9:{i:0;s:12:\"fixed-layout\";i:1;s:12:\"fluid-layout\";i:2;s:17:\"responsive-layout\";i:3;s:10:\"one-column\";i:4;s:11:\"two-columns\";i:5;s:13:\"three-columns\";i:6;s:12:\"four-columns\";i:7;s:12:\"left-sidebar\";i:8;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:8:\"blavatar\";i:2;s:10:\"buddypress\";i:3;s:17:\"custom-background\";i:4;s:13:\"custom-colors\";i:5;s:13:\"custom-header\";i:6;s:11:\"custom-menu\";i:7;s:12:\"editor-style\";i:8;s:21:\"featured-image-header\";i:9;s:15:\"featured-images\";i:10;s:15:\"flexible-header\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:3:{i:0;s:7:\"holiday\";i:1;s:13:\"photoblogging\";i:2;s:8:\"seasonal\";}}", "yes");
INSERT INTO `wp_options` VALUES("183", "wdev-frash", "a:3:{s:7:\"plugins\";a:1:{s:23:\"wp-smushit/wp-smush.php\";i:1467079281;}s:5:\"queue\";a:1:{s:32:\"fc50097023d0d34c5a66f6cddcf77694\";a:3:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:4:\"rate\";s:7:\"show_at\";i:1467684081;}}s:4:\"done\";a:1:{i:0;a:6:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:5:\"email\";s:7:\"show_at\";i:1467079281;s:5:\"state\";s:6:\"ignore\";s:4:\"hash\";s:32:\"fc50097023d0d34c5a66f6cddcf77694\";s:10:\"handled_at\";i:1467079626;}}}", "yes");
INSERT INTO `wp_options` VALUES("184", "wp-smush-version", "2.3.1", "yes");
INSERT INTO `wp_options` VALUES("158", "ewww_image_optimizer_bulk_attachments", "", "no");
INSERT INTO `wp_options` VALUES("159", "ewww_image_optimizer_flag_attachments", "", "no");
INSERT INTO `wp_options` VALUES("160", "ewww_image_optimizer_ngg_attachments", "", "no");
INSERT INTO `wp_options` VALUES("161", "ewww_image_optimizer_aux_attachments", "", "no");
INSERT INTO `wp_options` VALUES("162", "ewww_image_optimizer_defer_attachments", "", "no");
INSERT INTO `wp_options` VALUES("137", "recently_activated", "a:2:{s:53:\"wordpress-flash-uploader/wordpress-flash-uploader.php\";i:1467109762;s:23:\"lazy-load/lazy-load.php\";i:1467108417;}", "yes");
INSERT INTO `wp_options` VALUES("138", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1467089825", "yes");
INSERT INTO `wp_options` VALUES("139", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5926\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3671\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3617\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3136\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2807\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2399\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2226\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2104\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"2052\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"2039\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1995\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1938\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1875\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"1756\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1694\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1591\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1547\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1402\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1320\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1291\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1232\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1117\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1093\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:4:\"1009\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"997\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"987\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"927\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"918\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"917\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"915\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"914\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"842\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"836\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"799\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"782\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"776\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"763\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"762\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"758\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"754\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"751\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"745\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"712\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"704\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"696\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"695\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"693\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"692\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"668\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"667\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"653\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"647\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"617\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"614\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"606\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"602\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"599\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"598\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"591\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"583\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"579\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"571\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"565\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"557\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"556\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"543\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"538\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"525\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"523\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"517\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"516\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"515\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"511\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"508\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"486\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"470\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"465\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"464\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"463\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"455\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"447\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"445\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"435\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"428\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"424\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"423\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"423\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"421\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"414\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"413\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"410\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"407\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"405\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"405\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"403\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"403\";}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";s:3:\"400\";}s:7:\"profile\";a:3:{s:4:\"name\";s:7:\"profile\";s:4:\"slug\";s:7:\"profile\";s:5:\"count\";s:3:\"395\";}s:4:\"text\";a:3:{s:4:\"name\";s:4:\"text\";s:4:\"slug\";s:4:\"text\";s:5:\"count\";s:3:\"395\";}s:8:\"linkedin\";a:3:{s:4:\"name\";s:8:\"linkedin\";s:4:\"slug\";s:8:\"linkedin\";s:5:\"count\";s:3:\"394\";}}", "yes");
INSERT INTO `wp_options` VALUES("188", "_transient_timeout_wp-smush-bulk_sent_count", "1467079342", "no");
INSERT INTO `wp_options` VALUES("189", "_transient_wp-smush-bulk_sent_count", "0", "no");
INSERT INTO `wp_options` VALUES("192", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:3:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:62:\"https://downloads.wordpress.org/release/ja/wordpress-4.5.3.zip\";s:6:\"locale\";s:2:\"ja\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:62:\"https://downloads.wordpress.org/release/ja/wordpress-4.5.3.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.5.3\";s:7:\"version\";s:5:\"4.5.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.5.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.5.3-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.5.3-partial-2.zip\";s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.5.3\";s:7:\"version\";s:5:\"4.5.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:5:\"4.5.2\";}i:2;O:8:\"stdClass\":12:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.5.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.5.3-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.5.3-partial-2.zip\";s:8:\"rollback\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.5.3-rollback-2.zip\";}s:7:\"current\";s:5:\"4.5.3\";s:7:\"version\";s:5:\"4.5.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:5:\"4.5.2\";s:12:\"notify_email\";s:1:\"1\";s:9:\"new_files\";s:0:\"\";}}s:12:\"last_checked\";i:1467085108;s:15:\"version_checked\";s:5:\"4.5.2\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("208", "siteguard_config", "a:31:{s:18:\"show_admin_notices\";s:1:\"0\";s:25:\"admin_filter_exclude_path\";s:25:\"css,images,admin-ajax.php\";s:19:\"admin_filter_enable\";s:1:\"0\";s:16:\"renamelogin_path\";s:11:\"login_24362\";s:18:\"renamelogin_enable\";s:1:\"1\";s:14:\"captcha_enable\";s:1:\"1\";s:13:\"captcha_login\";s:1:\"1\";s:15:\"captcha_comment\";s:1:\"1\";s:18:\"captcha_lostpasswd\";s:1:\"1\";s:18:\"captcha_registuser\";s:1:\"1\";s:16:\"same_login_error\";s:1:\"1\";s:16:\"loginlock_enable\";s:1:\"1\";s:18:\"loginlock_interval\";s:1:\"5\";s:19:\"loginlock_threshold\";s:1:\"3\";s:17:\"loginlock_locksec\";s:2:\"60\";s:19:\"loginlock_fail_once\";s:1:\"0\";s:20:\"fail_once_admin_only\";s:1:\"1\";s:17:\"loginalert_enable\";s:1:\"1\";s:21:\"loginalert_admin_only\";s:1:\"1\";s:18:\"loginalert_subject\";s:43:\"%SITENAME%にログインがありました\";s:15:\"loginalert_body\";s:208:\"%DATE% %TIME%に%USERNAME%がログインしました。\n\n== ログイン情報 ==\nIPアドレス：%IPADDRESS%\nリファラー：%REFERER%\nユーザーエージェント：%USERAGENT%\n\n--\nSiteGuard WP Plugin\";s:23:\"disable_pingback_enable\";s:1:\"1\";s:23:\"waf_exclude_rule_enable\";s:1:\"0\";s:16:\"waf_exclude_rule\";a:0:{}s:13:\"notify_wpcore\";s:1:\"1\";s:14:\"notify_plugins\";s:1:\"2\";s:13:\"notify_themes\";s:1:\"2\";s:8:\"notified\";a:3:{s:4:\"core\";s:0:\"\";s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:15:\"last_check_time\";i:1467275671;s:21:\"updates_notify_enable\";s:1:\"1\";s:7:\"version\";s:5:\"1.2.5\";}", "yes");
INSERT INTO `wp_options` VALUES("142", "autoptimize_version", "2.0.0", "yes");
INSERT INTO `wp_options` VALUES("145", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("146", "akismet_strictness", "0", "yes");
INSERT INTO `wp_options` VALUES("147", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `wp_options` VALUES("148", "wordpress_api_key", "e560a122af2d", "yes");
INSERT INTO `wp_options` VALUES("168", "ewww_image_optimizer_png_level", "10", "yes");
INSERT INTO `wp_options` VALUES("169", "ewww_image_optimizer_gif_level", "10", "yes");
INSERT INTO `wp_options` VALUES("170", "ewww_image_optimizer_pdf_level", "0", "yes");
INSERT INTO `wp_options` VALUES("171", "ewww_image_optimizer_version", "285.0", "yes");
INSERT INTO `wp_options` VALUES("185", "wp-smush-skip-redirect", "1", "yes");
INSERT INTO `wp_options` VALUES("187", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1467085109;s:7:\"checked\";a:3:{s:13:\"twentyfifteen\";s:3:\"1.5\";s:14:\"twentyfourteen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.2\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("195", "ossdl_off_cdn_url", "http://demo.sample100.jetboy.jp", "yes");
INSERT INTO `wp_options` VALUES("196", "ossdl_off_include_dirs", "wp-content,wp-includes", "yes");
INSERT INTO `wp_options` VALUES("197", "ossdl_off_exclude", ".php", "yes");
INSERT INTO `wp_options` VALUES("198", "ossdl_cname", "", "yes");
INSERT INTO `wp_options` VALUES("199", "wp_super_cache_index_detected", "3", "yes");
INSERT INTO `wp_options` VALUES("200", "wpsupercache_start", "1467079312", "yes");
INSERT INTO `wp_options` VALUES("201", "wpsupercache_count", "0", "yes");
INSERT INTO `wp_options` VALUES("202", "wpsupercache_gc_time", "1467348596", "yes");
INSERT INTO `wp_options` VALUES("204", "supercache_stats", "a:3:{s:9:\"generated\";i:1467111320;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:12:\"expired_list\";a:0:{}s:6:\"cached\";i:0;s:11:\"cached_list\";a:0:{}s:2:\"ts\";i:1467111320;}s:7:\"wpcache\";a:3:{s:6:\"cached\";i:0;s:7:\"expired\";i:0;s:5:\"fsize\";s:3:\"0KB\";}}", "yes");
INSERT INTO `wp_options` VALUES("205", "_transient_is_multi_author", "0", "yes");
INSERT INTO `wp_options` VALUES("206", "_transient_twentysixteen_categories", "1", "yes");
INSERT INTO `wp_options` VALUES("211", "_transient_timeout_feed_ab995de7a5278071ed721c721c891aed", "1467122821", "no");
INSERT INTO `wp_options` VALUES("212", "_transient_feed_ab995de7a5278071ed721c721c891aed", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"日本語\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://ja.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress 日本語ローカルサイトブログ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2016 08:27:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"ja\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.6-alpha-37876\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress 4.5.3 メンテナンス・セキュリティリリース\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://ja.wordpress.org/2016/06/22/wordpress-4-5-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jun 2016 23:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3946\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"WordPress 4.5.3 がご利用いただけるようになりました。これは過去のバージョンすべてに対するセキュリティリリースであり、サイトを今すぐに更新することを強くおすすめします。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4438:\"<p>以下は、<a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/06/wordpress-4-5-3/\"> Maintenance and Security Release</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<hr />\n<p>WordPress 4.5.3 がご利用いただけるようになりました。これは過去のバージョンすべてに対する<strong>セキュリティリリース</strong>であり、サイトを今すぐに更新することを強くおすすめします。</p>\n<p>WordPress 4.5.2 およびそれ以前のバージョンは複数のセキュリティ問題に影響を受けています。カスタマイザーでのリダイレクトバイパス (報告: <a href=\"http://yassineaboukir.com/\">Yassine Aboukir</a>)、添付ファイル名称を通じた2件の異なる XSS 問題 (報告者: <a href=\"https://klikki.fi/\">Jouko Pynnönen</a>、<a href=\"https://twitter.com/divy_er\">Divyesh Prajapati</a>)、リビジョン履歴情報の露見 (報告者: WordPress セキュリティチーム <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>、Dan Moen 各氏によりそれぞれ)、oEmbed DoS (報告者: Automattic の Jennifer Dodd)、権限がない投稿からのカテゴリー削除 (報告者: <a href=\"https://www.alleyinteractive.com/\">Alley Interactive</a> の David Herrera)、盗まれた Cookie に依るパスワードの変更 (報告者: WordPress セキュリティチーム <a href=\"https://blogwaffe.com/\">Michael Adams</a> )、比較的安全性の低い <code>sanitize_file_name</code> エッジケース数個 (報告者: WordPress セキュリティチーム <a href=\"http://peter.westwood.name/\">Peter Westwood</a>)。</p>\n<p>報告者の皆さん、<a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">責任ある情報公開</a>プロセスを実践していただきありがとうございます。</p>\n<p>上記のセキュリティ問題に加え、WordPress 4.5.3 では4.5、4.5.1、4.5.2 からの17件のバグを修正しました。詳しくは<a href=\"https://codex.wordpress.org/Version_4.5.3\">リリースノート</a>を読むか、<a href=\"https://core.trac.wordpress.org/query?milestone=4.5.3\">変更一覧</a>をご覧ください。</p>\n<p><a href=\"https://wordpress.org/download/\">WordPress 4.5.3 をダウンロードする</a>か、「ダッシュボード → 更新」画面から「今すぐ更新」をクリックしてください。自動バックグラウンド更新に対応しているサイトに対しては、すでに WordPress 4.5.3 への自動更新が始まっています。</p>\n<p>4.5.3 へ貢献してくれた皆さん、ありがとうございます。</p>\n<p><a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/neverything\">Silvan Hagen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>,  <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>,<a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordPress 4.5.2 セキュリティリリース\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://ja.wordpress.org/2016/05/07/wordpress-4-5-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 May 2016 00:16:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3926\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"WordPress 4.5.2 がご利用いただけるようになりました。これは以前のすべてのバージョンに対するセキュリティリリースであり、サイトを今すぐ更新することを強くおすすめします。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2942:\"<p>以下は、<a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandi</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/05/wordpress-4-5-2/\">WordPress 4.5.2 Security Release</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<p><ins datetime=\"2016-05-07T06:30:51+00:00\">（訳注: セキュリティ問題の報告者である Kinugawa 氏にご指摘いただき、SOME 脆弱性および反射型 XSS に関する訳を公開後に修正しました）</ins></p>\n<hr />\n<p>WordPress 4.5.2 がご利用いただけるようになりました。これは以前のすべてのバージョンに対する<strong>セキュリティリリース</strong>であり、サイトを今すぐ更新することを強くおすすめします。</p>\n<p>WordPress バージョン 4.5.1 およびそれ以前のバージョンは、WordPress がファイルアップロードのために使っているサードパーティライブラリである Plupload を通して SOME (Same Origin Method Execution) 脆弱性にさらされています。WordPress バージョン 4.2 から 4.5.1 は、MediaElement.js を利用して特別に作った URI を使う、反射型 XSS 攻撃に対する脆弱性があります。MediaElement.js は、メディアプレイヤー用のサードパーティライブラリです。MediaElement.js および Plupload は、いずれもこの問題を修正する更新をリリースしています</p>\n<p>これらの問題は両方とも、<a href=\"https://cure53.de/\">Cure53</a> の Mario Heiderich、Masato Kinugawa、Filedescriptor によって分析・報告されました。<a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">責任ある情報公開</a>プロセスに従ってくれた彼らと、問題を修正するために私達と密接に協力してくれた Plupload、MediaElement.js チームに感謝します。</p>\n<p><a href=\"https://wordpress.org/download/\">WordPress 4.5.2 をダウンロード</a>するか、「ダッシュボード → 更新」に移動して「今すぐ更新」をクリックしてください。自動バックグラウンド更新に対応しているサイトは、順次 WordPress 4.5.2 への自動更新が始まるはずです。</p>\n<p>さらに、広範に公開された ImageMagick 画像処理ライブラリの脆弱性も複数存在しています。このライブラリは、WordPress に対応した多くのホスティングサービスにおいて使われています。これらの問題に対する私達の現在の反応については、<a href=\"https://make.wordpress.org/core/2016/05/06/imagemagick-vulnerability-information/\">コア開発ブログのこの投稿</a>をご覧ください。</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordPress 4.5.1 メンテナンスリリース\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://ja.wordpress.org/2016/04/27/wordpress-4-5-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Apr 2016 01:38:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3919\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"12件のバグを修正した WordPress 4.5.1 がご利用いただけるようになりました。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2743:\"<p>以下は、<a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/04/wordpress-4-5-1-maintenance-release/\">WordPress 4.5.1 Maintenance Release</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<hr />\n<p>WordPress 4.5 が600万ダウンロードを超えた今、メンテナンスリリースである WordPress 4.5.1 の公開をお知らせできることを嬉しく思います。</p>\n<p>このリリースではバージョン 4.5 のバグを12件修正しました。その中で特に大きなものとしては Twenty Eleven テーマをベースにしたサイトに影響を与える class の問題、特定の Chrome バージョンとビジュアルエディターの互換性問題、そしてメディアアップロードに影響を与える Imagick のバグが含まれています。追加情報については<a href=\"https://codex.wordpress.org/Version_4.5.1\">リリースノート</a>をご覧いただくか、<a href=\"https://core.trac.wordpress.org/log/branches/4.5?rev=37295&amp;stop_rev=37182\">変更一覧</a>をご確認ください。</p>\n<p><a href=\"https://wordpress.org/download/\">WordPress 4.5.1 をダウンロード</a>するか、「ダッシュボード → 更新」に移動して「今すぐ更新」をクリックしてください。自動バックグラウンド更新に対応しているサイトは、順次 WordPress 4.5.1 への自動更新が始まるはずです。</p>\n<p>4.5.1 に貢献してくださった皆さん、ありがとうございました。</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandi</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/WiZZarD_\">Pieter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.5 “コールマン”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://ja.wordpress.org/2016/04/14/wordpress-4-5-coleman/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Apr 2016 03:05:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3885\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:400:\"ジャズ・サキソフォーン奏者コールマン・ホーキンスに敬意を表して名付けられた WordPress バージョン 4.5「コールマン」のダウンロードおよび WordPress ダッシュボードからの更新が可能になりました。4.5 の新しい機能は、執筆中にもサイト構築においてもワークフローの無駄をなくしてくれます。\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:31709:\"<p>以下は、<a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/04/coleman/\">WordPress 4.5 “Coleman”</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<p><strong>注:</strong> 一部の環境でアップグレード後に <a href=\"https://ja.forums.wordpress.org/topic/158985?replies=16\">Fatal error が出るという報告</a>があります。<a href=\"https://ja.forums.wordpress.org/topic/158991?replies=1\">対策はこちら</a>をご覧ください。</p>\n<hr />\n<p>ジャズ・サキソフォーン奏者コールマン・ホーキンスに敬意を表して名付けられた WordPress バージョン 4.5「コールマン」のダウンロードおよび WordPress ダッシュボードからの更新が可能になりました。4.5 の新しい機能は、執筆中にもサイト構築においてもワークフローの無駄をなくしてくれます。</p>\n<p><iframe width=\'692\' height=\'388\' src=\'https://videopress.com/embed/scFdjVo6?hd=1&amp;defaultLangCode=ja\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>\n<hr />\n<h2>編集の改善</h2>\n<p><img class=\"aligncenter size-full wp-image-4220\" src=\"https://wordpress.org/news/files/2016/04/illustration-short-inlinelinks.png\" alt=\"インラインリンクのイラスト\" width=\"1000\" height=\"400\" /></p>\n<h3>インラインでのリンク</h3>\n<p>さらに無駄を排除したインターフェースで、移動することなく簡単にコンテンツにリンクできるようになりました。執筆に集中できます。</p>\n<p><img class=\"aligncenter size-full wp-image-4265\" src=\"https://wordpress.org/news/files/2016/04/editing-shortcuts-big.gif\" alt=\"書式ショートカット\" width=\"960\" height=\"576\" /></p>\n<h3>書式ショートカット</h3>\n<p>リストや見出しに書式ショートカットを活用していますか ? 水平線と <code>&lt;code&gt;</code> が追加され、さらに便利になりました。</p>\n<hr />\n<h2>カスタマイズの改善</h2>\n<p><img class=\"aligncenter size-full wp-image-4221\" src=\"https://wordpress.org/news/files/2016/04/illustration-short-responsive-preview.png\" alt=\"illustration-short-responsive-preview\" width=\"1000\" height=\"400\" /></p>\n<h3>ライブレスポンシブプレビュー</h3>\n<p>サイトがどんな画面でもきれいに表示されるよう、確認しましょう。カスタマイザー内から直接、モバイル・タブレット・デスクトップ表示をプレビューできるようになりました。</p>\n<p><img class=\"aligncenter wp-image-4239 size-full\" src=\"https://wordpress.org/news/files/2016/04/illustration-short-customlogo-whitespace.png\" width=\"1000\" height=\"440\" /></p>\n<h3>カスタムロゴ</h3>\n<p>テーマが企業やブランドのロゴ追加に対応できるようになりました。Twenty Fifteen または Twenty Sixteen テーマを有効化して、カスタマイザーの「サイト基本情報」セクションでお試しください。</p>\n<hr />\n<h2>開発者向けの変更</h2>\n<div class=\"under-the-hood three-col\">\n<div class=\"col\">\n<h3>高性能な画像リサイズ</h3>\n<p>生成された画像が、目に見える品質の劣化なく最大50倍のスピードで読み込まれるようになりました。<a href=\"https://make.wordpress.org/core/2016/03/12/performance-improvements-for-images-in-wordpress-4-5/\">すごい</a> !</p>\n</div>\n<div class=\"col\">\n<h3>選択的更新</h3>\n<p>カスタマイザーが<a href=\"https://make.wordpress.org/core/2016/02/16/selective-refresh-in-the-customizer/\">包括フレームワーク</a>に対応し、JavaScript 内の PHP コードをリライトすることなくプレビューの一部をレンダリングできるようになりました。</p>\n</div>\n<div class=\"col\">\n<h3>スクリプトローダーの改善</h3>\n<p>スクリプトヘッダーおよびフッター依存への対応改善を追加しました。新しい <code><a href=\"https://make.wordpress.org/core/2016/03/08/enhanced-script-loader-in-wordpress-4-5/\">wp_add_inline_script()</a></code> は、登録されたスクリプトにコードを追加できるようにします。</p>\n<h3>埋め込みテンプレートの改善</h3>\n<p>埋め込みテンプレートを複数のパーツに分割し、テンプレート階層に従って<a href=\"https://make.wordpress.org/core/2016/03/11/embeds-changes-in-wordpress-4-5/\">テーマが直接上書き</a>できるようになりました。</p>\n<h3>JavaScript ライブラリの更新</h3>\n<p>jQuery 1.12.3と jQuery Migrate 1.4.0、Backbone 1.2.3、Underscore 1.8.3が同梱されています。</p>\n</div>\n</div>\n<div class=\"under-the-hood two-col\"></div>\n<hr />\n<h2>チーム</h2>\n<p><a class=\"alignleft\" href=\"https://profiles.wordpress.org/mikeschroder\"><img id=\"grav-76424a001dc6b3ebb4faca0c567800c4-0\" class=\"grav-hashed\" src=\"https://www.gravatar.com/avatar/76424a001dc6b3ebb4faca0c567800c4?d=mm&amp;s=180&amp;r=G\" alt=\"Mike Schroder\" width=\"80\" height=\"80\" /></a>このリリースは <a href=\"https://getsource.net/\">Mike Schroder</a> がリードを、<a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein </a>がリリース補佐を、そして <a href=\"https://choycedesign.com/\">Mel Choyce</a> がリリースデザインリードを務め、以下に記したすばらしい皆さんの手助けによって完成しました。今回のリリースでは、props を受けた貢献者は227人いました。コールマン・ホーキンスの曲をお好みの音楽サービスで聴きながら、以下の方たちのプロフィールをいくつか眺めてみませんか。<br />\n<a href=\"https://profiles.wordpress.org/mercime\">@mercime</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/uglyrobot\">Aaron Edwards</a>, <a href=\"https://profiles.wordpress.org/ahockley\">Aaron Hockley</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abiralneupane\">Abiral Neupane</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/aidanlane\">aidanlane</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/ambrosey\">ambrosey</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andg\">Andrea Gandino</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rockwell15\">Andrew Rockwell</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/apaliku\">apaliku</a>, <a href=\"https://profiles.wordpress.org/aramzs\">Aram Zucker-Scharff</a>, <a href=\"https://profiles.wordpress.org/ashmatadeen\">ash.matadeen</a>, <a href=\"https://profiles.wordpress.org/bappidgreat\">Ashok Kumar Nath</a>, <a href=\"https://profiles.wordpress.org/bandonrandon\">BandonRandon</a>, <a href=\"https://profiles.wordpress.org/barryceelen\">Barry Ceelen</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/berengerzyla\">berengerzyla</a>, <a href=\"https://profiles.wordpress.org/neoxx\">Bernhard Riedl</a>, <a href=\"https://profiles.wordpress.org/thisisit\">Bhushan S. Jawle</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/williamsba1\">Brad Williams</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/thebrandonallen\">Brandon Allen</a>, <a href=\"https://profiles.wordpress.org/bhubbard\">Brandon Hubbard</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/borgesbruno\">Bruno Borges</a>, <a href=\"https://profiles.wordpress.org/chmac\">Callum Macdonald</a>, <a href=\"https://profiles.wordpress.org/camikaos\">Cami Kaos</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/mackensen\">Charles Fulton</a>, <a href=\"https://profiles.wordpress.org/chetanchauhan\">Chetan Chauhan</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrico\">ChriCo</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/chris_dev\">Chris Mok</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/ckoerner\">ckoerner</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/compute\">Compute</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">d4z_c0nf</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/scarinessreported\">Daniel Bailey</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/diddledan\">Daniel Llewellyn</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/danielpataki\">danielpataki</a>, <a href=\"https://profiles.wordpress.org/dvankooten\">Danny van Kooten</a>, <a href=\"https://profiles.wordpress.org/thewanderingbrit\">Dave Clements</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dbrumbaugh10up\">David Brumbaugh</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dnewton\">David Newton</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide &#8216;Folletto&#8217; Casali</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dossy\">Dossy Shiobara</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/drebbitsweb\">Dreb Bits</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duaneblake\">duaneblake</a>, <a href=\"https://profiles.wordpress.org/kucrut\">Dzikri Aziz</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/codex-m\">Emerson Maningo</a>, <a href=\"https://profiles.wordpress.org/enej\">enej</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericdaams\">Eric Daams</a>, <a href=\"https://profiles.wordpress.org/ethitter\">Erick Hitter</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/faishal\">faishal</a>, <a href=\"https://profiles.wordpress.org/fantasyworld\">fantasyworld</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/finnj\">finnj</a>, <a href=\"https://profiles.wordpress.org/firebird75\">firebird75</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fusillicode\">fusillicode</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/garusky\">Giuseppe Mamone</a>, <a href=\"https://profiles.wordpress.org/jubstuff\">Giustino Borzacchiello</a>, <a href=\"https://profiles.wordpress.org/grantpalin\">Grant Palin</a>, <a href=\"https://profiles.wordpress.org/groovecoder\">groovecoder</a>, <a href=\"https://profiles.wordpress.org/wido\">Guido Scialfa</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/hakre\">hakre</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/iamntz\">Ionut Staicu</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/jamesdigioia\">James DiGioia</a>, <a href=\"https://profiles.wordpress.org/jason_the_adams\">Jason</a>, <a href=\"https://profiles.wordpress.org/jaspermdegroot\">Jasper de Groot</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeffpyebrookcom\">Jeffrey Schutzman</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/ardathksheyna\">Jess G.</a>, <a href=\"https://profiles.wordpress.org/boluda\">Joan Boluda</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelerr\">joelerr</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnnypea\">JohnnyPea</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/keraweb\">Jory Hogeveen</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/joshlevinson\">Josh Levinson</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/jrchamp\">jrchamp</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/katieburch\">katieburch</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kiranpotphode\">Kiran Potphode</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/krissiev\">KrissieV</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/leemon\">leemon</a>, <a href=\"https://profiles.wordpress.org/layotte\">Lew Ayotte</a>, <a href=\"https://profiles.wordpress.org/liamdempsey\">Liam Dempsey</a>, <a href=\"https://profiles.wordpress.org/luan-ramos\">Luan Ramos</a>, <a href=\"https://profiles.wordpress.org/luciole135\">luciole135</a>, <a href=\"https://profiles.wordpress.org/lpawlik\">Lukas Pawlik</a>, <a href=\"https://profiles.wordpress.org/latz\">Lutz Schröer</a>, <a href=\"https://profiles.wordpress.org/madvic\">madvic</a>, <a href=\"https://profiles.wordpress.org/marcochiesi\">Marco Chiesi</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/mark8barnes\">Mark Barnes</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/gitlost\">Martin Burke</a>, <a href=\"https://profiles.wordpress.org/mattfelten\">Matt Felten</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattgeri\">MattGeri</a>, <a href=\"https://profiles.wordpress.org/wp-architect\">Matthew Ell</a>, <a href=\"https://profiles.wordpress.org/maweder\">maweder</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mcapybara\">mcapybara</a>, <a href=\"https://profiles.wordpress.org/mehulkaklotar\">Mehul Kaklotar</a>, <a href=\"https://profiles.wordpress.org/meitar\">Meitar</a>, <a href=\"https://profiles.wordpress.org/mensmaximus\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/micropat\">micropat</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Mika Epstein</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/usermrpapa\">Mr Papa</a>, <a href=\"https://profiles.wordpress.org/mwidmann\">mwidmann</a>, <a href=\"https://profiles.wordpress.org/nexurium\">nexurium</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/nicdford\">Nic Ford</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/ninos-ego\">Ninos</a>, <a href=\"https://profiles.wordpress.org/oaron\">oaron</a>, <a href=\"https://profiles.wordpress.org/overclokk\">overclokk</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/obrienlabs\">Pat O&#8217;Brien</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pauldewouters\">Paul de Wouters</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/perezlabs\">Perez Labs</a>, <a href=\"https://profiles.wordpress.org/gungeekatx\">Pete Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/cadeyrn\">petermolnar</a>, <a href=\"https://profiles.wordpress.org/walbo\">Petter Walbø Johnsgård</a>, <a href=\"https://profiles.wordpress.org/wizzard_\">Pieter</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/ptahdunbar\">Pirate Dunbar</a>, <a href=\"https://profiles.wordpress.org/prettyboymp\">prettyboymp</a>, <a href=\"https://profiles.wordpress.org/profforg\">Profforg</a>, <a href=\"https://profiles.wordpress.org/programmin\">programmin</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahalaboulfeth\">rahal.aboulfeth</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/lamosty\">Rastislav Lamos</a>, <a href=\"https://profiles.wordpress.org/rickalee\">Ricky Lee Whittemore</a>, <a href=\"https://profiles.wordpress.org/ritteshpatel\">Ritesh Patel</a>, <a href=\"https://profiles.wordpress.org/rob\">rob</a>, <a href=\"https://profiles.wordpress.org/rogerhub\">Roger Chen</a>, <a href=\"https://profiles.wordpress.org/romsocial\">RomSocial</a>, <a href=\"https://profiles.wordpress.org/ruudjoyo\">Ruud Laan</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sagarjadhav\">Sagar Jadhav</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/salvoaranzulla\">salvoaranzulla</a>, <a href=\"https://profiles.wordpress.org/samhotchkiss\">Sam Hotchkiss</a>, <a href=\"https://profiles.wordpress.org/rosso99\">Sara Rosso</a>, <a href=\"https://profiles.wordpress.org/sarciszewski\">sarciszewski</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scottbrownconsulting\">scottbrownconsulting</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergejmueller\">Sergej Müller</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shamess\">Shane</a>, <a href=\"https://profiles.wordpress.org/shinichin\">Shinichi Nishikawa</a>, <a href=\"https://profiles.wordpress.org/sidati\">sidati</a>, <a href=\"https://profiles.wordpress.org/siobhan\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/aargh-a-knot\">sky</a>, <a href=\"https://profiles.wordpress.org/slushman\">slushman</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/stephanethomas\">stephanethomas</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/charlestonsw\">Store Locator Plus</a>, <a href=\"https://profiles.wordpress.org/subharanjan\">Subharanjan</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/tacoverdo\">Taco Verdonschot</a>, <a href=\"https://profiles.wordpress.org/tahteche\">tahteche</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/takayukister\">Takayuki Miyoshi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/themiked\">theMikeD</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timplunkett\">timplunkett</a>, <a href=\"https://profiles.wordpress.org/tmuikku\">tmuikku</a>, <a href=\"https://profiles.wordpress.org/skithund\">Toni Viemerö</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/rilwis\">Tran Ngoc Tuan Anh</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/vhomenko\">vhomenko</a>, <a href=\"https://profiles.wordpress.org/virgodesign\">virgodesign</a>, <a href=\"https://profiles.wordpress.org/vladolaru\">vlad.olaru</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vtieu\">vtieu</a>, <a href=\"https://profiles.wordpress.org/webaware\">webaware</a>, <a href=\"https://profiles.wordpress.org/wesleye\">Wesley Elfring</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wisdmlabs\">WisdmLabs</a>, <a href=\"https://profiles.wordpress.org/wpdelighter\">WP Delighter</a>, <a href=\"https://profiles.wordpress.org/xavortm\">xavortm</a>, <a href=\"https://profiles.wordpress.org/yetanotherdaniel\">yetAnotherDaniel</a>, and <a href=\"https://profiles.wordpress.org/zinigor\">zinigor</a>.</p>\n<p>&nbsp;</p>\n<p>リリース動画を制作した <a href=\"http://siobhanmckeown.com/\">Siobhan McKeown</a> と、ナレーションを担当した <a href=\"https://jacklenox.com/\">Jack Lenox</a> に深く感謝します。</p>\n<p>最後に、このリリースのために翻訳を提供してくれた貢献者の皆さんに感謝します。WordPress 4.5 は44の言語に完全に翻訳されており、リリース動画の字幕は32言語に翻訳されました。</p>\n<p>情報を追いたい、または手伝いたい、という方は <a href=\"https://make.wordpress.org/\">Make WordPress</a> と<a href=\"https://make.wordpress.org/core/\">コア開発ブログ</a>を見てみてください。WordPress を選んでいただき、ありがとうございます。バージョン 4.6 でまたお会いしましょう！</p>\n<hr />\n<h2>日本語コミュニティ貢献者</h2>\n<p>以下、WordPress 4.5 日本語版リリースまでのサイクルの日本語コミュニティ貢献者の方々です。ありがとうございました！</p>\n<h3>WordPress 4.5 日本語版リリースリーダー</h3>\n<p><a href=\"https://profiles.wordpress.org/Nao\">Naoko Takano</a></p>\n<h3>WordPress 4.5 日本語版翻訳</h3>\n<p><a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/extendwings/\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/hnle/\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/caseyjp/\">caseyjp</a>, <a href=\"https://profiles.wordpress.org/odysseygate/\">odyssey</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>, <a href=\"https://profiles.wordpress.org/tg29359/\">tg29359</a></p>\n<h3>WordPress 4.5 日本語版 /WP Multibyte Patch 動作テスト</h3>\n<p><a href=\"https://profiles.wordpress.org/tenpura/\">Seisuke Kuraishi (tenpura)</a>, <a href=\"https://profiles.wordpress.org/Nao\">Naoko Takano</a></p>\n<h3>日本語フォーラム</h3>\n<p><a href=\"https://profiles.wordpress.org/digitmaetel\">digit @maetel</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/nobita\">nobita</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/jim912\">jim912</a>, <a href=\"https://profiles.wordpress.org/mura0403\">mura0403</a>, <a href=\"https://profiles.wordpress.org/ikaring\">ikaring</a>, <a href=\"https://profiles.wordpress.org/tg29359\">tg29359</a>, <a href=\"https://profiles.wordpress.org/takayukister\">Takayuki Miyoshi</a>, <a href=\"https://profiles.wordpress.org/rocketmartue\">RocketMartue</a>, <a href=\"https://profiles.wordpress.org/andante0727\">Tsuyoshi</a>, <a href=\"https://profiles.wordpress.org/tenpura\">Seisuke Kuraishi (tenpura)</a>, <a href=\"https://profiles.wordpress.org/inc2734\">Takashi Kitajima</a>, <a href=\"https://profiles.wordpress.org/kuck1u\">KUCKLU</a>, <a href=\"https://profiles.wordpress.org/ShinichiN\">Shinichi Nishikawa</a>, <a href=\"https://profiles.wordpress.org/npssl\">npssl</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a></p>\n<h3>Codex 日本語版</h3>\n<h4>システム管理、バグ報告</h4>\n<p><a href=\"https://profiles.wordpress.org/hiromasa/\">hiromasa</a>, <a href=\"https://profiles.wordpress.org/miccweb\">miccweb</a></p>\n<h4>翻訳、執筆</h4>\n<p><a title=\"利用者:Akira Tachibana\" href=\"https://wpdocs.osdn.jp/利用者:Akira_Tachibana\">Akira Tachibana</a>, <a title=\"利用者:Gblsm\" href=\"https://wpdocs.osdn.jp/利用者:Gblsm\">Gblsm</a>, <a title=\"利用者:Nao\" href=\"https://wpdocs.osdn.jp/利用者:Nao\">Nao</a>, <a title=\"利用者:Spicagraph\" href=\"https://wpdocs.osdn.jp/利用者:Spicagraph\">Spicagraph</a>, <a title=\"利用者:Miccweb\" href=\"https://wpdocs.osdn.jp/利用者:Miccweb\">Miccweb</a>‎, <a title=\"利用者:Gossk58\" href=\"https://wpdocs.osdn.jp/利用者:Gossk58\">Gossk58</a>,<a title=\"利用者:Mayuko\" href=\"https://wpdocs.osdn.jp/利用者:Mayuko\">Mayuko</a>‎, <a title=\"利用者:Hinaloe\" href=\"https://wpdocs.osdn.jp/利用者:Hinaloe\">Hinaloe</a>, <a title=\"利用者:Hideokamoto\" href=\"https://wpdocs.osdn.jp/利用者:Hideokamoto\">Hideokamoto</a>, <a title=\"利用者:Tai\" href=\"https://wpdocs.osdn.jp/利用者:Tai\">Tai</a></p>\n<h3>貢献者データ集計</h3>\n<p><a href=\"https://profiles.wordpress.org/nukaga\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/ounziw\">Fumito MIZUNO</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress 4.5 リリース候補 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://ja.wordpress.org/2016/04/10/wordpress-4-5-rc2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Apr 2016 06:48:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3879\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"WordPress 4.5 リリース候補の第2弾 (英語版) がご利用いただけるようになりました。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4387:\"<p>以下は、<a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/04/wordpress-4-5-rc2/\">WordPress 4.5 RC2</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<hr />\n<p>WordPress 4.5 リリース候補の第2弾 (英語版) がご利用いただけるようになりました。</p>\n<p>リリース候補 1 をリリースして以来、<a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37171&amp;stop_rev=37078&amp;limit=120&amp;verbose=on\">91個の変更</a>を加えました。</p>\n<p>リリース候補 (RC) とは「私達としては完成していると思うが、数千万人のユーザーと数千個のプラグインやテーマが存在している以上、何かを見逃している可能性がある」ということを意味しています。WordPress 4.5 を<strong>4月12日 (火)</strong>にリリースしたいと思っていますが、そのためにはみなさんの助けが必要です。</p>\n<p>まだバージョン 4.5 をテストしていない方には、今がチャンスです。</p>\n<p><strong>バグを見つけたと思った場合</strong>はサポートフォーラムの<a href=\"https://wordpress.org/support/forum/alphabeta\">アルファ・ベータエリア</a> (<a href=\"https://ja.forums.wordpress.org/forum/7\">日本語</a>) に投稿できます。既知のバグは<a href=\"https://core.trac.wordpress.org/report/5\">こちらで確認</a>できます。</p>\n<p>WordPress 4.5 をテストするには、<a href=\"https://ja.wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> プラグイン (「最新版ナイトリービルド」を選択) を利用するか、<a href=\"https://wordpress.org/wordpress-4.5-RC1.zip\">ベータ版の ZIP ファイルをこちらからダウンロード</a>してください。</p>\n<p>4.5 の新機能については、<a href=\"https://ja.wordpress.org/2016/02/27/wordpress-4-5-beta-1/\">ベータ 1</a>、<a href=\"https://ja.wordpress.org/2016/03/03/wordpress-4-5-beta-2/\">ベータ 2</a>、<a href=\"https://ja.wordpress.org/2016/03/11/wordpress-4-5-beta-3/\">ベータ 3</a>、<a href=\"https://ja.wordpress.org/2016/03/17/wordpress-4-5-beta-4/\">ベータ 4</a> のブログ記事をご覧ください。</p>\n<p><strong>開発者の皆さんへ。</strong>ご自分のプラグインやテーマを WordPress 4.5 でテストし、来週になる前にプラグインの Readme 内で <em>Tested up to</em> (最新の対応バージョン) を 4.5 に更新してください。皆さんが互換性の問題を発見した場合、何も壊したくはないので、最終リリースの前に問題を解決できるようサポートフォーラムに投稿してください。</p>\n<p><strong>翻訳者の皆さん</strong>、About ページを含め文字列は完全にフリーズされました。ぜひ翻訳を進めてください。</p>\n<p>リリース候補 1 以降の注意すべき変更は以下のとおりです。</p>\n<ul>\n<li>REST API インフラストラクチャー内でデータのエスケープを正規化。REST API インフラをお使いの場合は、<a href=\"https://make.wordpress.org/core/2016/04/06/rest-api-slashed-data-in-wordpress-4-4-and-4-5/\">この変更についての記事をご覧ください</a>。</li>\n<li>ウィジェットインスタンスのカスタマイザー設定が、ウィジェットインスタンス自体の登録より少し後に登録されるように修正。詳細は <a href=\"https://core.trac.wordpress.org/ticket/36431\">#36431</a> を参照。</li>\n<li>カスタムロゴ機能と Twenty Fifteen / Twenty Sixteen での画像切り抜きに関する各種の問題を修正。</li>\n</ul>\n<p><a href=\"https://make.wordpress.org/core/\">コア開発ブログをフォロー</a>するのをお忘れなく。<a href=\"https://make.wordpress.org/core/2016/03/30/wordpress-4-5-field-guide/\">4.5 リリース向けの「フィールドガイド」</a>もご用意しています。</p>\n<p><em>It’s great fun to test</em><br />\n<em>Enjoyment in another</em><br />\n<em>Release Candidate</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"コントリビューターウィークエンド: Global WordPress Translation Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://ja.wordpress.org/2016/04/09/contributor-weekend-global-wordpress-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 09 Apr 2016 00:36:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3870\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"Global WordPress Translation Day は、WordPress の翻訳に協力したいという新しいコントリビューターの手助けをするために設けられました。4月24日 (日) の日本時間午前9時からの開催となります。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4686:\"<p>以下は、<a href=\"https://profiles.wordpress.org/chanthaboune\">Josepha</a> が書いた WordPress.org 公式ブログの記事「<a href=\"https://wordpress.org/news/2016/04/contributor-weekend-global-wordpress-translation-day/\">Contributor Weekend: Global WordPress Translation Day</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<p>国内でもオンラインイベント、オフラインイベント (東京、京都、男木島、福岡）が開催される予定です。イベント開催または参加をご希望の方は、<a href=\"http://wordbench.org/2016/04/04/global-wordpress-translation-day/\">WordBench.org の記事</a>で詳細をご覧ください。</p>\n<hr />\n<p><a href=\"https://wptranslationday.org/\">Global WordPress Translation Day</a> (世界的 WordPress 翻訳の日)  は、WordPress プロジェクトの <a href=\"https://make.wordpress.org/polyglots\">Polyglots チーム</a>が運営するコントリビューター・イニシアチブです。この一日は、WordPress を現在使える160言語のうちのいずれかに翻訳したいという新しいコントリビューターの手助けをするために設けられました。</p>\n<p><a href=\"https://wptranslationday.org/\"><img class=\"aligncenter wp-image-3874 size-large\" src=\"https://ja.wordpress.org/files/2016/04/global-wordpress-translation-day-1024x515.png\" alt=\"Global WordPress Translation Day\" width=\"692\" height=\"348\" srcset=\"https://ja.wordpress.org/files/2016/04/global-wordpress-translation-day-1024x515.png 1024w, https://ja.wordpress.org/files/2016/04/global-wordpress-translation-day-300x151.png 300w, https://ja.wordpress.org/files/2016/04/global-wordpress-translation-day-768x386.png 768w\" sizes=\"(max-width: 692px) 100vw, 692px\" /></a></p>\n<p>Global WordPress Translation Day は、4月24日 (日) の 0:00 UTC (協定世界時、日本時間で同日の午前9時) にスタートし、すべてのタイムゾーンをカバーするため24時間続きます。</p>\n<h3>何をするのですか ?</h3>\n<ul>\n<li>ライブトレーニング: 24時間、ライブストリームでチュートリアルを開催します。さまざまな言語で、WordPress の翻訳やコードを翻訳可能にする方法などについて話します (30分〜1時間。一般的な方法や、その言語特有の指示など) 。国際化のセッションは英語で行われます。セッションは、WordPress の翻訳や国際化のエキスパートが担当します。スケジュールは<a href=\"https://wptranslationday.org/#schedule\">サイト</a>でご確認ください。</li>\n<li>ローカル開催のオフライン翻訳コントリビューターデイ: コントリビューターが各地に集まり、顔を合わせて翻訳を行います。</li>\n<li>ローカル開催のオンライン翻訳コントリビューターデイ: 一定の時間、オンラインで翻訳チームが新しいコントリビューターのオリエンテーションをしたり、文字列の翻訳を行います。</li>\n</ul>\n<p>もし地域で勉強会を開いている方は、コントリビューターデイを開催してみませんか。</p>\n<p><strong>このイニシアチブについて詳しく読み、<a href=\"https://make.wordpress.org/polyglots/2016/03/02/wordpress-global-translation-day-april-24th-2016/\">イベント運営者として登録しましょう</a></strong> (訳注: 日本でのイベント開催をご希望の方は、前述の <a href=\"http://wordbench.org/2016/04/04/global-wordpress-translation-day/\">WordBench.org の記事</a>もご覧ください)。</p>\n<h3>英語しか話せなくても参加できますか ?</h3>\n<p>英語だけしか話せなくても、イギリス、カナダ、ニュージーランド、オーストラリア、南アフリカなどの異なるロケールもあります。 英語には世界中にたくさんの変化形があり、これらについて理解し、ユーザーにとってオプションを選択することがなぜ重症なのかをライブセッションで学ぶこともできます。</p>\n<h3>質問がある場合</h3>\n<p>Polyglots チームとイベント運営者が <a href=\"http://wordpress.slack.com/messages/polyglots/\">英語版 Slack の #Polyglots チャンネル</a>にいます。みんな、親切に助けてくれるはずです (訳注: 日本語版コミュニティの <a href=\"https://wpja.slack.com/messages/translate/\">WordSlack #translate チャンネル</a>もご利用ください) 。</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.5 リリース候補\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://ja.wordpress.org/2016/03/24/wordpress-4-5-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Mar 2016 14:46:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3863\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WordPress 4.5 リリース候補 (英語版) がご利用いただけるようになりました。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3485:\"<p>以下は、<a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-release-candidate/\">WordPress 4.5 Release Candidate</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<hr />\n<p>WordPress 4.5 リリース候補 (英語版) がご利用いただけるようになりました。</p>\n<p>1週間前にベータ 4 をリリースして以来、<a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37077&amp;stop_rev=37026&amp;limit=120&amp;verbose=on\">49個の変更</a>を加えました。リリース候補 (RC) とは「私達としては完成していると思うが、数千万人のユーザーと数千個のプラグインやテーマが存在している以上、何かを見逃している可能性がある」ということを意味しています。WordPress 4.5 を<strong>4月12日 (火)</strong>にリリースしたいと思っていますが、そのためにはみなさんの助けが必要です。</p>\n<p>まだバージョン 4.5 をテストしていない方には、今がチャンスです。</p>\n<p><strong>バグを見つけたと思った場合</strong>はサポートフォーラムの<a href=\"https://wordpress.org/support/forum/alphabeta\">アルファ・ベータエリア</a> (<a href=\"https://ja.forums.wordpress.org/forum/7\">日本語</a>) に投稿できます。情報をお待ちしています！もし再現可能なバグ報告を書けるなら <a href=\"https://make.wordpress.org/core/reports/\">WordPress Trac に報告</a>してください。</p>\n<p>WordPress 4.5 をテストするには、<a href=\"https://ja.wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> プラグイン (「最新版ナイトリービルド」を選択) を利用するか、<a href=\"https://wordpress.org/wordpress-4.5-RC1.zip\">ベータ版の ZIP ファイルをこちらからダウンロード</a>してください。</p>\n<p>4.5 の新機能については、<a href=\"https://ja.wordpress.org/2016/02/27/wordpress-4-5-beta-1/\">ベータ 1</a>、<a href=\"https://ja.wordpress.org/2016/03/03/wordpress-4-5-beta-2/\">ベータ 2</a>、<a href=\"https://ja.wordpress.org/2016/03/11/wordpress-4-5-beta-3/\">ベータ 3</a>、<a href=\"https://ja.wordpress.org/2016/03/17/wordpress-4-5-beta-4/\">ベータ 4</a> のブログ記事をご覧ください。</p>\n<p><strong>開発者の皆さんへ。</strong>ご自分のプラグインやテーマを WordPress 4.5 でテストし、来週になる前にプラグインの Readme 内で <em>Tested up to</em> (最新の対応バージョン) を 4.5 に更新してください。皆さんが互換性の問題を発見した場合、何も壊したくはないので、最終リリースの前に問題を解決できるようサポートフォーラムに投稿してください。</p>\n<p><a href=\"https://make.wordpress.org/core/\">開発ブログ</a>をフォローするのをお忘れなく。ここで、引き続き 4.5 向けの<a href=\"https://make.wordpress.org/core/tag/dev-notes+4-5/\">開発者向けノート</a>を公開していっています。</p>\n<p><em>Free as in Freedom</em><br />\n<em>It is WordPress 4.5</em><br />\n<em>Also free as in beer</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 4.5 ベータ 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://ja.wordpress.org/2016/03/17/wordpress-4-5-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 13:24:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3857\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WordPress 4.5 ベータ 4 (英語版) がご利用いただけるようになりました。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4512:\"<p>以下は、<a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\">WordPress 4.5 Beta 4</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<hr />\n<p>WordPress 4.5 ベータ 4 (英語版) がご利用いただけるようになりました。</p>\n<p><strong>このソフトウェアはまだ開発中です</strong>ので、本番サイトで使うことはおすすめしません。新しいバージョンを試すためにテストサイトを立ち上げることを検討してみてください。WordPress 4.5 をテストするには、<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> プラグイン (「最新版ナイトリービルド」を選択) を利用するか、<a href=\"https://wordpress.org/wordpress-4.5-beta4.zip\">ベータ版の ZIP ファイルをこちらからダウンロード</a>してください。</p>\n<p>4.5 の新機能については、<a href=\"https://ja.wordpress.org/2016/02/27/wordpress-4-5-beta-1/\">ベータ 1</a>、<a href=\"https://ja.wordpress.org/2016/03/03/wordpress-4-5-beta-2/\">ベータ 2</a>、<a href=\"https://ja.wordpress.org/2016/03/11/wordpress-4-5-beta-3/\">ベータ 3</a> のブログ記事、さらに <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">make/core 上の詳しいフィールドガイド</a>をご覧ください。これは WordPress 4.5 向けに<a href=\"https://make.wordpress.org/core/version-4-5-project-schedule/\">計画されたベータの最後のバージョン</a>で、来週リリース候補版を予定しています。</p>\n<p>ベータ 4 に含まれる修正の一部は以下のとおりです。</p>\n<ul>\n<li><strong>Twitter のモーメントおよびタイムライン</strong>からの埋め込みに対応 (<a href=\"https://core.trac.wordpress.org/ticket/36197\">#36197</a>) 。</li>\n<li><strong>Imagick 使用の HHVM</strong> への対応を改善するためのさらなる変更。HHVM 環境での画像リサイズ、回転をテストしてください (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>) 。</li>\n<li><strong>インラインリンク</strong>機能の微調整 (<a href=\"https://core.trac.wordpress.org/ticket/33301\">#33301</a>, <a href=\"https://core.trac.wordpress.org/ticket/30468\">#30468</a>) 。</li>\n<li>スペース無しで3個以上のダッシュ記号 (<code>---</code>) をつなげた場合 <code>&lt;hr&gt;</code> に変換する<strong>エディターショートカット</strong>に対応。ユーザーに対する最善のショートカットを検討する時間を確保するため、太字および斜体のテキストパターンは削除され、4.5 には含まれなくなりました (<a href=\"https://core.trac.wordpress.org/ticket/33300\">#33300</a>) 。</li>\n<li><strong>SSL 環境でのレスポンシブ画像</strong>向けの修正。SSL (特に http/https 混合環境) のテストをお願いします (<a href=\"https://core.trac.wordpress.org/ticket/34945\">#34945</a>) 。</li>\n<li>入れ子になっている <strong>IIS での WordPress インストール</strong>においてのリライトルールの動作を許可 (<a href=\"https://core.trac.wordpress.org/ticket/35558\">#35558</a>) 。</li>\n<li><strong>各種バグ修正。</strong>先週の間に<a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37025&amp;stop_rev=36932&amp;limit=200&amp;verbose=on\">約100件の変更</a>を行いました。</li>\n</ul>\n<p><strong>バグを見つけたと思った場合</strong>はサポートフォーラムの<a href=\"https://wordpress.org/support/forum/alphabeta\">アルファ・ベータエリア</a> (<a href=\"https://ja.forums.wordpress.org/forum/7\">日本語</a>) に投稿できます。情報をお待ちしています！もし再現可能なバグ報告を書けるなら <a href=\"https://make.wordpress.org/core/reports/\">WordPress Trac に報告</a>してください。こちらでは<a href=\"https://core.trac.wordpress.org/tickets/major\">既知のバグ一覧</a>も見ることができます。</p>\n<p>Happy testing!</p>\n<p class=\"p1\"><em>Llegamos al fin</em><br />\n<em>del tiempo pa’ beta</em><br />\n<em>¡Pruébalo Ahora!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 4.5 ベータ 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://ja.wordpress.org/2016/03/11/wordpress-4-5-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 23:30:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3851\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WordPress 4.5 ベータ 3 (英語版) がご利用いただけるようになりました。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4862:\"<p>以下は、<a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">WordPress 4.5 Beta 3</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<hr />\n<p>WordPress 4.5 ベータ 3 (英語版) がご利用いただけるようになりました。</p>\n<p><strong>このソフトウェアはまだ開発中です</strong>ので、本番サイトで使うことはおすすめしません。新しいバージョンを試すためにテストサイトを立ち上げることを検討してみてください。WordPress 4.5 をテストするには、<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> プラグイン (「最新版ナイトリービルド」を選択) を利用するか、<a href=\"https://wordpress.org/wordpress-4.5-beta3.zip\">ベータ版の ZIP ファイルをこちらからダウンロード</a>してください。</p>\n<p>4.5 の新機能については、<a href=\"https://ja.wordpress.org/2016/02/27/wordpress-4-5-beta-1/\">ベータ 1</a> と<a href=\"https://ja.wordpress.org/2016/03/03/wordpress-4-5-beta-2/\">ベータ 2</a> のブログ記事、さらに <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">make/core 上の詳しいフィールドガイド</a>をご覧ください。ベータ 3 に含まれる修正の一部は以下のとおりです。</p>\n<ul>\n<li>多数の<strong>テーマロゴサポート</strong> (<a href=\"https://core.trac.wordpress.org/ticket/33755\">#33755</a>) に関する修正。同梱の Twenty Fifteen 対応 (<a href=\"https://core.trac.wordpress.org/ticket/35944\">#35944</a>) など。</li>\n<li>テーマインストールプレビューツールへの<strong>レスポンシブプレビュー</strong>追加 (<a href=\"https://core.trac.wordpress.org/ticket/36017\">#36017</a>) 。</li>\n<li><strong>HHVM での Imagick</strong> サポート (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>) 。</li>\n<li><code>strip_meta()</code> によって作成者、著作権、ライセンス、画像方向情報が失われないよう、<strong>IPTC、XMP、EXIF プロフィールをホワイトリストに追加</strong> (<a href=\"https://core.trac.wordpress.org/ticket/28634\">#28634</a>) 。</li>\n<li><code>wp_normalize_path()</code> での <strong>Windows シェア/DFS ルート</strong>サポート追加 (<a href=\"https://core.trac.wordpress.org/ticket/35996\">#35996</a>) 。</li>\n<li>新規インストールがデフォルトで、WordPress.org API に依存せず<strong>シークレットキーと salt をローカルで生成する</strong>よう変更。 インターネットに接続できない環境での WordPress のインストールをぜひテストしてください (例えば <img class=\"emoji\" src=\"https://s.w.org/images/core/emoji/72x72/1f6f3.png\" alt=\"🛳\" />、<img class=\"emoji\" src=\"https://s.w.org/images/core/emoji/72x72/2708.png\" alt=\"✈️\" />、<img class=\"emoji\" src=\"https://s.w.org/images/core/emoji/72x72/1f6f0.png\" alt=\"🛰\" />) (<a href=\"https://core.trac.wordpress.org/ticket/35290\">#35290</a>) 。</li>\n<li>REST API への OPTIONS  リクエストが <strong>Allow header を返す</strong>ように変更 (<a href=\"https://core.trac.wordpress.org/ticket/35975\">#35975</a>) 。</li>\n<li>twemoji.js をバージョン 2 に更新 (<a href=\"https://core.trac.wordpress.org/ticket/36059\">#36059</a>) し、IE11 での<strong>絵文字</strong>互換を追加 (<a href=\"https://core.trac.wordpress.org/ticket/35977\">#35977</a>) 。</li>\n<li><strong>各種バグ修正。</strong>先週の間に<a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36931&amp;stop_rev=36814&amp;limit=200&amp;verbose=on\">100件以上の変更</a>を行いました。</li>\n</ul>\n<p><strong>バグを見つけたと思った場合</strong>はサポートフォーラムの<a href=\"https://wordpress.org/support/forum/alphabeta\">アルファ・ベータエリア</a> (<a href=\"https://ja.forums.wordpress.org/forum/7\">日本語</a>) に投稿できます。情報をお待ちしています！もし再現可能なバグ報告を書けるなら <a href=\"https://make.wordpress.org/core/reports/\">WordPress Trac に報告</a>してください。こちらでは<a href=\"https://core.trac.wordpress.org/tickets/major\">既知のバグ一覧</a>も見ることができます。</p>\n<p>Happy testing!</p>\n<p class=\"p1\"><em><span class=\"s1\">Beta one, two, three<br />\n</span><span class=\"s1\">so many bugs have been fixed<br />\n</span><span class=\"s2\">Closer now; four, five.</span></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 4.5 ベータ 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://ja.wordpress.org/2016/03/03/wordpress-4-5-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Mar 2016 12:59:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.wordpress.org/?p=3847\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WordPress 4.5 ベータ 2 (英語版) がご利用いただけるようになりました。\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Naoko Takano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3266:\"<p>以下は、<a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a> が書いた WordPress.org 公式ブログの記事、「<a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">WordPress 4.5 Beta 2</a>」を訳したものです。</p>\n<p>誤字脱字誤訳などありましたら<a href=\"https://ja.forums.wordpress.org/forum/7\">フォーラムまでお知らせください</a>。</p>\n<hr />\n<p>WordPress 4.5 ベータ 2 (英語版) がご利用いただけるようになりました。</p>\n<p><strong>このソフトウェアはまだ開発中です</strong>ので、本番サイトで使うことはおすすめしません。新しいバージョンを試すためにテストサイトを立ち上げることを検討してみてください。WordPress 4.5 をテストするには、<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> プラグイン (「最新版ナイトリービルド」を選択) を利用するか、<a href=\"https://wordpress.org/wordpress-4.5-beta2.zip\">ベータ版の ZIP ファイルをこちらからダウンロード</a>してください。</p>\n<p>4.5 の新機能については、<a href=\"https://ja.wordpress.org/2016/02/27/wordpress-4-5-beta-1/\">ベータ 1 のブログ記事</a>をご覧ください。</p>\n<ul>\n<li><strong>TinyMCE</strong> に<a href=\"https://core.trac.wordpress.org/ticket/33300\">水平線 (HR) 編集ショートカット</a>および<a href=\"https://core.trac.wordpress.org/ticket/28612\">非表示にできる「テキストとしてペースト」通知</a>を追加。</li>\n<li><strong>限定的再読み込み</strong>サポートを<a href=\"https://core.trac.wordpress.org/changeset/36797\">コアテーマのタイトルとタグラインで有効化</a>。これにより、Shift を押しながらクリックしてコントロールにフォーカスすることと、プレビューで PHP フィルターを適用することが可能になりました。</li>\n<li><strong>画像アップロード</strong>において、ImageMagick がリサイズ時にメタ情報の除去を完了できなかった際の致命的なエラーを解決 (<a href=\"https://core.trac.wordpress.org/ticket/33642\">#33642</a>) 。</li>\n<li><strong>各種バグ修正</strong>。先週<a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36813&amp;stop_rev=36701&amp;limit=200&amp;verbose=on\">100以上の変更</a>を行いました。</li>\n</ul>\n<p><strong>バグを見つけたと思った場合</strong>はサポートフォーラムの<a href=\"https://wordpress.org/support/forum/alphabeta\">アルファ・ベータエリア</a> (<a href=\"https://ja.forums.wordpress.org/forum/7\">日本語</a>) に投稿できます。情報をお待ちしています！もし再現可能なバグ報告を書けるなら <a href=\"https://make.wordpress.org/core/reports/\">WordPress Trac に報告</a>してください。こちらでは<a href=\"https://core.trac.wordpress.org/tickets/major\">既知のバグ一覧</a>も見ることができます。</p>\n<p>Happy testing!</p>\n<p><em>It’s peer pressure time</em><br />\n<em>Testing: all cool kids do it</em><br />\n<em>Help find ALL the bugs!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:30:\"https://ja.wordpress.org/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 28 Jun 2016 02:07:01 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 22 Jun 2016 08:27:41 GMT\";s:4:\"link\";s:61:\"<https://ja.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20160506200020\";}", "no");
INSERT INTO `wp_options` VALUES("213", "_transient_timeout_feed_mod_ab995de7a5278071ed721c721c891aed", "1467122821", "no");
INSERT INTO `wp_options` VALUES("214", "_transient_feed_mod_ab995de7a5278071ed721c721c891aed", "1467079621", "no");
INSERT INTO `wp_options` VALUES("215", "_transient_timeout_feed_498b4cc5a65f3557dea9a8cad8d4d322", "1467122822", "no");
INSERT INTO `wp_options` VALUES("216", "_transient_feed_498b4cc5a65f3557dea9a8cad8d4d322", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:132:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"日本語 » Recent Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"フォーラム\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"ja\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 02:07:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:35:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"sasasa24 :  &quot;カスタム投稿にて。今日より古い記事に【終了】と表示させたい&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159705#post-231749\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 02:03:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231749@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:184:\"<p>ikaring様</p>\n<p>ありがとうございます。<br />\n参考ページまで教えて頂いて助かります。<br />\nこのページを参考にしてやってみます！\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"sasasa24\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"meijinochoco :  &quot;カスタムフィールドでショートコードを呼び出す場合&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159696#post-231748\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 02:00:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231748@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1835:\"<p>mypacecreatorさん。こんにちは。ご回答まことにありがとうございます。<br />\nご指摘のとおり、Smart Custom Fieldsです。まさか専用の関数だったとは。<br />\n以下、ご確認事項への返答です。</p>\n<p>&#62;何のためにショートコードを使いたいのか<br />\nカスタムフィールド内で、いくつかプラグインの機能がほしいと思っています。<br />\n今回、商品をいくつか並べる記事になるのですが、その書式において、<br />\nshortcodes ultimate、Browser Shots、Add Any shereなどのプラグインの機能がほしいところです。<br />\nいずれもショートコードなくして呼び出す方法が分からないので、今のことろショートコードは私には必須かもしれません。</p>\n<p>&#62;&#62;具体的にショートコードはどういうものか（WordPress標準の？自作？何らかのプラグインの？）<br />\n上述のとおりすべてプラグインのものです。</p>\n<p>&#62;本当に繰り返しフィールドでないといけないのか<br />\n１つの記事ABCと商品を複数並べるつもりです。<br />\n同じ書式がほしいので、カスタムフィールドと投稿タイプを作りました。<br />\nただし、商品は３つの記事や、１０個の記事があり、その都度変わります。<br />\nなのでその都度商品のフィールド数を追加できる機能が欲しかったのです。<br />\n同じ書式の繰り返し、ということですが、もしかしてもっと楽な方法ってありますでしょうか？</p>\n<p>以上です。素人すぎていまいち的を得ていない返答になってしまっているかもしれませんが、ご検討いただければ幸いです。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"meijinochoco\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"熊本地震東区避難所75日目 :  &quot;4.5.3　インストールエラー&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159701#post-231747\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:59:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231747@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:654:\"<p>古い PHP は公式サポートが終了しているのでセキュリティの脆弱性を遺したまま使うことになりますよ。また、それでトラブルが起こっても PHP バージョンや WordPress のバージョンが最新でないかぎり、わたしは協力しません。</p>\n<p>古い条件でもWordPressの動作はしますが、関数の問題が残り、テーマやプラグインは使えないものが多くなるでしょう。関数が出すエラーを一つづつ自身で解決する根性次第です。</p>\n<p>構文エラーも、この関数の仕様変更に起因していると思います。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"熊本地震東区避難所75日目\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"ikaring :  &quot;カスタム投稿にて。今日より古い記事に【終了】と表示させたい&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159705#post-231746\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:52:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231746@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:981:\"<p>可能だと思いますよ。<br />\nカスタム投稿タイプの一覧なので、使用するテンプレートはarchive-bn.phpですかね。<br />\nそこで、wp_queryとかで下記オプションを指定したら日付フィールドでソートできるはずです。<br />\n<pre><code>&#039;orderby&#039;   =&#62; &#039;meta_value&#039;,\n&#039;meta_key =&#62; &#039;日付を入れたカスタムフィールド名&#039;</code></pre>\n<p><a href=\"http://wpdocs.osdn.jp/関数リファレンス/WP_Query#.E9.A0.86.E5.BA.8F.E3.81.A5.E3.81.91.E3.83.91.E3.83.A9.E3.83.A1.E3.83.BC.E3.82.BF\" rel=\"nofollow\">http://wpdocs.osdn.jp/関数リファレンス/WP_Query#.E9.A0.86.E5.BA.8F.E3.81.A5.E3.81.91.E3.83.91.E3.83.A9.E3.83.A1.E3.83.BC.E3.82.BF</a></p>\n<p>日付の比較はこのページとか参考になるかと思います。<br />\n<a href=\"http://qiita.com/konweb/items/233a7fefe3f33ec595ae\" rel=\"nofollow\">http://qiita.com/konweb/items/233a7fefe3f33ec595ae</a>\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"ikaring\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"sarasarari :  &quot;Advanced Custom Fieldsで作ったテキストエリアの文字数制限&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159706#post-231745\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:47:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231745@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:308:\"<p>以下のように書くことで、自己解決いたしましたので<br />\n明記します！</p>\n<pre><code>&#60;?php\n$cf_name = get_field(&#039;abcd&#039;);\nif(mb_strlen($cf_name)&#62;200) {\n$cf_name= mb_substr($cf_name,0,200) ; echo $cf_name. ･･･ ;\n} else {echo $cf_name;}\n?&#62;</code></pre>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"sarasarari\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"sarasarari :  &quot;Advanced Custom Fieldsで作ったテキストエリアの文字数制限&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159706#post-231744\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:42:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231744@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:510:\"<p>Advanced Custom Fieldsを使い、テキストエリアを作りました。</p>\n<p>このテキストエリアに文字数制限をかけたいので、<br />\n&#60;?php echo mb_substr(get_post_meta($post-&#62;ID,\'abcd\', TRUE), 0,200); ?&#62;<br />\nとし、文字数制限はかけれたのですが、<br />\n制限した文字数を超えた場合だけ、「・・・続きを読む」とつけたい場合、<br />\nどうすれば良いでしょうか？</p>\n<p>ご教授お願いいたします。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"sarasarari\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"hikkomijian :  &quot;WooCommerceでの日本の郵便番号でハイフンを入れたい&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159680#post-231743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:34:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231743@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1121:\"<p>どうすれば一番良いのかまだわかりませんが、新バージョンではハイフンはいらないから削除することになった、と勝手に考え、チェック時にハイフンを無視するようにしたほうが良いのかなと思いました。<br />\nというわけで、その場所を探し、たぶんここかな？と思い修正しました。</p>\n<p>wp-content/plugins/woocommerce/includes/class-wc-validation.php<br />\nの74行目付近</p>\n<blockquote><p>\n			case \'JP\' :<br />\n				$valid = (bool) preg_match( \'/^([0-9]{3})([-])([0-9]{4})$/\', $postcode );<br />\n				break;\n</p></blockquote>\n<p>を</p>\n<blockquote><p>\n			case \'JP\' :<br />\n				$valid = (bool) preg_match( \'/^([0-9]{3})([-])?([0-9]{4})$/\', $postcode );<br />\n				break;\n</p></blockquote>\n<p>としてみました。<br />\nそしたらエラーは出なくなりました。</p>\n<p>ただ、毎回直すのは面倒なので、これって、プラグインのfunctionに書いて修正できたりするのでしょうか？WordPressのfunction？でしょうか、、。勉強不足ですみません。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"hikkomijian\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"ikaring :  &quot;問い合わせフォームの入力画面を2ページ以上に分割させたい！&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159697#post-231742\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:33:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231742@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:404:\"<p>MW WP Formでステップ3と4はできますので、作るのはステップ1から2への遷移だけですよね。<br />\n例えば、同じページでステップ2を非表示にしておいて、ステップ1の「次へ」ボタンを押すと、ステップ1を非表示にして、ステップ2を表示させるようなことをjsでやったら良いのではないでしょうか。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"ikaring\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"ogupo :  &quot;GPL　Version 2のテーマのフッターのキャッチコピーは消してよいのか&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159703#post-231741\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:23:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231741@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:736:\"<p>そうだったのですか！！？？<br />\nそれでは、GPLライセンスに加入すると損ではないですか？？</p>\n<p>新参で、よく分からないのですが、<br />\nGPLライセンスに加入することで、GPL所属のWordPressのテンプレートを改変することができる。また、この話題にしているテンプレートも、あるテンプレートをもとに改変して作られたと考えてよろしいのでしょうか？？</p>\n<p>そうでなければ、情報教材として売られているテーマの説明がつきませんよね・・・。</p>\n<p>テーマからそれてしまうのですが、追加で回答をお願いしてよろしいでしょうか？？\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"ogupo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"munyagu :  &quot;ドメイン名変更後のデータベース接続確立エラーについて&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159702#post-231740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 01:07:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231740@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:539:\"<p>ドメインを変更しただけで「データベース接続確立エラー」になるのも何かおかしい気がするのですが、そういうものなのでしょうか？<br />\nWordPressであまりそういうエラーに出会ったことがないもので・・・</p>\n<p>少し前提をお伺いしたいのですが、<br />\n・WordPressの設置サーバーは変更していない。<br />\n・データベースはWordPressと同じサーバー内で動作している。<br />\nという状況でしょうか？\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"munyagu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"sasasa24 :  &quot;カスタム投稿にて。今日より古い記事に【終了】と表示させたい&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159705#post-231739\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 00:59:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231739@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:889:\"<p>Custom Posttype UI　と　Advance Custom Field プラグインを使用しています。</p>\n<p>カスタム投稿「bn」をつくり、そこに画像と日付を入力できる項目を設けました。<br />\n投稿した画像（アイキャッチではない）を入力した日付（投稿日とは別）の古い順に並べ、なおかつ今日より古い日付のものは、画像のすぐ下に【終了】と載せたいです。</p>\n<p>カスタムフィールドテンプレートを使う記事を見ましたが、設定がうまく行かず…。<br />\n<a href=\"http://office7f.com/2015/08/07/wordpress-end/\" rel=\"nofollow\">http://office7f.com/2015/08/07/wordpress-end/</a></p>\n<p>カスタム投稿だけでそれを実現するのは難しいのでしょうか？<br />\nどなたかご教授頂ければと思います。よろしくお願い致します。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"sasasa24\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"munyagu :  &quot;4.5.3　インストールエラー&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159701#post-231738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 00:53:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231738@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"<p>分かる方は、大塚商会のサポートの方だと思いますので、そちらにお問合せされるべきと思います。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"munyagu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"miiitaka :  &quot;固定ページの親ページが設定できません。&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159687#post-231737\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 00:51:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231737@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:445:\"<p>@kenken001 さん</p>\n<p>非公開でも表示する方法があります。<br />\n<a href=\"http://qiita.com/miiitaka/items/3109206e6dc0998418a0\" rel=\"nofollow\">http://qiita.com/miiitaka/items/3109206e6dc0998418a0</a></p>\n<p>以前、私も同じ問題で悩んだ時に解決した方法です。<br />\n親ページを仮で作っておいて、子ページから作る時に私用したロジックです。<br />\nご参考までに。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"miiitaka\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"design_office :  &quot;4.5.3　インストールエラー&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159701#post-231736\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 00:50:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231736@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:942:\"<p>ご返答ありがとうございます。</p>\n<p>確かに、サーバー仕様は古いのですが、<br />\n公式サイトでは、<br />\n「古い PHP や MySQL しか利用できないレガシーな環境でも、PHP 5.2.4 以上、かつ MySQL 5.0 以上であれば WordPress は動作します」と記載があります。<br />\n動作する最低条件はクリアしてますので、動作は問題ないと思っていました。</p>\n<p>古いサーバー仕様では、<br />\nいきなり、最新版4.5.3をインストールすると問題があるため、<br />\n動くバージョンである4.2.4からインストールして、アップグレードしていけば<br />\n4.5.3も動きますか？</p>\n<p>ご返答可能であれば、お願いします。<br />\nわからない場合は、ご返答不要です。<br />\n別の方で、分かる方いらっしゃいましたら、ご返答お願いします。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"design_office\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"munyagu :  &quot;問い合わせフォームの入力画面を2ページ以上に分割させたい！&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159697#post-231735\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 00:40:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231735@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:830:\"<p>どなたからもご回答がない様子なので、問合せフォームのプラグインに全く詳しくありませんが・・・</p>\n<p>少し検索してみたところ、そのようなプラグインは見当たりませんでした。<br />\nまた、PHPでできた複数ページ対応のメールフォームが配布されていれば、それをWordPressの固定ページとして組み込むことも可能かもしれないと思いましたが、そのようなものも見つけることができませんでした。</p>\n<p>結論から言うと、ご自分でお作りになるか（どこかに発注するか）、複数ページ入力はあきらめてMW WP Formなどの確認ページを表示できるメールフォームを使うかのどちらかしかないのでは、と思います。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"munyagu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"munyagu :  &quot;ログイン出来ず変なページが表示されます&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159634#post-231734\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 00:27:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231734@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"<p>他所様のサイトに迷惑をかけていたかどうかは、DNSにどのような設定をしていたかによりますよね。</p>\n<p>いくつか設定するDNSサーバー名のひとつを間違っていたのではないかと推測していますが、その場合、特に他所様のサイトには迷惑はかかっていない気がします。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"munyagu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Daisuke Takahashi :  &quot;長いURLがはみ出してしまう件&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159704#post-231733\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 00:26:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231733@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:324:\"<p>お使いのテーマは画像などのライセンスがGPLではないため、提供元などに問い合わせてきてください。<br />\n基本的に、このフォーラム上ではPHPファイルや画像などすべてのファイルのライセンスがGPLであるテーマを対象としています。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Daisuke Takahashi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"kenkenkenny :  &quot;サイトにログインできない&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159698#post-231732\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jun 2016 00:05:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231732@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:735:\"<p>ありがとうございます。</p>\n<p>まず試したのは、他人のＵＲＬを見たとき<br />\n<a href=\"http://○○○.wordpress.com\" rel=\"nofollow\">http://○○○.wordpress.com</a> となっていたので、同じようにトライしました。</p>\n<p><a href=\"http://kenkenkenny.wordpress.com/db\" rel=\"nofollow\">http://kenkenkenny.wordpress.com/db</a></p>\n<p><a href=\"http://kenkenkenny.wordpress.com\" rel=\"nofollow\">http://kenkenkenny.wordpress.com</a></p>\n<p>wordpress けんくんブログ</p>\n<p>もログインできませんでした。ちなみにgoogleでの検索です。</p>\n<p>あとはよくわからないので、細かな操作はしていません。</p>\n<p>よろしくお願いします。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"kenkenkenny\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"momomint :  &quot;長いURLがはみ出してしまう件&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159704#post-231731\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 23:36:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231731@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:321:\"<p>XeoryBaseというテーマを利用しております。</p>\n<p>IE(バージョン11)で見た時に<br />\n引用(blockquote)箇所に書いた<br />\n長いURLがはみ出してしまいます。</p>\n<p>具体的にどこ箇所を編集すればいいのでしょうか？<br />\nよろしくお願いします。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"momomint\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"熊本地震東区避難所75日目 :  &quot;ログイン出来ず変なページが表示されます&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159634#post-231730\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 23:26:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231730@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:765:\"<blockquote><p>テキストエディタから、ビジュアルエディタタブを押しても移動できず、「メディアを追加」ボタンを押しても無反応です。<br />\nプラグイン停止ボタンも無反応。</p></blockquote>\n<p>ビジュアルエディタの問題は、プラグインの相性。</p>\n<blockquote><p>ログイン出来ず変なページが表示されます。</p></blockquote>\n<p>ログイン出来ないのではなく、DNSの設定を間違っていて他所様のサイトに迷惑をかけていたのは kibou2 さん側だった。</p>\n<p>WordPressの問題とは、離れがちのこと。テスト環境や、別サイトを用意しておくと、差異が気づきやすかったかと思われます。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"熊本地震東区避難所75日目\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Hinaloe :  &quot;GPL　Version 2のテーマのフッターのキャッチコピーは消してよいのか&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159703#post-231729\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 23:21:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231729@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"<p>結論だけ書くと</p>\n<ul>\n<li>改変は自由</li>\n<li>再頒布の場合はGPLを継承する必要がある(改変の有無にか変わらず可)</li>\n<li>その販売も可</li>\n</ul>\n<p>です。<br />\n(もしこれらを許可しないような記述があった場合、それはライセンス違反なのでその旨を作者のかたにお伝えください。)\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Hinaloe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"oisit :  &quot;カスタムタクソノミーのテンプレート&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159694#post-231728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 23:05:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231728@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:313:\"<p>確認の意味で固定ページにカスタム投稿のカテゴリー一覧ページを作って、<br />\n手作業でカテゴリーのリンク集を作ってみたらいいとおもいます。<br />\nカテゴリーの数が多くないならそのまま採用してもいいかもしれません。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"oisit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"kibou2 :  &quot;ログイン出来ず変なページが表示されます&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159634#post-231727\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 22:47:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231727@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:465:\"<p>たくさんのアドバイスありがとうございました。<br />\n問題解決しました。</p>\n<p>変なページに飛ばされる原因はネームサーバーの設定ミスでした<br />\nＸサーバーに問合せしたところ指摘された所を修正したところ<br />\n飛ばされることは無くなりました。</p>\n<p>まだ様子を見ているところですが一応トピック解決済みとさせていただきます。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"kibou2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"oisit :  &quot;『カスタム投稿タイプ』VS『ページのテンプレート』それぞれのメリット&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159684#post-231726\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 22:44:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231726@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:866:\"<p>スレッドタイトルと中身がずれてるんでは？</p>\n<p>仮に固定ページで作るなら、<br />\n固定ページのテンプレートを複数（A,B）作って、<br />\nそれぞれのページを作った時にページテンプレートを選べばいいのでは。<br />\n（2）のテンプレートは固定ページのテンプレートになる。<br />\nAの記事にはaのサイドバーのページテンプレートを。<br />\nBの記事にはbのサイドバーのページテンプレートを。<br />\nみたいな感じ。</p>\n<p>ページ数が増える（あるいはpostの形式をつかう）なら、<br />\nサイドバー表示分岐用のカスタム分類を作って、<br />\n記事作成時にどちらか選択して、<br />\nそれを取得してget_sidebarを変えてあげればどうなんでしょうか。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"oisit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"ogupo :  &quot;GPL　Version 2のテーマのフッターのキャッチコピーは消してよいのか&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159703#post-231725\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 20:56:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231725@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1214:\"<p>とあるテーマの利用規約について、作者に問い合わせてみたところ、<br />\n「GPL Version 2 (<a href=\"http://www.gnu.org/licenses/gpl-2.0.html)」\" rel=\"nofollow\">http://www.gnu.org/licenses/gpl-2.0.html)」</a><br />\nでライセンスされています。</p>\n<p>ダウンロードしたファイル内にある当方で作成した部分については、<br />\n全て GPL ライセンスです。</p>\n<p>また内部で使用している一部のライブラリは MIT でライセンスされています。</p>\n<p>GPL Version 2 は WordPress 本体と同じライセンスですので、<br />\nそちらも参照してください。</p>\n<p>と返事が返ってきました。これは、つまり、①フッターのキャッチコピーをしてはいけないということでしょうか？？②改変後の配布も不可？？③改変後の配布のときもフッターのキャッチコピーをしてはいけない・・・？？④改変したものを売ってはいけない？？<br />\nということなのでしょうか？？？どこまでOKなのか、分かりません。どうか、お教えてください。よろしくお願いいたします。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"ogupo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"npssl :  &quot;4.5.3　インストールエラー&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159701#post-231724\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 14:28:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231724@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:259:\"<p>WordPress 日本語版の推奨動作環境<br />\n・PHP バージョン 5.6 以上<br />\n・MySQL バージョン 5.6 以上 または MariaDB バージョン 10.0 以上</p>\n<p>ちょっと古いですね。公式サポートも終わってます。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"npssl\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"npssl :  &quot;ドメイン名変更後のデータベース接続確立エラーについて&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159702#post-231723\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 14:06:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231723@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:572:\"<p>wp_postsのguidに旧FQDNが残っています。<br />\n他にも自サイト記事へのリンクなどもあるでしょうし、wp_optionsにシリアライズされた旧FQDNが使われている場合もあるので、スクリプトを使って書き換えます。<br />\n<a href=\"https://wpdocs.osdn.jp/WordPress_%E3%81%AE%E5%BC%95%E8%B6%8A%E3%81%97#.E3.83.89.E3.83.A1.E3.82.A4.E3.83.B3.E5.90.8D.E3.81.BE.E3.81.9F.E3.81.AFURL.E3.82.92.E5.A4.89.E6.9B.B4.E3.81.99.E3.82.8B.E3.81.A8.E3.81.8D\" rel=\"nofollow\">ドメイン名またはURLを変更するとき</a>\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"npssl\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"gblsm :  &quot;設置時のパーミッションについて&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159681#post-231722\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 13:53:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231722@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"<p>先々のことを考えるとSQLiteからMySQLへの移行を改めて検討なさった方が良いかもしれませんね。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"gblsm\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"satoshinakamura :  &quot;ドメイン名変更後のデータベース接続確立エラーについて&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159702#post-231721\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 13:42:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231721@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1518:\"<p>ドメイン名(FQDN)変更後に以下の以下の設定を変更しましたが、<br />\n『データベース接続確立エラー』<br />\nによりサイト閲覧が出来なくなりました。</p>\n<p>[設定変更内容]<br />\n・wp-config.php<br />\nDOMAIN_CURRENT_SITE</p>\n<p>・データベースの以下レコードを変更<br />\nwp_options<br />\n+-----------+-------------+---------------------------+----------+<br />\n&#124; option_id &#124; option_name &#124; option_value              &#124; autoload &#124;<br />\n+-----------+-------------+---------------------------+----------+<br />\n&#124;        36 &#124; home        &#124; <a href=\"http://xxx.xxx.xxxxxxxxxx\" rel=\"nofollow\">http://xxx.xxx.xxxxxxxxxx</a> &#124; yes      &#124;<br />\n+-----------+-------------+---------------------------+----------+</p>\n<p>+-----------+-------------+---------------------------+----------+<br />\n&#124; option_id &#124; option_name &#124; option_value              &#124; autoload &#124;<br />\n+-----------+-------------+---------------------------+----------+<br />\n&#124;         1 &#124; siteurl     &#124; <a href=\"http://xxx.xxx.xxxxxxxxxx\" rel=\"nofollow\">http://xxx.xxx.xxxxxxxxxx</a> &#124; yes      &#124;<br />\n+-----------+-------------+---------------------------+----------+</p>\n<p><strong>wp-config.phpの接続情報を元にmysqlコマンドで接続した際は接続が出来ます。</strong></p>\n<p>他に設定箇所がありましたらご教示いただければと思います。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"satoshinakamura\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"design_office :  &quot;4.5.3　インストールエラー&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159701#post-231720\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 13:31:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231720@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1063:\"<p>知人のサーバーにwordpress4.5.3をアップロードし、<br />\nアップロードしたＵＲＬにアクセスしたところ、以下のようなエラーが表示されました。</p>\n<p>----------------------<br />\nParse error: parse error, unexpected \'{\' in /サーバのルートディレクトリのフルパス/アップしたフォルダ/wp-includes/functions.php on line 2872<br />\n------------------------<br />\n2回やり直しましたが、再現性があります。</p>\n<p>サーバー仕様は以下です。<br />\n・使用サーバー<br />\n大塚商会のアルファメール<br />\n・PHPのバージョン<br />\n5.3.2<br />\n・データベース バージョン<br />\n5.1.47 </p>\n<p>ご質問ですが、<br />\n１）構文エラーのようですが、ファイルは問題ないようです。<br />\nサーバー仕様の問題でしょうか？<br />\n２）最新版wordpress4.5.3はインストールできないのでしょうか？</p>\n<p>原因が分かる方いらっしゃいましたら、教えてください。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"design_office\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"tumuzo :  &quot;設置時のパーミッションについて&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159681#post-231719\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 12:03:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231719@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:437:\"<p>コメント頂きまして感謝します。</p>\n<p>SQLiteを使っていることが原因だとすると、もう手に負えないと思いますので、<br />\nwp_optionsテーブルの値を直接書き換えてみようと思います。</p>\n<p>直接コマンドラインで触れる環境でないため、SQLiteManagerを入れるところから始めようと思います。</p>\n<p>どうも有難うございます。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"tumuzo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"tumuzo :  &quot;画像フォルダ(wp-content/uploads/)の年月別保管を解除できない&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159610#post-231718\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 11:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231718@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:878:\"<p>コメント有難うございました。</p>\n<blockquote><p>\n年月別のフォルダが存在していたというのは、Fc2ブログというのから引っ越しする以前にすでにWordPressのブログを運用していたということですか。\n</p></blockquote>\n<p>そうです。とはいっても数件の記事を試験的に書いただけで、WORDPRESSの管理画面上で全ての記事と画像を削除し、FFFTPを使って、<br />\n/wp-content/uploads/以下のフォルダと中身も直接削除してあります。<br />\nなので、記事もデータベース上から消されていて、実際のファイルも物理削除されている状態だとは思います。</p>\n<p>物理削除してしまったので、データベース上の情報と画像ファイルとの整合性が取れなくなっているのでしょうか？\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"tumuzo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"熊本地震東区避難所75日目 :  &quot;悪性のFacebookのドメインにリダイレクトされる&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159693#post-231717\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 10:34:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231717@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:441:\"<p>カスペルスキーから指摘のあった、スクリプトへのリンクはサイト上で確認できていますか。<br />\nなお、kanae7さんのサイトのアドレスは、貼らないようにお願いしますね。ランサムウェアの拡散になりますからね。また、サイトもことが解決するまでメンテナンスモードなどにして公開させないでおくことが望まれます。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"熊本地震東区避難所75日目\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"熊本地震東区避難所75日目 :  &quot;サイトにログインできない&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159698#post-231716\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 10:18:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231716@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:487:\"<p>解決方法として検索して得た情報は、どういうものですか。<br />\n簡単でいいので、具体的に教えてください。導く材料になりますから。</p>\n<p>ただし、ワードプレスは設置できているのでバグではないはずです。バグや提案としての投稿でしたら、対応もまた変えなくてはなりません。</p>\n<p>なお、サーバーの設定には問題点もあるように見受けられます。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"熊本地震東区避難所75日目\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"nanakochi123456 :  &quot;[plugin]super-cache に意図しないディレクトリが作成される&quot;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ja.forums.wordpress.org/topic/159700#post-231715\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jun 2016 10:13:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"231715@https://ja.forums.wordpress.org/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1871:\"<p>wpsupercacheが急激なアクセス過多によって、おかしな状態となってしまったようです。<br />\n(super-cache は 1.4.8です)</p>\n<p>これは不具合かどうかわかりますでしょうか？</p>\n<p>１．急に分間30000近くのアクセスになり、データベースと接続できなくなる。<br />\n２．apache→mysqlの順番にダウンさせて、mysql→apacheの順にアップさせる<br />\n３．サーバー過負荷が対処できないため、OSを再起動する<br />\n４．Webで確認したら、TOPページの内容がディレクトリの一覧となり、復旧できなくなる</p>\n<p>supercache/ の中身を見ると<br />\n-rw------- ????.????.tmp<br />\ndrwx------ about (<a href=\"http://example.com/about/\" rel=\"nofollow\">http://example.com/about/</a> と仮定する、いくつかあります）<br />\n-rw------- index-mobile.html<br />\n-rw------- index-mobile.html.gz<br />\ndrwx------ index.html</p>\n<p>index.html がsupercacheの中にディレクトリとして勝手に生成されたようで、<br />\nこのディレクトリを rm -rf して削除したら、index.html ファイルが生成され、正常に動作しました。</p>\n<p>index.htmlの中には、以下の内容がありました。<br />\nindex-mobile.html.gz<br />\nindex-mobile.html.gz.needs-rebuild<br />\n????.tmp.gzr<br />\nindex-mobile.html<br />\nhindex-mobile.html.needs-rebuild</p>\n<p>この勝手にディレクトリが出来てしまうのは不具合でしょうか？</p>\n<p>過負荷の状態で再現性が少ないものかもですが、よろしくお願いします。</p>\n<p>※誤って英語版にこの内容で投稿してしまいました。<br />\n※急激なアクセスは、予期されていたもので、不正なものではありません。<br />\n※OSはFreeBSD 10.1 phpは5.4です。\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"nanakochi123456\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:36:\"https://ja.forums.wordpress.org/rss/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:7:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 28 Jun 2016 02:07:02 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Tue, 28 Jun 2016 02:03:09 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";}s:5:\"build\";s:14:\"20160506200020\";}", "no");
INSERT INTO `wp_options` VALUES("217", "_transient_timeout_feed_mod_498b4cc5a65f3557dea9a8cad8d4d322", "1467122822", "no");
INSERT INTO `wp_options` VALUES("218", "_transient_feed_mod_498b4cc5a65f3557dea9a8cad8d4d322", "1467079622", "no");
INSERT INTO `wp_options` VALUES("219", "_transient_timeout_dash_45827e8e892dd0b85803a110fad8690f", "1467122822", "no");
INSERT INTO `wp_options` VALUES("220", "_transient_dash_45827e8e892dd0b85803a110fad8690f", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://ja.wordpress.org/2016/06/22/wordpress-4-5-3/\'>WordPress 4.5.3 メンテナンス・セキュリティリリース</a> <span class=\"rss-date\">6月 21, 2016</span><div class=\"rssSummary\">WordPress 4.5.3 がご利用いただけるようになりました。これは過去のバージョンすべてに対するセキュ [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://ja.forums.wordpress.org/topic/159705#post-231749\'>sasasa24 :  &quot;カスタム投稿にて。今日より古い記事に【終了】と表示させたい&quot;</a></li><li><a class=\'rsswidget\' href=\'https://ja.forums.wordpress.org/topic/159696#post-231748\'>meijinochoco :  &quot;カスタムフィールドでショートコードを呼び出す場合&quot;</a></li><li><a class=\'rsswidget\' href=\'https://ja.forums.wordpress.org/topic/159701#post-231747\'>熊本地震東区避難所75日目 :  &quot;4.5.3　インストールエラー&quot;</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\"dashboard-news-plugin\"><span>人気のプラグイン:</span> Clef Two-Factor Authentication&nbsp;<a href=\"plugin-install.php?tab=plugin-information&amp;plugin=wpclef&amp;_wpnonce=2f0db4b6e9&amp;TB_iframe=true&amp;width=600&amp;height=800\" class=\"thickbox open-plugin-details-modal\" aria-label=\"Clef Two-Factor Authentication のインストール\">(インストール)</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("227", "_transient_doing_cron", "1467084943.1691529750823974609375", "yes");
INSERT INTO `wp_options` VALUES("234", "autoptimize_js", "on", "yes");
INSERT INTO `wp_options` VALUES("232", "autoptimize_html", "on", "yes");
INSERT INTO `wp_options` VALUES("233", "autoptimize_html_keepcomments", "", "yes");
INSERT INTO `wp_options` VALUES("235", "autoptimize_js_exclude", "s_sid,smowtion_size,sc_project,WAU_,wau_add,comment-form-quicktags,edToolbar,ch_client,seal.js", "yes");
INSERT INTO `wp_options` VALUES("236", "autoptimize_js_trycatch", "", "yes");
INSERT INTO `wp_options` VALUES("237", "autoptimize_js_justhead", "", "yes");
INSERT INTO `wp_options` VALUES("238", "autoptimize_js_forcehead", "on", "yes");
INSERT INTO `wp_options` VALUES("239", "autoptimize_js_include_inline", "", "yes");
INSERT INTO `wp_options` VALUES("240", "autoptimize_css", "on", "yes");
INSERT INTO `wp_options` VALUES("241", "autoptimize_css_exclude", "admin-bar.min.css, dashicons.min.css", "yes");
INSERT INTO `wp_options` VALUES("242", "autoptimize_css_justhead", "", "yes");
INSERT INTO `wp_options` VALUES("243", "autoptimize_css_datauris", "", "yes");
INSERT INTO `wp_options` VALUES("244", "autoptimize_css_defer", "", "yes");
INSERT INTO `wp_options` VALUES("245", "autoptimize_css_defer_inline", "", "yes");
INSERT INTO `wp_options` VALUES("246", "autoptimize_css_inline", "", "yes");
INSERT INTO `wp_options` VALUES("247", "autoptimize_css_include_inline", "", "yes");
INSERT INTO `wp_options` VALUES("248", "autoptimize_css_nogooglefont", "", "yes");
INSERT INTO `wp_options` VALUES("249", "autoptimize_cdn_url", "", "yes");
INSERT INTO `wp_options` VALUES("250", "autoptimize_cache_clean", "0", "yes");
INSERT INTO `wp_options` VALUES("251", "autoptimize_cache_nogzip", "on", "yes");
INSERT INTO `wp_options` VALUES("252", "autoptimize_show_adv", "0", "yes");
INSERT INTO `wp_options` VALUES("255", "current_theme", "Twenty Sixteen", "yes");
INSERT INTO `wp_options` VALUES("256", "theme_mods_untitled", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467094504;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:10:\"nav_menu-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("257", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("258", "theme_mods_flymag", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467094573;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:10:\"nav_menu-2\";}s:9:\"sidebar-2\";N;s:9:\"sidebar-3\";N;s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:9:\"sidebar-6\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("259", "theme_mods_estore", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:20:\"estore_global_layout\";s:21:\"no_sidebar_full_width\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467106132;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:20:\"estore_sidebar_right\";a:1:{i:0;s:10:\"nav_menu-2\";}s:19:\"estore_sidebar_left\";N;s:21:\"estore_sidebar_header\";N;s:21:\"estore_sidebar_slider\";N;s:28:\"estore_sidebar_slider_beside\";N;s:20:\"estore_sidebar_front\";N;s:22:\"estore_footer_sidebar1\";N;s:22:\"estore_footer_sidebar2\";N;s:22:\"estore_footer_sidebar3\";N;s:22:\"estore_footer_sidebar4\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("260", "widget_estore_728x90_ad", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("261", "widget_estore_about", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("262", "widget_estore_featured_posts_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("263", "widget_estore_logo_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("264", "widget_estore_featured_posts_slider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("265", "widget_estore_featured_posts_carousel_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("266", "widget_estore_posts_grid", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("267", "widget_estore_vertical_promo_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("268", "widget_estore_full_width_promo_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("273", "biz_vektor_theme_options", "a:106:{s:10:\"font_title\";s:5:\"serif\";s:9:\"font_menu\";s:5:\"serif\";s:11:\"gMenuDivide\";s:14:\"divide_natural\";s:9:\"head_logo\";s:0:\"\";s:9:\"foot_logo\";s:0:\"\";s:11:\"contact_txt\";s:0:\"\";s:10:\"tel_number\";s:0:\"\";s:12:\"contact_time\";s:0:\"\";s:12:\"sub_sitename\";s:0:\"\";s:15:\"contact_address\";s:0:\"\";s:12:\"contact_link\";s:0:\"\";s:8:\"topTitle\";s:0:\"\";s:14:\"commonKeyWords\";s:0:\"\";s:19:\"header_image_height\";i:250;s:16:\"enableie8Warning\";b:1;s:20:\"topEntryTitleDisplay\";s:0:\"\";s:17:\"topSideBarDisplay\";b:0;s:13:\"top3PrDisplay\";s:0:\"\";s:12:\"postTopCount\";s:1:\"5\";s:10:\"postTopUrl\";s:0:\"\";s:11:\"listBlogTop\";s:12:\"listType_set\";s:15:\"listBlogArchive\";s:12:\"listType_set\";s:7:\"blogRss\";s:0:\"\";s:18:\"side_child_display\";s:18:\"side_child_display\";s:12:\"rssLabelName\";s:12:\"Blog entries\";s:7:\"favicon\";s:0:\"\";s:12:\"theme_layout\";s:15:\"content-sidebar\";s:13:\"postLabelName\";s:4:\"Blog\";s:11:\"theme_style\";s:7:\"default\";s:18:\"enable_google_font\";s:4:\"true\";s:9:\"pr1_title\";s:24:\"豊富なオプション\";s:15:\"pr1_description\";s:120:\"この部分はテーマオプション画面か、テーマカスタマイザーから変更する事が出来ます。\";s:8:\"pr1_link\";s:0:\"\";s:9:\"pr1_image\";s:109:\"http://demo.sample100.jetboy.jp/wp-content/themes/bizvektor-global-edition/images/samples/pr_image_demo_1.jpg\";s:11:\"pr1_image_s\";s:112:\"http://demo.sample100.jetboy.jp/wp-content/themes/bizvektor-global-edition/images/samples/pr_image_demo_sq_1.jpg\";s:9:\"pr2_title\";s:21:\"豊富なデザイン\";s:15:\"pr2_description\";s:123:\"BizVektorはサイトの色を変更出来るだけではなく、違うデザインに切り替える事が出来ます。\";s:8:\"pr2_link\";s:0:\"\";s:9:\"pr2_image\";s:109:\"http://demo.sample100.jetboy.jp/wp-content/themes/bizvektor-global-edition/images/samples/pr_image_demo_2.jpg\";s:11:\"pr2_image_s\";s:112:\"http://demo.sample100.jetboy.jp/wp-content/themes/bizvektor-global-edition/images/samples/pr_image_demo_sq_2.jpg\";s:9:\"pr3_title\";s:27:\"ビジネス用に最適化\";s:15:\"pr3_description\";s:144:\"子ページリスト用テンプレートや問い合わせへの誘導など、ビジネスに必須な様々な機能を備えています。\";s:8:\"pr3_link\";s:0:\"\";s:9:\"pr3_image\";s:109:\"http://demo.sample100.jetboy.jp/wp-content/themes/bizvektor-global-edition/images/samples/pr_image_demo_3.jpg\";s:11:\"pr3_image_s\";s:112:\"http://demo.sample100.jetboy.jp/wp-content/themes/bizvektor-global-edition/images/samples/pr_image_demo_sq_3.jpg\";s:7:\"version\";s:6:\"g1.0.8\";s:6:\"SNSuse\";b:0;s:11:\"global_font\";s:9:\"Open+Sans\";s:16:\"postRelatedCount\";s:1:\"6\";s:12:\"infoTopCount\";s:1:\"5\";s:4:\"gaID\";s:0:\"\";s:6:\"gaType\";s:13:\"gaType_normal\";s:13:\"infoLabelName\";s:11:\"Information\";s:10:\"infoTopUrl\";s:37:\"http://demo.sample100.jetboy.jp/info/\";s:11:\"listInfoTop\";s:12:\"listType_set\";s:15:\"listInfoArchive\";s:12:\"listType_set\";s:17:\"ad_conent_moretag\";s:0:\"\";s:15:\"ad_conent_after\";s:0:\"\";s:16:\"ad_related_after\";s:0:\"\";s:7:\"twitter\";s:0:\"\";s:8:\"facebook\";s:0:\"\";s:7:\"fbAppId\";s:0:\"\";s:9:\"fbAdminId\";s:0:\"\";s:8:\"ogpImage\";s:0:\"\";s:13:\"ogpTagDisplay\";s:6:\"ogp_on\";s:12:\"snsBtnsFront\";s:0:\"\";s:11:\"snsBtnsPage\";s:0:\"\";s:11:\"snsBtnsPost\";s:0:\"\";s:11:\"snsBtnsInfo\";s:0:\"\";s:13:\"snsBtnsHidden\";s:0:\"\";s:15:\"fbCommentsFront\";s:0:\"\";s:14:\"fbCommentsPage\";s:0:\"\";s:14:\"fbCommentsPost\";s:0:\"\";s:14:\"fbCommentsInfo\";s:0:\"\";s:16:\"fbCommentsHidden\";s:0:\"\";s:14:\"fbLikeBoxFront\";s:0:\"\";s:13:\"fbLikeBoxSide\";s:0:\"\";s:12:\"fbLikeBoxURL\";s:0:\"\";s:15:\"fbLikeBoxStream\";s:0:\"\";s:13:\"fbLikeBoxFace\";s:0:\"\";s:15:\"fbLikeBoxHeight\";s:0:\"\";s:10:\"slide1link\";s:0:\"\";s:11:\"slide1image\";s:0:\"\";s:9:\"slide1alt\";s:0:\"\";s:13:\"slide1display\";s:0:\"\";s:11:\"slide1blank\";s:0:\"\";s:10:\"slide2link\";s:0:\"\";s:11:\"slide2image\";s:0:\"\";s:9:\"slide2alt\";s:0:\"\";s:13:\"slide2display\";s:0:\"\";s:11:\"slide2blank\";s:0:\"\";s:10:\"slide3link\";s:0:\"\";s:11:\"slide3image\";s:0:\"\";s:9:\"slide3alt\";s:0:\"\";s:13:\"slide3display\";s:0:\"\";s:11:\"slide3blank\";s:0:\"\";s:10:\"slide4link\";s:0:\"\";s:11:\"slide4image\";s:0:\"\";s:9:\"slide4alt\";s:0:\"\";s:13:\"slide4display\";s:0:\"\";s:11:\"slide4blank\";s:0:\"\";s:10:\"slide5link\";s:0:\"\";s:11:\"slide5image\";s:0:\"\";s:9:\"slide5alt\";s:0:\"\";s:13:\"slide5display\";s:0:\"\";s:11:\"slide5blank\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("269", "estore_admin_notice_welcome", "1", "yes");
INSERT INTO `wp_options` VALUES("275", "WFUAdminOptions", "a:50:{s:7:\"wp_path\";s:0:\"\";s:11:\"maxfilesize\";s:0:\"\";s:11:\"resize_show\";s:4:\"true\";s:11:\"resize_data\";s:11:\"100000,1024\";s:12:\"resize_label\";s:13:\"Original,1024\";s:14:\"resize_default\";s:1:\"0\";s:23:\"allowed_file_extensions\";s:3:\"all\";s:25:\"forbidden_file_extensions\";s:3:\"php\";s:22:\"enable_folder_browsing\";s:4:\"true\";s:22:\"enable_folder_handling\";s:4:\"true\";s:18:\"enable_file_rename\";s:5:\"false\";s:9:\"show_size\";s:4:\"true\";s:9:\"normalize\";s:4:\"true\";s:10:\"file_chmod\";s:0:\"\";s:9:\"dir_chmod\";s:0:\"\";s:17:\"language_dropdown\";s:8:\"de,en,es\";s:15:\"use_image_magic\";s:5:\"false\";s:16:\"image_magic_path\";s:7:\"convert\";s:25:\"upload_notification_email\";s:0:\"\";s:30:\"upload_notification_email_from\";s:0:\"\";s:33:\"upload_notification_email_subject\";s:45:\"Files where uploaded by the WP Flash Uploader\";s:30:\"upload_notification_email_text\";s:44:\"The following files where uploaded by %s: %s\";s:20:\"enable_file_download\";s:4:\"true\";s:27:\"preview_textfile_extensions\";s:7:\"log,php\";s:24:\"edit_textfile_extensions\";s:12:\"txt,css,html\";s:19:\"exclude_directories\";s:3:\"svn\";s:18:\"enable_folder_move\";s:4:\"true\";s:20:\"enable_file_copymove\";s:4:\"true\";s:8:\"swf_text\";s:0:\"\";s:14:\"show_wfu_media\";s:4:\"true\";s:15:\"show_sync_media\";s:4:\"true\";s:12:\"show_wfu_tab\";s:4:\"true\";s:13:\"show_sync_tab\";s:4:\"true\";s:11:\"hide_donate\";s:5:\"false\";s:13:\"hide_htaccess\";s:5:\"false\";s:14:\"detect_resized\";s:4:\"true\";s:11:\"file_filter\";s:46:\"*1024*.*,*300*.*,*150*.*,*85x85*.*,*280x125*.*\";s:10:\"flash_size\";s:3:\"650\";s:11:\"securitykey\";s:40:\"da39a3ee5e6b4b0d3255bfef95601890afd80709\";s:22:\"frontend_upload_folder\";s:79:\"/home/sample100/public_html/demo.sample100.jetboy.jp/wp-content/uploads/2016/06\";s:14:\"master_profile\";s:5:\"false\";s:19:\"master_profile_type\";s:28:\"master_profile_type_username\";s:15:\"sync_extensions\";s:0:\"\";s:9:\"scheduler\";s:4:\"none\";s:19:\"frontend_javascript\";s:0:\"\";s:9:\"sync_time\";s:0:\"\";s:15:\"synch_max_files\";s:4:\"auto\";s:20:\"sync_warning_message\";s:4:\"true\";s:14:\"remove_invalid\";s:5:\"false\";s:16:\"enable_auto_sync\";s:4:\"true\";}", "yes");
INSERT INTO `wp_options` VALUES("270", "theme_mods_canard", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467094944;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:10:\"nav_menu-2\";}s:9:\"sidebar-2\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("271", "theme_mods_twentyfifteen", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467095108;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:10:\"nav_menu-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("272", "theme_mods_bizvektor-global-edition", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467106063;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:20:\"top-side-widget-area\";a:1:{i:0;s:10:\"nav_menu-2\";}s:16:\"post-widget-area\";N;s:16:\"page-widget-area\";N;s:27:\"common-side-top-widget-area\";N;s:30:\"common-side-bottom-widget-area\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("274", "biz_vektor_theme_options_default_design", "", "yes");
INSERT INTO `wp_options` VALUES("276", "ewww_image_optimizer_bulk_resume", "", "yes");
INSERT INTO `wp_options` VALUES("280", "duplicator_version_plugin", "1.1.12", "yes");
INSERT INTO `wp_options` VALUES("277", "mediafromftp_log_version", "1.0", "yes");
INSERT INTO `wp_options` VALUES("278", "mediafromftp_settings_1", "a:14:{s:7:\"pagemax\";i:20;s:7:\"basedir\";s:18:\"wp-content/uploads\";s:9:\"searchdir\";s:18:\"wp-content/uploads\";s:4:\"sort\";s:3:\"asc\";s:14:\"ext2typefilter\";s:3:\"all\";s:9:\"extfilter\";s:3:\"all\";s:7:\"dateset\";s:3:\"new\";s:18:\"max_execution_time\";i:300;s:14:\"character_code\";s:5:\"UTF-8\";s:7:\"exclude\";s:56:\"(.ktai.)|(.backwpup_log.)|(.ps_auto_sitemap.)|\\.php|\\.js\";s:17:\"thumb_deep_search\";b:0;s:4:\"cron\";a:6:{s:5:\"apply\";b:0;s:8:\"schedule\";s:6:\"hourly\";s:12:\"limit_number\";b:0;s:10:\"mail_apply\";b:1;s:4:\"mail\";s:26:\"ooizumieikoubu@yahoo.co.jp\";s:4:\"user\";i:1;}s:7:\"caption\";a:2:{s:5:\"apply\";b:0;s:9:\"exif_text\";s:115:\"%title% %credit% %camera% %caption% %created_timestamp% %copyright% %aperture% %shutter_speed% %iso% %focal_length%\";}s:3:\"log\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("281", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-01 04:51:52\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.2\";s:9:\"VersionDB\";s:6:\"5.5.48\";s:10:\"VersionPHP\";s:6:\"5.5.36\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20160701_e38387e383a2e382b5e382a4e38388\";s:4:\"Hash\";s:29:\"5775f6e8581168294160701045152\";s:8:\"NameHash\";s:69:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:69:\"/home/sample100/public_html/demo.sample100.jetboy.jp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"http://demo.sample100.jetboy.jp/wp-snapshots/\";s:8:\"ScanFile\";s:79:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/sample100/public_html/demo.sample100.jetboy.jp\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-01 04:51:52\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.2\";s:9:\"VersionDB\";s:6:\"5.5.48\";s:10:\"VersionPHP\";s:6:\"5.5.36\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20160701_e38387e383a2e382b5e382a4e38388\";s:4:\"Hash\";s:29:\"5775f6e8581168294160701045152\";s:8:\"NameHash\";s:69:\"20160701_e38387e383a2e382b5e382a4e38388_5775f6e8581168294160701045152\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:69:\"/home/sample100/public_html/demo.sample100.jetboy.jp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"http://demo.sample100.jetboy.jp/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:52;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "4", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3", "4", "_edit_lock", "1467111135:1");
INSERT INTO `wp_postmeta` VALUES("4", "6", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("5", "6", "_edit_lock", "1467111171:1");
INSERT INTO `wp_postmeta` VALUES("6", "8", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("7", "8", "_edit_lock", "1467091814:1");
INSERT INTO `wp_postmeta` VALUES("8", "10", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("9", "10", "_edit_lock", "1467091846:1");
INSERT INTO `wp_postmeta` VALUES("46", "2", "_edit_lock", "1467106180:1");
INSERT INTO `wp_postmeta` VALUES("113", "72", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:187110;s:10:\"size_after\";i:187110;s:4:\"time\";d:0.210000000000000019984014443252817727625370025634765625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:3635;s:10:\"size_after\";i:3635;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7177;s:10:\"size_after\";i:7177;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:35854;s:10:\"size_after\";i:35854;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:59382;s:10:\"size_after\";i:59382;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:81062;s:10:\"size_after\";i:81062;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}}}");
INSERT INTO `wp_postmeta` VALUES("112", "72", "_wp_attached_file", "2016/06/262.jpg");
INSERT INTO `wp_postmeta` VALUES("47", "2", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("28", "14", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("29", "14", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("30", "14", "_menu_item_object_id", "6");
INSERT INTO `wp_postmeta` VALUES("31", "14", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("32", "14", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("33", "14", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("34", "14", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("35", "14", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("48", "19", "_wp_attached_file", "2016/06/AKANE278122238_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("37", "15", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("38", "15", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("39", "15", "_menu_item_object_id", "4");
INSERT INTO `wp_postmeta` VALUES("40", "15", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("41", "15", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("42", "15", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("43", "15", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("44", "15", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("49", "19", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:244180;s:10:\"size_after\";i:244180;s:4:\"time\";d:0.2399999999999999911182158029987476766109466552734375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6070;s:10:\"size_after\";i:6070;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:11702;s:10:\"size_after\";i:11702;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:49185;s:10:\"size_after\";i:49185;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:77688;s:10:\"size_after\";i:77688;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:99535;s:10:\"size_after\";i:99535;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}}}");
INSERT INTO `wp_postmeta` VALUES("50", "19", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:31:\"2016/06/AKANE278122238_TP_V.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"AKANE278122238_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.3% (408.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"AKANE278122238_TP_V-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 3.7% (444.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"AKANE278122238_TP_V-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:32:\"Reduced by 2.0% (1,004.0&nbsp;B)\";}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"AKANE278122238_TP_V-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 1.8% (1.4&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:32:\"AKANE278122238_TP_V-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 1.8% (1.8&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 1.8% (4.1&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("51", "23", "_wp_attached_file", "2016/06/MAR_DSC0478_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("52", "23", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:379814;s:10:\"size_after\";i:379814;s:4:\"time\";d:0.4899999999999999911182158029987476766109466552734375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5607;s:10:\"size_after\";i:5607;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:13343;s:10:\"size_after\";i:13343;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:73606;s:10:\"size_after\";i:73606;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:123421;s:10:\"size_after\";i:123421;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:163837;s:10:\"size_after\";i:163837;s:4:\"time\";d:0.309999999999999997779553950749686919152736663818359375;}}}");
INSERT INTO `wp_postmeta` VALUES("53", "23", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:980;s:4:\"file\";s:28:\"2016/06/MAR_DSC0478_TP_V.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"MAR_DSC0478_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.8% (407.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"MAR_DSC0478_TP_V-300x184.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:184;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.4% (611.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:28:\"MAR_DSC0478_TP_V-768x470.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.4% (3.3&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:29:\"MAR_DSC0478_TP_V-1024x627.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:627;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.4% (5.5&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:29:\"MAR_DSC0478_TP_V-1200x735.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:735;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.3% (7.2&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 3.4% (14.1&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("54", "26", "_wp_attached_file", "2016/06/AME84_amenoodaiba_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("55", "26", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:418990;s:10:\"size_after\";i:418990;s:4:\"time\";d:0.39000000000000001332267629550187848508358001708984375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7644;s:10:\"size_after\";i:7644;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:17355;s:10:\"size_after\";i:17355;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:83650;s:10:\"size_after\";i:83650;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:135565;s:10:\"size_after\";i:135565;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:174776;s:10:\"size_after\";i:174776;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}}}");
INSERT INTO `wp_postmeta` VALUES("56", "26", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:34:\"2016/06/AME84_amenoodaiba_TP_V.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"AME84_amenoodaiba_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 7.0% (577.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"AME84_amenoodaiba_TP_V-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 6.4% (1.2&nbsp;kB)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:34:\"AME84_amenoodaiba_TP_V-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.5% (4.8&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:35:\"AME84_amenoodaiba_TP_V-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.1% (7.1&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:35:\"AME84_amenoodaiba_TP_V-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.9% (8.7&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.9% (21.1&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("57", "27", "_wp_attached_file", "2016/06/20130321-P3210210_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("58", "27", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:333070;s:10:\"size_after\";i:333070;s:4:\"time\";d:0.309999999999999997779553950749686919152736663818359375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:4880;s:10:\"size_after\";i:4880;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:11455;s:10:\"size_after\";i:11455;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:63915;s:10:\"size_after\";i:63915;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:108970;s:10:\"size_after\";i:108970;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:143850;s:10:\"size_after\";i:143850;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}}}");
INSERT INTO `wp_postmeta` VALUES("59", "27", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:34:\"2016/06/20130321-P3210210_TP_V.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"20130321-P3210210_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 7.3% (385.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"20130321-P3210210_TP_V-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.8% (581.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:34:\"20130321-P3210210_TP_V-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.2% (2.8&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:35:\"20130321-P3210210_TP_V-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.9% (5.5&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:35:\"20130321-P3210210_TP_V-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.1% (7.6&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:31:\"Reduced by 10.1% (57.8&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("60", "28", "_wp_attached_file", "2016/06/UNI128200110_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("61", "28", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:319167;s:10:\"size_after\";i:319167;s:4:\"time\";d:0.5300000000000000266453525910037569701671600341796875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5917;s:10:\"size_after\";i:5917;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:12950;s:10:\"size_after\";i:12950;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:62597;s:10:\"size_after\";i:62597;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:103201;s:10:\"size_after\";i:103201;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:134502;s:10:\"size_after\";i:134502;s:4:\"time\";d:0.330000000000000015543122344752191565930843353271484375;}}}");
INSERT INTO `wp_postmeta` VALUES("62", "28", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:29:\"2016/06/UNI128200110_TP_V.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"UNI128200110_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.6% (421.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"UNI128200110_TP_V-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.2% (851.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"UNI128200110_TP_V-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 6.2% (4.0&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"UNI128200110_TP_V-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.7% (6.1&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:30:\"UNI128200110_TP_V-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.8% (8.0&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.9% (21.4&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("63", "29", "_wp_attached_file", "2016/06/UNI15052349sandiego03_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("64", "29", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:441293;s:10:\"size_after\";i:441293;s:4:\"time\";d:0.480000000000000037747582837255322374403476715087890625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:8187;s:10:\"size_after\";i:8187;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:16386;s:10:\"size_after\";i:16386;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:86007;s:10:\"size_after\";i:86007;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:142695;s:10:\"size_after\";i:142695;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:188018;s:10:\"size_after\";i:188018;s:4:\"time\";d:0.2600000000000000088817841970012523233890533447265625;}}}");
INSERT INTO `wp_postmeta` VALUES("65", "29", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:939;s:4:\"file\";s:38:\"2016/06/UNI15052349sandiego03_TP_V.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:38:\"UNI15052349sandiego03_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.3% (548.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:38:\"UNI15052349sandiego03_TP_V-300x176.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.7% (987.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:38:\"UNI15052349sandiego03_TP_V-768x451.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:451;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.9% (4.3&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:39:\"UNI15052349sandiego03_TP_V-1024x601.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:601;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.7% (6.9&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:39:\"UNI15052349sandiego03_TP_V-1200x704.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:704;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.7% (9.1&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.0% (24.6&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("66", "31", "_wp_attached_file", "2016/06/moro_IMG_1861_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("67", "31", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:170296;s:10:\"size_after\";i:170296;s:4:\"time\";d:0.38000000000000000444089209850062616169452667236328125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:9:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:3956;s:10:\"size_after\";i:3956;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7091;s:10:\"size_after\";i:7091;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:32146;s:10:\"size_after\";i:32146;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:52268;s:10:\"size_after\";i:52268;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:21:\"estore-featured-image\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:10280;s:10:\"size_after\";i:10280;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:19:\"estore-product-grid\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1617;s:10:\"size_after\";i:1617;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:13:\"estore-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:21713;s:10:\"size_after\";i:21713;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"estore-slider\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:35282;s:10:\"size_after\";i:35282;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:19:\"estore-medium-image\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5943;s:10:\"size_after\";i:5943;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}}}");
INSERT INTO `wp_postmeta` VALUES("68", "31", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:30:\"2016/06/moro_IMG_1861_TP_V.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"moro_IMG_1861_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 8.7% (379.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"moro_IMG_1861_TP_V-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.9% (447.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"moro_IMG_1861_TP_V-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.8% (1.6&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"moro_IMG_1861_TP_V-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.3% (2.8&nbsp;kB)\";}s:21:\"estore-featured-image\";a:5:{s:4:\"file\";s:30:\"moro_IMG_1861_TP_V-380x250.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.6% (491.0&nbsp;B)\";}s:19:\"estore-product-grid\";a:5:{s:4:\"file\";s:28:\"moro_IMG_1861_TP_V-75x75.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:31:\"Reduced by 18.7% (373.0&nbsp;B)\";}s:13:\"estore-square\";a:5:{s:4:\"file\";s:30:\"moro_IMG_1861_TP_V-444x444.jpg\";s:5:\"width\";i:444;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.1% (921.0&nbsp;B)\";}s:13:\"estore-slider\";a:5:{s:4:\"file\";s:30:\"moro_IMG_1861_TP_V-800x521.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:521;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.8% (1.7&nbsp;kB)\";}s:19:\"estore-medium-image\";a:5:{s:4:\"file\";s:30:\"moro_IMG_1861_TP_V-250x180.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.4% (406.0&nbsp;B)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.0% (5.3&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("69", "32", "_wp_attached_file", "2016/06/moro8452_IMG_2002_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("70", "32", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:233278;s:10:\"size_after\";i:233278;s:4:\"time\";d:0.44000000000000005773159728050814010202884674072265625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:9:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5326;s:10:\"size_after\";i:5326;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:10286;s:10:\"size_after\";i:10286;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:43994;s:10:\"size_after\";i:43994;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:72837;s:10:\"size_after\";i:72837;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:21:\"estore-featured-image\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:14673;s:10:\"size_after\";i:14673;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:19:\"estore-product-grid\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:2072;s:10:\"size_after\";i:2072;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:13:\"estore-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:27494;s:10:\"size_after\";i:27494;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:13:\"estore-slider\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:48214;s:10:\"size_after\";i:48214;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:19:\"estore-medium-image\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:8382;s:10:\"size_after\";i:8382;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}}}");
INSERT INTO `wp_postmeta` VALUES("71", "32", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:34:\"2016/06/moro8452_IMG_2002_TP_V.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"moro8452_IMG_2002_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.8% (388.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"moro8452_IMG_2002_TP_V-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 3.8% (401.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:34:\"moro8452_IMG_2002_TP_V-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.3% (1.5&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:35:\"moro8452_IMG_2002_TP_V-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.2% (3.1&nbsp;kB)\";}s:21:\"estore-featured-image\";a:5:{s:4:\"file\";s:34:\"moro8452_IMG_2002_TP_V-380x250.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 3.0% (448.0&nbsp;B)\";}s:19:\"estore-product-grid\";a:5:{s:4:\"file\";s:32:\"moro8452_IMG_2002_TP_V-75x75.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:31:\"Reduced by 15.6% (382.0&nbsp;B)\";}s:13:\"estore-square\";a:5:{s:4:\"file\";s:34:\"moro8452_IMG_2002_TP_V-444x444.jpg\";s:5:\"width\";i:444;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 3.5% (983.0&nbsp;B)\";}s:13:\"estore-slider\";a:5:{s:4:\"file\";s:34:\"moro8452_IMG_2002_TP_V-800x521.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:521;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.8% (1.9&nbsp;kB)\";}s:19:\"estore-medium-image\";a:5:{s:4:\"file\";s:34:\"moro8452_IMG_2002_TP_V-250x180.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.4% (389.0&nbsp;B)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.0% (15.0&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("72", "4", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("73", "4", "estore_page_specific_layout", "default_layout");
INSERT INTO `wp_postmeta` VALUES("74", "34", "_wp_attached_file", "2016/06/AME84_ganmineko_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("75", "34", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:251857;s:10:\"size_after\";i:251857;s:4:\"time\";d:0.5100000000000000088817841970012523233890533447265625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:9:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5998;s:10:\"size_after\";i:5998;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:12370;s:10:\"size_after\";i:12370;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:48349;s:10:\"size_after\";i:48349;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:75409;s:10:\"size_after\";i:75409;s:4:\"time\";d:0.1700000000000000122124532708767219446599483489990234375;}s:21:\"estore-featured-image\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:17133;s:10:\"size_after\";i:17133;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:19:\"estore-product-grid\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:2363;s:10:\"size_after\";i:2363;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"estore-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:28083;s:10:\"size_after\";i:28083;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"estore-slider\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:51917;s:10:\"size_after\";i:51917;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:19:\"estore-medium-image\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:10235;s:10:\"size_after\";i:10235;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}}}");
INSERT INTO `wp_postmeta` VALUES("76", "34", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:32:\"2016/06/AME84_ganmineko_TP_V.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"AME84_ganmineko_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.4% (410.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"AME84_ganmineko_TP_V-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.4% (575.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"AME84_ganmineko_TP_V-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.6% (1.8&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:33:\"AME84_ganmineko_TP_V-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.4% (2.6&nbsp;kB)\";}s:21:\"estore-featured-image\";a:5:{s:4:\"file\";s:32:\"AME84_ganmineko_TP_V-380x250.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.1% (727.0&nbsp;B)\";}s:19:\"estore-product-grid\";a:5:{s:4:\"file\";s:30:\"AME84_ganmineko_TP_V-75x75.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:31:\"Reduced by 14.0% (384.0&nbsp;B)\";}s:13:\"estore-square\";a:5:{s:4:\"file\";s:32:\"AME84_ganmineko_TP_V-444x444.jpg\";s:5:\"width\";i:444;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.9% (1.1&nbsp;kB)\";}s:13:\"estore-slider\";a:5:{s:4:\"file\";s:32:\"AME84_ganmineko_TP_V-800x521.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:521;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.0% (2.1&nbsp;kB)\";}s:19:\"estore-medium-image\";a:5:{s:4:\"file\";s:32:\"AME84_ganmineko_TP_V-250x180.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.6% (492.0&nbsp;B)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.8% (8.7&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("77", "43", "_wp_attached_file", "2016/06/sekisetu140208048196.jpg");
INSERT INTO `wp_postmeta` VALUES("78", "43", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:325678;s:10:\"size_after\";i:325678;s:4:\"time\";d:0.54999999999999993338661852249060757458209991455078125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6127;s:10:\"size_after\";i:6127;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:13622;s:10:\"size_after\";i:13622;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:64648;s:10:\"size_after\";i:64648;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:105103;s:10:\"size_after\";i:105103;s:4:\"time\";d:0.289999999999999980015985556747182272374629974365234375;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:136178;s:10:\"size_after\";i:136178;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}}}");
INSERT INTO `wp_postmeta` VALUES("79", "43", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:5679;s:6:\"height\";i:3641;s:4:\"file\";s:32:\"2016/06/sekisetu140208048196.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"sekisetu140208048196-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.4% (420.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"sekisetu140208048196-300x192.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.1% (588.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"sekisetu140208048196-768x492.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 2.5% (1.6&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:33:\"sekisetu140208048196-1024x657.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:657;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 2.6% (2.7&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:33:\"sekisetu140208048196-1200x769.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:769;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 2.7% (3.7&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:31:\"Reduced by 6.7% (512.1&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("80", "43", "_edit_lock", "1467107461:1");
INSERT INTO `wp_postmeta` VALUES("81", "49", "_wp_attached_file", "2016/06/MIDSC_8613_TP_V.jpg");
INSERT INTO `wp_postmeta` VALUES("82", "49", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:133726;s:10:\"size_after\";i:133726;s:4:\"time\";d:0.32999999999999996003197111349436454474925994873046875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:2819;s:10:\"size_after\";i:2819;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5498;s:10:\"size_after\";i:5498;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:24841;s:10:\"size_after\";i:24841;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:42323;s:10:\"size_after\";i:42323;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:58245;s:10:\"size_after\";i:58245;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}}}");
INSERT INTO `wp_postmeta` VALUES("83", "49", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1068;s:4:\"file\";s:27:\"2016/06/MIDSC_8613_TP_V.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"MIDSC_8613_TP_V-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:31:\"Reduced by 13.7% (448.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"MIDSC_8613_TP_V-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 9.7% (589.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:27:\"MIDSC_8613_TP_V-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 9.4% (2.5&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:28:\"MIDSC_8613_TP_V-1024x684.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:684;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 10.2% (4.7&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:28:\"MIDSC_8613_TP_V-1200x801.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:801;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 10.7% (6.8&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 2.2% (4.1&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("84", "55", "_wp_attached_file", "2016/06/336k.jpg");
INSERT INTO `wp_postmeta` VALUES("85", "55", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:294853;s:10:\"size_after\";i:294853;s:4:\"time\";d:0.340000000000000024424906541753443889319896697998046875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5224;s:10:\"size_after\";i:5224;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:12147;s:10:\"size_after\";i:12147;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:57828;s:10:\"size_after\";i:57828;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:94518;s:10:\"size_after\";i:94518;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:125136;s:10:\"size_after\";i:125136;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}}}");
INSERT INTO `wp_postmeta` VALUES("86", "55", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1068;s:4:\"file\";s:16:\"2016/06/336k.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"336k-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.7% (377.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"336k-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.2% (526.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"336k-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.7% (2.2&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"336k-1024x684.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:684;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.5% (3.3&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:17:\"336k-1200x801.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:801;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 3.7% (4.7&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.2% (13.6&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("87", "56", "_wp_attached_file", "2016/06/451k.jpg");
INSERT INTO `wp_postmeta` VALUES("88", "56", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:352839;s:10:\"size_after\";i:352839;s:4:\"time\";d:0.39000000000000001332267629550187848508358001708984375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5361;s:10:\"size_after\";i:5361;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:12045;s:10:\"size_after\";i:12045;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:66788;s:10:\"size_after\";i:66788;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:115218;s:10:\"size_after\";i:115218;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:153427;s:10:\"size_after\";i:153427;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}}}");
INSERT INTO `wp_postmeta` VALUES("89", "56", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:16:\"2016/06/451k.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"451k-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.3% (363.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"451k-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.6% (587.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"451k-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.6% (3.9&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"451k-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.8% (6.9&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:17:\"451k-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 6.0% (9.5&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.7% (29.5&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("90", "57", "_wp_attached_file", "2016/06/520k.jpg");
INSERT INTO `wp_postmeta` VALUES("91", "57", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:566757;s:10:\"size_after\";i:566757;s:4:\"time\";d:0.440000000000000002220446049250313080847263336181640625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7408;s:10:\"size_after\";i:7408;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:19804;s:10:\"size_after\";i:19804;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:113568;s:10:\"size_after\";i:113568;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:183989;s:10:\"size_after\";i:183989;s:4:\"time\";d:0.179999999999999993338661852249060757458209991455078125;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:241988;s:10:\"size_after\";i:241988;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}}}");
INSERT INTO `wp_postmeta` VALUES("92", "57", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1200;s:4:\"file\";s:16:\"2016/06/520k.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"520k-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.6% (521.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"520k-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.7% (1.2&nbsp;kB)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"520k-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.9% (5.7&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"520k-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.3% (8.0&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:17:\"520k-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.5% (11.0&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 3.8% (19.4&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("93", "58", "_wp_attached_file", "2016/06/803k.jpg");
INSERT INTO `wp_postmeta` VALUES("94", "58", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:488773;s:10:\"size_after\";i:488773;s:4:\"time\";d:0.38000000000000000444089209850062616169452667236328125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6607;s:10:\"size_after\";i:6607;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:15766;s:10:\"size_after\";i:15766;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:93604;s:10:\"size_after\";i:93604;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:158775;s:10:\"size_after\";i:158775;s:4:\"time\";d:0.2099999999999999922284388276239042170345783233642578125;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:214021;s:10:\"size_after\";i:214021;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}}}");
INSERT INTO `wp_postmeta` VALUES("95", "58", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1068;s:4:\"file\";s:16:\"2016/06/803k.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"803k-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.7% (472.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"803k-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 6.3% (1.0&nbsp;kB)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"803k-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.9% (5.8&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"803k-1024x684.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:684;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.9% (9.7&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:17:\"803k-1200x801.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:801;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.8% (12.9&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 9.9% (77.9&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("96", "59", "_wp_attached_file", "2016/06/545k.jpg");
INSERT INTO `wp_postmeta` VALUES("97", "59", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:459144;s:10:\"size_after\";i:459144;s:4:\"time\";d:0.770000000000000017763568394002504646778106689453125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7081;s:10:\"size_after\";i:7081;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:16320;s:10:\"size_after\";i:16320;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:88232;s:10:\"size_after\";i:88232;s:4:\"time\";d:0.2300000000000000099920072216264088638126850128173828125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:149462;s:10:\"size_after\";i:149462;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:198049;s:10:\"size_after\";i:198049;s:4:\"time\";d:0.35999999999999998667732370449812151491641998291015625;}}}");
INSERT INTO `wp_postmeta` VALUES("98", "59", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:16:\"2016/06/545k.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"545k-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.6% (417.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"545k-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.7% (810.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"545k-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.4% (4.0&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"545k-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.2% (6.3&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:17:\"545k-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.1% (8.3&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.4% (28.4&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("103", "64", "_wp_attached_file", "2016/06/8700k.jpg");
INSERT INTO `wp_postmeta` VALUES("104", "64", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:136349;s:10:\"size_after\";i:136349;s:4:\"time\";d:0.25;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:2814;s:10:\"size_after\";i:2814;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5500;s:10:\"size_after\";i:5500;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:25053;s:10:\"size_after\";i:25053;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:43304;s:10:\"size_after\";i:43304;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:59678;s:10:\"size_after\";i:59678;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}}}");
INSERT INTO `wp_postmeta` VALUES("105", "64", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:6016;s:6:\"height\";i:4016;s:4:\"file\";s:17:\"2016/06/8700k.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"8700k-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:31:\"Reduced by 13.9% (456.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"8700k-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 9.6% (583.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"8700k-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 9.5% (2.6&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:18:\"8700k-1024x684.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:684;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 10.7% (5.1&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:18:\"8700k-1200x801.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:801;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 11.1% (7.2&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:10:\"No savings\";}");
INSERT INTO `wp_postmeta` VALUES("106", "8", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("107", "8", "_wp_trash_meta_time", "1467110192");
INSERT INTO `wp_postmeta` VALUES("108", "8", "_wp_desired_post_slug", "sample3");
INSERT INTO `wp_postmeta` VALUES("109", "10", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("110", "10", "_wp_trash_meta_time", "1467110195");
INSERT INTO `wp_postmeta` VALUES("111", "10", "_wp_desired_post_slug", "sample4");
INSERT INTO `wp_postmeta` VALUES("114", "72", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:887;s:4:\"file\";s:15:\"2016/06/262.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"262-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 9.4% (378.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"262-300x166.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.5% (421.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"262-768x426.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:426;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.5% (2.0&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"262-1024x568.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:568;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 6.0% (3.7&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:16:\"262-1200x665.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:665;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 6.4% (5.4&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.5% (16.6&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("115", "74", "_wp_attached_file", "2016/06/623.jpg");
INSERT INTO `wp_postmeta` VALUES("116", "74", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:496916;s:10:\"size_after\";i:496916;s:4:\"time\";d:0.729999999999999982236431605997495353221893310546875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6543;s:10:\"size_after\";i:6543;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:15541;s:10:\"size_after\";i:15541;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:93181;s:10:\"size_after\";i:93181;s:4:\"time\";d:0.2399999999999999911182158029987476766109466552734375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:163178;s:10:\"size_after\";i:163178;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:218473;s:10:\"size_after\";i:218473;s:4:\"time\";d:0.2800000000000000266453525910037569701671600341796875;}}}");
INSERT INTO `wp_postmeta` VALUES("117", "74", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:15:\"2016/06/623.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"623-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.2% (431.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"623-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:32:\"Reduced by 6.1% (1,005.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"623-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 6.4% (6.2&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"623-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.2% (10.6&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:16:\"623-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.4% (14.5&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.6% (40.0&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("118", "74", "_edit_lock", "1467110745:1");
INSERT INTO `wp_postmeta` VALUES("119", "76", "_wp_attached_file", "2016/06/573.jpg");
INSERT INTO `wp_postmeta` VALUES("120", "76", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:437552;s:10:\"size_after\";i:437552;s:4:\"time\";d:0.560000000000000053290705182007513940334320068359375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5592;s:10:\"size_after\";i:5592;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:14016;s:10:\"size_after\";i:14016;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:81658;s:10:\"size_after\";i:81658;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:142742;s:10:\"size_after\";i:142742;s:4:\"time\";d:0.289999999999999980015985556747182272374629974365234375;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:193544;s:10:\"size_after\";i:193544;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}}}");
INSERT INTO `wp_postmeta` VALUES("121", "76", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:15:\"2016/06/573.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"573-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 6.2% (372.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"573-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.4% (642.0&nbsp;B)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"573-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.1% (3.4&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"573-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.4% (6.4&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:16:\"573-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 4.6% (9.1&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 5.2% (28.8&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("122", "76", "_edit_lock", "1467111006:1");
INSERT INTO `wp_postmeta` VALUES("123", "79", "_wp_attached_file", "2016/06/524.jpg");
INSERT INTO `wp_postmeta` VALUES("124", "79", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:498645;s:10:\"size_after\";i:498645;s:4:\"time\";d:0.38000000000000000444089209850062616169452667236328125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7777;s:10:\"size_after\";i:7777;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:17882;s:10:\"size_after\";i:17882;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:97229;s:10:\"size_after\";i:97229;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:162740;s:10:\"size_after\";i:162740;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:14:\"post-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:213017;s:10:\"size_after\";i:213017;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}}}");
INSERT INTO `wp_postmeta` VALUES("125", "79", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:15:\"2016/06/524.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"524-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 7.1% (595.0&nbsp;B)\";}s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"524-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 6.9% (1.3&nbsp;kB)\";}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"524-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.6% (5.7&nbsp;kB)\";}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"524-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:29:\"Reduced by 5.1% (8.5&nbsp;kB)\";}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:16:\"524-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.8% (10.6&nbsp;kB)\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:20:\"ewww_image_optimizer\";s:30:\"Reduced by 4.9% (24.9&nbsp;kB)\";}");
INSERT INTO `wp_postmeta` VALUES("126", "82", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("127", "82", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("128", "82", "_menu_item_object_id", "82");
INSERT INTO `wp_postmeta` VALUES("129", "82", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("130", "82", "_menu_item_target", "_blank");
INSERT INTO `wp_postmeta` VALUES("131", "82", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("132", "82", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("133", "82", "_menu_item_url", "https://gtmetrix.com/?url=http%3A%2F%2Fdemo.sample100.jetboy.jp");
INSERT INTO `wp_postmeta` VALUES("135", "83", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("136", "83", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("137", "83", "_menu_item_object_id", "83");
INSERT INTO `wp_postmeta` VALUES("138", "83", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("139", "83", "_menu_item_target", "_blank");
INSERT INTO `wp_postmeta` VALUES("140", "83", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("141", "83", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("142", "83", "_menu_item_url", "https://developers.google.com/speed/pagespeed/insights/?hl=ja&url=http%3A%2F%2Fdemo.sample100.jetboy.jp&tab=desktop");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2016-06-28 01:54:23", "2016-06-28 01:54:23", "Welcome to WordPress. This is your first post. Edit or delete it, then start writing!", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2016-06-28 01:54:23", "2016-06-28 01:54:23", "", "0", "http://demo.sample100.jetboy.jp/?p=1", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("2", "1", "2016-06-28 01:54:23", "2016-06-28 01:54:23", "<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-23\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-300x184.jpg\" alt=\"MAR_DSC0478_TP_V\" width=\"300\" height=\"184\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-26\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V-300x200.jpg\" alt=\"AME84_amenoodaiba_TP_V\" width=\"300\" height=\"200\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-27\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V-300x200.jpg\" alt=\"20130321-P3210210_TP_V\" width=\"300\" height=\"200\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-28\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V-300x200.jpg\" alt=\"UNI128200110_TP_V\" width=\"300\" height=\"200\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-29\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V-300x176.jpg\" alt=\"UNI15052349sandiego03_TP_V\" width=\"300\" height=\"176\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。", "サンプルページ", "", "publish", "closed", "open", "", "top", "", "", "2016-06-28 06:12:12", "2016-06-28 06:12:12", "", "0", "http://demo.sample100.jetboy.jp/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("3", "1", "2016-06-28 01:54:42", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "open", "open", "", "", "", "", "2016-06-28 01:54:42", "0000-00-00 00:00:00", "", "0", "http://demo.sample100.jetboy.jp/?p=3", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("4", "1", "2016-06-28 05:31:53", "2016-06-28 05:31:53", "<h4>冬の八ヶ岳連峰（天狗岳）</h4>\r\n(JPEG 262KB SIZE:1600 × 887)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg\"/>\r\n<h4>八甲田山</h4>\r\n(JPEG 623KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623.jpg\" />\r\n<h4>ジョシュア・ツリー国立公園(アメリカロサンゼルス)</h4>\r\n(JPEG 524KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524.jpg\" />\r\n<h4>ベネズエラ・ブルーマウンテン</h4>\r\n(JPEG 803KB SIZE:1600 × 1068)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\" />\r\n<h4>旭岳（北海道）</h4>\r\n(JPEG 545KB SIZE:1600 × 1068)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル(KB)", "", "publish", "closed", "closed", "", "sample1", "", "", "2016-06-28 10:53:43", "2016-06-28 10:53:43", "", "0", "http://demo.sample100.jetboy.jp/?page_id=4", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5", "1", "2016-06-28 05:31:53", "2016-06-28 05:31:53", "", "サンプル1", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 05:31:53", "2016-06-28 05:31:53", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2016-06-28 05:32:11", "2016-06-28 05:32:11", "<h4>ウユニ塩湖の日の出</h4><p>（JPEG8.1MB Size:6016×4016）</p>\r\n<img class=\"alignnone size-medium wp-image-64\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg\" />", "超高画質ファイル(MB)", "", "publish", "closed", "closed", "", "sample2", "", "", "2016-06-28 10:55:06", "2016-06-28 10:55:06", "", "0", "http://demo.sample100.jetboy.jp/?page_id=6", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2016-06-28 05:32:11", "2016-06-28 05:32:11", "", "サンプル2", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 05:32:11", "2016-06-28 05:32:11", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2016-06-28 05:32:30", "2016-06-28 05:32:30", "", "サンプル3", "", "trash", "closed", "closed", "", "sample3__trashed", "", "", "2016-06-28 10:36:32", "2016-06-28 10:36:32", "", "0", "http://demo.sample100.jetboy.jp/?page_id=8", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2016-06-28 05:32:30", "2016-06-28 05:32:30", "", "サンプル3", "", "inherit", "closed", "closed", "", "8-revision-v1", "", "", "2016-06-28 05:32:30", "2016-06-28 05:32:30", "", "8", "http://demo.sample100.jetboy.jp/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2016-06-28 05:32:53", "2016-06-28 05:32:53", "", "サンプル4", "", "trash", "closed", "closed", "", "sample4__trashed", "", "", "2016-06-28 10:36:35", "2016-06-28 10:36:35", "", "0", "http://demo.sample100.jetboy.jp/?page_id=10", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2016-06-28 05:32:53", "2016-06-28 05:32:53", "", "サンプル4", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2016-06-28 05:32:53", "2016-06-28 05:32:53", "", "10", "http://demo.sample100.jetboy.jp/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2016-06-28 05:33:44", "2016-06-28 05:33:44", " ", "", "", "publish", "closed", "closed", "", "14", "", "", "2016-06-29 04:14:15", "2016-06-29 04:14:15", "", "0", "http://demo.sample100.jetboy.jp/?p=14", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2016-06-28 05:33:44", "2016-06-28 05:33:44", " ", "", "", "publish", "closed", "closed", "", "15", "", "", "2016-06-29 04:14:15", "2016-06-29 04:14:15", "", "0", "http://demo.sample100.jetboy.jp/?p=15", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("72", "1", "2016-06-28 10:41:39", "2016-06-28 10:41:39", "", "262", "", "inherit", "closed", "closed", "", "262", "", "", "2016-06-28 10:41:39", "2016-06-28 10:41:39", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2016-06-28 05:34:06", "2016-06-28 05:34:06", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\r\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like piña coladas. (And gettin\' caught in the rain.)</blockquote>\r\n...or something like this:\r\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\r\nAs a new WordPress user, you should go to <a href=\"http://demo.sample100.jetboy.jp/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "TOPページ", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-06-28 05:34:06", "2016-06-28 05:34:06", "", "2", "http://demo.sample100.jetboy.jp/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2016-06-28 05:55:21", "2016-06-28 05:55:21", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\r\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like piña coladas. (And gettin\' caught in the rain.)</blockquote>\r\n...or something like this:\r\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\r\nAs a new WordPress user, you should go to <a href=\"http://demo.sample100.jetboy.jp/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "サンプルページ", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-06-28 05:55:21", "2016-06-28 05:55:21", "", "2", "http://demo.sample100.jetboy.jp/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2016-06-28 06:11:06", "2016-06-28 06:11:06", "<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\n<img class=\"alignnone size-medium wp-image-23\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-300x184.jpg\" alt=\"MAR_DSC0478_TP_V\" width=\"300\" height=\"184\" />\n\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\n<img class=\"alignnone size-medium wp-image-26\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V-300x200.jpg\" alt=\"AME84_amenoodaiba_TP_V\" width=\"300\" height=\"200\" />\n\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\n<img class=\"alignnone size-medium wp-image-27\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V-300x200.jpg\" alt=\"20130321-P3210210_TP_V\" width=\"300\" height=\"200\" />\n\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\n<img class=\"alignnone size-medium wp-image-23\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-300x184.jpg\" alt=\"MAR_DSC0478_TP_V\" width=\"300\" height=\"184\" />\n\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\n<img class=\"alignnone size-medium wp-image-23\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-300x184.jpg\" alt=\"MAR_DSC0478_TP_V\" width=\"300\" height=\"184\" />\n\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。", "サンプルページ", "", "inherit", "closed", "closed", "", "2-autosave-v1", "", "", "2016-06-28 06:11:06", "2016-06-28 06:11:06", "", "2", "http://demo.sample100.jetboy.jp/2-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2016-06-28 06:03:20", "2016-06-28 06:03:20", "", "AKANE278122238_TP_V", "", "inherit", "open", "closed", "", "akane278122238_tp_v", "", "", "2016-06-28 06:03:20", "2016-06-28 06:03:20", "", "2", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2016-06-28 06:03:31", "2016-06-28 06:03:31", "<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-300x200.jpg\" alt=\"AKANE278122238_TP_V\" width=\"300\" height=\"200\" />\r\n\r\n&nbsp;\r\n\r\nThis is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\r\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like piña coladas. (And gettin\' caught in the rain.)</blockquote>\r\n...or something like this:\r\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\r\nAs a new WordPress user, you should go to <a href=\"http://demo.sample100.jetboy.jp/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "サンプルページ", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-06-28 06:03:31", "2016-06-28 06:03:31", "", "2", "http://demo.sample100.jetboy.jp/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2016-06-28 06:08:02", "2016-06-28 06:08:02", "<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-23\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-300x184.jpg\" alt=\"MAR_DSC0478_TP_V\" width=\"300\" height=\"184\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。", "サンプルページ", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-06-28 06:08:02", "2016-06-28 06:08:02", "", "2", "http://demo.sample100.jetboy.jp/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2016-06-28 06:05:31", "2016-06-28 06:05:31", "<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-300x200.jpg\" alt=\"AKANE278122238_TP_V\" width=\"300\" height=\"200\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\r\nAs a new WordPress user, you should go to <a href=\"http://demo.sample100.jetboy.jp/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "サンプルページ", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-06-28 06:05:31", "2016-06-28 06:05:31", "", "2", "http://demo.sample100.jetboy.jp/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2016-06-28 06:04:44", "2016-06-28 06:04:44", "<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-300x200.jpg\" alt=\"AKANE278122238_TP_V\" width=\"300\" height=\"200\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like piña coladas. (And gettin\' caught in the rain.)</blockquote>\r\n...or something like this:\r\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\r\nAs a new WordPress user, you should go to <a href=\"http://demo.sample100.jetboy.jp/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "サンプルページ", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-06-28 06:04:44", "2016-06-28 06:04:44", "", "2", "http://demo.sample100.jetboy.jp/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2016-06-28 06:06:48", "2016-06-28 06:06:48", "", "MAR_DSC0478_TP_V", "", "inherit", "open", "closed", "", "mar_dsc0478_tp_v", "", "", "2016-06-28 06:06:48", "2016-06-28 06:06:48", "", "2", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("24", "1", "2016-06-28 06:06:59", "2016-06-28 06:06:59", "<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-23\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-300x184.jpg\" alt=\"MAR_DSC0478_TP_V\" width=\"300\" height=\"184\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\r\nAs a new WordPress user, you should go to <a href=\"http://demo.sample100.jetboy.jp/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "サンプルページ", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-06-28 06:06:59", "2016-06-28 06:06:59", "", "2", "http://demo.sample100.jetboy.jp/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2016-06-28 06:09:38", "2016-06-28 06:09:38", "", "AME84_amenoodaiba_TP_V", "", "inherit", "open", "closed", "", "ame84_amenoodaiba_tp_v", "", "", "2016-06-28 06:09:38", "2016-06-28 06:09:38", "", "2", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2016-06-28 06:10:25", "2016-06-28 06:10:25", "", "20130321-P3210210_TP_V", "", "inherit", "open", "closed", "", "20130321-p3210210_tp_v", "", "", "2016-06-28 06:10:25", "2016-06-28 06:10:25", "", "2", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2016-06-28 06:11:38", "2016-06-28 06:11:38", "", "UNI128200110_TP_V", "", "inherit", "open", "closed", "", "uni128200110_tp_v", "", "", "2016-06-28 06:11:38", "2016-06-28 06:11:38", "", "2", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("29", "1", "2016-06-28 06:12:00", "2016-06-28 06:12:00", "", "UNI15052349sandiego03_TP_V", "", "inherit", "open", "closed", "", "uni15052349sandiego03_tp_v", "", "", "2016-06-28 06:12:00", "2016-06-28 06:12:00", "", "2", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2016-06-28 06:12:12", "2016-06-28 06:12:12", "<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-23\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MAR_DSC0478_TP_V-300x184.jpg\" alt=\"MAR_DSC0478_TP_V\" width=\"300\" height=\"184\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-26\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_amenoodaiba_TP_V-300x200.jpg\" alt=\"AME84_amenoodaiba_TP_V\" width=\"300\" height=\"200\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-27\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/20130321-P3210210_TP_V-300x200.jpg\" alt=\"20130321-P3210210_TP_V\" width=\"300\" height=\"200\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-28\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI128200110_TP_V-300x200.jpg\" alt=\"UNI128200110_TP_V\" width=\"300\" height=\"200\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。\r\n<blockquote>この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。</blockquote>\r\n<img class=\"alignnone size-medium wp-image-29\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/UNI15052349sandiego03_TP_V-300x176.jpg\" alt=\"UNI15052349sandiego03_TP_V\" width=\"300\" height=\"176\" />\r\n\r\nこの文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。この文章はダミーです。文字の大きさ、量、字間、行間等を確認するために入れています。", "サンプルページ", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-06-28 06:12:12", "2016-06-28 06:12:12", "", "2", "http://demo.sample100.jetboy.jp/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2016-06-28 06:27:22", "2016-06-28 06:27:22", "", "moro_IMG_1861_TP_V", "", "inherit", "open", "closed", "", "moro_img_1861_tp_v", "", "", "2016-06-28 06:27:22", "2016-06-28 06:27:22", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2016-06-28 06:27:43", "2016-06-28 06:27:43", "", "moro8452_IMG_2002_TP_V", "", "inherit", "open", "closed", "", "moro8452_img_2002_tp_v", "", "", "2016-06-28 06:27:43", "2016-06-28 06:27:43", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2016-06-28 09:57:41", "2016-06-28 09:57:41", "<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V.jpg\"/>", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 09:57:41", "2016-06-28 09:57:41", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2016-06-28 09:35:49", "2016-06-28 09:35:49", "<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-300x200.jpg\" alt=\"AKANE278122238_TP_V\"/>", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 09:35:49", "2016-06-28 09:35:49", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2016-06-28 06:28:00", "2016-06-28 06:28:00", "<img class=\"alignnone size-medium wp-image-31\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-300x200.jpg\" alt=\"moro_IMG_1861_TP_V\" width=\"300\" height=\"200\" /> <img class=\"alignnone size-medium wp-image-32\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-300x200.jpg\" alt=\"moro8452_IMG_2002_TP_V\" width=\"300\" height=\"200\" />", "サンプル1", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 06:28:00", "2016-06-28 06:28:00", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2016-06-28 06:28:40", "2016-06-28 06:28:40", "", "AME84_ganmineko_TP_V", "", "inherit", "open", "closed", "", "ame84_ganmineko_tp_v", "", "", "2016-06-28 06:28:40", "2016-06-28 06:28:40", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2016-06-28 10:52:44", "2016-06-28 10:52:44", "<h4>冬の八ヶ岳連峰（天狗岳）</h4>\n(JPEG 262KB SIZE:1600 × 887)\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg\"/>\n<h4>八甲田山</h4>\n(JPEG 623KB SIZE:1600 × 1066)\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623.jpg\" />\n<h4>タヒチ</h4>\n(JPEG 573KB SIZE:1600 × 1066)\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573.jpg\" />\n<h4>ベネズエラ・ブルーマウンテン</h4>\n(JPEG 803KB SIZE:1600 × 1068)\n\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/5k.jpg\" />\n<h4>旭岳（北海道）</h4>\n(JPEG 545KB SIZE:1600 × 1068)\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル(KB)", "", "inherit", "closed", "closed", "", "4-autosave-v1", "", "", "2016-06-28 10:52:44", "2016-06-28 10:52:44", "", "4", "http://demo.sample100.jetboy.jp/4-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2016-06-28 09:49:18", "2016-06-28 09:49:18", "", "sekisetu140208048196", "", "inherit", "closed", "closed", "", "sekisetu140208048196", "", "", "2016-06-28 09:49:18", "2016-06-28 09:49:18", "", "6", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("44", "1", "2016-06-28 10:15:21", "2016-06-28 10:15:21", "", "高画質ファイル7.8MB", "", "inherit", "closed", "closed", "", "6-autosave-v1", "", "", "2016-06-28 10:15:21", "2016-06-28 10:15:21", "", "6", "http://demo.sample100.jetboy.jp/6-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2016-06-28 09:32:48", "2016-06-28 09:32:48", "<img class=\"size-medium wp-image-31 alignleft\" src=\"http://dummyimage.com/300\" alt=\"moro_IMG_1861_TP_V\"/>", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 09:32:48", "2016-06-28 09:32:48", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2016-06-28 06:29:25", "2016-06-28 06:29:25", "<img class=\"alignnone size-medium wp-image-31\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-300x200.jpg\" alt=\"moro_IMG_1861_TP_V\" width=\"300\" height=\"200\" />\r\n<img class=\"alignnone size-medium wp-image-32\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-300x200.jpg\" alt=\"moro8452_IMG_2002_TP_V\" width=\"300\" height=\"200\" />\r\n<img class=\"alignnone size-medium wp-image-34\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-300x200.jpg\" alt=\"AME84_ganmineko_TP_V\" width=\"300\" height=\"200\" />", "サンプル1", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 06:29:25", "2016-06-28 06:29:25", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2016-06-28 06:29:46", "2016-06-28 06:29:46", "<img class=\"alignnone size-medium wp-image-31\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-300x200.jpg\" alt=\"moro_IMG_1861_TP_V\" width=\"300\" height=\"200\" />　<img class=\"alignnone size-medium wp-image-32\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-300x200.jpg\" alt=\"moro8452_IMG_2002_TP_V\" width=\"300\" height=\"200\" />　<img class=\"alignnone size-medium wp-image-34\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-300x200.jpg\" alt=\"AME84_ganmineko_TP_V\" width=\"300\" height=\"200\" />", "サンプル1", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 06:29:46", "2016-06-28 06:29:46", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2016-06-28 06:36:23", "2016-06-28 06:36:23", "<img class=\"size-medium wp-image-31 alignleft\" src=\"http://dummyimage.com/300\" alt=\"moro_IMG_1861_TP_V\" width=\"300\" height=\"200\" />　<img class=\"size-medium wp-image-32 alignright\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-300x200.jpg\" alt=\"moro8452_IMG_2002_TP_V\" width=\"300\" height=\"200\" />　<img class=\"size-medium wp-image-34 aligncenter\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-300x200.jpg\" alt=\"AME84_ganmineko_TP_V\" width=\"300\" height=\"200\" />", "サンプル1", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 06:36:23", "2016-06-28 06:36:23", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2016-06-28 06:31:38", "2016-06-28 06:31:38", "<img class=\"size-medium wp-image-31 alignleft\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro_IMG_1861_TP_V-300x200.jpg\" alt=\"moro_IMG_1861_TP_V\" width=\"300\" height=\"200\" />　<img class=\"size-medium wp-image-32 alignright\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/moro8452_IMG_2002_TP_V-300x200.jpg\" alt=\"moro8452_IMG_2002_TP_V\" width=\"300\" height=\"200\" />　<img class=\"size-medium wp-image-34 aligncenter\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AME84_ganmineko_TP_V-300x200.jpg\" alt=\"AME84_ganmineko_TP_V\" width=\"300\" height=\"200\" />", "サンプル1", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 06:31:38", "2016-06-28 06:31:38", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2016-06-28 09:34:16", "2016-06-28 09:34:16", "<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V-300x200.jpg\" alt=\"AKANE278122238_TP_V\" width=\"300\" height=\"200\" />", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 09:34:16", "2016-06-28 09:34:16", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("65", "1", "2016-06-28 10:31:06", "2016-06-28 10:31:06", "<img class=\"alignnone size-medium wp-image-64\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg\" />", "高画質ファイル7.8MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 10:31:06", "2016-06-28 10:31:06", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("45", "1", "2016-06-28 09:50:01", "2016-06-28 09:50:01", "<img class=\"alignnone size-medium wp-image-43\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196-300x192.jpg\" alt=\"sekisetu140208048196\" />", "高画質ファイル7.8MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 09:50:01", "2016-06-28 09:50:01", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2016-06-28 09:50:07", "2016-06-28 09:50:07", "<img class=\"alignnone size-medium wp-image-43\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196-300x192.jpg\"/>", "高画質ファイル7.8MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 09:50:07", "2016-06-28 09:50:07", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2016-06-28 09:50:48", "2016-06-28 09:50:48", "<img class=\"alignnone size-medium wp-image-43\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196-300x192.jpg\" width=\"3641\"/>", "高画質ファイル7.8MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 09:50:48", "2016-06-28 09:50:48", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2016-06-28 09:52:34", "2016-06-28 09:52:34", "<img class=\"alignnone size-medium wp-image-43\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/sekisetu140208048196.jpg\"/>", "高画質ファイル7.8MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 09:52:34", "2016-06-28 09:52:34", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2016-06-28 09:54:30", "2016-06-28 09:54:30", "", "MIDSC_8613_TP_V", "", "inherit", "closed", "closed", "", "midsc_8613_tp_v", "", "", "2016-06-28 09:54:30", "2016-06-28 09:54:30", "", "6", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MIDSC_8613_TP_V.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2016-06-28 09:54:52", "2016-06-28 09:54:52", "<img class=\"alignnone size-medium wp-image-49\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/MIDSC_8613_TP_V.jpg\" />", "高画質ファイル7.8MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 09:54:52", "2016-06-28 09:54:52", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2016-06-28 09:58:33", "2016-06-28 09:58:33", "<h2>高画質でも安定稼働</h2>\r\n<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V.jpg\"/>", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 09:58:33", "2016-06-28 09:58:33", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2016-06-28 09:58:54", "2016-06-28 09:58:54", "<h3>高画質でも安定稼働</h3>\r\n<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V.jpg\"/>", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 09:58:54", "2016-06-28 09:58:54", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2016-06-28 09:59:21", "2016-06-28 09:59:21", "<strong>高画質でも安定稼働</strong>\r\n<img class=\"alignnone size-medium wp-image-19\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/AKANE278122238_TP_V.jpg\" />", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 09:59:21", "2016-06-28 09:59:21", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2016-06-28 10:03:59", "2016-06-28 10:03:59", "", "336k", "", "inherit", "closed", "closed", "", "336k", "", "", "2016-06-28 10:03:59", "2016-06-28 10:03:59", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2016-06-28 10:04:53", "2016-06-28 10:04:53", "", "451k", "", "inherit", "closed", "closed", "", "451k", "", "", "2016-06-28 10:04:53", "2016-06-28 10:04:53", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2016-06-28 10:05:22", "2016-06-28 10:05:22", "", "520k", "", "inherit", "closed", "closed", "", "520k", "", "", "2016-06-28 10:05:22", "2016-06-28 10:05:22", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2016-06-28 10:05:54", "2016-06-28 10:05:54", "", "803k", "", "inherit", "closed", "closed", "", "803k", "", "", "2016-06-28 10:05:54", "2016-06-28 10:05:54", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2016-06-28 10:06:23", "2016-06-28 10:06:23", "", "545k", "", "inherit", "closed", "closed", "", "545k", "", "", "2016-06-28 10:06:23", "2016-06-28 10:06:23", "", "4", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("60", "1", "2016-06-28 10:06:42", "2016-06-28 10:06:42", "<strong>高画質でも安定稼働</strong>\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k.jpg\" />\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k.jpg\"/>\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k.jpg\"/>\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\"/>\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\"/>", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 10:06:42", "2016-06-28 10:06:42", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("61", "1", "2016-06-28 10:10:53", "2016-06-28 10:10:53", "<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k.jpg\" />\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k.jpg\" />\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k.jpg\" />\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\" />\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 10:10:53", "2016-06-28 10:10:53", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2016-06-28 10:30:14", "2016-06-28 10:30:14", "", "8700k", "", "inherit", "closed", "closed", "", "8700k", "", "", "2016-06-28 10:30:54", "2016-06-28 10:30:54", "", "6", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("66", "1", "2016-06-28 10:32:04", "2016-06-28 10:32:04", "<img class=\"alignnone size-medium wp-image-64\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg\" />", "高画質ファイル8.1MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 10:32:04", "2016-06-28 10:32:04", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("67", "1", "2016-06-28 10:32:16", "2016-06-28 10:32:16", "<img class=\"alignnone size-medium wp-image-64\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg\" />", "超高画質ファイル8.1MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 10:32:16", "2016-06-28 10:32:16", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("68", "1", "2016-06-28 10:33:11", "2016-06-28 10:33:11", "<h4>ウユニ塩湖の日の出</h4>\r\n<img class=\"alignnone size-medium wp-image-64\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg\" />", "超高画質ファイル8.1MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 10:33:11", "2016-06-28 10:33:11", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("69", "1", "2016-06-28 10:35:13", "2016-06-28 10:35:13", "<h4>ウユニ塩湖の日の出（JPEG8.1MB Size:6016×4016）</h4>\r\n<img class=\"alignnone size-medium wp-image-64\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg\" />", "超高画質ファイル8.1MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 10:35:13", "2016-06-28 10:35:13", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2016-06-28 10:35:31", "2016-06-28 10:35:31", "<h4>ウユニ塩湖の日の出</h4><p>（JPEG8.1MB Size:6016×4016）</p>\r\n<img class=\"alignnone size-medium wp-image-64\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg\" />", "超高画質ファイル8.1MB", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 10:35:31", "2016-06-28 10:35:31", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2016-06-28 10:38:53", "2016-06-28 10:38:53", "<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/336k.jpg\" />\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k.jpg\" />\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k.jpg\" />\r\n<h4>ベネズエラ・ブルーマウンテン</h4>\r\n<p>(JPEG 803KB SIZE:1600 × 1068)</p>\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\" />\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル310KB", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 10:38:53", "2016-06-28 10:38:53", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("73", "1", "2016-06-28 10:42:59", "2016-06-28 10:42:59", "<h4>冬の八ヶ岳連峰（天狗岳）</h4>\r\n(JPEG 262KB SIZE:1600 × 887)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg\"/>\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/451k.jpg\" />\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k.jpg\" />\r\n<h4>ベネズエラ・ブルーマウンテン</h4>\r\n(JPEG 803KB SIZE:1600 × 1068)\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\" />\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル(KB)", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 10:42:59", "2016-06-28 10:42:59", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("74", "1", "2016-06-28 10:45:20", "2016-06-28 10:45:20", "", "623", "", "inherit", "closed", "closed", "", "623", "", "", "2016-06-28 10:45:20", "2016-06-28 10:45:20", "", "0", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("75", "1", "2016-06-28 10:46:09", "2016-06-28 10:46:09", "<h4>冬の八ヶ岳連峰（天狗岳）</h4>\r\n(JPEG 262KB SIZE:1600 × 887)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg\"/>\r\n<h4>八甲田山</h4>\r\n(JPEG 623KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623.jpg\" />\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/520k.jpg\" />\r\n<h4>ベネズエラ・ブルーマウンテン</h4>\r\n(JPEG 803KB SIZE:1600 × 1068)\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\" />\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル(KB)", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 10:46:09", "2016-06-28 10:46:09", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("76", "1", "2016-06-28 10:48:15", "2016-06-28 10:48:15", "", "573", "", "inherit", "closed", "closed", "", "573", "", "", "2016-06-28 10:48:15", "2016-06-28 10:48:15", "", "0", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("77", "1", "2016-06-28 10:49:03", "2016-06-28 10:49:03", "<h4>冬の八ヶ岳連峰（天狗岳）</h4>\r\n(JPEG 262KB SIZE:1600 × 887)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg\"/>\r\n<h4>八甲田山</h4>\r\n(JPEG 623KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623.jpg\" />\r\n<h4>タヒチ</h4>\r\n(JPEG 573KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573.jpg\" />\r\n<h4>ベネズエラ・ブルーマウンテン</h4>\r\n(JPEG 803KB SIZE:1600 × 1068)\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\" />\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル(KB)", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 10:49:03", "2016-06-28 10:49:03", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("78", "1", "2016-06-28 10:50:42", "2016-06-28 10:50:42", "<h4>冬の八ヶ岳連峰（天狗岳）</h4>\r\n(JPEG 262KB SIZE:1600 × 887)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg\"/>\r\n<h4>八甲田山</h4>\r\n(JPEG 623KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623.jpg\" />\r\n<h4>タヒチ</h4>\r\n(JPEG 573KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/573.jpg\" />\r\n<h4>ベネズエラ・ブルーマウンテン</h4>\r\n(JPEG 803KB SIZE:1600 × 1068)\r\n\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\" />\r\n<h4>旭岳（北海道）</h4>\r\n(JPEG 545KB SIZE:1600 × 1068)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル(KB)", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 10:50:42", "2016-06-28 10:50:42", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("79", "1", "2016-06-28 10:52:37", "2016-06-28 10:52:37", "", "524", "", "inherit", "closed", "closed", "", "524", "", "", "2016-06-28 10:52:37", "2016-06-28 10:52:37", "", "0", "http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("80", "1", "2016-06-28 10:53:43", "2016-06-28 10:53:43", "<h4>冬の八ヶ岳連峰（天狗岳）</h4>\r\n(JPEG 262KB SIZE:1600 × 887)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/262.jpg\"/>\r\n<h4>八甲田山</h4>\r\n(JPEG 623KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/623.jpg\" />\r\n<h4>ジョシュア・ツリー国立公園(アメリカロサンゼルス)</h4>\r\n(JPEG 524KB SIZE:1600 × 1066)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/524.jpg\" />\r\n<h4>ベネズエラ・ブルーマウンテン</h4>\r\n(JPEG 803KB SIZE:1600 × 1068)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/803k.jpg\" />\r\n<h4>旭岳（北海道）</h4>\r\n(JPEG 545KB SIZE:1600 × 1068)\r\n<img src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/545k.jpg\" />", "高画質ファイル(KB)", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2016-06-28 10:53:43", "2016-06-28 10:53:43", "", "4", "http://demo.sample100.jetboy.jp/4-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("81", "1", "2016-06-28 10:55:06", "2016-06-28 10:55:06", "<h4>ウユニ塩湖の日の出</h4><p>（JPEG8.1MB Size:6016×4016）</p>\r\n<img class=\"alignnone size-medium wp-image-64\" src=\"http://demo.sample100.jetboy.jp/wp-content/uploads/2016/06/8700k.jpg\" />", "超高画質ファイル(MB)", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-28 10:55:06", "2016-06-28 10:55:06", "", "6", "http://demo.sample100.jetboy.jp/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("82", "1", "2016-06-29 03:59:13", "2016-06-29 03:59:13", "", "GTMetrix結果", "", "publish", "closed", "closed", "", "gtmetrix%e7%b5%90%e6%9e%9c", "", "", "2016-06-29 04:14:15", "2016-06-29 04:14:15", "", "0", "http://demo.sample100.jetboy.jp/?p=82", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("83", "1", "2016-06-29 03:59:13", "2016-06-29 03:59:13", "", "Google PageSpeed結果", "", "publish", "closed", "closed", "", "pagespeed-insights%e7%b5%90%e6%9e%9c", "", "", "2016-06-29 04:14:15", "2016-06-29 04:14:15", "", "0", "http://demo.sample100.jetboy.jp/?p=83", "4", "nav_menu_item", "", "0");

/* INSERT TABLE DATA: wp_siteguard_history */
INSERT INTO `wp_siteguard_history` VALUES("1", "tokumon", "210.234.76.18", "0", "2016-06-29 03:57:33");
INSERT INTO `wp_siteguard_history` VALUES("2", "tokumon", "210.234.76.18", "0", "2016-06-29 03:57:39");
INSERT INTO `wp_siteguard_history` VALUES("3", "tokumon", "210.234.76.18", "0", "2016-06-30 10:41:02");
INSERT INTO `wp_siteguard_history` VALUES("4", "tokumon", "210.234.76.18", "0", "2016-06-30 10:41:07");
INSERT INTO `wp_siteguard_history` VALUES("5", "tokumon", "210.234.76.18", "0", "2016-06-30 10:41:21");
INSERT INTO `wp_siteguard_history` VALUES("6", "tokumon", "210.234.76.18", "0", "2016-06-30 10:41:31");
INSERT INTO `wp_siteguard_history` VALUES("7", "tokumon", "210.234.76.18", "0", "2016-06-30 10:41:43");
INSERT INTO `wp_siteguard_history` VALUES("8", "tokumon", "210.234.76.18", "0", "2016-06-30 10:42:42");
INSERT INTO `wp_siteguard_history` VALUES("9", "tokumon", "210.234.76.18", "0", "2016-06-30 10:42:57");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("1", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("15", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("14", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("82", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("83", "2", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "nav_menu", "", "0", "4");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "Uncategorized", "uncategorized", "0");
INSERT INTO `wp_terms` VALUES("2", "トップメニュー", "%e3%83%88%e3%83%83%e3%83%97%e3%83%a1%e3%83%8b%e3%83%a5%e3%83%bc", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "nickname", "tokumon");
INSERT INTO `wp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("7", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("8", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("9", "1", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("10", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("11", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("12", "1", "dismissed_wp_pointers", "");
INSERT INTO `wp_usermeta` VALUES("13", "1", "show_welcome_panel", "1");
INSERT INTO `wp_usermeta` VALUES("25", "1", "session_tokens", "a:1:{s:64:\"31d8f342f99391e2b34dd1de1514bba9ccae1ef788dc2e089eb2c0651ebaf25e\";a:4:{s:10:\"expiration\";i:1467456440;s:2:\"ip\";s:13:\"210.234.76.18\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36\";s:5:\"login\";i:1467283640;}}");
INSERT INTO `wp_usermeta` VALUES("15", "1", "wp_dashboard_quick_press_last_post_id", "3");
INSERT INTO `wp_usermeta` VALUES("16", "1", "managenav-menuscolumnshidden", "a:4:{i:0;s:15:\"title-attribute\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";}");
INSERT INTO `wp_usermeta` VALUES("17", "1", "metaboxhidden_nav-menus", "a:2:{i:0;s:12:\"add-post_tag\";i:1;s:15:\"add-post_format\";}");
INSERT INTO `wp_usermeta` VALUES("18", "1", "wp_user-settings", "libraryContent=browse&editor=html");
INSERT INTO `wp_usermeta` VALUES("19", "1", "wp_user-settings-time", "1467109986");
INSERT INTO `wp_usermeta` VALUES("20", "1", "nav_menu_recently_edited", "2");
INSERT INTO `wp_usermeta` VALUES("23", "1", "wp_media_library_mode", "list");
INSERT INTO `wp_usermeta` VALUES("21", "1", "closedpostboxes_page", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("22", "1", "metaboxhidden_page", "a:3:{i:0;s:12:\"revisionsdiv\";i:1;s:10:\"postcustom\";i:2;s:9:\"authordiv\";}");
INSERT INTO `wp_usermeta` VALUES("26", "1", "session_tokens", "a:1:{s:64:\"31d8f342f99391e2b34dd1de1514bba9ccae1ef788dc2e089eb2c0651ebaf25e\";a:4:{s:10:\"expiration\";i:1467456440;s:2:\"ip\";s:13:\"210.234.76.18\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36\";s:5:\"login\";i:1467283640;}}");
INSERT INTO `wp_usermeta` VALUES("27", "1", "session_tokens", "a:1:{s:64:\"31d8f342f99391e2b34dd1de1514bba9ccae1ef788dc2e089eb2c0651ebaf25e\";a:4:{s:10:\"expiration\";i:1467456440;s:2:\"ip\";s:13:\"210.234.76.18\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36\";s:5:\"login\";i:1467283640;}}");
INSERT INTO `wp_usermeta` VALUES("28", "1", "session_tokens", "a:1:{s:64:\"31d8f342f99391e2b34dd1de1514bba9ccae1ef788dc2e089eb2c0651ebaf25e\";a:4:{s:10:\"expiration\";i:1467456440;s:2:\"ip\";s:13:\"210.234.76.18\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36\";s:5:\"login\";i:1467283640;}}");
INSERT INTO `wp_usermeta` VALUES("29", "1", "default_password_nag", "");
INSERT INTO `wp_usermeta` VALUES("30", "1", "session_tokens", "a:1:{s:64:\"31d8f342f99391e2b34dd1de1514bba9ccae1ef788dc2e089eb2c0651ebaf25e\";a:4:{s:10:\"expiration\";i:1467456440;s:2:\"ip\";s:13:\"210.234.76.18\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36\";s:5:\"login\";i:1467283640;}}");
INSERT INTO `wp_usermeta` VALUES("31", "1", "session_tokens", "a:1:{s:64:\"31d8f342f99391e2b34dd1de1514bba9ccae1ef788dc2e089eb2c0651ebaf25e\";a:4:{s:10:\"expiration\";i:1467456440;s:2:\"ip\";s:13:\"210.234.76.18\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36\";s:5:\"login\";i:1467283640;}}");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "tokumon", "$P$BKIHnWElzu2XE3oomWauHtnnvOPv.J1", "tokumon", "ooizumieikoubu@yahoo.co.jp", "", "2016-06-28 01:54:23", "1467283397:$P$B3tS7wo6v4cyKepklcVnGNgM.hxr6q/", "0", "tokumon");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2016-07-01 04:52:03*/
/* DUPLICATOR_MYSQLDUMP_EOF */
